﻿// <summary>ソースコード：外部DB接続システム業務クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSBusiProc;
using CommonMP.HYSSOP.Interface.HSDBAProc;
using CommonMP.HYSSOP.Interface.HSData;

using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSLibraryMng;
using CommonMP.HYSSOP.CoreImpl.HSDBAProc;
using CommonMP.HYSSOP.CoreImpl.HSController;

namespace CommonMP.External.RiverSurveyDataManagementSystem.HYSSOP.BusiProc
{
    /// <summary><para>class outline:</para>
    /// <para>外部DB接続システム業務クラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/09/24][新規作成]</para>
    /// </remarks>
    public class HySDBABusiProcedureBase : HySBusiProcedure
    {
        /// <summary>ログ出力用　クラス名称</summary>
        private static readonly string CLASS_NAME = "HySDBABusiProcedureBase";

        /// <summary>業務動作中フラグ</summary>
        protected bool m_bWorkFlg = false;

        ///// <summary>外部DB接続用データ管理システム用環境変数</summary>
        //protected HySEnvInf m_csEnvInf = null;

        /// <summary>シミュレータ識別子</summary>
        protected HySKind m_csSimKindID = HySDefine.SIMULATOR_KIND;

        /// <summary>業務管理制御クラス</summary>
        protected HySControllerRoot m_csController = null;

        /// <summary>ＤＢアクセススレッド制御クラス</summary>
        protected HySDBAThreadControllerBase m_csDBAThreadCtl = null;


        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDBABusiProcedureBase cdBusiProc = new HySDBABusiProcedureBase( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>RsdBusiProcedure 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDBABusiProcedureBase()
        {

        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetSimKind(HySKind csSimKindID)
        {
            m_csSimKindID = csSimKindID;
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySKind シミュレーター種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySKind GetSimKind()
        {
            return m_csSimKindID;
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EqualSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>Boolean true:同じ、false:異なる</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean EqualSimKind(HySKind csSimKindID)
        {
            return m_csSimKindID.Equals(csSimKindID);
        }

        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>Boolean true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean Initialize()
        {
            m_bWorkFlg = true;

            HySDBAProcedureBase csDBAProc = new HySDBAProcedureBase();
            csDBAProc.SetSimKind(m_csSimKindID);
            m_csDBAThreadCtl = new HySDBAThreadControllerBase(csDBAProc);
            m_csDBAThreadCtl.SetController(m_csController);

            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>Boolean true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean Terminate()
        {
            m_bWorkFlg = false;

            m_csDBAThreadCtl.ThreadStop();

            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>システム終了準備完了判別</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = ExitOK( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : システムExit準備OK　、false : システムExit準備NG</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean ExitOK()
        {
            // 動作中ならfalse、そうでないならtrue
            return !m_bWorkFlg;
        }

        /// <summary><para>method outline:</para>
        /// <para>制御クラスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetController( csCtl ) </para>
        /// </example>
        /// <param name="csCtl">制御クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetController(HySControllerRoot csCtl)
        {
            m_csController = csCtl;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        virtual public Boolean EventCallback(HySSysEvent csEvent)
        {
            bool bRtn = false;
            HySEventObject csEventObj = (HySEventObject)csEvent;
            long lEventNo = csEventObj.GetEventNo();
            long lSubEventNo = csEventObj.GetSubEventNo();

            m_csDBAThreadCtl.EventCallback(csEvent);

            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを送る</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = PutEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>自分からイベントを送信する時に使用する</para>
        /// </remarks>
        virtual public Boolean PutEvent(HySSysEvent csEvent)
        {
            string strMethod = "PutEvent";
            bool bRtn = false;

            // 送信元シミュレータ種別設定
            ((HySEventObject)csEvent).SetFromSimKind(GetSimKind());

            bRtn = m_csController.PutEvent(csEvent);
            if (!bRtn)
            {
                // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, CLASS_NAME, strMethod, CommonMP.HYSSOP.CoreImpl.Properties.HysMsgResources.STATEMENT_SEND_FAILURE);
              //HySLog.LogOut(HySLog.ONLINE, CLASS_NAME, strMethod, "イベント送信失敗");
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>ファクトリー管理クラスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetFactoryMng( csFactoryMng ) </para>
        /// </example>
        /// <param name="csFactoryMng">ファクトリー管理クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetFactoryMng(HySFactoryMng csFactoryMng)
        {
            // Do Nothing
        }
    }
}
