﻿// <summary>ソースコード：表示業務処理クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSBusiProc;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSViewer;

using CommonMP.HYSSOP.CoreImpl.HSLibraryMng;


namespace CommonMP.HYSSOP.CoreImpl.HSBusiProc
{
    /// <summary><para>class outline:</para>
    /// <para>表示業務処理</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// </remarks>
    public class HySDispBusiProcedure : HySBusiProcedure
    {
        /// <summary>業務動作中フラグ</summary>
        protected bool m_bWorkFlg = false;

        /// <summary>シミュレータ識別子</summary>
        protected HySKind m_csSimKindID = HySDefine.COMMON_DISP_BUSIPROCEDURE;

        /// <summary>業務管理制御クラス</summary>
        protected HySControllerRoot m_csController = null;

        /// <summary>データコンテナ管理テーブル</summary>
        protected HySDataHashTable m_csDataContainerTbl = new HySDataHashTable();

        /// <summary>ロックオブジェクト(初期化時のユニークID生成に使用する)</summary>
        protected static object m_csSync = new object();
        /// <summary>最後に生成したID時刻</summary>
        protected static DateTime m_csLastIDTime = DateTime.Now;
        /// <summary>最後に生成したID枝番</summary>
        protected static int m_csLastIDSuffix = 0;

        /// <summary>要求有り識別</summary>
        protected HySString m_csTrue = new HySString(HySDispDefine.TRUE_TEXT);
        /// <summary>要求無し識別</summary>
        protected HySString m_csFalse = new HySString(HySDispDefine.FALSE_TEXT);

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySBusiProcedure cdBusiProc = new HySDispBusiProcedure()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDispBusiProcedure 生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDispBusiProcedure()
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySBusiProcedure cdBusiProc = new HySDispBusiProcedure(csController)</para>
        /// </example>
        /// <param name="csController">表示業務処理クラス</param>
        /// <returns>HySDispBusiProcedure 生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDispBusiProcedure(HySControllerRoot csController)
        {
            m_csController = csController;
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetSimKind(HySKind csSimKindID)
        {
            m_csSimKindID = csSimKindID;
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySKind シミュレーター種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySKind GetSimKind()
        {
            return m_csSimKindID;
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EqualSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>Boolean true:同じ、false:異なる</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean EqualSimKind(HySKind csSimKindID)
        {
            return m_csSimKindID.Equals(csSimKindID);
        }

        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>Boolean true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean Initialize()
        {
            m_bWorkFlg = true;
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>Boolean true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean Terminate()
        {
            m_bWorkFlg = false;
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>制御クラスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetController( csCtl ) </para>
        /// </example>
        /// <param name="csCtl">制御クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetController(HySControllerRoot csCtl)
        {
            m_csController = csCtl;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>Boolean true:正常, false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        public virtual Boolean EventCallback(HySSysEvent csEvent)
        {
            //String csMethod = "HySDispBusiProcedure.EventCallback";
            Boolean bRtn = false;

            // イベント情報展開
            HySEventObject csHySEvent = (HySEventObject)csEvent;
            long lEventNo = csHySEvent.GetEventNo();

            // 画面一般イベント毎処理
            if (lEventNo == HySEventObject.CMND_DISP_SCREEN   ||
                lEventNo == HySEventObject.CMND_DISPLY_COMMON ||
                lEventNo == HySEventObject.NOTICE_DISPLY_OK   ||
                lEventNo == HySEventObject.NOTICE_DISPLY_NG   ||
                lEventNo == HySEventObject.CMND_CLOSE_SCREEN )
            {  // 評価画面または計算結果モニタ画面指示の場合
                if (csHySEvent.GetData() is HySKind)
                {  // 画面識別子の場合
                    HySKind csScreenKind = (HySKind)csHySEvent.GetData();
                    if (csScreenKind.Equals(HySDefine.DISP_FORM_GIS_BASEMAP       ) == true ||
                        csScreenKind.Equals(HySDefine.DISP_FORM_GIS_FIGURE        ) == true ||
                        csScreenKind.Equals(HySDefine.DISP_FORM_GIS_HYDRLGCL_OBJ  ) == true ||
                        csScreenKind.Equals(HySDefine.DISP_FORM_GIS2D_MESH        ) == true ||
                        csScreenKind.Equals(HySDefine.DISP_FORM_GIS3D_FIGURE      ) == true ||
                        csScreenKind.Equals(HySDefine.DISP_FORM_GIS3D_MESH        ) == true ||
                        csScreenKind.Equals(HySDefine.DISP_FORM_RIVER_CROSSSECTION) == true)
                    {  // ＧＩＳ画面関連イベントの場合
                        long lEventSubNo = ((HySEventObject)csEvent).GetSubEventNo();
                        if (lEventNo == HySEventObject.CMND_DISP_SCREEN ||
                            lEventNo == HySEventObject.NOTICE_DISPLY_OK ||
                            lEventNo == HySEventObject.NOTICE_DISPLY_NG)
                        {  // 画面表示要求の場合
                            bRtn = this.GISEventCallback(csEvent);
                        }
                        else
                        {  // 評価画面関連イベントの場合
                            bRtn = this.ReportEventCallback(csEvent);
                        }
                    }
                    else if (csScreenKind.Equals(HySDefine.DISP_FORM_MONITER) == true)
                    {  // 計算結果モニタ画面関連イベントの場合
                        bRtn = this.MoniterEventCallback(csEvent);
                    }
                    else
                    {  // 評価画面関連イベントの場合
                        bRtn = this.ReportEventCallback(csEvent);
                    }
                }
            }
            // ＤＢ関連イベント毎処理
            if (lEventNo == HySEventObject.NOTICE_DB_QUERY ||
                lEventNo == HySEventObject.NOTICE_DB_OK ||
                lEventNo == HySEventObject.NOTICE_DB_NG)
            {  // ＤＢ検索結果応答の場合
                bRtn = this.ReportEventCallback(csEvent);
            }
            else if (lEventNo == HySEventObject.CMND_GIS_COMMON)
            {  // GIS関連一般指示の場合
            }
            else if (lEventNo == HySEventObject.NOTICE_GIS_OK)
            {  // GIS関連一般報告(正常報告)の場合
            }
            else if (lEventNo == HySEventObject.NOTICE_GIS_NG)
            {  // GIS関連一般報告(異常報告)の場合
            }
            //else
            //{  // その他
            //    HySLog.LogOut(HySLog.TRIAL_RUN, csMethod, "処理対象外イベント: イベント番号: " + lEventNo.ToString());
            //}

            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>評価画面機能イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = ReportEventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>Boolean true:正常, false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        public virtual Boolean ReportEventCallback(HySSysEvent csEvent)
        {
            //String csMethod = "HySDispBusiProcedure.ReportEventCallback";
            Boolean bRtn = false;
            HySEventObject csEventObj = null;
            HySContainer csContainer = null;
            HySDispBusiProcedureCtlInfo csDBPCtlInfo = null;
            HySStockDataList csStockDataList = null;
            HySStockDataList csAnsStockDataList = null;
            HySEventObject csEventObjWk = null;
            ArrayList csIDList = null;
            HySString csSearchKeys = null;
            long lCnt = 0;
            int iP = 0;

            // イベント情報展開
            HySKind csScreenKind = null;
            HySEventObject csHySEvent = (HySEventObject)csEvent;
            long lEventNo = csHySEvent.GetEventNo();
            HySKind csSimKind = csHySEvent.GetToSimKind();
            HySID csID = (HySID)csHySEvent.GetSuppID();
            HySID csResponsID = (HySID)csHySEvent.GetResponseInfo();
            long lEventSubNo = ((HySEventObject)csEvent).GetSubEventNo();
            HySDataRoot csScreenGrKind = null;

            // 該当イベント毎処理
            if (lEventNo == HySEventObject.CMND_DISP_SCREEN)
            {  // 画面表示指示の場合
                csScreenKind = (HySKind)csHySEvent.GetData();
                if (csScreenKind is HySKind)
                {  // 表示画面識別が有る場合
                    if (csID is HySID)
                    {  // データ識別子が有る場合
                        csContainer = GetDataContainer(csSimKind, csID); // データコンテナを検索
                        if (csContainer is HySDataContainer)
                        {  // データコンテナが有る場合
                            csDBPCtlInfo = (HySDispBusiProcedureCtlInfo)csContainer.GetData(HySDispDefine.DISPCTL_INFO_KEYS);
                            if (csDBPCtlInfo is HySDispBusiProcedureCtlInfo)
                            {  // 表示業務管理データが有る場合
                                if (csDBPCtlInfo.GetParentsScreenKind().Equals(csScreenKind) == false)
                                {  // 親画面以外の場合
                                    csDBPCtlInfo.SetChildScreenKind(csScreenKind); // 子画面識別子追加
                                    csScreenGrKind = this.GetScreenGrKind(csScreenKind,
                                                          csDBPCtlInfo.GetParentsScreenKind()); // Form識別子取得
                                    if (lEventSubNo == HySDispDefine.NOTICE_NO_SEARCH_CONDITION_SCREEN_LATEST  ||
                                        lEventSubNo == HySDispDefine.NOTICE_NO_SEARCH_CONDITION_SCREEN_GENERAL ||
                                        lEventSubNo == HySDispDefine.NOTICE_NO_RESULT_SELECTION_SCREEN         ||
                                        lEventSubNo == HySDispDefine.NOTICE_ONLY_RESULT_SELECTION_NOTIFICATION)
                                    {  // 自動更新指定の場合
                                        csDBPCtlInfo.SetParentsScreenMode(lEventSubNo);
                                    }
                                }
                            }
                        }
                    }
                    else
                    {  // 自身が親画面の場合
                        csID = this.CreateID(); // ユニークＩＤ生成
                        // データコンテナの作成と管理テーブルへの登録
                        csContainer = CreateDataContainer(HySDefine.COMMON_DISP_BUSIPROCEDURE, csID);
                        // コンテナ毎の一貫管理番号生成
                        long lSeqNo = CreateContainerSeqNumber();
                        csContainer.SetData(HySDispDefine.CONTAINER_NUMBER_KEYS, new HySString(lSeqNo.ToString()));
                        // 表示業務管理データ生成とデータコンアテナへの追加
                        csDBPCtlInfo = new HySDispBusiProcedureCtlInfo(csScreenKind);
                        if (lEventSubNo == HySDispDefine.NOTICE_NO_SEARCH_CONDITION_SCREEN_LATEST  ||
                            lEventSubNo == HySDispDefine.NOTICE_NO_SEARCH_CONDITION_SCREEN_GENERAL ||
                            lEventSubNo == HySDispDefine.NOTICE_NO_RESULT_SELECTION_SCREEN         ||
                            lEventSubNo == HySDispDefine.NOTICE_ONLY_RESULT_SELECTION_NOTIFICATION)
                        {  // 自動更新指定の場合
                            csDBPCtlInfo.SetParentsScreenMode(lEventSubNo);
                            if (lEventSubNo == HySDispDefine.NOTICE_NO_SEARCH_CONDITION_SCREEN_LATEST)
                            {  // 最新演算データ検索要求情報を含む場合
                                csSearchKeys = (HySString)csHySEvent.GetSubData();
                                if (csSearchKeys is HySString)
                                {  // 検索要求が有効な場合
                                    HySDataLinkedList csWork = new HySDataLinkedList();
                                    csWork.AddLast(csSearchKeys.Clone()); // 検索条件の設定
                                    csDBPCtlInfo.SetTemporaryDataList(HySDefine.DISP_FORM_SEARCH_CONDITION, csWork);
                                }
                            }
                        }
                        else
                        {  // 手動更新指定の場合
                            csDBPCtlInfo.SetParentsScreenMode(HySDispDefine.NOTICE_SCREEN_FUNDAMENTAL_MOTION);
                        }
                        csContainer.SetData(HySDispDefine.DISPCTL_INFO_KEYS, csDBPCtlInfo);
                        csScreenGrKind = csScreenKind; // 親画面識別設定
                    }
                    // ビュージョブに画面表示を指示
                    csEventObj = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISP_SCREEN);
                    csEventObj.SetToSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
                    csEventObj.SetSuppID(csID);
                    csEventObj.SetData(csScreenGrKind);
                    csEventObj.SetSubEventNo(HySDispDefine.NOTICE_SCREEN_DISPLAY);
                    csEventObj.SetSubData(csContainer); // データコンテナインスタンス設定
                    this.PutEvent(csEventObj);
                    bRtn = true;
                }
            }
            else if (lEventNo == HySEventObject.CMND_DISPLY_COMMON)
            {  // 画面関連一般指示の場合
                csScreenKind = (HySKind)csHySEvent.GetData();
                if (csScreenKind is HySKind)
                {  // 表示画面識別が有る場合
                    csContainer = GetDataContainer(csSimKind, csID); // データコンテナ検索
                    if (csContainer is HySDataContainer)
                    {  // データコンテナが有る場合
                        csDBPCtlInfo = (HySDispBusiProcedureCtlInfo)csContainer.GetData(HySDispDefine.DISPCTL_INFO_KEYS);
                        if (csDBPCtlInfo is HySDispBusiProcedureCtlInfo)
                        {  // 表示業務管理データが有る場合
                            if (lEventSubNo == HySDispDefine.NOTICE_CALC_RESULT_DATA_LIST_REQUEST)
                            {  // 演算結果データ一覧検索指示の場合
                                if (HySDefine.DISP_FORM_SEARCH_CONDITION.Equals(csScreenKind) == true)
                                {  // 検索条件設定画面の検索開始通知の場合
                                    PutSearchStatusEvent(HySDispDefine.NOTICE_DB_REQUEST_BUSY, csID, csDBPCtlInfo); // 検索中通知
                                    // 検索条件展開を実施
                                    csStockDataList = (HySStockDataList)csContainer.GetData(HySDispDefine.STOCKDATALIST_KEYS);
                                    if (csStockDataList is HySStockDataList)
                                    {  // 保存データ一覧が有る場合
                                        csStockDataList.Clear(); // 保存データ一覧初期化
                                    }
                                    else
                                    {  // 保存データ一覧が無い場合
                                        csStockDataList = new HySStockDataList(); // 保存データ一覧生成
                                        csContainer.SetData(HySDispDefine.STOCKDATALIST_KEYS, csStockDataList); // データコンテナに保存データ一覧登録
                                    }
                                    csDBPCtlInfo.GetIDList().Clear(); // 保存データ一覧選択状態リスト初期化
                                    csDBPCtlInfo.GetIDConditionList().ClearAllObject(); // 選択データ識別検索条件管理リスト初期化
                                    this.CreateCalcResultListSearchCondition(csID, csContainer, csDBPCtlInfo); // 検索条件管理データ生成
                                    // ライブラリマネージャに検索要求発行
                                    if (this.SearchRequestEventIssue(csID, csContainer, csDBPCtlInfo) == false)
                                    {  // 検索要求データが全て受信済みの場合
                                        csEventObjWk = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.NOTICE_DB_OK);
                                        csEventObjWk.SetFromSimKind(HySDefine.SIMULATOR_KIND);
                                        csEventObjWk.SetToSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
                                        csEventObjWk.SetResponseInfo(csID.Clone());
                                        csEventObjWk.SetData(new HySStockDataList());
                                        csEventObjWk.SetSuppID(HySLibraryMngDefine.DB_KIND_CALC_RESULT_DATA);
                                        lEventSubNo = HySLibraryMngDefine.DB_QUERY_DATA_LIST;
                                        csEventObjWk.SetSubEventNo(lEventSubNo);
                                        this.PutEvent(csEventObjWk);
                                    }
                                    bRtn = true;
                                }
                                else if (HySDefine.DISP_FORM_LINE_GRAPH.Equals(csScreenKind)        == true ||
                                         HySDefine.DISP_FORM_HYDRO_HYETO_GRAPH.Equals(csScreenKind) == true ||
                                         HySDefine.DISP_FORM_RIVERBED_SHAPE.Equals(csScreenKind)    == true)
                                {  // 検索条件設定画面以外の場合
                                    if (csDBPCtlInfo.GetParentsScreenMode() == HySDispDefine.NOTICE_NO_SEARCH_CONDITION_SCREEN_LATEST)
                                    {  // 最新演算データ検索要求情報の場合
                                        HySDataLinkedList csWork = csDBPCtlInfo.GetTemporaryDataList(HySDefine.DISP_FORM_SEARCH_CONDITION) as HySDataLinkedList;
                                        if (csWork is HySDataLinkedList)
                                        {  // 検索情報記憶エリアが有効な場合
                                            csSearchKeys = null;
                                            if (csWork.GetCount() >= 1)
                                            {  // 検索条件が有る場合
                                                csSearchKeys = csWork.GetData((long)0) as HySString; // 検索条件取得
                                            }
                                            if (csWork.GetCount() == 3)
                                            {  // 検索条件が有る場合
                                                csWork.RemoveData((long)1); // 識別ＩＤ削除
                                                csWork.RemoveData((long)1); // 選択状態削除
                                            }
                                        }
                                        if (csSearchKeys is HySString)
                                        {  // 検索要求が有効な場合
                                            csStockDataList = (HySStockDataList)csContainer.GetData(HySDispDefine.STOCKDATALIST_KEYS);
                                            if (csStockDataList is HySStockDataList)
                                            {  // 保存データ一覧が有る場合
                                                csIDList = csDBPCtlInfo.GetIDList() as ArrayList;
                                                if (csIDList is ArrayList)
                                                {  // 選択リスト一覧エリアが有る場合
                                                    if (csIDList.Count > 0)
                                                    {  // 選択リスト一覧に登録情報が有る場合
                                                        if (csIDList.Count > 0)
                                                        {  // 現状の選択キーを退避
                                                            HySDataLinkedList csOldID = new HySDataLinkedList();
                                                            HySDataLinkedList csOldIDList = new HySDataLinkedList();
                                                            for (long lP = 0; lP < csIDList.Count; lP++)
                                                            {  // 既存件数分繰り返す
                                                                HySStockData csTempWk = csStockDataList.GetData(lP) as HySStockData;
                                                                csOldID.AddLast(csTempWk.GetID().Clone()); // 識別ＩＤ
                                                                csOldIDList.AddLast(((HySString)csIDList[(int)lP]).Clone()); // 選択状態
                                                            }
                                                            csWork.AddLast(csOldID);     // 識別ＩＤ登録
                                                            csWork.AddLast(csOldIDList); // 選択状態登録
                                                        }
                                                    }
                                                }
                                            }
                                            // 継続検索
                                            HySDataLinkedList csQueryCondition = csDBPCtlInfo.GetQueryCondition();
                                            if (csQueryCondition is HySDataLinkedList)
                                            {  // 抽出条件設定が有る場合
                                                csQueryCondition.Clear(); // 検索条件リストを初期化
                                                string[] sInWk;
                                                sInWk = csSearchKeys.ToString().Split(',');
                                                if (sInWk.Length == 3)
                                                {  // データ分割が有効な場合
                                                    HySID csFugID = new HySID(sInWk[0]);
                                                    csDBPCtlInfo.SetPeculiarDataList(csScreenKind, csFugID); // 演算シミュレーション識別子設定
                                                    // 検索条件生成
                                                    string csKey = HySDispDefine.STOCKDATA_KIND_CALC_RESULT_DATA.ToString() + ",";
                                                    csKey += sInWk[1] + ","; // プロジェクト名設定
                                                    csKey += ",,,,,,,,,,";   // 区切り設定
                                                    csKey += sInWk[2];       // 要素ＩＤ設定
                                                    csKey += "," + HySDispDefine.SERACH_MAX_NUMBER.ToString(); // 検索最大件数設定
                                                    if (HySDefine.DISP_FORM_LINE_GRAPH.Equals(csScreenKind) == true)
                                                    {  // 評価汎用基本グラフの場合
                                                        csKey += "," + HySDataKindDefine.D1_CELL_SERIAL.ToString() + ",1,0,0";
                                                    }
                                                    else if (HySDefine.DISP_FORM_HYDRO_HYETO_GRAPH.Equals(csScreenKind) == true)
                                                    {  // 評価特定ハイドロ／ハイエトグラフの場合
                                                        csKey += "," + HySDataKindDefine.D1_CELL_SERIAL.ToString() + ",,0,0";
                                                    }
                                                    else if (HySDefine.DISP_FORM_RIVERBED_SHAPE.Equals(csScreenKind) == true)
                                                    {  // 特殊１次元縦断データグラフの場合
                                                        csKey += "," + HySDataKindDefine.D1_CELL_SERIAL.ToString() + ",,0,0";
                                                    }
                                                    csQueryCondition.GetFirstData();
                                                    csQueryCondition.AddLast(new HySString(csKey)); // 検索条件設定
                                                }
                                                PutSearchStatusEvent(HySDispDefine.NOTICE_DB_REQUEST_BUSY, csID, csDBPCtlInfo); // 検索中通知
                                                // 検索条件展開を実施
                                                if (csStockDataList is HySStockDataList)
                                                {  // 保存データ一覧が有る場合
                                                    csStockDataList.Clear(); // 保存データ一覧初期化
                                                }
                                                else
                                                {  // 保存データ一覧が無い場合
                                                    csStockDataList = new HySStockDataList(); // 保存データ一覧生成
                                                    csContainer.SetData(HySDispDefine.STOCKDATALIST_KEYS, csStockDataList); // データコンテナに保存データ一覧登録
                                                }
                                                csDBPCtlInfo.GetIDList().Clear(); // 保存データ一覧選択状態リスト初期化
                                                this.CreateCalcResultListSearchCondition(csID, csContainer, csDBPCtlInfo); // 検索条件管理データ生成
                                                // ライブラリマネージャに検索要求発行
                                                if (this.SearchRequestEventIssue(csID, csContainer, csDBPCtlInfo) == false)
                                                {  // 検索要求データが全て受信済みの場合
                                                    csEventObjWk = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.NOTICE_DB_OK);
                                                    csEventObjWk.SetFromSimKind(HySDefine.SIMULATOR_KIND);
                                                    csEventObjWk.SetToSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
                                                    csEventObjWk.SetResponseInfo(csID.Clone());
                                                    csEventObjWk.SetData(new HySStockDataList());
                                                    csEventObjWk.SetSuppID(HySLibraryMngDefine.DB_KIND_CALC_RESULT_DATA);
                                                    lEventSubNo = HySLibraryMngDefine.DB_QUERY_DATA_LIST;
                                                    csEventObjWk.SetSubEventNo(lEventSubNo);
                                                    this.PutEvent(csEventObjWk);
                                                }
                                                bRtn = true;
                                            }
                                        }
                                    }
                                }
                            }
                            else if (lEventSubNo == HySDispDefine.NOTICE_CALC_RESULT_DATA_REQUEST ||
                                     lEventSubNo == HySDispDefine.NOTICE_KML_OUTPUT_REQUEST)
                            {  // 演算結果データ検索指示の場合
                                if (HySDefine.DISP_FORM_RESULT_SELECTION.Equals(csScreenKind) == true)
                                {  // 検索結果選択画面の検索開始通知の場合
                                    csStockDataList = (HySStockDataList)csContainer.GetData(HySDispDefine.STOCKDATALIST_KEYS);
                                    if (csStockDataList is HySStockDataList)
                                    {  // 保存データ一覧が有る場合
                                        if (lEventSubNo == HySDispDefine.NOTICE_KML_OUTPUT_REQUEST)
                                        {  // KML出力要求の場合
                                            HySString csOutFile = csHySEvent.GetSubData() as HySString;
                                            if (csOutFile is HySString)
                                            {  // KML出力ファイル名が有効な場合
                                                csDBPCtlInfo.SetTemporaryDataList(csDBPCtlInfo.GetParentsScreenKind(),
                                                                                  csOutFile); // KML出力ファイル名設定
                                            }
                                            else
                                            {  // KML出力ファイル名が有効な場合
                                                csDBPCtlInfo.RemoveTemporaryDataList(csDBPCtlInfo.GetParentsScreenKind()); // 初期化
                                            }
                                        }
                                        PutSearchStatusEvent(HySDispDefine.NOTICE_DB_REQUEST_BUSY, csID, csDBPCtlInfo); // 検索中通知
                                        this.CreateCalcResultDataSearchCondition(csID, csContainer, csDBPCtlInfo); // 検索条件管理データ生成
                                        // ライブラリマネージャに検索要求発行
                                        if (this.SearchRequestEventIssue(csID, csContainer, csDBPCtlInfo) == false)
                                        {  // 検索要求データが全て受信済みの場合
                                            csEventObjWk = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.NOTICE_DB_OK);
                                            csEventObjWk.SetFromSimKind(HySDefine.SIMULATOR_KIND);
                                            csEventObjWk.SetToSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
                                            csEventObjWk.SetResponseInfo(csID.Clone());
                                            csEventObjWk.SetData(new HySStockDataList());
                                            csEventObjWk.SetSuppID(HySLibraryMngDefine.DB_KIND_CALC_RESULT_DATA);
                                            lEventSubNo = HySLibraryMngDefine.DB_QUERY_DATA_LIST_BY_ID;
                                            csEventObjWk.SetSubEventNo(lEventSubNo);
                                            this.PutEvent(csEventObjWk);
                                        }
                                    }
                                    bRtn = true;
                                }
                            }
                            else if (lEventSubNo == HySDispDefine.NOTICE_KML_OUTPUT_COMPLET)
                            {  // ＫＭＬ出力完了報告の場合
                                PutSearchStatusEvent(HySDispDefine.NOTICE_DB_REQUEST_COMPLET, csID, csDBPCtlInfo); // 検索完了通知
                            }
                            else if (lEventSubNo == HySDispDefine.NOTICE_CALC_LOT_INFO_LIST_REQUEST)
                            {  // 演算ロット一覧検索指示の場合
                                if (HySDefine.DISP_FORM_RESULT_SELECTION.Equals(csScreenKind) == true)
                                {  // 検索結果選択画面の検索開始通知の場合
                                    csStockDataList = (HySStockDataList)csContainer.GetData(HySDispDefine.STOCKDATALIST_KEYS);
                                    if (csStockDataList is HySStockDataList)
                                    {  // 保存データ一覧が有る場合
                                        PutSearchStatusEvent(HySDispDefine.NOTICE_DB_REQUEST_BUSY, csID, csDBPCtlInfo); // 検索中通知
                                        this.CreateCalcLotInfoListSearchCondition(csID, csContainer, csDBPCtlInfo); // 検索条件管理データ生成
                                        // ライブラリマネージャに検索要求発行
                                        if (this.SearchRequestEventIssue(csID, csContainer, csDBPCtlInfo) == false)
                                        {  // 検索要求データが全て受信済みの場合
                                            csEventObjWk = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.NOTICE_DB_OK);
                                            csEventObjWk.SetFromSimKind(HySDefine.SIMULATOR_KIND);
                                            csEventObjWk.SetToSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
                                            csEventObjWk.SetResponseInfo(csID.Clone());
                                            csEventObjWk.SetData(new HySStockDataList());
                                            csEventObjWk.SetSuppID(HySLibraryMngDefine.DB_KIND_CALC_LOT_INFO);
                                            lEventSubNo = HySLibraryMngDefine.DB_QUERY_DATA_LIST_BY_ID;
                                            csEventObjWk.SetSubEventNo(lEventSubNo);
                                            this.PutEvent(csEventObjWk);
                                        }
                                    }
                                    bRtn = true;
                                }
                            }
                            else if (lEventSubNo == HySDispDefine.NOTICE_CALC_LOT_INFO_UPDATE_REQUEST)
                            {  // 演算ロット更新指示の場合
                                if (HySDefine.DISP_FORM_RESULT_SELECTION.Equals(csScreenKind) == true)
                                {  // 検索結果選択画面の更新通知の場合
                                    csStockDataList = (HySStockDataList)csContainer.GetData(HySDispDefine.STOCKDATALIST_KEYS);
                                    if (csStockDataList is HySStockDataList)
                                    {  // 保存データ一覧が有る場合
                                        PutSearchStatusEvent(HySDispDefine.NOTICE_DB_REQUEST_BUSY, csID, csDBPCtlInfo); // 更新中通知
                                        this.CreateCalcLotInfoUpdateCondition(csID, csContainer, csDBPCtlInfo);     // 更新条件管理データ生成
                                        // ライブラリマネージャに検索要求発行
                                        if (this.UpdateRequestEventIssue(csID, csContainer, csDBPCtlInfo) == false)
                                        {  // 検索要求データが全て受信済みの場合
                                            csEventObjWk = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.NOTICE_DB_OK);
                                            csEventObjWk.SetFromSimKind(HySDefine.SIMULATOR_KIND);
                                            csEventObjWk.SetToSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
                                            csEventObjWk.SetResponseInfo(csID.Clone());
                                            csEventObjWk.SetData(new HySStockDataList());
                                            csEventObjWk.SetSuppID(HySLibraryMngDefine.DB_KIND_CALC_LOT_INFO);
                                            lEventSubNo = HySLibraryMngDefine.DB_REGISTER_DATA_UPDATE_PARTIAL;
                                            csEventObjWk.SetSubEventNo(lEventSubNo);
                                            this.PutEvent(csEventObjWk);
                                        }
                                    }
                                    bRtn = true;
                                }
                            }
                            else if (lEventSubNo == HySDispDefine.NOTICE_SCREEN_UPDATE)
                            {  // 表示更新指示の場合
                                if (HySDefine.DISP_FORM_RESULT_SELECTION.Equals(csScreenKind) == true ||
                                    HySDefine.DISP_FORM_GRAPH_CUSTOMIZ.Equals(csScreenKind) == true)
                                {  // 検索結果選択画面の再表示要求の場合
                                    csEventObj = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISPLY_COMMON);
                                    csEventObj.SetToSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
                                    csEventObj.SetSuppID(csID);
                                    csEventObj.SetData(csDBPCtlInfo.GetParentsScreenKind());
                                    csEventObj.SetSubEventNo(lEventSubNo);
                                    csEventObj.SetSubData(csContainer); // データコンテナインスタンス設定
                                    this.PutEvent(csEventObj);
                                    bRtn = true;
                                }
                            }
                            else if (lEventSubNo == HySDispDefine.NOTICE_SCREEN_MINIMIZED ||
                                     lEventSubNo == HySDispDefine.NOTICE_SCREEN_NORMAL ||
                                     lEventSubNo == HySDispDefine.NOTICE_SCREEN_HIDE ||
                                     lEventSubNo == HySDispDefine.NOTICE_SCREEN_ACTIVE)
                            {  // 隠す・最小化・ノーマライズ・アクティブ指示の場合
                                lCnt = csDBPCtlInfo.GetChildCount();
                                for (iP = 1; iP <= (int)lCnt; iP++)
                                {  // 登録済みの子画面数分繰り返す
                                    csEventObj = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISPLY_COMMON);
                                    csEventObj.SetToSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
                                    csEventObj.SetSuppID(csID);
                                    csEventObj.SetData((HySKind)csDBPCtlInfo.GetChildScreenKind(iP));
                                    csEventObj.SetSubEventNo(lEventSubNo);
                                    this.PutEvent(csEventObj);
                                }
                                bRtn = true;
                            }
                        }
                    }
                }
            }
            else if (lEventNo == HySEventObject.NOTICE_DISPLY_OK ||
                     lEventNo == HySEventObject.NOTICE_DISPLY_NG)
            {  // 画面関連一般報告(正常報告)／画面関連一般報告(異常報告)の場合
                csScreenKind = (HySKind)csHySEvent.GetData();
                if (csScreenKind is HySKind)
                {  // 表示画面識別が有る場合
                    csContainer = GetDataContainer(csSimKind, csID); // データコンテナ検索
                    if (csContainer is HySDataContainer)
                    {  // データコンテナが有る場合
                        csDBPCtlInfo = (HySDispBusiProcedureCtlInfo)csContainer.GetData(HySDispDefine.DISPCTL_INFO_KEYS);
                        if (csDBPCtlInfo is HySDispBusiProcedureCtlInfo)
                        {  // 表示業務管理データが有る場合
                            if (lEventSubNo == HySDispDefine.NOTICE_SCREEN_CLOSE)
                            {  // 画面終了後処理指示の場合
                                if (csDBPCtlInfo.GetParentsScreenKind().Equals(csScreenKind) == false)
                                {  // 親画面以外の場合
                                    csDBPCtlInfo.RemoveChildScreenKind(csScreenKind); // 子画面識別子削除
                                    // 子画面終了通知
                                    csEventObj = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISPLY_COMMON);
                                    csEventObj.SetToSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
                                    csEventObj.SetSuppID(csID);
                                    csEventObj.SetData(csDBPCtlInfo.GetParentsScreenKind());
                                    csEventObj.SetSubEventNo(lEventSubNo);
                                    csEventObj.SetSubData(csScreenKind);
                                    this.PutEvent(csEventObj);
                                }
                                else
                                {  // 親画面終了通知の場合は該当画面のデータコンテナ解放
                                    lCnt = csDBPCtlInfo.GetChildCount();
                                    for (iP = 1; iP <= (int)lCnt; iP++)
                                    {  // 登録済みの子画面数分繰り返す
                                        csEventObj = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISPLY_COMMON);
                                        csEventObj.SetToSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
                                        csEventObj.SetSuppID(csID);
                                        csEventObj.SetData((HySKind)csDBPCtlInfo.GetChildScreenKind(iP));
                                        csEventObj.SetSubEventNo(lEventSubNo);
                                        this.PutEvent(csEventObj);
                                    }
                                    DeleteFromDataContainerTbl(csSimKind, csID);
                                }
                                bRtn = true;
                            }
                            else if (lEventSubNo == HySDispDefine.NOTICE_SCREEN_DISPLAY)
                            {  // 画面表示後処理指示の場合
                                if (csDBPCtlInfo.GetParentsScreenKind().Equals(csScreenKind) == false)
                                {  // 親画面以外の場合
                                    if (csDBPCtlInfo.EqualScreenKind(csScreenKind) == true)
                                    {  // 子画面からの報告の場合
                                        if (lEventNo == HySEventObject.NOTICE_DISPLY_NG)
                                        {  // 画面指示異常完了報告の場合は子画面識別子削除
                                            csDBPCtlInfo.RemoveChildScreenKind(csScreenKind);
                                        }
                                        // 親画面にボタン占有解除を指示
                                        csEventObj = new HySEventObject(HySSysEvent.OBJID_VIEWER, lEventNo);
                                        csEventObj.SetToSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
                                        csEventObj.SetSuppID(csID);
                                        csEventObj.SetData(csDBPCtlInfo.GetParentsScreenKind());
                                        csEventObj.SetSubEventNo(lEventSubNo);
                                        csEventObj.SetSubData(csScreenKind);
                                        this.PutEvent(csEventObj);
                                    }
                                }
                                else
                                {  // 親画面の場合
                                    if (lEventNo == HySEventObject.NOTICE_DISPLY_NG)
                                    {  // 画面指示異常完了報告の場合は該当画面のデータコンテナ解放
                                        DeleteFromDataContainerTbl(csSimKind, csID);
                                    }
                                }
                                bRtn = true;
                            }
                        }
                    }
                }
                else
                {  // 管理外の報告の場合
                    //HySLog.LogOut(HySLog.TRIAL_RUN, csMethod, "管理外の報告イベント受信:" + csSimKind.GetString() + csID.GetString());
                    return bRtn;
                }
            }
            else if (lEventNo == HySEventObject.NOTICE_DB_QUERY ||
                     lEventNo == HySEventObject.NOTICE_DB_OK ||
                     lEventNo == HySEventObject.NOTICE_DB_NG)
            {  // DB関連検索結果またはDB関連一般報告(処理正常/異常報告)の場合
                //HySLog.LogOut(HySLog.TRIAL_RUN, csMethod, "ＤＢ検索完了イベント受信:" + csID.ToString());
                bool bAnsFlg = true; // 画面処理要設定
                csContainer = GetDataContainer(csSimKind, csResponsID); // データコンテナ検索
                if (csContainer is HySDataContainer)
                {  // データコンテナが有る場合
                    csDBPCtlInfo = (HySDispBusiProcedureCtlInfo)csContainer.GetData(HySDispDefine.DISPCTL_INFO_KEYS);
                    if (csDBPCtlInfo is HySDispBusiProcedureCtlInfo)
                    {  // 表示業務管理データが有る場合
                        if (lEventNo == HySEventObject.NOTICE_DB_QUERY ||
                            lEventNo == HySEventObject.NOTICE_DB_OK)
                        {  // 検索応答データが有る場合
                            csAnsStockDataList = (HySStockDataList)csHySEvent.GetData();
                            if (this.RetrievalCompletionJudgment(csContainer, csDBPCtlInfo, csAnsStockDataList) == true)
                            {  // 検索が完了した場合
                                if (csDBPCtlInfo.GetQueryType() == HySDispDefine.NOTICE_CALC_RESULT_DATA_LIST_REQUEST)
                                {  // 演算結果データ一覧検索の場合
                                    if (csAnsStockDataList is HySStockDataList)
                                    {  // 検索結果が有る場合
                                        csStockDataList = (HySStockDataList)csContainer.GetData(HySDispDefine.STOCKDATALIST_KEYS);
                                        if (csStockDataList == null)
                                        {  // データ保存クラスリストが無い場合は新規で作成する
                                            csStockDataList = new HySStockDataList();
                                            csContainer.SetData(HySDispDefine.STOCKDATALIST_KEYS, csStockDataList);
                                        }
                                        for (long lP = 0; lP < csAnsStockDataList.GetCount(); lP++)
                                        {  // 検索結果件数分繰り返す
                                            csStockDataList.AddLast(csAnsStockDataList.GetData(lP));
                                        }
                                    }
                                }
                                else if (csDBPCtlInfo.GetQueryType() == HySDispDefine.NOTICE_CALC_RESULT_DATA_REQUEST)
                                {  // 演算結果データ検索の場合
                                    if (csAnsStockDataList is HySStockDataList)
                                    {  // 検索結果が有る場合
                                        csStockDataList = (HySStockDataList)csContainer.GetData(HySDispDefine.STOCKDATALIST_KEYS);
                                        if (csStockDataList is HySStockDataList)
                                        {  // データ保存クラスリストが有る場合
                                            this.StockDataMerging(csAnsStockDataList, csContainer, csDBPCtlInfo); // 検索結果マージ
                                        }
                                    }
                                }
                                else if (csDBPCtlInfo.GetQueryType() == HySDispDefine.NOTICE_CALC_LOT_INFO_LIST_REQUEST)
                                {  // 演算ロット一覧検索の場合
                                    if (csAnsStockDataList is HySStockDataList)
                                    {  // 検索結果が有る場合
                                        csContainer.SetData(HySDispDefine.PERMANENREPOSITORY_KEYS, csAnsStockDataList); // 演算ロット情報退避
                                        csStockDataList = (HySStockDataList)csContainer.GetData(HySDispDefine.STOCKDATALIST_KEYS);
                                        if (csStockDataList is HySStockDataList)
                                        {  // データ保存クラスリストが有る場合
                                            this.StockDataMerging(csAnsStockDataList, csContainer, csDBPCtlInfo); // 検索結果マージ
                                        }
                                    }
                                }
                                else if (csDBPCtlInfo.GetQueryType() == HySDispDefine.NOTICE_CALC_LOT_INFO_UPDATE_REQUEST)
                                {  // 演算ロット一覧更新の場合
                                }
                                else
                                {  // その他の場合
                                }
                            }
                        }
                        else
                        {  // ＤＢ検索異常の場合
                            this.SetRetrievalRetry(csContainer); // 検索リトライ依頼設定                            
                        }
                        bool bRequestFlg = false;
                        if (csDBPCtlInfo.GetQueryType() == HySDispDefine.NOTICE_CALC_LOT_INFO_UPDATE_REQUEST)
                        {  // 演算ロット一覧更新の場合
                            bRequestFlg = this.UpdateRequestEventIssue(csResponsID, csContainer, csDBPCtlInfo);
                        }
                        else
                        {  // 演算ロット一覧更新以外の場合
                            bRequestFlg = this.SearchRequestEventIssue(csResponsID, csContainer, csDBPCtlInfo);
                        }
                        if (bRequestFlg == true)
                        {  // 検索要求データ受信残がある場合
                            bAnsFlg = false; // 画面表示否設定
                        }
                        else
                        {  // 要求データ受信残が無い場合
                            if (csDBPCtlInfo.GetQueryType() == HySDispDefine.NOTICE_CALC_RESULT_DATA_LIST_REQUEST)
                            {  // 演算結果データ一覧検索の場合
                                this.StockDataThinningOut(csContainer, csDBPCtlInfo); // 検索結果補正
                                // 外部データリストの追加 //
                                ExternalConditionDevelopment(csResponsID, csContainer, csDBPCtlInfo); // 外部データ名称の保存データ型展開
                                csAnsStockDataList = (HySStockDataList)csContainer.GetData(HySDispDefine.EXTERNALDATALIST_KEYS);
                                if (csAnsStockDataList is HySStockDataList)
                                {  // データ検索条件クラス管理リストが有る場合
                                    if (csAnsStockDataList.GetCount() > 0)
                                    {  // 外部データリストが有る場合
                                        csAnsStockDataList.SetCursorFirst(); // カーソルを先頭に設定
                                        csStockDataList = (HySStockDataList)csContainer.GetData(HySDispDefine.STOCKDATALIST_KEYS);
                                        if (csStockDataList == null)
                                        {  // データ保存クラスリストが無い場合は新規で作成する
                                            csStockDataList = new HySStockDataList();
                                            csContainer.SetData(HySDispDefine.STOCKDATALIST_KEYS, csStockDataList);
                                        }
                                        csIDList = csDBPCtlInfo.GetIDList() as ArrayList;
                                        for (long lP = 0; lP < csAnsStockDataList.GetCount(); lP++)
                                        {  // 検索結果件数分繰り返す
                                            csStockDataList.AddLast(csAnsStockDataList.GetData(lP));
                                            csIDList.Add(m_csFalse.Clone());
                                        }
                                    }
                                    // 更新モードが保存期間取得要の場合
                                    csEventObjWk = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_DISPLY_COMMON);
                                    csEventObjWk.SetToSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
                                    csEventObjWk.SetSuppID(csResponsID.Clone());
                                    csEventObjWk.SetResponseInfo(csResponsID.Clone());
                                    csEventObjWk.SetData(HySDefine.DISP_FORM_RESULT_SELECTION);
                                    csEventObjWk.SetSubEventNo(HySDispDefine.NOTICE_CALC_LOT_INFO_LIST_REQUEST);
                                    this.PutEvent(csEventObjWk);
                                    bAnsFlg = false; // 画面表示否設定
                                }
                            }
                            else if (csDBPCtlInfo.GetQueryType() == HySDispDefine.NOTICE_CALC_RESULT_DATA_REQUEST)
                            {  // 演算結果データ検索の場合
                            }
                            else if (csDBPCtlInfo.GetQueryType() == HySDispDefine.NOTICE_CALC_LOT_INFO_LIST_REQUEST)
                            {  // 演算ロット一覧検索の場合
                                if (csDBPCtlInfo.GetParentsScreenMode() != HySDispDefine.NOTICE_ONLY_RESULT_SELECTION_NOTIFICATION)
                                {  // 更新モードがデータ本体取得要の場合
                                    csEventObjWk = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_DISPLY_COMMON);
                                    csEventObjWk.SetToSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
                                    csEventObjWk.SetSuppID(csResponsID.Clone());
                                    csEventObjWk.SetResponseInfo(csResponsID.Clone());
                                    csEventObjWk.SetData(HySDefine.DISP_FORM_RESULT_SELECTION);
                                    csEventObjWk.SetSubEventNo(HySDispDefine.NOTICE_CALC_RESULT_DATA_REQUEST);
                                    this.PutEvent(csEventObjWk);
                                    bAnsFlg = false; // 画面表示否設定
                                }
                            }
                            else if (csDBPCtlInfo.GetQueryType() == HySDispDefine.NOTICE_CALC_LOT_INFO_UPDATE_REQUEST)
                            {  // 演算ロット一覧更新の場合
                                PutSearchStatusEvent(HySDispDefine.NOTICE_DB_REQUEST_COMPLET, csResponsID, csDBPCtlInfo); // 検索完了通知
                                bAnsFlg = false; // 画面表示否設定
                            }
                            else
                            {  // その他の場合
                            }
                        }
                        bRtn = true;
                        if (bAnsFlg == true)
                        {  // 画面表示要の場合
                            if (csDBPCtlInfo is HySDispBusiProcedureCtlInfo)
                            {  // 表示業務管理データが有る場合
                                if (csDBPCtlInfo.GetParentsScreenMode() == HySDispDefine.NOTICE_NO_SEARCH_CONDITION_SCREEN_LATEST  ||
                                    csDBPCtlInfo.GetParentsScreenMode() == HySDispDefine.NOTICE_NO_SEARCH_CONDITION_SCREEN_GENERAL ||
                                    csDBPCtlInfo.GetParentsScreenMode() == HySDispDefine.NOTICE_NO_RESULT_SELECTION_SCREEN         ||
                                    csDBPCtlInfo.GetParentsScreenMode() == HySDispDefine.NOTICE_SCREEN_FUNDAMENTAL_MOTION          ||
                                    csDBPCtlInfo.GetQueryType() == HySDispDefine.NOTICE_CALC_RESULT_DATA_REQUEST)
                                {  // 親画面の表示更新要の場合
                                    csEventObj = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISPLY_COMMON);
                                    csEventObj.SetToSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
                                    csEventObj.SetSuppID(csResponsID);
                                    csEventObj.SetData(csDBPCtlInfo.GetParentsScreenKind());
                                    csEventObj.SetSubEventNo(HySDispDefine.NOTICE_SCREEN_UPDATE);
                                    csEventObj.SetSubData(csContainer); // データコンテナインスタンス設定
                                    this.PutEvent(csEventObj);
                                }
                                // 表示ビューアへの「検索結果選択画面」表示指示
                                if (csDBPCtlInfo.EqualScreenKind(HySDefine.DISP_FORM_RESULT_SELECTION) == true)
                                {  // 検索結果選画面が有る場合は画面表示更新指示を出す
                                    if (csDBPCtlInfo.GetParentsScreenKind().Equals(HySDefine.DISP_FORM_GIS2D_MESH) == true)
                                    {  // ＧＩＳメッシュ表示の場合
                                        HySString csOutFile = csDBPCtlInfo.GetTemporaryDataList(HySDefine.DISP_FORM_GIS2D_MESH) as HySString;
                                        if (csOutFile is HySString)
                                        {  // KMLファイル出力の場合
                                            PutSearchStatusEvent(HySDispDefine.NOTICE_DB_REQUEST_BUSY, csResponsID, csDBPCtlInfo); // 検索中通知
                                        }
                                        else
                                        {  // 画面表示の場合
                                            PutSearchStatusEvent(HySDispDefine.NOTICE_DB_REQUEST_COMPLET, csResponsID, csDBPCtlInfo); // 検索完了通知
                                            csEventObj = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISPLY_COMMON);
                                            csEventObj.SetToSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
                                            csEventObj.SetSuppID(csResponsID);
                                            csEventObj.SetData(HySDefine.DISP_FORM_RESULT_SELECTION);
                                            csEventObj.SetSubEventNo(HySDispDefine.NOTICE_SCREEN_UPDATE);
                                            csEventObj.SetSubData(csContainer); // データコンテナインスタンス設定
                                            this.PutEvent(csEventObj);
                                        }
                                    }
                                    else
                                    {  // 演算結果表示の場合
                                        PutSearchStatusEvent(HySDispDefine.NOTICE_DB_REQUEST_COMPLET, csResponsID, csDBPCtlInfo); // 検索完了通知
                                        csEventObj = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISPLY_COMMON);
                                        csEventObj.SetToSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
                                        csEventObj.SetSuppID(csResponsID);
                                        csEventObj.SetData(HySDefine.DISP_FORM_RESULT_SELECTION);
                                        csEventObj.SetSubEventNo(HySDispDefine.NOTICE_SCREEN_UPDATE);
                                        csEventObj.SetSubData(csContainer); // データコンテナインスタンス設定
                                        this.PutEvent(csEventObj);
                                    }
                                }
                                else
                                {  // 検索結果選画面が無い場合で検索画面が表示されている場合は画面表示指示を出す
                                    if (csDBPCtlInfo.EqualScreenKind(HySDefine.DISP_FORM_SEARCH_CONDITION) == true)
                                    {  // 検索画面が表示されている場合
                                        if (csDBPCtlInfo.GetParentsScreenMode() != HySDispDefine.NOTICE_NO_SEARCH_CONDITION_SCREEN_LATEST &&
                                            csDBPCtlInfo.GetParentsScreenMode() != HySDispDefine.NOTICE_NO_SEARCH_CONDITION_SCREEN_GENERAL)
                                        { // 検索結果選画面表示要の場合
                                            PutSearchStatusEvent(HySDispDefine.NOTICE_DB_REQUEST_COMPLET, csResponsID, csDBPCtlInfo); // 検索完了通知
                                            csEventObjWk = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_DISP_SCREEN);
                                            csEventObjWk.SetToSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
                                            csEventObjWk.SetSuppID(csResponsID);
                                            csEventObjWk.SetData(HySDefine.DISP_FORM_RESULT_SELECTION);
                                            this.EventCallback(csEventObjWk);
                                        }
                                    }
                                }
                                bRtn = true;
                            }
                        }
                    }
                }
            }
            //else
            //{  // その他
            //    HySLog.LogOut(HySLog.TRIAL_RUN, csMethod, "処理対象外イベント: イベント番号: " + lEventNo.ToString());
            //}

            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>計算結果モニタ機能がイベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = MoniterEventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>Boolean true:正常, false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        public virtual Boolean MoniterEventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = false;
            HySEventObject csEventObj = null;
            HySContainer csContainer = null;
            HySDispBusiProcedureCtlInfo csDBPCtlInfo = null;

            // イベント情報展開
            HySEventObject csHySEvent = (HySEventObject)csEvent;
            long lEventNo = csHySEvent.GetEventNo();                      // イベント番号
            HySKind csSimKind = csHySEvent.GetToSimKind();                // シミュレータ識別子
            HySKind csFromSimKind = csHySEvent.GetFromSimKind();          // 送り元シミュレータ識別子
            HySID csID = (HySID)csHySEvent.GetSuppID();                   // 演算シミュレータ識別子
            HySID csResponseInfoID = (HySID)csHySEvent.GetResponseInfo(); // 要素ＩＤ
            HySKind csScreenKind = (HySKind)csHySEvent.GetData();         // 画面識別子
            long lEventSubNo = ((HySEventObject)csEvent).GetSubEventNo(); // サブイベント番号
            HySDataRoot csSubData = csHySEvent.GetSubData();              // データ授受用コンテナインスタンス

            // 該当イベント毎処理
            if (lEventNo == HySEventObject.CMND_DISP_SCREEN)
            {  // 画面表示指示の場合
                if (csID is HySID)
                {  // 演算シミュレータ識別が有効な場合
                    if (csResponseInfoID is HySID)
                    {  // 要素ＩＤが有効な場合
                        csContainer = GetDataContainer(csSimKind, csID); // 既存データコンテナ検索
                        if (csContainer == null)
                        {  // データコンテナが無い（初回）場合
                            csContainer = CreateDataContainer(HySDefine.COMMON_DISP_BUSIPROCEDURE, csID); // コンテナ生成
                            csContainer.SetData(HySDispDefine.CONTAINER_NUMBER_KEYS, new HySString("0")); // コンテナ毎の一貫管理番号登録
                            csDBPCtlInfo = new HySDispBusiProcedureCtlInfo(csScreenKind);                 // 表示業務管理データ生成
                            csDBPCtlInfo.SetParentsScreenMode(HySDispDefine.NOTICE_SCREEN_FUNDAMENTAL_MOTION); // 手動更新指定
                            // データコンテナに画面制御情報登録
                            csContainer.SetData(HySDispDefine.DISPCTL_INFO_KEYS, csDBPCtlInfo);
                            // ビュージョブにスクリーン生成を指示
                            csEventObj = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISP_SCREEN);
                            csEventObj.SetToSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
                            csEventObj.SetSuppID(csID);
                            csEventObj.SetResponseInfo(csResponseInfoID);
                            csEventObj.SetData(csScreenKind);
                            csEventObj.SetSubEventNo(HySDispDefine.NOTICE_SCREEN_DISPLAY);
                            csEventObj.SetSubData(csContainer); // 管理データコンテナインスタンス設定
                            this.PutEvent(csEventObj);

                            HySDebugAgent.MonitorDataNotify(csContainer);
                        }
                        else
                        {  // データコンテナが有る場合
                            csDBPCtlInfo = (HySDispBusiProcedureCtlInfo)csContainer.GetData(HySDispDefine.DISPCTL_INFO_KEYS);
                        }
                        if (csDBPCtlInfo is HySDispBusiProcedureCtlInfo)
                        {  // 表示業務管理データが有る場合
                            HySKind csChildKind = new HySObjectKind(csResponseInfoID.ToString());
                            csDBPCtlInfo.SetChildScreenKind(csChildKind); // 子画面識別子追加
                            if (lEventSubNo == HySDispDefine.NOTICE_RESULT_AREA_CREATE)
                            {  // 演算結果データインスタンス通知の場合
                                if (csSubData is HySDataRoot)
                                {  // データ授受用データインスタンスが有る場合
                                    csDBPCtlInfo.SetPeculiarDataList(csChildKind, csSubData); // データインスタンス設定
                                    csDBPCtlInfo.SetTemporaryDataList(csChildKind, new HySString("true")); // リセット設定
                                }
                            }
                            else
                            {  // 表示画面識別が無い（表示のみ）場合
                                bool bFormOkFlg = true;
                                HySDataLinkedList csArrayList = new HySDataLinkedList();
                                csArrayList.AddLast(csScreenKind);
                                if (csSubData is HySDataLinkedList)
                                {  // モデル種別が有る場合
                                    HySID csFormKind = HySMoniterScreen.GetViewFormID((HySDataLinkedList)csSubData);
                                    if (csFormKind is HySID)
                                    {  // Form識別子が有効な場合
                                        csArrayList.AddLast(new HySObjectKind(csFormKind.ToString()));
                                    }
                                    else
                                    {  // Form識別子が無効な場合
                                        bFormOkFlg = false;
                                    }
                                }
                                if (bFormOkFlg == true)
                                {  // Form識別子が有効な場合
                                    csEventObj = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISPLY_COMMON);
                                    csEventObj.SetToSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
                                    csEventObj.SetSuppID(csID);
                                    csEventObj.SetResponseInfo(csResponseInfoID);
                                    csEventObj.SetData(csArrayList);
                                    csEventObj.SetSubEventNo(HySDispDefine.NOTICE_FROM_DISPLAY);
                                    csEventObj.SetSubData(csFromSimKind);
                                    this.PutEvent(csEventObj);
                                }
                                else
                                {  // Form識別子が無効な場合
                                    csEventObj = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.NOTICE_DISPLY_OK);
                                    csEventObj.SetFromSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
                                    csEventObj.SetToSimKind(csFromSimKind);
                                    csEventObj.SetSuppID(csResponseInfoID);
                                    csEventObj.SetSubEventNo(HySDispDefine.NOTICE_SCREEN_CLOSE);
                                    this.PutEvent(csEventObj);
                                    bRtn = true;
                                }
                            }
                        }
                        bRtn = true;
                    }
                }
            }
            else if (lEventNo == HySEventObject.CMND_DISPLY_COMMON)
            {  // 画面関連一般指示の場合
                csContainer = GetDataContainer(csSimKind, csID); // データコンテナ検索
                if (csContainer is HySDataContainer)
                {  // データコンテナが有る場合
                    csDBPCtlInfo = (HySDispBusiProcedureCtlInfo)csContainer.GetData(HySDispDefine.DISPCTL_INFO_KEYS);
                    if (csDBPCtlInfo is HySDispBusiProcedureCtlInfo)
                    {  // 表示業務管理データが有る場合
                        if (lEventSubNo == HySDispDefine.NOTICE_SCREEN_UPDATE)
                        {  // 表示更新指示の場合
                        }
                        bRtn = true;
                    }
                }
            }
            else if (lEventNo == HySEventObject.NOTICE_DISPLY_OK ||
                     lEventNo == HySEventObject.NOTICE_DISPLY_NG)
            {  // 画面関連一般報告(正常報告)／画面関連一般報告(異常報告)の場合
                csContainer = GetDataContainer(csSimKind, csID); // データコンテナ検索
                if (csContainer is HySDataContainer)
                {  // データコンテナが有る場合
                    csDBPCtlInfo = (HySDispBusiProcedureCtlInfo)csContainer.GetData(HySDispDefine.DISPCTL_INFO_KEYS);
                    if (csDBPCtlInfo is HySDispBusiProcedureCtlInfo)
                    {  // 表示業務管理データが有る場合
                        if (lEventSubNo == HySDispDefine.NOTICE_SCREEN_CLOSE)
                        {  // 画面終了後処理指示の場合
                            if (csDBPCtlInfo.GetParentsScreenKind().Equals(csScreenKind) == true)
                            {  // 親画面の場合
                                DeleteFromDataContainerTbl(csSimKind, csID);
                            }
                        }
                        else if (lEventSubNo == HySDispDefine.NOTICE_SCREEN_DISPLAY)
                        {  // 画面表示後処理指示の場合
                            if (csDBPCtlInfo.GetParentsScreenKind().Equals(csScreenKind) == false)
                            {  // 親画面以外の場合
                                if (csDBPCtlInfo.EqualScreenKind(csScreenKind) == true)
                                {  // 子画面からの報告の場合
                                    if (lEventNo == HySEventObject.NOTICE_DISPLY_NG)
                                    {  // 画面指示異常完了報告の場合は子画面識別子削除
                                        csDBPCtlInfo.RemoveChildScreenKind(csScreenKind);
                                    }
                                }
                            }
                            else
                            {  // 親画面の場合
                                if (lEventNo == HySEventObject.NOTICE_DISPLY_NG)
                                {  // 画面指示異常完了報告の場合は該当画面のデータコンテナ解放
                                    DeleteFromDataContainerTbl(csSimKind, csID);
                                }
                            }
                        }
                        bRtn = true;
                    }
                }
            }
            else if (lEventNo == HySEventObject.CMND_CLOSE_SCREEN)
            {  // 画面消去指示の場合
                if (csID is HySID)
                {  // シミュレータ識別が有効な場合
                    if (csResponseInfoID is HySID)
                    {  // 要素ＩＤが有効な場合
                        HySKind csChildKind = new HySObjectKind(csResponseInfoID.ToString());
                        csContainer = GetDataContainer(csSimKind, csID); // 既存データコンテナ検索
                        if (csContainer is HySDataContainer)
                        {  // データコンテナが有る場合
                            csEventObj = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISPLY_COMMON);
                            csEventObj.SetToSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
                            csEventObj.SetSuppID(csID);
                            csEventObj.SetResponseInfo(csResponseInfoID);
                            csEventObj.SetData(csScreenKind);
                            csEventObj.SetSubEventNo(HySDispDefine.NOTICE_SCREEN_CLOSE);
                            this.PutEvent(csEventObj);
                            bRtn = true;
                        }
                    }
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>ＧＩＳイベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = GISEventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>Boolean true:正常, false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        public virtual Boolean GISEventCallback(HySSysEvent csEvent)
        {
            //String csMethod = "HySDispBusiProcedure.GISEventCallback";
            Boolean bRtn = false;
            HySEventObject csEventObj = null;
            HySContainer csContainer = null;
            HySDispBusiProcedureCtlInfo csDBPCtlInfo = null;
            HySDataRoot csGisData = null;
            long lCnt = 0;
            int iP = 0;

            // イベント情報展開
            HySKind csScreenKind = null;
            HySEventObject csHySEvent = (HySEventObject)csEvent;
            long lEventNo = csHySEvent.GetEventNo();
            HySKind csSimKind = csHySEvent.GetToSimKind();
            HySID csID = (HySID)csHySEvent.GetSuppID();
            HySID csResponsID = (HySID)csHySEvent.GetResponseInfo();
            long lEventSubNo = ((HySEventObject)csEvent).GetSubEventNo();
            csScreenKind = (HySKind)csHySEvent.GetData();
            HySDataRoot csScreenGrKind = null;

            // 該当イベント毎処理
            if (lEventNo == HySEventObject.CMND_DISP_SCREEN)
            {  // 画面表示指示の場合
                if (csID is HySID)
                {  // データ識別子が有る場合
                    csContainer = GetDataContainer(csSimKind, csID); // データコンテナを検索
                    if (csContainer is HySDataContainer)
                    {  // データコンテナが有る場合
                        csDBPCtlInfo = (HySDispBusiProcedureCtlInfo)csContainer.GetData(HySDispDefine.DISPCTL_INFO_KEYS);
                        if (csDBPCtlInfo is HySDispBusiProcedureCtlInfo)
                        {  // 表示業務管理データが有る場合
                            if (csDBPCtlInfo.GetParentsScreenKind().Equals(csScreenKind) == false)
                            {  // 親画面以外の場合
                                csDBPCtlInfo.SetChildScreenKind(csScreenKind); // 子画面識別子追加
                                csScreenGrKind = this.GetScreenGrKind(csScreenKind,
                                                      csDBPCtlInfo.GetParentsScreenKind()); // Form識別子取得
                                if (lEventSubNo == HySDispDefine.NOTICE_NO_SEARCH_CONDITION_SCREEN_LATEST ||
                                    lEventSubNo == HySDispDefine.NOTICE_NO_SEARCH_CONDITION_SCREEN_GENERAL ||
                                    lEventSubNo == HySDispDefine.NOTICE_NO_RESULT_SELECTION_SCREEN ||
                                    lEventSubNo == HySDispDefine.NOTICE_ONLY_RESULT_SELECTION_NOTIFICATION)
                                {  // 自動更新指定の場合
                                    csDBPCtlInfo.SetParentsScreenMode(lEventSubNo);
                                }
                            }
                        }
                    }
                }
                else
                {  // 自身が親画面の場合
                    long lSeqNo = 0;
                    csGisData = null;
                    if (csScreenKind.Equals(HySDefine.DISP_FORM_GIS_BASEMAP) == true)
                    {  // ＧＩＳ画面（地図）関連イベントの場合
                        csID = new HySID(csScreenKind.ToString()); // シングル画面の場合はＩＤ固定
                        //csGisData = new HySGeoBaseMapData(36.0, 140.0, 25000);
                        csGisData = new HySGeoBaseMapData(35.30, 138.725, 10000, 50, 0);

                    }
                    else if(csScreenKind.Equals(HySDefine.DISP_FORM_RIVER_CROSSSECTION) == true)
                    {  // ＧＩＳ画面（河道横断）関連イベントの場合
                        csID = new HySID(csScreenKind.ToString()); // シングル画面の場合はＩＤ固定
                    }
                    else
                    {  // ＧＩＳ画面（メッシュ）関連イベントの場合
                        csID = this.CreateID(); // ユニークＩＤ生成
                        lSeqNo = this.CreateContainerSeqNumber(); // コンテナ毎の一貫管理番号生成
                    }
                    csContainer = GetDataContainer(csSimKind, csID); // データコンテナを検索
                    if (csContainer is HySDataContainer)
                    {  // データコンテナが有る場合
                        csDBPCtlInfo = (HySDispBusiProcedureCtlInfo)csContainer.GetData(HySDispDefine.DISPCTL_INFO_KEYS);
                    }
                    else
                    {  // データコンテナが無い場合
                        csContainer = CreateDataContainer(HySDefine.COMMON_DISP_BUSIPROCEDURE, csID); // データコンテナ生成
                        csContainer.SetData(HySDispDefine.CONTAINER_NUMBER_KEYS, new HySString(lSeqNo.ToString())); // コンテナ毎の一貫管理番号登録
                        csDBPCtlInfo = new HySDispBusiProcedureCtlInfo(csScreenKind); // 表示業務管理データ生成
                        if (lEventSubNo == HySDispDefine.NOTICE_NO_SEARCH_CONDITION_SCREEN_LATEST ||
                            lEventSubNo == HySDispDefine.NOTICE_NO_SEARCH_CONDITION_SCREEN_GENERAL ||
                            lEventSubNo == HySDispDefine.NOTICE_NO_RESULT_SELECTION_SCREEN ||
                            lEventSubNo == HySDispDefine.NOTICE_ONLY_RESULT_SELECTION_NOTIFICATION)
                        {  // 自動更新指定の場合
                            csDBPCtlInfo.SetParentsScreenMode(lEventSubNo);
                            if (lEventSubNo == HySDispDefine.NOTICE_NO_SEARCH_CONDITION_SCREEN_LATEST)
                            {  // 最新演算データ検索要求情報を含む場合は展開する
                            }
                        }
                        else
                        {  // 手動更新指定の場合
                            csDBPCtlInfo.SetParentsScreenMode(HySDispDefine.NOTICE_SCREEN_FUNDAMENTAL_MOTION);
                        }
                    }
                    if (csGisData is HySDataRoot)
                    {  // 親画面の固有データが有る場合
                        csContainer.SetData(new HySString(csScreenKind.ToString()), csGisData); // ＧＩＳデータ登録
                    }
                    csScreenGrKind = csScreenKind; // 親画面識別設定
                }
                // ビュージョブに画面表示を指示
                csEventObj = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISP_SCREEN);
                csEventObj.SetToSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
                csEventObj.SetSuppID(csID);
                csEventObj.SetData(csScreenGrKind);
                csEventObj.SetSubEventNo(HySDispDefine.NOTICE_SCREEN_DISPLAY);
                csEventObj.SetSubData(csContainer);
                this.PutEvent(csEventObj);
                csContainer.SetData(HySDispDefine.DISPCTL_INFO_KEYS, csDBPCtlInfo); // データコンテナ登録
                bRtn = true;
            }
            else if (lEventNo == HySEventObject.NOTICE_DISPLY_OK ||
                     lEventNo == HySEventObject.NOTICE_DISPLY_NG)
            {  // 画面関連一般報告(正常報告)／画面関連一般報告(異常報告)の場合
                csScreenKind = (HySKind)csHySEvent.GetData();
                if (csScreenKind is HySKind)
                {  // 表示画面識別が有る場合
                    csContainer = GetDataContainer(csSimKind, csID); // データコンテナ検索
                    if (csContainer is HySDataContainer)
                    {  // データコンテナが有る場合
                        csDBPCtlInfo = (HySDispBusiProcedureCtlInfo)csContainer.GetData(HySDispDefine.DISPCTL_INFO_KEYS);
                        if (csDBPCtlInfo is HySDispBusiProcedureCtlInfo)
                        {  // 表示業務管理データが有る場合
                            if (lEventSubNo == HySDispDefine.NOTICE_SCREEN_CLOSE)
                            {  // 画面終了後処理指示の場合
                                if (csDBPCtlInfo.GetParentsScreenKind().Equals(csScreenKind) == false)
                                {  // 親画面以外の場合
                                    csDBPCtlInfo.RemoveChildScreenKind(csScreenKind); // 子画面識別子削除
                                    // 子画面終了通知
                                    csEventObj = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISPLY_COMMON);
                                    csEventObj.SetToSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
                                    csEventObj.SetSuppID(csID);
                                    csEventObj.SetData(csDBPCtlInfo.GetParentsScreenKind());
                                    csEventObj.SetSubEventNo(lEventSubNo);
                                    csEventObj.SetSubData(csScreenKind);
                                    this.PutEvent(csEventObj);
                                }
                                else
                                {  // 親画面終了通知の場合は該当画面のデータコンテナ解放
                                    lCnt = csDBPCtlInfo.GetChildCount();
                                    for (iP = 1; iP <= (int)lCnt; iP++)
                                    {  // 登録済みの子画面数分繰り返す
                                        csEventObj = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISPLY_COMMON);
                                        csEventObj.SetToSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
                                        csEventObj.SetSuppID(csID);
                                        csEventObj.SetData((HySKind)csDBPCtlInfo.GetChildScreenKind(iP));
                                        csEventObj.SetSubEventNo(lEventSubNo);
                                        this.PutEvent(csEventObj);
                                    }
                                    DeleteFromDataContainerTbl(csSimKind, csID);
                                }
                                bRtn = true;
                            }
                            else if (lEventSubNo == HySDispDefine.NOTICE_SCREEN_DISPLAY)
                            {  // 画面表示後処理指示の場合
                                if (csDBPCtlInfo.GetParentsScreenKind().Equals(csScreenKind) == false)
                                {  // 親画面以外の場合
                                    if (csDBPCtlInfo.EqualScreenKind(csScreenKind) == true)
                                    {  // 子画面からの報告の場合
                                        if (lEventNo == HySEventObject.NOTICE_DISPLY_NG)
                                        {  // 画面指示異常完了報告の場合は子画面識別子削除
                                            csDBPCtlInfo.RemoveChildScreenKind(csScreenKind);
                                        }
                                        // 親画面にボタン占有解除を指示
                                        csEventObj = new HySEventObject(HySSysEvent.OBJID_VIEWER, lEventNo);
                                        csEventObj.SetToSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
                                        csEventObj.SetSuppID(csID);
                                        csEventObj.SetData(csDBPCtlInfo.GetParentsScreenKind());
                                        csEventObj.SetSubEventNo(lEventSubNo);
                                        csEventObj.SetSubData(csScreenKind);
                                        this.PutEvent(csEventObj);
                                    }
                                }
                                else
                                {  // 親画面の場合
                                    if (lEventNo == HySEventObject.NOTICE_DISPLY_NG)
                                    {  // 画面指示異常完了報告の場合は該当画面のデータコンテナ解放
                                        DeleteFromDataContainerTbl(csSimKind, csID);
                                    }
                                }
                                bRtn = true;
                            }
                        }
                    }
                }
                else
                {  // 管理外の報告の場合
                    //HySLog.LogOut(HySLog.TRIAL_RUN, csMethod, "管理外の報告イベント受信:" + csSimKind.GetString() + csID.GetString());
                    return bRtn;
                }
            }
            //else
            //{  // その他
            //    HySLog.LogOut(HySLog.TRIAL_RUN, csMethod, "処理対象外イベント: イベント番号: " + lEventNo.ToString());
            //}

            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを送る</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = PutEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <returns>Boolean true:正常, false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>自分からイベントを送信する時に使用する</para>
        /// </remarks>
        public virtual Boolean PutEvent(HySSysEvent csEvent)
        {
            String csMethod = "HySDispBusiProcedure.PutEvent";
            Boolean bRtn = false;

            bRtn = m_csController.PutEvent(csEvent);
            if (!bRtn)
            {
                // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, csMethod, Properties.HysMsgResources.STATEMENT_SEND_FAILURE);
              //HySLog.LogOut(HySLog.ONLINE, csMethod, "イベント送信失敗");
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>システム終了準備完了判別</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = ExitOK( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>Boolean true:システムExit準備OK、false:システムExit準備NG</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean ExitOK()
        {
            if (m_bWorkFlg == true)
            { return false; }
            else
            { return true; }
        }

        /// <summary><para>method outline:</para>
        /// <para>対応する画面グループ情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataRoot csArrayList = GetScreenGrKind(csScreenKind,csParentsScreenKind) </para>
        /// </example>
        /// <param name="csScreenKind">画面識別子</param>
        /// <param name="csParentsScreenKind">親画面識別子</param>
        /// <returns>HySDataRoot 対応する画面グループ情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDataRoot GetScreenGrKind(HySKind csScreenKind, HySKind csParentsScreenKind)
        {
            HySID csFormKind = null;
            HySDataLinkedList csArrayList = new HySDataLinkedList();

            csArrayList.AddLast(csScreenKind); // 画面識別子設定
            if (csScreenKind.Equals(HySDefine.DISP_FORM_SEARCH_CONDITION) == true)
            {  // 検索条件設定の場合
                csFormKind = HySSearchConditionScreen.GetFormKind(csParentsScreenKind);
            }
            else if (csScreenKind.Equals(HySDefine.DISP_FORM_RESULT_SELECTION) == true)
            {  // 検索結果選択の場合
                csFormKind = HySResultSelectionScreen.GetFormKind(csParentsScreenKind);
            }
            else if (csScreenKind.Equals(HySDefine.DISP_FORM_GRAPH_CUSTOMIZ) == true)
            {  // グラフカスタマイズの場合
                csFormKind = HySGraphCustomizScreen.GetFormKind(csParentsScreenKind);
            }
            if (csFormKind is HySID)
            {  // Form識別子が有効な場合
                csArrayList.AddLast(new HySObjectKind(csFormKind.ToString()));
            }
            return csArrayList;
        }

        /**********************************/
        /* データコンテナ制御関連メソッド */
        /**********************************/
        /// <summary><para>method outline:</para>
        /// <para>ID作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csID = CreateID( )</para>
        /// </example>
        /// <returns>HySID ユニークID</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected HySID CreateID()
        {
            String csIDString;
            lock (m_csSync)
            {
                DateTime csIDTime = DateTime.Now;
                // 時刻が変わった場合、ID生成用時刻を再設定し、枝番をリセットする
                TimeSpan dt = csIDTime.Subtract(m_csLastIDTime);
                TimeSpan minDt = new TimeSpan(0, 0, 0, 0, 1);   // 最小時間差=1ms
                if (dt > minDt)
                {
                    m_csLastIDTime = csIDTime;
                    m_csLastIDSuffix = 0;
                }
                else
                {
                    ++m_csLastIDSuffix;   // 枝番を加算
                }
                // ID文字列を生成({年/月/日 時:分:秒.ミリ秒}-{枝番})
                csIDString = string.Format("{0:yyyy/MM/dd HH:mm:ss.fff}-{1:D6}", m_csLastIDTime, m_csLastIDSuffix);
            }
            return new HySID(csIDString);
        }
        /// <summary><para>method outline:</para>
        /// <para>データコンテナクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySContainer csContainer = CreateDataContainer( csSimulatorKind, csID ) </para>
        /// </example>
        /// <param name="csSimulatorKind">シミュレーター種別識別子</param>
        /// <param name="csID">データ識別子</param>
        /// <returns>HySContainer データコンテナクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private HySContainer CreateDataContainer(HySKind csSimulatorKind, HySIdentifier csID)
        {
            HySDataContainer csContainer = null;
            csContainer = new HySDataContainer(csSimulatorKind, csID); // データコンテナ生成
            AddToDataContainerTbl(csContainer); // データコンテナ管理テーブルへ追加
            return csContainer;
        }
        /// <summary><para>method outline:</para>
        /// <para>コンテナ毎の一貫管理番号生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lSeqNo = CreateContainerSeqNumber()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long コンテナ毎の一貫管理番号</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private long CreateContainerSeqNumber()
        {
            long lRtn = 1;
            long lP;

            List<long> lSeqNo = new List<long>();

            HySDataLinkedList csList = m_csDataContainerTbl.GetKeyList();
            if (csList is HySDataLinkedList)
            {  // ハッシュキーリストが有る場合
                for (lP = 0; lP < csList.GetCount(); lP++)
                {
                    // 既存のコンテナ毎の一貫管理番号を取得する
                    HySDataContainer csContainer = m_csDataContainerTbl[(HySString)csList.GetData(lP)] as HySDataContainer;
                    HySString csSeqNo = csContainer.GetData(HySDispDefine.CONTAINER_NUMBER_KEYS) as HySString;
                    if (csSeqNo is HySString)
                    {  // 貫管理番号が有る場合
                        if (long.Parse(csSeqNo.ToString()) > 0)
                        {  // 管理番号が有効な場合
                            lSeqNo.Add(long.Parse(csSeqNo.ToString()));
                        }
                    }
                }
                lSeqNo.Sort();
                for (lP = 0; lP < lSeqNo.Count; lP++)
                {
                    if (lSeqNo[(int)lP] != (lP + 1))
                    {  // 一貫番号に歯抜けが有る場合
                        lRtn = (lP + 1); // 歯抜け番号を設定
                        break;
                    }
                    lRtn = lSeqNo[(int)lP] + 1; // 次番号を設定
                }
            }
            // スタック解放
            lSeqNo = null;
            csList = null;
            // リターン
            return lRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>データコンテナ管理テーブルへ追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AddToDataContainerTbl(csDataContainer)</para>
        /// </example>
        /// <param name="csDataContainer">データコンテナ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void AddToDataContainerTbl(HySDataContainer csDataContainer)
        {
            HySID csDataID = (HySID)csDataContainer.GetID();
            HySKind csSimKind = csDataContainer.GetSimKind();
            HySString csPrcID = (HySString)csDataID.GetString();
            HySString csPrcKind = (HySString)csSimKind.GetString();
            HySString csPrcKey = csPrcKind + csPrcID;
            m_csDataContainerTbl.AddObject(csPrcKey, csDataContainer);
        }
        /// <summary><para>method outline:</para>
        /// <para>データコンテナ管理テーブルから取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataContainer csDataContainer = GetDataContainer(csSimKind, csID)</para>
        /// </example>
        /// <param name="csSimKind">シミュレータ種別</param>
        /// <param name="csID">データ識別子</param>
        /// <returns>HySDataContainer データコンテナ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private HySDataContainer GetDataContainer(HySKind csSimKind, HySID csID)
        {
            if (csSimKind is HySKind && csID is HySID)
            {  // パラメータが正常な場合
                HySString csPrcID = (HySString)csID.GetString();
                HySString csPrcKind = (HySString)csSimKind.GetString();
                HySString csPrcKey = csPrcKind + csPrcID;
                return (HySDataContainer)m_csDataContainerTbl[csPrcKey];
            }
            else
            {  // パラメータが異常な場合
                return null;
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>データコンテナ管理テーブルから削除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> DeleteFromDataContainerTbl(csSimKind, csID)</para>
        /// </example>
        /// <param name="csSimKind">シミュレータ種別</param>
        /// <param name="csID">データ識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DeleteFromDataContainerTbl(HySKind csSimKind, HySID csID)
        {
            HySString csPrcID = (HySString)csID.GetString();
            HySString csPrcKind = (HySString)csSimKind.GetString();
            HySString csPrcKey = csPrcKind + csPrcID;
            m_csDataContainerTbl.DeleteData(csPrcKey);
            GC.Collect(); // 強制　ガベージコレクション
        }

        /************************/
        /* ＤＢ検索関連メソッド */
        /* **********************/
        /// <summary><para>method outline:</para>
        /// <para>外部ファイル条件展開処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ExternalConditionDevelopment(csID,csContainer,csDBPCtlInfo) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <param name="csContainer">データコンテナ</param>
        /// <param name="csDBPCtlInfo">表示業務管理データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ExternalConditionDevelopment(HySID csID, HySContainer csContainer, HySDispBusiProcedureCtlInfo csDBPCtlInfo)
        {
            HySStockData csStockData = null;
            HySKind csKind = HySDefine.COMMON_DISP_BUSIPROCEDURE;
            int iLp = 0;
            int iLp1 = 0;
            int iLp2 = 0;

            HySStockDataList csStockDataList = (HySStockDataList)csContainer.GetData(HySDispDefine.EXTERNALDATALIST_KEYS);
            if (csStockDataList is HySStockDataList)
            {  // データ検索条件クラス管理リストが有る場合
                csStockDataList.Clear();
            }
            else
            {  // データ検索条件クラス管理リストが無い場合
                csStockDataList = new HySStockDataList();
                // 外部ファイルデータ保存クラスリスト登録
                csContainer.SetData(HySDispDefine.EXTERNALDATALIST_KEYS, csStockDataList);
            }
            csStockDataList.SetCursorFirst(); // 先頭にカーソル設定
            // 検索条件エントリを設定
            HySDataLinkedList csQueryCondition = csDBPCtlInfo.GetQueryCondition();
            if (csQueryCondition is HySDataLinkedList)
            {  // 抽出条件設定が有る場合
                for (iLp = 0; iLp < csQueryCondition.GetCount(); iLp++)
                {  // 行数分繰り返す
                    HySString csKeyCondition = (HySString)csQueryCondition.GetData((long)iLp); // 入力検索条件取得
                    bool bInflg = false;
                    int iCsNo = -1;
                    string[] sInWk;
                    sInWk = csKeyCondition.ToString().Split(',');
                    for (iLp1 = 0; iLp1 < sInWk.Length; iLp1++)
                    {  // 設定項目件数分繰り返す
                        switch (iLp1)
                        {  // 項目で分岐
                            case 0: // 検索区分
                                for (iLp2 = 0; iLp2 < HySDispDefine.SEARCHDATA_TYPE.GetLength(0); iLp2++)
                                {  // 検索種別件数分繰り返す
                                    if (sInWk[iLp1].Equals(HySDispDefine.SEARCHDATA_TYPE[iLp2, 0].ToString()) == true)
                                    { // 検索種別が一致した場合
                                        switch (iLp2)
                                        {
                                            case 0: // 演算結果データ
                                                break;
                                            case 1: // 外部データ
                                                iCsNo = iLp2;
                                                // データ保存クラス生成
                                                csStockData = new HySStockData((HySObjectKind)csKind, csID);
                                                // データ種別設定
                                                csStockData.SetDataKind((HySObjectKind)HySDispDefine.STOCKDATA_KIND_EXTERNAL);
                                                // データ検索条件記憶
                                                csDBPCtlInfo.GetIDConditionList().AddObject(new HySString(csStockData.GetID().ToString()), csKeyCondition.Clone());
                                                break;
                                            default: // その他
                                                break;
                                        }
                                    }
                                }
                                break;
                            case 1: // 名称（登録名称）
                                if (iCsNo >= 0)
                                {  // 検索区分が有効な場合
                                    if (sInWk[iLp1].Length > 0)
                                    {  // 入力が有る場合
                                        HySDataHashTable csKeyInfo = new HySDataHashTable();
                                        // ファイル名称設定
                                        csStockData.SetSaveName(new HySString(sInWk[iLp1]));
                                        // プロジェクト名設定
                                        csKeyInfo.AddObject(HySCalResultDataQueryFieldNames.PROJECT_NAME, new HySString(sInWk[iLp1]));
                                        // 作成時刻設定
                                        DateTime csDT;
                                        DateTime csDTBase = DateTime.Parse("1/1/1970 0:0:0");
                                        try
                                        {
                                            csDT = System.IO.File.GetCreationTime(sInWk[iLp1]);
                                        }
                                        catch
                                        {
                                            csDT = DateTime.Now;
                                        }
                                        TimeSpan csTS = csDT - csDTBase;
                                        HySTime csOrgTime = new HySTime((long)csTS.TotalSeconds);
                                        // 登録日時設定
                                        csStockData.SetRegisertTime(csOrgTime);
                                        // 演算日時設定
                                        csKeyInfo.AddObject(HySCalLotInfoQueryFieldNames.CALC_EXEC_DATE, csOrgTime);
                                        // 外部データの妥当性を判定
                                        if (csDBPCtlInfo.GetParentsScreenKind().Equals(HySDefine.DISP_FORM_EXCEL) == true)
                                        {  // Ｅｘｃｅｌ表示の場合
                                            bInflg = true;
                                        }
                                        else
                                        {  // Ｅｘｃｅｌ表示以外の場合
                                            bool bOpenOn = false;
                                            HySFile csFile = new HySFile(csStockData.GetSaveName());
                                            try
                                            {
                                                HySString sOut = new HySString();
                                                if (csFile.Exist() == true)
                                                {  // 既存ファイルが有れば
                                                    if (csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR) == 0)
                                                    {  // 既存CSVファイルを正常に開ければ
                                                        bOpenOn = true; // ファイルオープンを記憶
                                                        while (csFile.ReadText(ref sOut) != 0)
                                                        {  // 行が有る場合
                                                            if (sOut.ToString() is string)
                                                            {  // 行情報取得ができた場合
                                                                string[] sInWkFile = sOut.ToString().Split(',');
                                                                if (sInWkFile.LongLength > 1)
                                                                {  // 行にデータが有る場合
                                                                    HySLong csLong = new HySLong(1);
                                                                    if (sInWkFile[0].Equals("Time") == true || sInWkFile[0].Equals("Value") == true)
                                                                    {  // 評価画面機能のExcelヘッダの場合
                                                                        if (csDBPCtlInfo.GetParentsScreenKind().Equals(HySDefine.DISP_FORM_RIVERBED_SHAPE) == true)
                                                                        {  // １次元縦断データグラフの場合
                                                                            if (sInWkFile.LongLength > 2)
                                                                            {  // 1次元配列時系列の場合
                                                                                csLong.m_lValue = sInWkFile.LongLength - 1;
                                                                                csKeyInfo.AddObject(HySCalResultDataQueryFieldNames.DATA_DIM1, csLong);
                                                                                bInflg = true;
                                                                            }
                                                                        }
                                                                        else if (csDBPCtlInfo.GetParentsScreenKind().Equals(HySDefine.DISP_FORM_HYDRO_HYETO_GRAPH) == true)
                                                                        {  // ハイドロ／ハイエトグラフの場合
                                                                            bInflg = true;
                                                                            if (sInWk.Length >= 16)
                                                                            {  // データ1配列の設定が有る場合
                                                                                if (sInWk[2].Equals(HySDataKindDefine.QUANTITY_OF_WATER_FLOW.ToString()) == true)
                                                                                {  // データ種別が流量の場合
                                                                                    if (sInWk[15].Length > 0)
                                                                                    {  // データ1配列に設定が有る場合
                                                                                        if (sInWk[15].Equals("1") == false)
                                                                                        {  // データ１配列＝１次元配列時系列の場合
                                                                                            if (sInWkFile.LongLength > 2)
                                                                                            {  // 1次元配列時系列の場合
                                                                                                csLong.m_lValue = sInWkFile.LongLength - 1;
                                                                                            }
                                                                                            else
                                                                                            {
                                                                                                bInflg = false;
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                            if (bInflg == true)
                                                                            {  // 登録要の場合
                                                                                csKeyInfo.AddObject(HySCalResultDataQueryFieldNames.DATA_DIM1, csLong);
                                                                            }
                                                                        }
                                                                        else
                                                                        {  // その他画面の場合
                                                                            bInflg = true;
                                                                        }
                                                                        break;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        csFile.Close();
                                                        bOpenOn = false;
                                                    }
                                                }
                                            }
                                            catch
                                            {
                                                if (bOpenOn == true)
                                                {  // ファイルオープン中の場合
                                                    if (csFile is HySFile)
                                                    {  // ファイルインスタンスが有効な場合
                                                        csFile.Close();
                                                        bOpenOn = false;
                                                    }
                                                }
                                            }
                                        }
                                        if (bInflg == true)
                                        {  // 登録要の場合
                                            csStockData.SetKeyInfo(csKeyInfo);
                                        }
                                    }
                                }
                                break;
                            default:
                                break;
                        }
                        if (bInflg == true)
                        {  // 登録要の場合
                            csStockDataList.AddLast(csStockData);
                            bInflg = false;
                            break;
                        }
                    }
                }
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>演算結果データ一覧検索条件管理データ生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CreateCalcResultListSearchCondition(csID,csContainer,csDBPCtlInfo) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <param name="csContainer">データコンテナ</param>
        /// <param name="csDBPCtlInfo">表示業務管理データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CreateCalcResultListSearchCondition(HySID csID, HySContainer csContainer, HySDispBusiProcedureCtlInfo csDBPCtlInfo)
        {
            long lCnt = 0;

            csDBPCtlInfo.SetQueryType(HySDispDefine.NOTICE_CALC_RESULT_DATA_LIST_REQUEST); // 演算結果データ一覧検索設定

            HySDataLinkedList csQueryCtlDataList = (HySDataLinkedList)csContainer.GetData(HySDispDefine.QUERYCTLDATA_KEYS);
            if (csQueryCtlDataList is HySDataLinkedList)
            {  // データ検索条件クラス管理リストが有る場合
                csQueryCtlDataList.Clear();
            }
            else
            {  // データ検索条件クラス管理リストが無い場合
                csQueryCtlDataList = new HySDataLinkedList();
                csContainer.SetData(HySDispDefine.QUERYCTLDATA_KEYS, csQueryCtlDataList); // データ検索条件クラス管理リスト登録
            }
            csQueryCtlDataList.SetCursorFirst(); // 先頭にカーソル設定
            // 検索条件エントリを設定
            HySDataLinkedList csQueryCondition = csDBPCtlInfo.GetQueryCondition();
            if (csQueryCondition is HySDataLinkedList)
            {  // 抽出条件設定が有る場合
                for (long lLp = 0; lLp < csQueryCondition.GetCount(); lLp++)
                {  // 行数分繰り返す
                    HySString csKeyCondition = (HySString)csQueryCondition.GetData(lLp); // 入力検索条件取得
                    string[] sInWk;
                    sInWk = csKeyCondition.ToString().Split(',');
                    if (sInWk[0].Equals(HySDispDefine.STOCKDATA_KIND_EXTERNAL.ToString()) == false)
                    {  // 外部データ以外の場合
                        HySDispSearchRequest csDispSearchRequest = new HySDispSearchRequest(csID, csKeyCondition); // 検索管理データクラス生成
                        csDispSearchRequest.CreateCalcResultListQuery(); // 演算結果データ一覧検索条件生成
                        csQueryCtlDataList.AddLast(csDispSearchRequest); // データ登録
                    }
                }
            }
            this.SetDigestiveNumber(csContainer, lCnt); // 検索条件消化件数初期化
        }
        /// <summary><para>method outline:</para>
        /// <para>演算結果データ検索条件管理データ生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CreateCalcResultDataSearchCondition(csID,csContainer,csDBPCtlInfo) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <param name="csContainer">データコンテナ</param>
        /// <param name="csDBPCtlInfo">表示業務管理データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CreateCalcResultDataSearchCondition(HySID csID, HySContainer csContainer, HySDispBusiProcedureCtlInfo csDBPCtlInfo)
        {
            long lCnt = 0;
            HySDataLinkedList csDataID = new HySDataLinkedList();

            csDBPCtlInfo.SetQueryType(HySDispDefine.NOTICE_CALC_RESULT_DATA_REQUEST); // 演算結果データ検索設定

            // 検索結果選択リストから検索データＩＤ一覧を作成
            ArrayList csIDList = csDBPCtlInfo.GetIDList() as ArrayList;
            HySStockDataList csStockDataList = (HySStockDataList)csContainer.GetData(HySDispDefine.STOCKDATALIST_KEYS);
            if (csStockDataList.GetCount() > 0)
            {  // 保存データが有る場合
                for (long lP = 0; lP < csStockDataList.GetCount(); lP++)
                {  // 検索結果件数分繰り返す
                    if (csIDList[(int)lP].Equals(m_csTrue) == true)
                    {  // 選択されている場合
                        HySStockData csStockData = csStockDataList.GetData(lP) as HySStockData;
                        if (csStockData is HySStockData)
                        {  // データ保存クラスが有る場合
                            if (csStockData.GetDataKind().Equals(HySDispDefine.STOCKDATA_KIND_EXTERNAL) == false)
                            {  // 外部データ種別以外の場合
                                if (csStockData.GetData() == null)
                                {  // 本体データが無い場合
                                    csDataID.AddLast(csStockData.GetID()); // データ識別子取得
                                }
                            }
                        }
                    }
                }
            }

            // データ検索条件生成
            HySDataLinkedList csQueryCtlDataList = (HySDataLinkedList)csContainer.GetData(HySDispDefine.QUERYCTLDATA_KEYS);
            if (csQueryCtlDataList is HySDataLinkedList)
            {  // データ検索条件クラス管理リストが有る場合
                csQueryCtlDataList.Clear();
            }
            else
            {  // データ検索条件クラス管理リストが無い場合
                csQueryCtlDataList = new HySDataLinkedList();
                csContainer.SetData(HySDispDefine.QUERYCTLDATA_KEYS, csQueryCtlDataList); // データ検索条件クラス管理リスト登録
            }
            csQueryCtlDataList.SetCursorFirst(); // 先頭にカーソル設定
            // 検索条件エントリを設定
            if (csDataID.GetCount() > 0)
            {  // 検索データが有る場
                HySDispSearchRequest csDispSearchRequest = new HySDispSearchRequest(csID); // 検索管理データクラス生成
                csDispSearchRequest.CreateCalcResultDtaQuery(csDataID); // 演算結果データ検索条件生成
                csQueryCtlDataList.AddLast(csDispSearchRequest);        // データ登録
            }
            this.SetDigestiveNumber(csContainer, lCnt); // 検索条件消化件数初期化
        }
        /// <summary><para>method outline:</para>
        /// <para>演算ロット情報一覧検索条件管理データ生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CreateCalcLotInfoListSearchCondition(csID,csContainer,csDBPCtlInfo) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <param name="csContainer">データコンテナ</param>
        /// <param name="csDBPCtlInfo">表示業務管理データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CreateCalcLotInfoListSearchCondition(HySID csID, HySContainer csContainer, HySDispBusiProcedureCtlInfo csDBPCtlInfo)
        {
            long lCnt = 0;
            HySDataHashTable csHashTbl = new HySDataHashTable();

            csDBPCtlInfo.SetQueryType(HySDispDefine.NOTICE_CALC_LOT_INFO_LIST_REQUEST); // 演算ロット情報一覧検索設定

            // 検索結果選択リストから検索データＩＤ一覧を作成
            ArrayList csIDList = csDBPCtlInfo.GetIDList() as ArrayList;
            HySStockDataList csStockDataList = (HySStockDataList)csContainer.GetData(HySDispDefine.STOCKDATALIST_KEYS);
            if (csStockDataList.GetCount() > 0)
            {  // 保存データが有る場合
                for (long lP = 0; lP < csStockDataList.GetCount(); lP++)
                {  // 検索結果件数分繰り返す
                    HySStockData csStockData = csStockDataList.GetData(lP) as HySStockData;
                    if (csStockData is HySStockData)
                    {  // データ保存クラスが有る場合
                        if (csStockData.GetDataKind().Equals(HySDispDefine.STOCKDATA_KIND_EXTERNAL) == false)
                        {  // 外部データ種別以外の場合
                            long lKeyNum = 0;
                            HySDataHashTable csKeyInfo = csStockData.GetKeyInfo(ref lKeyNum);
                            if (lKeyNum > 0)
                            {  // その他検索キーがある場合
                                if (csKeyInfo[HySCalResultDataQueryFieldNames.LOT_ID] != null)
                                {  // ロットＩＤが有る場合
                                    HySID csIDName = (HySID)csKeyInfo[HySCalResultDataQueryFieldNames.LOT_ID];
                                    csHashTbl.AddObject(new HySString(csIDName.ToString()),
                                                        csKeyInfo[HySCalResultDataQueryFieldNames.LOT_ID]);
                                }
                            }
                        }
                    }
                }
            }
            // ハッシュテーブルから該当ロットＩＤ一覧作成
            if (csHashTbl.GetCount() > 0)
            {  // ロットＩＤが有る場合
                List<HySID> csLotID = new List<HySID>();
                HySDataLinkedList csDataIDBuf = csHashTbl.GetKeyList();
                if (csDataIDBuf is HySDataLinkedList)
                {  // キーリスト取得正常の場合
                    for (long lP = 0; lP < csDataIDBuf.GetCount(); lP++)
                    {  // 検索結果件数分繰り返す
                        HySString csIDName = csDataIDBuf.GetData(lP) as HySString;
                        csLotID.Add(((HySID)csHashTbl[csIDName]).Clone());
                    }
                }
                // データ検索条件生成
                HySDataLinkedList csQueryCtlDataList = (HySDataLinkedList)csContainer.GetData(HySDispDefine.QUERYCTLDATA_KEYS);
                if (csQueryCtlDataList is HySDataLinkedList)
                {  // データ検索条件クラス管理リストが有る場合
                    csQueryCtlDataList.Clear();
                }
                else
                {  // データ検索条件クラス管理リストが無い場合
                    csQueryCtlDataList = new HySDataLinkedList();
                    csContainer.SetData(HySDispDefine.QUERYCTLDATA_KEYS, csQueryCtlDataList); // データ検索条件クラス管理リスト登録
                }
                csQueryCtlDataList.SetCursorFirst(); // 先頭にカーソル設定
                // 検索条件エントリを設定
                if (csLotID.Count > 0)
                {  // 検索データが有る場
                    HySQueryEntryData csEntry = new HySQueryEntryData(HySCalLotInfoQueryFieldNames.LOT_ID,
                                                                      typeof(HySID),
                                                                      HySQueryCompareMode.IN,
                                                                      csLotID.ToArray());
                    // エントリィデータ登録                   
                    HySDispSearchRequest csDispSearchRequest = new HySDispSearchRequest(csID); // 検索管理データクラス生成
                    csDispSearchRequest.CreateCalcLotInfoListQuery(csEntry); // 演算ロット情報一覧検索条件生成
                    csQueryCtlDataList.AddLast(csDispSearchRequest);         // データ登録
                }
                this.SetDigestiveNumber(csContainer, lCnt); // 検索条件消化件数初期化
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>検索要求イベント発行処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = SearchRequestEventIssue(csID,csContainer,csDBPCtlInfo) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <param name="csContainer">データコンテナ</param>
        /// <param name="csDBPCtlInfo">表示業務管理データ</param>
        /// <returns>bool 要求状態(=true:要求残有、=false:要求残無）</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool SearchRequestEventIssue(HySID csID, HySContainer csContainer, HySDispBusiProcedureCtlInfo csDBPCtlInfo)
        {
            //String csMethod = "HySDispBusiProcedure.SearchRequestEventIssue";
            bool bRtn = false; // 残データ無し設定

            HySDataLinkedList csQueryCtlDataList = (HySDataLinkedList)csContainer.GetData(HySDispDefine.QUERYCTLDATA_KEYS);
            if (csQueryCtlDataList is HySDataLinkedList)
            {  // データ検索条件クラス管理リストが有る場合
                if (csQueryCtlDataList.GetCount() > 0)
                {  // 検索条件データが有る場合
                    long lCnt = this.GetDigestiveNumber(csContainer); // 検索条件取得位置設定
                    // 検索条件取得
                    if (lCnt < csQueryCtlDataList.GetCount())
                    {  // 検索残条件が有る場合
                        HySDispSearchRequest csDispSearchRequest = (HySDispSearchRequest)csQueryCtlDataList.GetData(lCnt);
                        if (csDispSearchRequest is HySDispSearchRequest)
                        {  // 取得データ検索条件が有効な場合ライブラリマネージャに検索を指示する
                            HySEventObject csEventObj = new HySEventObject(HySSysEvent.OBJID_LIBMANAGER, HySEventObject.CMND_DB_QUERY);
                            csEventObj.SetSubEventNo(csDispSearchRequest.GetSubEventNo()); // サブイベント番号（検索方式）
                            if (csDBPCtlInfo.GetQueryType() == HySDispDefine.NOTICE_CALC_RESULT_DATA_LIST_REQUEST)
                            {  // 演算結果データ一覧検索の場合
                                csEventObj.SetData(csDispSearchRequest.GetQueryCtlData()); // 付属データ（検索条件）
                            }
                            else if (csDBPCtlInfo.GetQueryType() == HySDispDefine.NOTICE_CALC_RESULT_DATA_REQUEST)
                            {  // 演算結果データ検索の場合
                                csEventObj.SetData(csDispSearchRequest.GetDtatIDList());   // 付属データ（データＩＤ）
                            }
                            else if (csDBPCtlInfo.GetQueryType() == HySDispDefine.NOTICE_CALC_LOT_INFO_LIST_REQUEST)
                            {  // 演算ロット一覧検索の場合
                                csEventObj.SetData(csDispSearchRequest.GetQueryCtlData()); // 付属データ（検索条件）
                            }
                            else
                            {  // その他の場合
                                return bRtn;
                            }
                            csEventObj.SetToSimKind(csDispSearchRequest.GetToSimKind());   // 送り先シミュレーション識別子
                            csEventObj.SetFromSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);// 送り元シミュレーション識別子
                            csEventObj.SetSuppID(csDispSearchRequest.GetDataID());         // 検索するデータ識別子
                            csEventObj.SetResponseInfo(csID.Clone());                      // 応答情報識別子設定
                            m_csController.PutEvent(csEventObj); // ライブラリマネージャにイベントを発行
                            bRtn = true; // 残データ有り設定
                            //HySLog.LogOut(HySLog.TRIAL_RUNE, csMethod, "ＤＢ検索イベント送信:" + csDispSearchRequest.GetDataID().ToString());
                        }
                    }
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>演算ロット情報更新条件管理データ生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CreateCalcLotInfoUpdateCondition(csID,csContainer,csDBPCtlInfo) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <param name="csContainer">データコンテナ</param>
        /// <param name="csDBPCtlInfo">表示業務管理データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CreateCalcLotInfoUpdateCondition(HySID csID, HySContainer csContainer, HySDispBusiProcedureCtlInfo csDBPCtlInfo)
        {
            long lCnt = 0;
            long lKeyNum = 0;
            HySID csLotID = null;
            HySStockDataList csStockDataList = null;
            HySStockData csStockData = null;
            HySDataHashTable csKeyInfo = null;
            HySDataHashTable csHashTbl = new HySDataHashTable();
            List<HySID> csLotID_True = new List<HySID>();
            List<HySID> csLotID_False = new List<HySID>();
            HySQueryEntryData csEntry = null;
            HySLong csPeservedPeriod = null;
            HySDispSearchRequest csDispSearchRequest = null;
            HySDBPartialUpdateSpec csUpdateSpec = null;
            HySStockData.PeservedPeriod csPreservedPeriod = HySStockData.PeservedPeriod.Temporary;
            HySString csTrue = new HySString("true");
            HySString csFalse = new HySString("false");

            csDBPCtlInfo.SetQueryType(HySDispDefine.NOTICE_CALC_LOT_INFO_UPDATE_REQUEST); // 演算ロット情報更新設定

            HySDataLinkedList csQueryCtlDataList = (HySDataLinkedList)csContainer.GetData(HySDispDefine.QUERYCTLDATA_KEYS);
            if (csQueryCtlDataList is HySDataLinkedList)
            {  // データ検索条件クラス管理リストが有る場合
                csQueryCtlDataList.Clear();
            }
            else
            {  // データ検索条件クラス管理リストが無い場合
                csQueryCtlDataList = new HySDataLinkedList();
                csContainer.SetData(HySDispDefine.QUERYCTLDATA_KEYS, csQueryCtlDataList); // データ検索条件クラス管理リスト登録
            }

            // 検索結果選択リストから検索データＩＤ一覧を作成
            csStockDataList = (HySStockDataList)csContainer.GetData(HySDispDefine.STOCKDATALIST_KEYS);
            if (csStockDataList.GetCount() > 0)
            {  // 保存データが有る場合
                for (long lP = 0; lP < csStockDataList.GetCount(); lP++)
                {  // 検索結果件数分繰り返す
                    csStockData = csStockDataList.GetData(lP) as HySStockData;
                    if (csStockData is HySStockData)
                    {  // データ保存クラスが有る場合
                        if (csStockData.GetDataKind().Equals(HySDispDefine.STOCKDATA_KIND_EXTERNAL) == false)
                        {  // 外部データ種別以外の場合
                            lKeyNum = 0;
                            csKeyInfo = csStockData.GetKeyInfo(ref lKeyNum);
                            if (lKeyNum > 0)
                            {  // その他検索キーがある場合
                                if (csKeyInfo[HySCalResultDataQueryFieldNames.LOT_ID] != null)
                                {  // ロットＩＤが有る場合
                                    csLotID = csKeyInfo[HySCalResultDataQueryFieldNames.LOT_ID] as HySID;
                                    csPreservedPeriod = csStockData.GetPeservedPeriod();
                                    if (csPreservedPeriod == HySStockData.PeservedPeriod.Temporary)
                                    {  // 保存期限区分が一時保存の場合
                                        csHashTbl.AddObject(new HySString(csLotID.ToString()), csFalse.Clone());
                                    }
                                    else
                                    {  // 保存期限区分が永久保存の場合
                                        csHashTbl.AddObject(new HySString(csLotID.ToString()), csTrue.Clone());
                                    }
                                }
                            }
                        }
                    }
                }
            }
            // ハッシュテーブルから該当ロットＩＤ一覧作成
            if (csHashTbl.GetCount() > 0)
            {  // ロットＩＤが有る場合
                csStockDataList = (HySStockDataList)csContainer.GetData(HySDispDefine.PERMANENREPOSITORY_KEYS);
                if (csStockDataList.GetCount() > 0)
                {  // 保存データが有る場合
                    for (long lP = 0; lP < csStockDataList.GetCount(); lP++)
                    {  // 検索結果件数分繰り返す
                        csStockData = csStockDataList.GetData(lP) as HySStockData;
                        if (csStockData is HySStockData)
                        {  // データ保存クラスが有る場合
                            lKeyNum = 0;
                            csKeyInfo = csStockData.GetKeyInfo(ref lKeyNum);
                            if (lKeyNum > 0)
                            {  // その他検索キーがある場合
                                if (csKeyInfo[HySCalResultDataQueryFieldNames.LOT_ID] != null)
                                {  // ロットＩＤが有る場合
                                    csLotID = csKeyInfo[HySCalResultDataQueryFieldNames.LOT_ID] as HySID;
                                    csPreservedPeriod = csStockData.GetPeservedPeriod();
                                    if (csPreservedPeriod == HySStockData.PeservedPeriod.Temporary)
                                    {  // 保存期限区分が一時保存の場合
                                        if (((HySString)csHashTbl[new HySString(csLotID.ToString())]).Equal(csFalse) == false)
                                        {  // 永久保存に格上げの場合
                                            csLotID_True.Add((HySID)csKeyInfo[HySCalResultDataQueryFieldNames.LOT_ID]);
                                        }
                                    }
                                    else
                                    {  // 保存期限区分が永久保存の場合
                                        if (((HySString)csHashTbl[new HySString(csLotID.ToString())]).Equal(csTrue) == false)
                                        {  // 一時保存に格下げの場合
                                            csLotID_False.Add((HySID)csKeyInfo[HySCalResultDataQueryFieldNames.LOT_ID]);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                if (csLotID_True.Count > 0 || csLotID_False.Count > 0)
                {  // 保存期限区分の変更が有る場合
                    csQueryCtlDataList.SetCursorFirst(); // 先頭にカーソル設定
                    if (csLotID_True.Count > 0)
                    {  // 永久保存への更新の場合
                        csEntry = new HySQueryEntryData(HySCalLotInfoQueryFieldNames.LOT_ID,
                                                                          typeof(HySID),
                                                                          HySQueryCompareMode.IN,
                                                                          csLotID_True.ToArray());
                        // エントリデータ生成
                        csPeservedPeriod = new HySLong((long)HySStockData.PeservedPeriod.Eternity);
                        csUpdateSpec = new HySDBPartialUpdateSpec();
                        csUpdateSpec.GetQueryCtlData().SetQueryEntryData(csEntry);
                        csUpdateSpec.GetModifyData().AddObject(HySCalLotInfoQueryFieldNames.PRESERVED_PERIOD,
                                                               csPeservedPeriod);
                        // 検索管理データクラス生成
                        csDispSearchRequest = new HySDispSearchRequest(csID);
                        csDispSearchRequest.CreateCalcLotInfoUpdateQuery(csUpdateSpec); // 演算ロット情報更新条件生成
                        csQueryCtlDataList.AddLast(csDispSearchRequest);                // データ登録
                    }
                    if (csLotID_False.Count > 0)
                    {  // 一時保存への更新の場合
                        csEntry = new HySQueryEntryData(HySCalLotInfoQueryFieldNames.LOT_ID,
                                                                          typeof(HySID),
                                                                          HySQueryCompareMode.IN,
                                                                          csLotID_False.ToArray());
                        // エントリデータ生成
                        csPeservedPeriod = new HySLong((long)HySStockData.PeservedPeriod.Temporary);
                        csUpdateSpec = new HySDBPartialUpdateSpec();
                        csUpdateSpec.GetQueryCtlData().SetQueryEntryData(csEntry);
                        csUpdateSpec.GetModifyData().AddObject(HySCalLotInfoQueryFieldNames.PRESERVED_PERIOD,
                                                               csPeservedPeriod);
                        // 検索管理データクラス生成
                        csDispSearchRequest = new HySDispSearchRequest(csID);
                        csDispSearchRequest.CreateCalcLotInfoUpdateQuery(csUpdateSpec); // 演算ロット情報更新条件生成
                        csQueryCtlDataList.AddLast(csDispSearchRequest);                // データ登録
                    }
                }
                this.SetDigestiveNumber(csContainer, lCnt); // 検索条件消化件数初期化
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>更新要求イベント発行処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = UpdateRequestEventIssue(csID,csContainer,csDBPCtlInfo) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <param name="csContainer">データコンテナ</param>
        /// <param name="csDBPCtlInfo">表示業務管理データ</param>
        /// <returns>bool 要求状態(=true:要求残有、=false:要求残無）</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool UpdateRequestEventIssue(HySID csID, HySContainer csContainer, HySDispBusiProcedureCtlInfo csDBPCtlInfo)
        {
            bool bRtn = false; // 残データ無し設定

            HySDataLinkedList csQueryCtlDataList = (HySDataLinkedList)csContainer.GetData(HySDispDefine.QUERYCTLDATA_KEYS);
            if (csQueryCtlDataList is HySDataLinkedList)
            {  // データ検索条件クラス管理リストが有る場合
                if (csQueryCtlDataList.GetCount() > 0)
                {  // 検索条件データが有る場合
                    long lCnt = this.GetDigestiveNumber(csContainer); // 検索条件取得位置設定
                    // 検索条件取得
                    if (lCnt < csQueryCtlDataList.GetCount())
                    {  // 検索残条件が有る場合
                        HySDispSearchRequest csDispSearchRequest = (HySDispSearchRequest)csQueryCtlDataList.GetData(lCnt);
                        if (csDispSearchRequest is HySDispSearchRequest)
                        {  // 取得データ検索条件が有効な場合ライブラリマネージャに検索を指示する
                            HySEventObject csEventObj = new HySEventObject(HySSysEvent.OBJID_LIBMANAGER, HySEventObject.CMND_DB_REGISTER);
                            csEventObj.SetSubEventNo(csDispSearchRequest.GetSubEventNo()); // サブイベント番号（検索方式）
                            if (csDBPCtlInfo.GetQueryType() == HySDispDefine.NOTICE_CALC_LOT_INFO_UPDATE_REQUEST)
                            {  // 演算ロット更新の場合
                                csEventObj.SetData(csDispSearchRequest.GetUpdateSpec());     // 付属データ（更新条件）
                            }
                            else
                            {  // その他の場合
                                return bRtn;
                            }
                            csEventObj.SetToSimKind(csDispSearchRequest.GetToSimKind());   // 送り先シミュレーション識別子
                            csEventObj.SetFromSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);// 送り元シミュレーション識別子
                            csEventObj.SetSuppID(csDispSearchRequest.GetDataID());         // 検索するデータ識別子
                            csEventObj.SetResponseInfo(csID.Clone());                      // 応答情報識別子設定
                            m_csController.PutEvent(csEventObj); // ライブラリマネージャにイベントを発行
                            bRtn = true; // 残データ有り設定
                        }
                    }
                }
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>検索完了判定処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = RetrievalCompletionJudgment(csContainer,csDBPCtlInfo,csStockDataList) </para>
        /// </example>
        /// <param name="csContainer">データコンテナ</param>
        /// <param name="csDBPCtlInfo">表示業務管理データ</param>
        /// <param name="csStockDataList">応答データ</param>
        /// <returns>bool 要求状態(=true:完了、=false:未完了）</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool RetrievalCompletionJudgment(HySContainer csContainer, HySDispBusiProcedureCtlInfo csDBPCtlInfo, HySStockDataList csStockDataList)
        {
            bool bRtn = true; // 完了設定
            HySDispSearchRequest csDispSearchRequest = null;
            HySString csQueryKeys = null;

            HySDataLinkedList csQueryCtlDataList = (HySDataLinkedList)csContainer.GetData(HySDispDefine.QUERYCTLDATA_KEYS);
            if (csQueryCtlDataList is HySDataLinkedList)
            {  // データ検索条件クラス管理リストが有る場合
                if (csQueryCtlDataList.GetCount() > 0)
                {  // 検索条件データが有る場合
                    long lCnt = this.GetDigestiveNumber(csContainer); // 検索条件取得位置設定
                    // 検索条件取得
                    if (lCnt < csQueryCtlDataList.GetCount())
                    {  // 検索残条件が有る場合
                        csDispSearchRequest = (HySDispSearchRequest)csQueryCtlDataList.GetData(lCnt);
                        if (csDispSearchRequest is HySDispSearchRequest)
                        {  // データ検索条件が有効な場合
                            this.SetDigestiveNumber(csContainer, (long)(this.GetDigestiveNumber(csContainer) + 1)); // 検索消化件数更新
                        }
                    }
                    // 対応する検索条件を記憶する
                    if (csDBPCtlInfo.GetQueryType() == HySDispDefine.NOTICE_CALC_RESULT_DATA_LIST_REQUEST)
                    {  // 演算結果データ一覧検索の場合
                        csDispSearchRequest = (HySDispSearchRequest)csQueryCtlDataList.GetData(lCnt);
                        if (csDispSearchRequest is HySDispSearchRequest)
                        {  // データ検索条件が有効な場合
                            csQueryKeys = csDispSearchRequest.GetQueryCondition();
                            for (long lP = 0; lP < csStockDataList.GetCount(); lP++)
                            {  // 検索結果件数分繰り返す
                                HySStockData csStockData = csStockDataList.GetData(lP) as HySStockData;
                                if (csStockData is HySStockData)
                                {  // データ保存クラスの場合
                                    csDBPCtlInfo.GetIDConditionList().AddObject(new HySString(csStockData.GetID().ToString()), csQueryKeys.Clone());
                                }
                            }
                        }
                    }
                }
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>検索リトライ依頼設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetRetrievalRetry(csContainer) </para>
        /// </example>
        /// <param name="csContainer">データコンテナ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetRetrievalRetry(HySContainer csContainer)
        {
            String csMethod = "HySDispBusiProcedure.SetRetrievalRetry";

            HySDataLinkedList csQueryCtlDataList = (HySDataLinkedList)csContainer.GetData(HySDispDefine.QUERYCTLDATA_KEYS);
            if (csQueryCtlDataList is HySDataLinkedList)
            {  // データ検索条件クラス管理リストが有る場合
                if (csQueryCtlDataList.GetCount() > 0)
                {  // 検索条件データが有る場合
                    long lCnt = this.GetDigestiveNumber(csContainer); // 検索条件取得位置設定
                    // 検索条件取得
                    if (lCnt < csQueryCtlDataList.GetCount())
                    {  // 検索残条件が有る場合
                        HySDispSearchRequest csDispSearchRequest = (HySDispSearchRequest)csQueryCtlDataList.GetData(lCnt);
                        if (csDispSearchRequest is HySDispSearchRequest)
                        {  // データ検索条件が有効な場合
                            if (csDispSearchRequest.UpRetryCount() == false)
                            {  // リトライ不可の場合
                                this.SetDigestiveNumber(csContainer, (long)(this.GetDigestiveNumber(csContainer) + 1)); // 検索消条件化件数更新
                                // ver1.5 エラートレース日本語対応
                                string DispStatement = Properties.HysMsgResources.STATEMENT_DB_ERROR + " (" + Properties.HysMsgResources.STATEMENT_SEARCH_ROWNO + lCnt.ToString() + ")";
                                HySLog.LogOut(HySLog.TRIAL_RUN, csMethod, DispStatement);
                              //HySLog.LogOut(HySLog.TRIAL_RUN, csMethod, "ＤＢ検索異常発生（検索行番号: " + lCnt.ToString() + "）");
                            }
                        }
                    }
                }
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>検索条件データ消化件数設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetRetrievalDataPoint(csContainer,lCount) </para>
        /// </example>
        /// <param name="csContainer">データコンテナ</param>
        /// <param name="lCount">ポインタ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetDigestiveNumber(HySContainer csContainer, long lCount)
        {
            HySString csCount = new HySString(lCount.ToString());
            csContainer.SetData(HySDispDefine.QUERYCTLDATAPOINT_KEYS, csCount); // 検索消化件数設定
        }
        /// <summary><para>method outline:</para>
        /// <para>検索条件データ消化件数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lCount = GetRetrievalDataPoint(csContainer) </para>
        /// </example>
        /// <param name="csContainer">データコンテナ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetDigestiveNumber(HySContainer csContainer)
        {
            HySString csCount = (HySString)csContainer.GetData(HySDispDefine.QUERYCTLDATAPOINT_KEYS); // 検索消化件数取得
            return long.Parse(csCount.ToString());
        }
        /// <summary><para>method outline:</para>
        /// <para>検索結果データの間引き処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>StockDataThinningOut(csContainer,csDBPCtlInfo) </para>
        /// </example>
        /// <param name="csContainer">データコンテナ</param>
        /// <param name="csDBPCtlInfo">表示業務管理データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void StockDataThinningOut(HySContainer csContainer, HySDispBusiProcedureCtlInfo csDBPCtlInfo)
        {
            HySID csLotID = null;
            bool bGISFlg = false;
            bool bExcelFlg = false;
            bool bRainFlg = false;
            long lKeyNum = 0;
            HySDataHashTable csKeyInfo = null;
            List<HySStockData> csStockList = new List<HySStockData>();

            // 時系列一覧作成
            HySStockDataList csStockDataList = (HySStockDataList)csContainer.GetData(HySDispDefine.STOCKDATALIST_KEYS);
            if (csStockDataList.GetCount() > 0)
            {  // 保存データが有る場合
                for (long lP = 0; lP < csStockDataList.GetCount(); lP++)
                {  // 検索結果件数分繰り返す
                    HySStockData csStockData = csStockDataList.GetData(lP) as HySStockData;
                    if (csStockData is HySStockData)
                    {  // データ保存クラスの場合
                        csKeyInfo = csStockData.GetKeyInfo(ref lKeyNum);
                        HySObjectKind csDataType = csKeyInfo[HySCalResultDataQueryFieldNames.DATA_TYPE] as HySObjectKind;
                        HySLong csDataDim1 = csKeyInfo[HySCalResultDataQueryFieldNames.DATA_DIM1] as HySLong;
                        HySLong csDataDim2 = csKeyInfo[HySCalResultDataQueryFieldNames.DATA_DIM2] as HySLong;
                        HySLong csDataDim3 = csKeyInfo[HySCalResultDataQueryFieldNames.DATA_DIM3] as HySLong;
                        if (csDataType is HySObjectKind)
                        {  // データ型の定義が有る場合
                            HySKind csScreenKind = (HySKind)csDBPCtlInfo.GetParentsScreenKind();
                            if (csScreenKind.Equals(HySDefine.DISP_FORM_GIS_BASEMAP) == true ||
                                csScreenKind.Equals(HySDefine.DISP_FORM_GIS_FIGURE) == true ||
                                csScreenKind.Equals(HySDefine.DISP_FORM_GIS_HYDRLGCL_OBJ) == true ||
                                csScreenKind.Equals(HySDefine.DISP_FORM_GIS2D_MESH) == true ||
                                csScreenKind.Equals(HySDefine.DISP_FORM_GIS3D_FIGURE) == true ||
                                csScreenKind.Equals(HySDefine.DISP_FORM_GIS3D_MESH) == true ||
                                csScreenKind.Equals(HySDefine.DISP_FORM_RIVER_CROSSSECTION) == true)
                            {  // ＧＩＳ画面関連イベントの場合
                                csStockList.Add(csStockData); // 保存データリスト格納
                                bGISFlg = true;
                            }
                            else if (csScreenKind.Equals(HySDefine.DISP_FORM_LINE_GRAPH) == true)
                            {  // 基本画面の場合
                                if (csDataDim1.m_lValue == 1 && csDataDim2.m_lValue == 0 && csDataDim3.m_lValue == 0)
                                {  // ポイント時系列の場合
                                    csStockList.Add(csStockData); // 保存データリスト格納
                                }
                            }
                            else if (csScreenKind.Equals(HySDefine.DISP_FORM_HYDRO_HYETO_GRAPH) == true)
                            {  // ハイドロ／ハイエト画面の場合
                                if (csDataDim2.m_lValue == 0 && csDataDim3.m_lValue == 0)
                                {  // ポイント時系列または１次元配列時系列の場合
                                    if (csStockData.GetDataKind().Equals(HySDataKindDefine.QUANTITY_OF_WATER_FLOW) == true ||
                                        csStockData.GetDataKind().Equals(HySDataKindDefine.SCALOR_RAIN_FALL) == true)
                                    {  // データ種別が「流量」と「雨量」の場合
                                        csStockList.Add(csStockData); // 保存データリスト格納
                                    }
                                }
                            }
                            else if (csScreenKind.Equals(HySDefine.DISP_FORM_RIVERBED_SHAPE) == true)
                            {  // 縦断データ画面の場合
                                if (csDataDim1.m_lValue > 1 && csDataDim2.m_lValue == 0 && csDataDim3.m_lValue == 0)
                                {  // １次元配列時系列の場合
                                    csStockList.Add(csStockData); // 保存データリスト格納
                                }
                            }
                            else if (csScreenKind.Equals(HySDefine.DISP_FORM_HQ_GRAPH) == true)
                            {  // Ｈ－Ｑグラフ画面の場合
                            }
                            else if (csScreenKind.Equals(HySDefine.DISP_FORM_EXCEL) == true)
                            {  // Ｅｘｃｅｌ画面の場合
                                csStockList.Add(csStockData); // 保存データリスト格納
                                bExcelFlg = true;
                            }
                        }
                    }
                }
                // 保存データを時系列にソートする
                if (csStockList.Count > 1)
                {  // ソートデータが有る場合
                    csStockList.Sort(
                        delegate(HySStockData csFrom, HySStockData csTo)
                        {
                            if (csFrom is HySStockData && csTo is HySStockData)
                            {
                                HySDataHashTable csKeyFromInfo = csFrom.GetKeyInfo(ref lKeyNum);
                                if (csKeyFromInfo[HySCalLotInfoQueryFieldNames.CALC_EXEC_DATE] != null)
                                {  // 演算実施日が有る場合
                                    HySTime csTime1 = (HySTime)csKeyFromInfo[HySCalResultDataQueryFieldNames.CALC_EXEC_DATE];
                                    HySDataHashTable csKeyToInfo = csTo.GetKeyInfo(ref lKeyNum);
                                    if (csKeyToInfo[HySCalLotInfoQueryFieldNames.CALC_EXEC_DATE] != null)
                                    {  // 演算実施日が有る場合
                                        HySTime csTime2 = (HySTime)csKeyToInfo[HySCalResultDataQueryFieldNames.CALC_EXEC_DATE];
                                        return (int)(csTime2.GetTime() - csTime1.GetTime());
                                    }
                                }
                            }
                            return 0;
                        }
                    );
                }
                if (csStockList.Count > 0)
                {  // ソートデータが有る場合
                    csKeyInfo = csStockList[0].GetKeyInfo(ref lKeyNum);
                    if (csKeyInfo[HySCalResultDataQueryFieldNames.LOT_ID] != null)
                    {  // ロットＩＤが有る場合
                        csLotID = (HySID)csKeyInfo[HySCalResultDataQueryFieldNames.LOT_ID];
                    }
                }

                ArrayList csIDList = csDBPCtlInfo.GetIDList() as ArrayList;
                csStockDataList.Clear(); // リストを初期化
                if (csDBPCtlInfo.GetParentsScreenMode() == HySDispDefine.NOTICE_NO_SEARCH_CONDITION_SCREEN_LATEST)
                {  // 最新演算データの自動更新画面モードの場合
                    bool bNewUpFlg = false;
                    HySDataLinkedList csOldID = null;
                    HySDataLinkedList csOldIDList = null;
                    HySDataLinkedList csWork = csDBPCtlInfo.GetTemporaryDataList(HySDefine.DISP_FORM_SEARCH_CONDITION) as HySDataLinkedList;
                    if (csWork is HySDataLinkedList)
                    {  // 検索情報記憶エリアが有効な場合
                        if (csWork.GetCount() >= 3)
                        {  // 前回情報の退避が有る場合
                            csOldID = csWork.GetData((long)1) as HySDataLinkedList;
                            csOldIDList = csWork.GetData((long)2) as HySDataLinkedList;
                            bNewUpFlg = true;
                        }
                    }
                    // 今回の検索最新版データ取得
                    bool bBreakFlg = false;
                    bRainFlg = false;
                    for (int iLp = 0; iLp < csStockList.Count; iLp++)
                    {  // 検索結果件数分繰り返す
                        csKeyInfo = csStockList[iLp].GetKeyInfo(ref lKeyNum);
                        if (csLotID.Equals((HySID)csKeyInfo[HySCalResultDataQueryFieldNames.LOT_ID]) == true)
                        {  // ロットＩＤが一致の場合
                            if (bNewUpFlg == true)
                            {  // 同一データの再更新取得チェック要の場合
                                for (int iLp1 = 0; iLp1 < csOldID.GetCount(); iLp1++)
                                {  // 退避識別ＩＤ件数分繰り返す
                                    string sWk1 = ((HySID)csStockList[iLp].GetID()).ToString();
                                    string sWk2 = ((HySID)csOldID.GetData((long)iLp1)).ToString();
                                    if (sWk1 == sWk2)
                                    {  // 退避データ識別と一致した場合
                                        bBreakFlg = true; // 中断設定
                                        break;
                                    }
                                }
                                if (bBreakFlg == true)
                                {  // 中断要の場合
                                    break;
                                }
                                else
                                {  // 中断否の場合
                                    csStockDataList.AddLast(csStockList[iLp]); // 保存データ設定
                                    csIDList.Add(m_csTrue.Clone());
                                }
                            }
                            else
                            {  // 同一データの再更新取得チェック不要の場合
                                csStockDataList.AddLast(csStockList[iLp]); // 保存データ設定
                                csIDList.Add(m_csTrue.Clone());
                            }
                        }
                    }
                    // 既存データで保存要情報の復帰
                    if (bNewUpFlg == true)
                    {  // 退避データの復帰が必要な場合
                        for (int iLp = 0; iLp < csStockList.Count; iLp++)
                        {  // 検索結果件数分繰り返す
                            for (int iLp1 = 0; iLp1 < csOldID.GetCount(); iLp1++)
                            {  // 退避識別ＩＤ件数分繰り返す
                                string sWk1 = ((HySID)csStockList[iLp].GetID()).ToString();
                                string sWk2 = ((HySID)csOldID.GetData((long)iLp1)).ToString();
                                if(sWk1 == sWk2)
                                {  // 退避データ識別と一致した場合
                                    csStockDataList.AddLast(csStockList[iLp]); // 保存データ設定
                                    csIDList.Add(((HySString)csOldIDList.GetData((long)iLp1)).Clone()); // 選択状態復帰
                                    break;
                                }
                            }
                        }
                    }
                }
                else
                {  // 通常検索による画面更新の場合
                    bRainFlg = false;
                    bool bWaterFlg = false;
                    for (int iLp = 0; iLp < csStockList.Count; iLp++)
                    {  // 検索結果件数分繰り返す
                        csKeyInfo = csStockList[iLp].GetKeyInfo(ref lKeyNum);
                        csStockDataList.AddLast(csStockList[iLp]); // 保存データ設定
                        if (csLotID.Equals((HySID)csKeyInfo[HySCalResultDataQueryFieldNames.LOT_ID]) == true)
                        {  // ロットＩＤが一致の場合
                            if (bGISFlg == true || bExcelFlg == true)
                            {  // ＧＩＳ要求またはＥｘｃｅｌ表示の場合
                                csIDList.Add(m_csFalse.Clone());
                            }
                            else
                            {  // 演算結果要求の場合
                                if (csDBPCtlInfo.GetParentsScreenKind().Equals(HySDefine.DISP_FORM_HYDRO_HYETO_GRAPH) == true)
                                {  // ハイドロ／ハイエト画面の場合
                                    if (csStockList[iLp].GetDataKind().Equals(HySDataKindDefine.SCALOR_RAIN_FALL) == true)
                                    {  // データ種別が「雨量」の場合
                                        if (bRainFlg == false)
                                        {  // 初回の場合
                                            csIDList.Add(m_csTrue.Clone());
                                            bRainFlg = true;
                                        }
                                        else
                                        {  // 初回以降の場合
                                            csIDList.Add(m_csFalse.Clone());
                                        }
                                    }
                                    else
                                    {  // データ種別が「雨量」以外の場合
                                        csIDList.Add(m_csTrue.Clone());
                                        bWaterFlg = true;
                                    }
                                }
                                else
                                {  // ハイドロ／ハイエト画面以外の場合
                                    csIDList.Add(m_csTrue.Clone());
                                }
                            }
                        }
                        else
                        {  // ロットＩＤが不一致の場合
                            if (csDBPCtlInfo.GetParentsScreenKind().Equals(HySDefine.DISP_FORM_HYDRO_HYETO_GRAPH) == true)
                            {  // ハイドロ／ハイエト画面の場合
                                if (csStockList[iLp].GetDataKind().Equals(HySDataKindDefine.SCALOR_RAIN_FALL) == true)
                                {  // データ種別が「雨量」の場合
                                    if (bRainFlg == false)
                                    {  // 初回の場合
                                        csIDList.Add(m_csTrue.Clone());
                                        bRainFlg = true;
                                    }
                                    else
                                    {  // 初回以降の場合
                                        csIDList.Add(m_csFalse.Clone());
                                    }
                                }
                                else
                                {  // データ種別が「雨量」以外の場合
                                    if (bWaterFlg == false)
                                    {  // 初回の場合
                                        csIDList.Add(m_csTrue.Clone());
                                        csLotID = (HySID)csKeyInfo[HySCalResultDataQueryFieldNames.LOT_ID]; 
                                        bWaterFlg = true;
                                    }
                                    else
                                    {  // 初回以降の場合
                                        csIDList.Add(m_csFalse.Clone());
                                    }
                                }
                            }
                            else
                            {  // ハイドロ／ハイエト画面以外の場合
                                csIDList.Add(m_csFalse.Clone());
                            }
                        }
                    }
                }
                csStockList = null;
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>検索結果データのマージ処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>StockDataMerging(csAnsStockList, csContainer,csDBPCtlInfo) </para>
        /// </example>
        /// <param name="csAnsStockList">検索データ本体</param>
        /// <param name="csContainer">データコンテナ</param>
        /// <param name="csDBPCtlInfo">表示業務管理データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void StockDataMerging(HySStockDataList csAnsStockList, HySContainer csContainer, HySDispBusiProcedureCtlInfo csDBPCtlInfo)
        {
           // 検索結果選択リストから検索データＩＤ一覧を作成
            ArrayList csIDList = csDBPCtlInfo.GetIDList() as ArrayList;
            HySStockDataList csStockDataList = (HySStockDataList)csContainer.GetData(HySDispDefine.STOCKDATALIST_KEYS);
            if (csStockDataList.GetCount() > 0)
            {  // 保存データが有る場合
                for (long lP = 0; lP < csStockDataList.GetCount(); lP++)
                {  // 検索結果件数分繰り返す
                    if (csDBPCtlInfo.GetQueryType() == HySDispDefine.NOTICE_CALC_RESULT_DATA_REQUEST)
                    {  // 演算結果データ検索の場合
                        if (csIDList[(int)lP].Equals(m_csTrue) == true)
                        {  // 選択されている場合
                            HySStockData csStockData = csStockDataList.GetData(lP) as HySStockData;
                            if (csStockData is HySStockData)
                            {  // データ保存クラスが有る場合
                                if (csStockData.GetData() == null)
                                {  // 本体データが無い場合
                                    for (long lP1 = 0; lP1 < csAnsStockList.GetCount(); lP1++)
                                    {  // 検索結果件数分繰り返す
                                        HySStockData csStockDataTemp = csAnsStockList.GetData(lP1) as HySStockData;
                                        if (csStockDataTemp is HySStockData)
                                        {  // データ保存クラスが有る場合
                                            if (csStockData.GetID().Equals(csStockDataTemp.GetID()) == true)
                                            {  // データＩＤが一致した場合
                                                csStockData.SetData(csStockDataTemp.GetData());
                                                break;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    else if (csDBPCtlInfo.GetQueryType() == HySDispDefine.NOTICE_CALC_LOT_INFO_LIST_REQUEST)
                    {  // 演算ロット一覧検索の場合
                        HySStockData csStockData = csStockDataList.GetData(lP) as HySStockData;
                        if (csStockData is HySStockData)
                        {  // データ保存クラスが有る場合
                            HySID csLotID = null;
                            long lKeyNum = 0;
                            HySDataHashTable csKeyInfo = csStockData.GetKeyInfo(ref lKeyNum);
                            if (csKeyInfo[HySCalResultDataQueryFieldNames.LOT_ID] != null)
                            {  // ロットＩＤが有る場合
                                csLotID = (HySID)csKeyInfo[HySCalResultDataQueryFieldNames.LOT_ID];
                                for (long lP1 = 0; lP1 < csAnsStockList.GetCount(); lP1++)
                                {  // 検索結果件数分繰り返す
                                    HySStockData csStockDataTemp = csAnsStockList.GetData(lP1) as HySStockData;
                                    if (csStockDataTemp is HySStockData)
                                    {  // データ保存クラスが有る場合
                                        HySID csLotIDChk = null;
                                        long lKeyNumChk = 0;
                                        HySDataHashTable csKeyInfoChk = csStockDataTemp.GetKeyInfo(ref lKeyNumChk);
                                        if (csKeyInfoChk[HySCalResultDataQueryFieldNames.LOT_ID] != null)
                                        {  // ロットＩＤが有る場合
                                            csLotIDChk = (HySID)csKeyInfoChk[HySCalResultDataQueryFieldNames.LOT_ID];
                                            if (csLotID.Equals(csLotIDChk) == true)
                                            {  // ロットＩＤが一致した場合
                                                csStockData.SetPeservedPeriod(csStockDataTemp.GetPeservedPeriod());
                                                break;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>検索状態イベント通知処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>PutSearchStatusEvent(lEventNo, csID, csDBPCtlInfo) </para>
        /// </example>
        /// <param name="lEventNo">サブイベント番号</param>
        /// <param name="csID">識別子</param>
        /// <param name="csDBPCtlInfo">表示業務管理データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void PutSearchStatusEvent(long lEventNo, HySID csID, HySDispBusiProcedureCtlInfo csDBPCtlInfo)
        {
            // 親画面に通知する
            HySEventObject csEventObj = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISPLY_COMMON);
            csEventObj.SetToSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
            csEventObj.SetSuppID(csID);
            csEventObj.SetData(csDBPCtlInfo.GetParentsScreenKind());
            csEventObj.SetSubEventNo(lEventNo);
            this.PutEvent(csEventObj);
            // 子画面に通知する
            long lCnt = csDBPCtlInfo.GetChildCount();
            for (int iLp = 1; iLp <= (int)lCnt; iLp++)
            {  // 登録済みの子画面数分繰り返す
                csEventObj = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISPLY_COMMON);
                csEventObj.SetToSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
                csEventObj.SetSuppID(csID);
                csEventObj.SetData((HySKind)csDBPCtlInfo.GetChildScreenKind(iLp));
                csEventObj.SetSubEventNo(lEventNo);
                this.PutEvent(csEventObj);
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>ファクトリー管理クラスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetFactoryMng( csFactoryMng ) </para>
        /// </example>
        /// <param name="csFactoryMng">ファクトリー管理クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetFactoryMng(HySFactoryMng csFactoryMng)
        {
            // Do Nothing
        }
        //
    }
}
