﻿// <summary>ソースコード：表示業務管理データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMP.HYSSOP.CoreImpl.HSBusiProc
{
    /// <summary><para>class outline:</para>
    /// <para>表示業務管理データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class HySDispBusiProcedureCtlInfo : HySDataRoot, HySVersionManagement 
    {
        /// <summary>親画面種別識別子</summary>
        protected HySObjectKind m_csParentsScreenKind = null;

        /// <summary>親画面動作モード</summary>
        protected long m_csParentsScreenMode = HySDispDefine.NOTICE_SCREEN_FUNDAMENTAL_MOTION; // 手動

        /// <summary>子画面種別識別子</summary>
        protected HySDataLinkedList m_csChildScreenKind = null;

        /// <summary>抽出条件設定値リスト</summary>
        protected HySDataLinkedList m_csQueryCondition = null;

        /// <summary>選択データ識別キー管理リスト</summary>
        protected ArrayList m_csIDList = null;

        /// <summary>選択データ識別検索条件管理リスト</summary>
        protected HySDataHashTable m_csIDConditionList = null;

        /// <summary>選択データ別表示セル条件管理リスト</summary>
        protected HySDataHashTable m_csIDCellConditionList = null;

        /// <summary>画面対応固有データ管理リスト</summary>
        protected HySDataHashTable m_csPeculiarDataList = null;

        /// <summary>画面対応一時データ管理リスト</summary>
        protected HySDataHashTable m_csTemporaryDataList = null;

        /// <summary>グラフカスタマイズ情報</summary>
        protected HySDataRoot m_csCustomizInfo = null;

        /// <summary>クエリ種別</summary>
        protected long m_lQueryType = 0;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>使用禁止</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDispBusiProcedureCtlInfo 生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected HySDispBusiProcedureCtlInfo()
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDispBusiProcedureCtlInfo csDispBusiProcedureCtlInfo = new HySDispBusiProcedureCtlInfo(csParentsScreenKind)</para>
        /// </example>
        /// <param name="csParentsScreenKind">親画面種別識別子</param>
        /// <returns>HySDispBusiProcedureCtlInfo 生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDispBusiProcedureCtlInfo( HySKind csParentsScreenKind )
        {
            m_csParentsScreenKind = new HySObjectKind(csParentsScreenKind.GetString()); // 親画面種別識別子生成
            m_csChildScreenKind = new HySDataLinkedList();    // 子画面種別識別子生成
            m_csIDList = new ArrayList();                     // 選択済みデータ保存クラスリスト生成
            m_csQueryCondition = new HySDataLinkedList();     // 抽出条件設定値リスト生成
            m_csPeculiarDataList = new HySDataHashTable();    // 子画面固有データ保存リスト生成
            m_csTemporaryDataList = new HySDataHashTable();   // 子画面一時データ保存リスト生成
            m_csIDConditionList = new HySDataHashTable();     // 選択データ識別検索条件管理リスト生成
            m_csIDCellConditionList = new HySDataHashTable(); // 選択データ別表示セル条件管理リスト生成

            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>親画面種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetParentsScreenKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySKind 画面種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySKind GetParentsScreenKind()
        {
            return (HySKind)m_csParentsScreenKind;
        }

        /// <summary><para>method outline:</para>
        /// <para>子画面種別識別子追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetChildScreenKind(csChildScreenKind)</para>
        /// </example>
        /// <param name="csChildScreenKind">子画面種別識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetChildScreenKind(HySKind csChildScreenKind)
        {
            m_csChildScreenKind.AddLast(new HySObjectKind(csChildScreenKind.GetString()));
        }

        /// <summary><para>method outline:</para>
        /// <para>子画面種別識別子件数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = GetChildCount()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long 子画面種別識別子件数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetChildCount()
        {
            return m_csChildScreenKind.GetCount();
        }

        /// <summary><para>method outline:</para>
        /// <para>指定位置の子画面種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long = GetChildScreenKind(lNumber)</para>
        /// </example>
        /// <param name="lNumber">取得データ位置（１～）</param>
        /// <returns>HySKind 子画面種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySKind GetChildScreenKind(long lNumber)
        {
            if (lNumber > 0 && lNumber <= m_csChildScreenKind.GetCount())
            {  // 取得位置が範囲内の場合
                return (HySKind)m_csChildScreenKind.GetData(lNumber - 1);
            }
            else
            {  // 取得位置が範囲外の場合
                return null;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>子画面種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = EqualScreenKind(csChildScreenKind)</para>
        /// </example>
        /// <param name="csChildScreenKind">子画面種別識別子</param>
        /// <returns>bool 比較結果（=true：同じ、=false：異なる）</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool EqualScreenKind(HySKind csChildScreenKind)
        {
            for (long lP = 0; lP < m_csChildScreenKind.GetCount(); lP++)
            {  // データ件数分繰り返す
                HySKind csKind = (HySKind)m_csChildScreenKind.GetData(lP);
                if (csKind.Equals(csChildScreenKind) == true)
                {  // 識別子一致の場合
                    return true;
                }
            }
            return false;
        }

        /// <summary><para>method outline:</para>
        /// <para>子画面種別識別子削除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> RemoveChildScreenKind(csChildScreenKind)</para>
        /// </example>
        /// <param name="csChildScreenKind">子画面種別識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void RemoveChildScreenKind(HySKind csChildScreenKind)
        {
            for (long lP = 0; lP < m_csChildScreenKind.GetCount(); lP++)
            {  // データ件数分繰り返す
                HySKind csKind = (HySKind)m_csChildScreenKind.GetData(lP);
                if (csKind.Equals(csChildScreenKind) == true)
                {  // 識別子一致の場合
                    m_csChildScreenKind.RemoveData(lP); // 該当識別子削除
                    break;
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>抽出条件設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetQueryCondition(csQueryCondition)</para>
        /// </example>
        /// <param name="csQueryCondition">抽出条件設定値</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetQueryCondition(HySDataLinkedList csQueryCondition)
        {
            m_csQueryCondition.Clear();
            for (long lP = 0; lP < csQueryCondition.GetCount(); lP++)
            {
                HySString csCondition = (HySString)csQueryCondition.GetData(lP);
                m_csQueryCondition.AddLast(new HySString(csCondition.ToString()));
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>抽出条件取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDataLinkedList csCondition = GetQueryCondition()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataLinkedList 抽出条件設定値</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDataLinkedList GetQueryCondition()
        {
            return m_csQueryCondition;
        }

        /// <summary><para>method outline:</para>
        /// <para>>選択データ識別キーリスト取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ArrayList csList = GetIDList() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ArrayList キーリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual ArrayList GetIDList()
        {
            return m_csIDList;
        }
        /// <summary><para>method outline:</para>
        /// <para>>選択データ識別検索条件管理リスト取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataHashTable csIDConditionList = GetIDConditionList() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataHashTable 選択データ識別検索条件管理リスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDataHashTable GetIDConditionList()
        {
            return m_csIDConditionList;
        }
        /// <summary><para>method outline:</para>
        /// <para>>選択データ表示セル条件管理リスト取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataHashTable csIDCellConditionList = GetIDCellConditionList() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataHashTable 選択データ表示セル条件管理リスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDataHashTable GetIDCellConditionList()
        {
            return m_csIDCellConditionList;
        }

        /// <summary><para>method outline:</para>
        /// <para>>親画面動作モード設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetParentsScreenMode(lMode) </para>
        /// </example>
        /// <param name="lMode">親画面動作モード</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetParentsScreenMode(long lMode)
        {
            m_csParentsScreenMode = lMode;
        }
        /// <summary><para>method outline:</para>
        /// <para>>親画面動作モード取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = GetParentsScreenMode() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long 親画面動作モード</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetParentsScreenMode()
        {
            return m_csParentsScreenMode;
        }

        /// <summary><para>method outline:</para>
        /// <para>>子画面固有データ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetPeculiarDataList(csChildScreenKind,csData) </para>
        /// </example>
        /// <param name="csChildScreenKind">子画面種別識別子</param>
        /// <param name="csData">子画面固有データインスタンス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetPeculiarDataList(HySKind csChildScreenKind, HySDataRoot csData)
        {
            m_csPeculiarDataList.AddObject(new HySString(csChildScreenKind.ToString()), csData);
        }
        /// <summary><para>method outline:</para>
        /// <para>>画面固有データ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataRoot csData = GetPeculiarDataList(csChildScreenKind) </para>
        /// </example>
        /// <param name="csChildScreenKind">画面種別識別子</param>
        /// <returns>HyDataRoot 画面固有データインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDataRoot GetPeculiarDataList(HySKind csChildScreenKind)
        {
            return m_csPeculiarDataList.GetObject(new HySString(csChildScreenKind.ToString()));
        }
        /// <summary><para>method outline:</para>
        /// <para>>画面固有データ削除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> RemovePeculiarDataList(csChildScreenKind) </para>
        /// </example>
        /// <param name="csChildScreenKind">画面種別識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void RemovePeculiarDataList(HySKind csChildScreenKind)
        {
            m_csPeculiarDataList.DeleteData(new HySString(csChildScreenKind.ToString()));
        }
        /// <summary><para>method outline:</para>
        /// <para>>画面固有データ件数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lCnt = GetPeculiarDataListCount() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long 画面固有データインスタンス件数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetPeculiarDataListCount()
        {
            return m_csPeculiarDataList.GetCount();
        }
        /// <summary><para>method outline:</para>
        /// <para>>画面一時データ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetTemporaryDataList(csChildScreenKind,csData) </para>
        /// </example>
        /// <param name="csChildScreenKind">画面種別識別子</param>
        /// <param name="csData">画面固有データインスタンス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetTemporaryDataList(HySKind csChildScreenKind, HySDataRoot csData)
        {
            m_csTemporaryDataList.AddObject(new HySString(csChildScreenKind.ToString()), csData);
        }
        /// <summary><para>method outline:</para>
        /// <para>>画面一時データ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataRoot csData = GetTemporaryDataList(csChildScreenKind) </para>
        /// </example>
        /// <param name="csChildScreenKind">画面種別識別子</param>
        /// <returns>HyDataRoot 画面固有データインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDataRoot GetTemporaryDataList(HySKind csChildScreenKind)
        {
            return m_csTemporaryDataList.GetObject(new HySString(csChildScreenKind.ToString()));
        }
        /// <summary><para>method outline:</para>
        /// <para>>画面一時データ削除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> RemoveTemporaryDataList(csChildScreenKind) </para>
        /// </example>
        /// <param name="csChildScreenKind">画面種別識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void RemoveTemporaryDataList(HySKind csChildScreenKind)
        {
            m_csTemporaryDataList.DeleteData(new HySString(csChildScreenKind.ToString()));
        }
        /// <summary><para>method outline:</para>
        /// <para>>画面一時データ件数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lCnt = GetTemporaryDataListCount() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long 画面固有データインスタンス件数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetTemporaryDataListCount()
        {
            return m_csTemporaryDataList.GetCount();
        }

        /// <summary><para>method outline:</para>
        /// <para>カスタマイズ情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetReportCustomiz(csCustomizInfo)</para>
        /// </example>
        /// <param name="csCustomizInfo">カスタマイズ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetReportCustomiz(HySDataRoot csCustomizInfo)
        {
            m_csCustomizInfo = csCustomizInfo;
        }
        /// <summary><para>method outline:</para>
        /// <para>カスタマイズ情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDataRoot csData = GetReportCustomiz()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataRoot カスタマイズ情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDataRoot GetReportCustomiz()
        {
            return m_csCustomizInfo;
        }

        /// <summary><para>method outline:</para>
        /// <para>クエリ種別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetQueryType(lQueryType)</para>
        /// </example>
        /// <param name="lQueryType">クエリ種別</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetQueryType(long lQueryType)
        {
            m_lQueryType = lQueryType;
        }
        /// <summary><para>method outline:</para>
        /// <para>クエリ種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lRtn = GetQueryType()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long クエリ種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetQueryType()
        {
            return m_lQueryType;
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                if (GetDecodedVersion() == null)
                {
                    // 旧バージョンからの移行処理を入れる
                }
                else
                {
                    //旧バージョンから順にバージョンを上げて行く
                    switch (GetDecodedVersion())
                    {
                        case "1.00":
                            {
                                // 旧バージョンからの移行処理を入れる
                                break;
                            }
                        //case "2.00": << 以後バージョンアップに伴って処理追加
                        //{
                        //    break;
                        //}
                    }
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
