﻿// <summary>ソースコード：解析業務ファクトリクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSBusiProc;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMP.HYSSOP.CoreImpl.HSBusiProc
{
    /// <summary><para>class outline:</para>
    /// <para>表示業務ファクトリクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// </remarks>
    public class HySDispBusiProcedureFactory : HySFactoryMono , HySBusiProcFactory 
    {
        /// <summary>シミュレーター種別識別子</summary>
        protected HySObjectKind m_csKindID = (HySObjectKind)HySDefine.COMMON_DISP_BUSIPROCEDURE;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySBusiProcedureFactory csFactory = new HySDispBusiProcedureFactory()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDispBusiProcedureFactory 生成されたコンストラクタ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDispBusiProcedureFactory()
        {
            SetFactoryID(HySDefine.FACTORY_ID_DISP_BUSIPROCEDURE);
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySKind シミュレーター種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySKind GetSimKind()
        {
            return m_csKindID;
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EqualSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>bool
        /// true  : 同じ
        /// false : 異なる
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool EqualSimKind(HySKind csSimKindID)
        {
            return m_csKindID.Equals(csSimKindID);
        }

        /// <summary><para>method outline:</para>
        /// <para>業務クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySBusiProcedure csBusiProc = CreateBusiProcedure( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySBusiProcedure 業務クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySBusiProcedure CreateBusiProcedure()
        {
            HySBusiProcedure csBusiProc = (HySBusiProcedure)new HySDispBusiProcedure();
            csBusiProc.SetSimKind(this.GetSimKind());
            return csBusiProc;
        }
    }
}
