﻿// <summary>ソースコード：>１次元セルデータ展開データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Xml;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.CoreImpl.HSBusiProc
{
    /// <summary><para>class outline:</para>
    /// <para>１次元セルデータ展開データクラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/10/01][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class HySDispCell1DataDevelopment : HySDataRoot, HySVersionManagement
    {
        /// <summary>第１分割数</summary>
        protected long m_lDim1 = 0;
        /// <summary>セル内の配列数</summary>
        protected long m_lCellDataNum = 0;
        /// <summary> セル内のデータの意味を示す </summary>
        protected HySDataCharacteristicInCell m_csCellDataKind = null;

        /// <summary>データ種別</summary>
        static readonly HySKind[,] m_csDataKind = {
                        // 基本画面用
                            { new HySObjectKind(HySDefine.DISP_FORM_LINE_GRAPH.ToString()),
                                HySDataKindDefine.ANY_VALUE             , HySDispDefine.STOCKDATA_KIND_LINE } // 任意
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_LINE_GRAPH.ToString()),
                                HySDataKindDefine.QUANTITY_OF_WATER_FLOW, HySDispDefine.STOCKDATA_KIND_LINE } // 流量
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_LINE_GRAPH.ToString()),
                                HySDataKindDefine.WATER_LEVEL           , HySDispDefine.STOCKDATA_KIND_LINE } // 水位
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_LINE_GRAPH.ToString()),
                                HySDataKindDefine.WATER_VOLUME          , HySDispDefine.STOCKDATA_KIND_LINE } // 水量
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_LINE_GRAPH.ToString()),
                                HySDataKindDefine.SCALOR_VELOCITY       , HySDispDefine.STOCKDATA_KIND_LINE } // 流速
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_LINE_GRAPH.ToString()),
                                HySDataKindDefine.VECTOR_L_VELOCITY     , HySDispDefine.STOCKDATA_KIND_LINE } // ライン方向流速
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_LINE_GRAPH.ToString()),
                                HySDataKindDefine.VECTOR_W_VELOCITY     , HySDispDefine.STOCKDATA_KIND_LINE } // 横方向流速
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_LINE_GRAPH.ToString()),
                                HySDataKindDefine.VECTOR_D_VELOCITY     , HySDispDefine.STOCKDATA_KIND_LINE } // 深さ方向流速
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_LINE_GRAPH.ToString()),
                                HySDataKindDefine.SCALOR_PRESSURE       , HySDispDefine.STOCKDATA_KIND_LINE } // 圧力
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_LINE_GRAPH.ToString()),
                                HySDataKindDefine.VECTOR_L_PRESSURE     , HySDispDefine.STOCKDATA_KIND_LINE } // ライン方向圧力
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_LINE_GRAPH.ToString()),
                                HySDataKindDefine.VECTOR_W_PRESSURE     , HySDispDefine.STOCKDATA_KIND_LINE } // 横方向圧力
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_LINE_GRAPH.ToString()),
                                HySDataKindDefine.VECTOR_D_PRESSURE     , HySDispDefine.STOCKDATA_KIND_LINE } // 深さ方向圧力
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_LINE_GRAPH.ToString()),
                                HySDataKindDefine.SCALOR_RAIN_FALL      , HySDispDefine.STOCKDATA_KIND_LINE } // 雨量
                        // ハイドロ／ハイエトグラフ画面用
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_HYDRO_HYETO_GRAPH.ToString()),
                                HySDataKindDefine.QUANTITY_OF_WATER_FLOW, HySDispDefine.STOCKDATA_KIND_HYDROHYETO } // 流量
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_HYDRO_HYETO_GRAPH.ToString()),
                                HySDataKindDefine.SCALOR_RAIN_FALL      , HySDispDefine.STOCKDATA_KIND_HYDROHYETO } // 雨量
                        // 河川水位遷移図画面用
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_RIVERBED_SHAPE.ToString()),
                                HySDataKindDefine.ANY_VALUE             , HySDispDefine.STOCKDATA_KIND_RIVERBEDSERIALE } // 任意
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_RIVERBED_SHAPE.ToString()),
                                HySDataKindDefine.QUANTITY_OF_WATER_FLOW, HySDispDefine.STOCKDATA_KIND_RIVERBEDSERIALE } // 流量
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_RIVERBED_SHAPE.ToString()),
                                HySDataKindDefine.WATER_LEVEL           , HySDispDefine.STOCKDATA_KIND_RIVERBEDSERIALE } // 水位
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_RIVERBED_SHAPE.ToString()),
                                HySDataKindDefine.WATER_VOLUME          , HySDispDefine.STOCKDATA_KIND_RIVERBEDSERIALE } // 水量
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_RIVERBED_SHAPE.ToString()),
                                HySDataKindDefine.SCALOR_VELOCITY       , HySDispDefine.STOCKDATA_KIND_RIVERBEDSERIALE } // 流速
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_RIVERBED_SHAPE.ToString()),
                                HySDataKindDefine.VECTOR_L_VELOCITY     , HySDispDefine.STOCKDATA_KIND_RIVERBEDSERIALE } // ライン方向流速
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_RIVERBED_SHAPE.ToString()),
                                HySDataKindDefine.VECTOR_W_VELOCITY     , HySDispDefine.STOCKDATA_KIND_RIVERBEDSERIALE } // 横方向流速
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_RIVERBED_SHAPE.ToString()),
                                HySDataKindDefine.VECTOR_D_VELOCITY     , HySDispDefine.STOCKDATA_KIND_RIVERBEDSERIALE } // 深さ方向流速
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_RIVERBED_SHAPE.ToString()),
                                HySDataKindDefine.SCALOR_PRESSURE       , HySDispDefine.STOCKDATA_KIND_RIVERBEDSERIALE } // 圧力
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_RIVERBED_SHAPE.ToString()),
                                HySDataKindDefine.VECTOR_L_PRESSURE     , HySDispDefine.STOCKDATA_KIND_RIVERBEDSERIALE } // ライン方向圧力
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_RIVERBED_SHAPE.ToString()),
                                HySDataKindDefine.VECTOR_W_PRESSURE     , HySDispDefine.STOCKDATA_KIND_RIVERBEDSERIALE } // 横方向圧力
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_RIVERBED_SHAPE.ToString()),
                                HySDataKindDefine.VECTOR_D_PRESSURE     , HySDispDefine.STOCKDATA_KIND_RIVERBEDSERIALE } // 深さ方向圧力
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_RIVERBED_SHAPE.ToString()),
                                HySDataKindDefine.SCALOR_RAIN_FALL      , HySDispDefine.STOCKDATA_KIND_RIVERBEDSERIALE } // 雨量
                        // Ｈ－Ｑ曲線図画面用
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_HQ_GRAPH.ToString()),
                                new HySObjectKind("")                   , HySDispDefine.STOCKDATA_KIND_HQ   } // 将来用
                        // Ｅｘｃｅｌ画面用
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_EXCEL.ToString()),
                                HySDataKindDefine.ANY_VALUE             , HySDispDefine.STOCKDATA_KIND_LINE } // 任意
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_EXCEL.ToString()),
                                HySDataKindDefine.QUANTITY_OF_WATER_FLOW, HySDispDefine.STOCKDATA_KIND_LINE } // 流量
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_EXCEL.ToString()),
                                HySDataKindDefine.WATER_LEVEL           , HySDispDefine.STOCKDATA_KIND_LINE } // 水位
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_EXCEL.ToString()),
                                HySDataKindDefine.WATER_VOLUME          , HySDispDefine.STOCKDATA_KIND_LINE } // 水量
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_EXCEL.ToString()),
                                HySDataKindDefine.SCALOR_VELOCITY       , HySDispDefine.STOCKDATA_KIND_LINE } // 流速
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_EXCEL.ToString()),
                                HySDataKindDefine.VECTOR_L_VELOCITY     , HySDispDefine.STOCKDATA_KIND_LINE } // ライン方向流速
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_EXCEL.ToString()),
                                HySDataKindDefine.VECTOR_W_VELOCITY     , HySDispDefine.STOCKDATA_KIND_LINE } // 横方向流速
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_EXCEL.ToString()),
                                HySDataKindDefine.VECTOR_D_VELOCITY     , HySDispDefine.STOCKDATA_KIND_LINE } // 深さ方向流速
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_EXCEL.ToString()),
                                HySDataKindDefine.SCALOR_PRESSURE       , HySDispDefine.STOCKDATA_KIND_LINE } // 圧力
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_EXCEL.ToString()),
                                HySDataKindDefine.VECTOR_L_PRESSURE     , HySDispDefine.STOCKDATA_KIND_LINE } // ライン方向圧力
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_EXCEL.ToString()),
                                HySDataKindDefine.VECTOR_W_PRESSURE     , HySDispDefine.STOCKDATA_KIND_LINE } // 横方向圧力
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_EXCEL.ToString()),
                                HySDataKindDefine.VECTOR_D_PRESSURE     , HySDispDefine.STOCKDATA_KIND_LINE } // 深さ方向圧力
                           ,{ new HySObjectKind(HySDefine.DISP_FORM_EXCEL.ToString()),
                                HySDataKindDefine.SCALOR_RAIN_FALL      , HySDispDefine.STOCKDATA_KIND_LINE } // 雨量
                                                 };

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySReportData csData = new HySReportData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> HySReportData 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDispCell1DataDevelopment()
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>セル型データ変換処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySStockData csNewData = CellDataConversion(csKind,csStockData,csCellNum)</para>
        /// </example>
        /// <param name="csKind">対応処理識別子</param>
        /// <param name="csStockData">保存データ</param>
        /// <param name="csCellNum">セル指定番号（1～）</param>
        /// <returns>HySDataRoot 変換後データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>セル型時系列データを評価画面用のデータ型式に変換する</para>
        /// </remarks>
        public virtual HySDataLinkedList CellDataConversion(HySKind csKind, HySStockData csStockData, HySLong csCellNum)
        {
            long lKCnt = 0;
            long lLp  = 0;
            long lLp0 = 0;
            long lLp1 = 0;
            long lNum = 0;
            long lCellNum = 0;
            double dQ = 0.0;
            double dH = 0.0;
            bool bFlag = false;

            HySTime csTime = null;
            HySTime csTmWk = null;
            HySID csDmyID = new HySID(((DateTime.Now.ToString() + DateTime.Now.Millisecond.ToString()).GetHashCode()).ToString());
            HySID csSetID = null;

            HySDataRoot[] csData = null;
            HySGraphLineTimeSeries csGraphLineTimeSeries = null;
            HySHydroHyetoData csHydroHyetoData = null;
            HySGraphLineLaneKilo csGraphLineLaneKilo = null;
            HySHQData csHQData = null;
            HySGraphHQ csGraphHQ = null;
            HySDataLinkedList csNewDataList = new HySDataLinkedList();

            for (lKCnt = 0; lKCnt < m_csDataKind.GetLength(0); lKCnt++)
            {  // 対象処理識別子件数分繰り返し
                try
                {
                    if (csKind.Equals(m_csDataKind[(int)lKCnt, 0]) == true &&
                       ((HySKind)csStockData.GetDataKind()).Equals(m_csDataKind[(int)lKCnt, 1]) == true)
                    {  // 画面識別子およびデータ識別子が対象の場合
                        bFlag = true; // データ有りを記憶
                        HySDataRoot csOrgData = csStockData.GetData(); // 実データ取得
                        // セルデータ展開
                        if (csOrgData is HySTimeSeriesCellArray)
                        {  // セルデータ配列の場合
                            if (csOrgData is HySTimeSeriesD1CellArrayData)
                            {  // 時系列 1次元セルの場合
                                m_lDim1 = ((HySTimeSeriesD1CellArrayData)csOrgData).GetDimension1(); // 第１分割数取得
                            }
                            if (m_lDim1 > 0)
                            {  // 時系列セルが有効な場合
                                m_lCellDataNum = ((HySTimeSeriesCellArray)csOrgData).GetDataDimentionInCell(); // セル内配列数取得
                                m_csCellDataKind = ((HySTimeSeriesCellArray)csOrgData).GetCellDataCharacteristic(); // セル内データの意味取得
                                // 格納データリア生成 //
                                if (m_csDataKind[(int)lKCnt, 2].Equals(HySDispDefine.STOCKDATA_KIND_LINE) == true)
                                {  // 時系列データの場合
                                    csData = new HySDataRoot[m_lDim1 * m_lCellDataNum];
                                    for (lLp1 = 0; lLp1 < csData.GetLength(0); lLp1++)
                                    {  // 時系列グラフデータ件数分繰り返す
                                        csData[(int)lLp1] = new HySGraphLineTimeSeries(csStockData.GetDataKind());
                                    }
                                }
                                else if (m_csDataKind[(int)lKCnt, 2].Equals(HySDispDefine.STOCKDATA_KIND_HYDROHYETO) == true)
                                {  // ハイドロ／ハイエトデータの場合
                                    csSetID = (csStockData.GetID() is HySID) ? csStockData.GetID() : csDmyID;
                                    csData = new HySDataRoot[m_lCellDataNum];
                                    for (lLp1 = 0; lLp1 < csData.GetLength(0); lLp1++)
                                    {  // 時系列グラフデータ件数分繰り返す
                                        csData[(int)lLp1] = new HySHydroHyetoData(); // インスタンス生成
                                        ((HySHydroHyetoData)csData[(int)lLp1]).SetGeoPosID(csStockData.GetPointID()); // 地点ID設定
                                        csGraphLineTimeSeries = (HySGraphLineTimeSeries)((HySHydroHyetoData)csData[(int)lLp1]).CreateTimeSeriesGraph
                                                                 (csSetID, csStockData.GetDataKind());
                                    }
                                }
                                else if (m_csDataKind[(int)lKCnt, 2].Equals(HySDispDefine.STOCKDATA_KIND_RIVERBEDSERIALE) == true)
                                {  // 河道時系列データの場合
                                    csData = new HySDataRoot[1];
                                    csData[0] = new HySRiverbedSerialData(csStockData.GetDataKind()); // インスタンス生成
                                    for (lLp1 = 1; lLp1 <= m_lDim1; lLp1++)
                                    {  // 第１分割数分繰り返す
                                        ((HySRiverbedSerialData)csData[0]).SetAltitudeData((double)lLp1, 0.0); // セル番号を横軸設定
                                    }
                                }
                                else if (m_csDataKind[(int)lKCnt, 2].Equals(HySDispDefine.STOCKDATA_KIND_HQ) == true)
                                {  // Ｈ－Ｑデータの場合
                                    break;
                                }
                                // セルデータ展開 //
                                long lDataNum = ((HySTimeSeriesCellArray)csOrgData).GetCount();                // 時系列データ件数取得
                                ((HySTimeSeriesCellArray)csOrgData).SetCursorFirst();                          // カーソルを先頭に設定
                                // 原本データを単独データとして取得する
                                for (lLp = 0; lLp < lDataNum; lLp++)
                                {  // 時系列データ件数分繰り返す
                                    HySCellArray csRecordData = ((HySTimeSeriesCellArray)csOrgData).GetCursorData() as HySCellArray;
                                    if (csRecordData is HySCellArray)
                                    {  // セルデータが有効な場合
                                        csTime = HySTime.DEFAULT_TIME.Clone();
                                        csTime.SetTime(csRecordData.GetLastTime().Clone()); // 時刻設定
                                        if (m_csDataKind[(int)lKCnt, 2].Equals(HySDispDefine.STOCKDATA_KIND_LINE) == true)
                                        {  // 時系列データ
                                            for (lLp1 = 0; lLp1 < m_lDim1; lLp1++)
                                            {  // 第１分割数分繰り返す
                                                for (lLp0 = 0; lLp0 < m_lCellDataNum; lLp0++)
                                                {  // セル内配列数数分繰り返す
                                                    long lCsNo = (lLp1 * m_lCellDataNum) + lLp0;
                                                    ((HySGraphLineTimeSeries)csData[(int)lCsNo]).AddData
                                                       (csTime.Clone(), csRecordData.GetCell(lLp1).m_dData[(int)lLp0]);
                                                }
                                            }
                                        }
                                        else if (m_csDataKind[(int)lKCnt, 2].Equals(HySDispDefine.STOCKDATA_KIND_HYDROHYETO) == true)
                                        {  // ハイドロデータ・ハイエトデータの場合
                                            if (csGraphLineTimeSeries is HySGraphLineTimeSeries)
                                            {  // 対応するデータ種別が有る場合
                                                if (csCellNum is HySLong)
                                                {  // セル指定有りの場合
                                                    lCellNum = (csCellNum.m_lValue > m_lDim1) ? 1 : csCellNum.m_lValue;
                                                }
                                                else
                                                {  // セル指定無しの場合
                                                    lCellNum = 1;
                                                }
                                                for (lLp1 = (lCellNum - 1); lLp1 < lCellNum; lLp1++)
                                                {  // 第１分割数分繰り返す
                                                    for (lLp0 = 0; lLp0 < m_lCellDataNum; lLp0++)
                                                    {  // セル内配列数数分繰り返す
                                                        csGraphLineTimeSeries = (HySGraphLineTimeSeries)((HySHydroHyetoData)csData[(int)lLp0]).GetTimeSeriesGraph(csSetID);
                                                        csGraphLineTimeSeries.AddData
                                                           (csTime.Clone(), csRecordData.GetCell(lLp1).m_dData[(int)lLp0]);
                                                    }
                                                }
                                            }
                                        }
                                        else if (m_csDataKind[(int)lKCnt, 2].Equals(HySDispDefine.STOCKDATA_KIND_RIVERBEDSERIALE) == true)
                                        {  // 河道列データの場合
                                            double dAlt = 0.0;
                                            // 河道データ列生成
                                            csGraphLineLaneKilo = ((HySRiverbedSerialData)csData[0]).CreateTimeSerialKilo
                                                                                                (csStockData.GetDataKind(), csTime);
                                            for (lLp1 = 0; lLp1 < m_lDim1; lLp1++)
                                            {  // 第１分割数分繰り返す
                                                for (lLp0 = 0; lLp0 < m_lCellDataNum; lLp0++)
                                                {  // セル内配列数数分繰り返す
                                                    dAlt = csRecordData.GetCell(lLp1).m_dData[(int)lLp0];
                                                    csGraphLineLaneKilo.AddData(dAlt); // データ設定
                                                }
                                            }
                                        }
                                        else if (m_csDataKind[(int)lKCnt, 2].Equals(HySDispDefine.STOCKDATA_KIND_HQ) == true)
                                        {  // Ｈ－Ｑデータの場合
                                        }
                                        csTime = null;
                                    }
                                    ((HySTimeSeriesCellArray)csOrgData).MoveCursorNext(); // カーソルを1つ更新
                                }
                                if (csData != null)
                                {  // 編集データが有る場合
                                    for (lLp1 = 0; lLp1 < csData.GetLength(0); lLp1++)
                                    {  // 時系列グラフデータ件数分繰り返す
                                        csNewDataList.AddLast(csData[(int)lLp1]);
                                    }
                                    csData = null;
                                }
                            }
                            break;
                        }
                        else if (csOrgData is HySGeoMeshSerial)
                        {  // 地理メッシュ情報の場合
                            if (csOrgData is HySGeoDim2MeshSerialData)
                            {  // 時系列 2次元地理メッシュの場合
                            }
                            else if (csOrgData is HySGeoDim3MeshSerialData)
                            {  // 時系列 3次元地理メッシュの場合
                            }
                        }
                        break;
                    }
                }
                catch
                {
                    csData = null;
                    continue;
                }
            }
            if (bFlag == false)
            {  // データ種別がセルデータ以外の場合
                if (((HySKind)csStockData.GetDataKind()).Equals(HySDispDefine.STOCKDATA_KIND_EXTERNAL) == true)
                {  // データ識別子が「外部データ」指定の場合は全て時系列グラフデータに展開する 
                    try
                    {
                        HySFile csFile = new HySFile(csStockData.GetSaveName());
                        csData = this.ReadExternalCSVFile(csFile); // 時系列グラフデータ型式読み込み
                        if (csData != null)
                        {  // 編集データが有る場合
                            if (csKind.Equals(HySDefine.DISP_FORM_LINE_GRAPH) == true)
                            {  // 時系列グラフデータの場合
                                for (lLp1 = 0; lLp1 < csData.GetLength(0); lLp1++)
                                {  // 時系列グラフデータ件数分繰り返す
                                    if (((HySGraphLineTimeSeries)csData[(int)lLp1]).GetCount() > 0)
                                    {  // 有効データの場合
                                        csNewDataList.AddLast(csData[(int)lLp1]);
                                    }
                                }
                            }
                            else if (csKind.Equals(HySDefine.DISP_FORM_HYDRO_HYETO_GRAPH) == true)
                            {  // ハイドロ／ハイエト／水位関係グラフデータの場合
                                long lTopCnt = 1;
                                long lLastCnt = csData.GetLength(0);
                                long lKeyNum = 0;
                                HySDataHashTable csKeyInfo = csStockData.GetKeyInfo(ref lKeyNum);
                                if (lKeyNum > 0)
                                {  // その他検索キーがある場合
                                    if (csKeyInfo[HySCalResultDataQueryFieldNames.DATA_DIM1] != null)
                                    {  // 管理者が有る場合
                                        if (((HySLong)csKeyInfo[HySCalResultDataQueryFieldNames.DATA_DIM1]).m_lValue > 1)
                                        {  // １次元配列時系列指定の場合
                                            if (csCellNum is HySLong)
                                            {  // セル指定有りの場合
                                                lTopCnt = (csCellNum.m_lValue > csData.GetLength(0)) ? 1 : csCellNum.m_lValue;
                                            }
                                            else
                                            {  // セル指定無しの場合
                                                lTopCnt = 1;
                                            }
                                            lLastCnt = lTopCnt;
                                        }
                                    }
                                }
                                for (lLp1 = (lTopCnt - 1); lLp1 < lLastCnt; lLp1++)
                                {  // 時系列グラフデータ件数分繰り返す
                                    lNum = ((HySGraphLineTimeSeries)csData[(int)lLp1]).GetCount();
                                    if (lNum > 0)
                                    {  // 編集データが有る場合
                                        csHydroHyetoData = new HySHydroHyetoData(); // インスタンス生成
                                        csGraphLineTimeSeries = (HySGraphLineTimeSeries)csHydroHyetoData.CreateTimeSeriesGraph
                                                                 (csDmyID, ((HySGraphLineTimeSeries)csData[(int)lLp1]).GetDataMeaning());
                                        csGraphLineTimeSeries.CopyData(((HySGraphLineTimeSeries)csData[(int)lLp1]));
                                        csGraphLineTimeSeries.SetDataMeaning(((HySGraphLineTimeSeries)csData[(int)lLp1]).GetDataMeaning());
                                        csNewDataList.AddLast(csHydroHyetoData);
                                    }
                                }
                            }
                            else if (csKind.Equals(HySDefine.DISP_FORM_RIVERBED_SHAPE) == true)
                            {  // 河道縦断面時系列グラフデータ（アニメーション用）の場合
                                if (csData.GetLength(0) > 1)
                                {  // １次元配列時系列データの場合
                                    lNum = ((HySGraphLineTimeSeries)csData[0]).GetCount();
                                    if (lNum > 0)
                                    {  // 編集データが有る場合
                                        HySRiverbedSerialData csRiverbedSerialData = new HySRiverbedSerialData(((HySGraphLineTimeSeries)csData[0]).GetDataMeaning()); // インスタンス生成
                                        for (lLp1 = 1; lLp1 <= csData.GetLength(0); lLp1++)
                                        {  // 第１分割数分繰り返す
                                            csRiverbedSerialData.SetAltitudeData((double)lLp1, 0.0); // セル番号を横軸設定
                                        }
                                        double dAlt = 0.0;
                                        for (lLp1 = 0; lLp1 < lNum; lLp1++)
                                        {  // 時系列数分繰り返す
                                            csGraphLineLaneKilo = csRiverbedSerialData.CreateTimeSerialKilo
                                                                       (((HySGraphLineTimeSeries)csData[0]).GetDataMeaning(),
                                                                       ((HySGraphLineTimeSeries)csData[0]).GetTime(lLp1));
                                            for (int lLp2 = 0; lLp2 < csData.GetLength(0); lLp2++)
                                            {  // 第１分割数分繰り返す
                                                dAlt = 0.0;
                                                if (((HySGraphLineTimeSeries)csData[lLp2]).GetCount() > lLp1)
                                                {  // 該当範囲にデータがある場合
                                                    dAlt = ((HySGraphLineTimeSeries)csData[lLp2]).GetData(lLp1);
                                                }
                                                csGraphLineLaneKilo.AddData(dAlt); // データ設定
                                            }
                                        }
                                        csNewDataList.AddLast(csRiverbedSerialData);
                                    }
                                }
                            }
                            else if (csKind.Equals(HySDefine.DISP_FORM_HQ_GRAPH) == true)
                            {  // ＨＱグラフデータの場合
                                for (lLp1 = 0; lLp1 < csData.GetLength(0); lLp1++)
                                {  // 時系列グラフデータ件数分繰り返す
                                    lNum = ((HySGraphLineTimeSeries)csData[(int)lLp1]).GetCount();
                                    if (lNum > 0)
                                    {  // 編集データが有る場合
                                        csHQData = new HySHQData(); // インスタンス生成
                                        csGraphHQ = (HySGraphHQ)csHQData.CreateHQGraph(csDmyID);
                                        ((HySGraphLineTimeSeries)csData[(int)lLp1]).SetCursorFirst();
                                        for (long lP = 0; lP < lNum; lP++)
                                        {
                                            csTmWk = ((HySGraphLineTimeSeries)csData[(int)lLp1]).GetCursorTime();
                                            dQ = csTmWk.GetTime();
                                            dH = ((HySGraphLineTimeSeries)csData[(int)lLp1]).GetCursorData();
                                            csGraphHQ.AddHQData(dQ, dH);
                                            ((HySGraphLineTimeSeries)csData[(int)lLp1]).MoveCursorNext();
                                        }
                                        csNewDataList.AddLast(csHQData);
                                    }
                                }
                            }
                            csData = null;
                        }
                    }
                    catch
                    {
                        csData = null;
                    }
                }
            }

            return csNewDataList;
        }

        /// <summary><para>method outline:</para>
        /// <para>外部データ指定のＣＳＶ形式ファイルを入力する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataRoot[] lRtn = ReadExternalCSVFile(csFile) </para>
        /// </example>
        /// <param name="csFile">入力ファイル</param>
        /// <returns>HySDataRoot[] 展開データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>サポートする入力型式はＣｏｍｍｏｎＭＰ標準モデルが出力する型式のみとする</para>
        /// </remarks>
        private HySDataRoot[] ReadExternalCSVFile(HySFile csFile)
        {
            HySString sOut = new HySString();
            HySDataRoot[] csData = null;

            if (csFile.Exist() == true)
            {  // 既存ファイルが有れば
                if (csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR) == 0)
                {  // 既存CSVファイルを正常に開ければ
                    while (csFile.ReadText(ref sOut) != 0)
                    {  // 行が有る場合
                        if (sOut.ToString() is string)
                        {  // 行情報取得ができた場合
                            string[] sInWk = sOut.ToString().Split(',');
                            if (sInWk.LongLength > 0)
                            {  // 行にデータが有る場合
                                if (sInWk[0].Equals("Time") == true || sInWk[0].Equals("Value") == true)
                                {  // 評価画面機能のExcelヘッダの場合
                                    csData = this.ReadExternalCSV(csFile, sInWk); // CSV情報展開
                                    break;
                                }
                            }
                        }
                    }
                    csFile.Close();
                }
            }
            return csData;
        }
        /// <summary><para>method outline:</para>
        /// <para>外部データ指定のＣＳＶ形式ファイル読み込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataRoot[] csData = ReadExternalCSV(csFile,sHeadWk) </para>
        /// </example>
        /// <param name="csFile">入力ファイル</param>
        /// <param name="sHeadWk">ヘッダ展開列</param>
        /// <returns>HySDataRoot[] 展開データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>サポートする入力型式はＣｏｍｍｏｎＭＰ標準モデルが出力する型式のみとする</para>
        /// </remarks>
        private HySDataRoot[] ReadExternalCSV(HySFile csFile, string[] sHeadWk)
        {
            // 使用フィールド初期化
            double dBase;
            long lDataNum = 0;
            long lSeriesNum = 0;
            HySString sOut = new HySString();
            string[] sInWk;
            double dData = 0.0;
            HySTime csTime;
            long csCnt = 0;
            HySDataRoot[] csData = null;
            bool bDataMode = false; // デフォルト＝値を設定

            // ＣＳＶファイルを読み込み＆展開
            if (sHeadWk.Length > 0)
            {  // ヘッダ行有効の場合
                csCnt = sHeadWk.LongLength;
                lSeriesNum = (csCnt <= 0) ? 0 : csCnt - 1;
                if (lSeriesNum > 0)
                {  // データ列が有る場合
                    if (sHeadWk[0].Equals("Time") == true)
                    {
                        bDataMode = true; // 時系列を記憶
                    }
                    csData = new HySDataRoot[lSeriesNum];
                    for (int iLp1 = 0; iLp1 < csData.GetLength(0); iLp1++)
                    {  // 時系列グラフデータ件数分繰り返す
                        HySObjectKind csKind = HySDataKindDefine.ANY_VALUE; // (sHeadWk[iLp1 + 1].Length > 0) ? new HySObjectKind(sHeadWk[iLp1 + 1]) : HySDataKindDefine.ANY_VALUE;
                        csData[iLp1] = new HySGraphLineTimeSeries(csKind);
                    }
                }
            }
            while (csFile.ReadText(ref sOut) != 0)
            {  // 行が有る場合
                sInWk = sOut.ToString().Split(','); // ','区切りで展開する
                csCnt = sInWk.LongLength;
                lDataNum = (csCnt <= 0) ? 0 : csCnt - 1;
                for (int iLp = 0; iLp < lDataNum; iLp++)
                {  // データ配列数分繰り返す
                    try
                    {
                        dData = double.Parse(sInWk[iLp + 1]);
                    }
                    catch
                    {
                        continue; // return null;
                    }
                    try
                    {
                        if (bDataMode == true)
                        {  // 時系列データの場合
                            csTime = HySTime.DEFAULT_TIME.Clone();
                            DateTime csDTBase = DateTime.Parse("1/1/1970 0:0:0");
                            DateTime csDT = DateTime.Parse(sInWk[0]);
                            TimeSpan csTS = csDT - csDTBase;
                            csTime.SetTime((long)csTS.TotalSeconds);
                            ((HySGraphLineTimeSeries)csData[iLp]).AddData(csTime.Clone(), dData);
                        }
                        else
                        {  // 値データの場合
                            csTime = HySTime.DEFAULT_TIME.Clone();
                            dBase = double.Parse(sInWk[0]);
                            csTime.SetTime((long)dBase);
                            ((HySGraphLineTimeSeries)csData[iLp]).AddData(csTime.Clone(), dData);
                        }
                    }
                    catch
                    {
                        continue; // return null;
                    }
                }
            }
            return csData;
        }
        
        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                if (GetDecodedVersion() == null)
                {
                    // 旧バージョンからの移行処理を入れる
                }
                else
                {
                    //旧バージョンから順にバージョンを上げて行く
                    switch (GetDecodedVersion())
                    {
                        case "1.00":
                            {
                                // 旧バージョンからの移行処理を入れる
                                break;
                            }
                        //case "2.00": << 以後バージョンアップに伴って処理追加
                        //{
                        //    break;
                        //}
                    }
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
