﻿// <summary>ソースコード：共通表示業務定義情報クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMP.HYSSOP.CoreImpl.HSBusiProc
{
    /// <summary><para>class outline:</para>
    /// <para>共通表示業務定義情報クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// </remarks>
    public static class HySDispDefine
    {
        // =====================================
        // start of クラス内 定数定義
        // =====================================
        /// <summary>コンテナ一貫番号識別キー</summary>
        static public readonly HySString CONTAINER_NUMBER_KEYS = new HySString("HySContainerNumbers");
        /// <summary>表示業務管理データクラス識別キー</summary>
        static public readonly HySString DISPCTL_INFO_KEYS = new HySString("HySDispBusiProcedureCtlInfo");
        /// <summary>データ保存クラスリスト識別キー</summary>
        static public readonly HySString STOCKDATALIST_KEYS = new HySString("HySStockDataList");
        /// <summary>外部データ保存クラスリスト識別キー</summary>
        static public readonly HySString EXTERNALDATALIST_KEYS = new HySString("ExternalDataList");
        /// <summary>データ検索条件管理情報識別キー</summary>
        static public readonly HySString QUERYCTLDATA_KEYS = new HySString("HySQueryCtlDataList");
        /// <summary>永久保存ロットＩＤ情報識別キー</summary>
        static public readonly HySString PERMANENREPOSITORY_KEYS = new HySString("PermanentRepository");
        /// <summary>データ検索条件ポインタ情報識別キー</summary>
        static public readonly HySString QUERYCTLDATAPOINT_KEYS = new HySString("HySQueryCtlDataListPoint");
        /// <summary>ＧＩＳ地図データインスタンス情報識別キー</summary>
        static public readonly HySString GISBASEMAPDATA_KEYS = new HySString("HySGeoBaseMapData");

        // <Display Command/Notice SubEvent>
        /// <summary>画面関連一般サブ要因(表示)</summary>
        static public readonly long NOTICE_SCREEN_DISPLAY = 0x20000001;
        /// <summary>画面関連一般サブ要因(更新)</summary>
        static public readonly long NOTICE_SCREEN_UPDATE = 0x20000002;
        /// <summary>画面関連一般サブ要因(画面終了)</summary>
        static public readonly long NOTICE_SCREEN_CLOSE = 0x20000003;
        /// <summary>画面関連一般サブ要因(最小化)</summary>
        static public readonly long NOTICE_SCREEN_MINIMIZED = 0x20000004;
        /// <summary>画面関連一般サブ要因(ノーマライズ)</summary>
        static public readonly long NOTICE_SCREEN_NORMAL = 0x20000005;
        /// <summary>画面関連一般サブ要因(隠す)</summary>
        static public readonly long NOTICE_SCREEN_HIDE = 0x20000006;
        /// <summary>画面関連一般サブ要因(隠す)</summary>
        static public readonly long NOTICE_SCREEN_ACTIVE = 0x20000007;
        /// <summary>画面関連一般サブ要因(動作区分:親画面表示⇒最新データ検索⇒親画面更新通知)</summary>
        static public readonly long NOTICE_NO_SEARCH_CONDITION_SCREEN_LATEST = 0x20000008;
        /// <summary>画面関連一般サブ要因(動作区分:親画面表示⇒データ検索⇒親画面更新通知)</summary>
        static public readonly long NOTICE_NO_SEARCH_CONDITION_SCREEN_GENERAL = 0x20000009;
        /// <summary>画面関連一般サブ要因(動作区分:親画面表示⇒検索画面表示⇒親画面更新通知)</summary>
        static public readonly long NOTICE_NO_RESULT_SELECTION_SCREEN = 0x2000000A;
        /// <summary>画面関連一般サブ要因(動作区分:親画面表示⇒検索画面表示⇒検索結果画面表示⇒親画面更新通知)</summary>
        static public readonly long NOTICE_ONLY_RESULT_SELECTION_NOTIFICATION = 0x2000000B;
        /// <summary>画面関連一般サブ要因(動作区分:親画面表示⇒検索画面表示⇒親画面更新通知⇒検索結果画面表示)</summary>
        static public readonly long NOTICE_SCREEN_FUNDAMENTAL_MOTION = 0x2000000C;
        /// <summary>画面関連一般サブ要因(ＫＭＬ要求)</summary>
        static public readonly long NOTICE_KML_OUTPUT_REQUEST = 0x2000000D;
        /// <summary>画面関連一般サブ要因(ＫＭＬ出力完了報告)</summary>
        static public readonly long NOTICE_KML_OUTPUT_COMPLET = 0x2000000E;

        // <DB Command/Notice SubEvent>
        /// <summary>ＤＢ関連一般サブ要因(演算結果データ一覧検索要求)</summary>
        static public readonly long NOTICE_CALC_RESULT_DATA_LIST_REQUEST = 0x20000011;
        /// <summary>ＤＢ関連一般サブ要因(演算結果データ検索要求)</summary>
        static public readonly long NOTICE_CALC_RESULT_DATA_REQUEST = 0x20000012;
        /// <summary>ＤＢ関連一般サブ要因(演算ロット一覧検索要求)</summary>
        static public readonly long NOTICE_CALC_LOT_INFO_LIST_REQUEST = 0x20000013;
        /// <summary>ＤＢ関連一般サブ要因(演算ロット保存状態更新要求)</summary>
        static public readonly long NOTICE_CALC_LOT_INFO_UPDATE_REQUEST = 0x20000014;
        /// <summary>ＤＢ関連一般サブ要因(検索処理中)</summary>
        static public readonly long NOTICE_DB_REQUEST_BUSY = 0x2000001A;
        /// <summary>ＤＢ関連一般サブ要因(検索完了)</summary>
        static public readonly long NOTICE_DB_REQUEST_COMPLET = 0x2000001B;

        // <Moniter_Display Command/Notice SubEvent>
        /// <summary>画面関連一般サブ要因(計算結果データ生成)</summary>
        static public readonly long NOTICE_RESULT_AREA_CREATE = 0x20000021;
        /// <summary>画面関連一般サブ要因(モデル管理アクティブ通知)</summary>
        static public readonly long NOTICE_ACTIVE_EVENT = 0x20000022;
        /// <summary>画面関連一般サブ要因(モデル管理非アクティブ通知)</summary>
        static public readonly long NOTICE_NON_ACTIVE_EVENT = 0x20000023;
        /// <summary>画面関連一般サブ要因(モデル管理クローズ通知)</summary>
        static public readonly long NOTICE_MODEL_CLOSE = 0x20000024;
        /// <summary>画面関連一般サブ要因(１スクリーンで複数フォーム表示)</summary>
        static public readonly long NOTICE_FROM_DISPLAY = 0x20000025;
       
        // 保持データ種別関連
        /// <summary>時系列グラフデータ</summary>
        static public readonly HySKind STOCKDATA_KIND_LINE = new HySObjectKind("LineTimeSeriesData");
        /// <summary>時系列グラフデータ（ハイエト／ハイドロ）</summary>
        static public readonly HySKind STOCKDATA_KIND_HYDROHYETO = new HySObjectKind("HydroHyetoTimeSeriesData");
        /// <summary>河道縦断面グラフ情報時系列データ</summary>
        static public readonly HySKind STOCKDATA_KIND_RIVERBEDSERIALE = new HySObjectKind("RiverbedSerialData");
        /// <summary>河道縦断面グラフデータ</summary>
        static public readonly HySKind STOCKDATA_KIND_RIVERBED = new HySObjectKind("RiverbedData");
        /// <summary>Ｈ－Ｑグラフデータ</summary>
        static public readonly HySKind STOCKDATA_KIND_HQ = new HySObjectKind("HQData");
        /// <summary>河道列データ</summary>
        static public readonly HySKind CSKIND_RIVERBEDSERIALE = new HySObjectKind("RiverbedTimeSerial");
        /// <summary>Ｈ－Ｑ散布図データ</summary>
        static public readonly HySKind CSKIND_HQSCATTERSERIALE = new HySObjectKind("HQScatterSerial");

        // 検索条件設定関連
        /// <summary>演算結果データ</summary>
        static public readonly HySKind STOCKDATA_KIND_CALC_RESULT_DATA = new HySObjectKind("Calc_Result_Data");
        /// <summary>外部データ</summary>
        static public readonly HySKind STOCKDATA_KIND_EXTERNAL = new HySObjectKind("ExternalData");
        /// <summary>当日指定（期間指定要素）</summary>
        static public readonly HySKind SPECIFICATION_TODAY = new HySObjectKind("Specification_Today");
        /// <summary>期間（期間指定要素）</summary>
        static public readonly HySKind SPECIFICATION_PERIOD = new HySObjectKind("Specification_Period");
        /// <summary>指定日以降（期間指定要素）</summary>
        static public readonly HySKind SPECIFICATION_DAY_FROM = new HySObjectKind("Specification_Day_From");
        /// <summary>指定日以前（期間指定要素）</summary>
        static public readonly HySKind SPECIFICATION_DAY_TO = new HySObjectKind("Specification_Day_To");
        /// <summary>複合検索</summary>
        static public readonly string COMPOUND_RETRIEVAL = "Compound_retrieval";
        /// <summary>単独検索</summary>
        static public readonly string SINGLE_RETRIEVAL = "Single_retrieval";
        /// <summary>検索無し</summary>
        static public readonly string NON_RETRIEVAL = "Non_retrieval";
        ///// <summary>データ種別キー名リスト</summary>
        //static public readonly HySKind[,] STOCKDATA_TYPE = { // データ種別,ラベル名称
        //                                   {HySDataKindDefine.QUANTITY_OF_WATER_FLOW, new HySObjectKind("流量") }
        //                                  ,{HySDataKindDefine.WATER_LEVEL           , new HySObjectKind("水位") }
        //                                  ,{HySDataKindDefine.WATER_VOLUME          , new HySObjectKind("水量") }
        //                                  ,{HySDataKindDefine.SCALOR_VELOCITY       , new HySObjectKind("流速") }
        //                                  ,{HySDataKindDefine.VECTOR_L_VELOCITY     , new HySObjectKind("ライン方向流速") }
        //                                  ,{HySDataKindDefine.VECTOR_W_VELOCITY     , new HySObjectKind("横方向流速") }
        //                                  ,{HySDataKindDefine.VECTOR_D_VELOCITY     , new HySObjectKind("深さ方向流速") }
        //                                  ,{HySDataKindDefine.SCALOR_PRESSURE       , new HySObjectKind("圧力") }
        //                                  ,{HySDataKindDefine.VECTOR_L_PRESSURE     , new HySObjectKind("ライン方向圧力") }
        //                                  ,{HySDataKindDefine.VECTOR_W_PRESSURE     , new HySObjectKind("横方向圧力") }
        //                                  ,{HySDataKindDefine.VECTOR_D_PRESSURE     , new HySObjectKind("深さ方向圧力") }
        //                                  ,{HySDataKindDefine.SCALOR_RAIN_FALL      , new HySObjectKind("雨量") }
        //                                  };
        //static public readonly HySKind[,] STOCKDATA_TYPE = { // データ種別,ラベル名称
        //                                   {HySDataKindDefine.QUANTITY_OF_WATER_FLOW, new HySObjectKind(Properties.HyssopImplResources.KIND_QUANTITY_OF_WATER_FLOW) }   //流量
        //                                  ,{HySDataKindDefine.WATER_LEVEL           , new HySObjectKind(Properties.HyssopImplResources.KIND_WATER_LEVEL) }              //水位
        //                                  ,{HySDataKindDefine.WATER_VOLUME          , new HySObjectKind(Properties.HyssopImplResources.KIND_WATER_VOLUME) }             //水量
        //                                  ,{HySDataKindDefine.SCALOR_VELOCITY       , new HySObjectKind(Properties.HyssopImplResources.KIND_SCALOR_VELOCITY) }          //流速
        //                                  ,{HySDataKindDefine.VECTOR_L_VELOCITY     , new HySObjectKind(Properties.HyssopImplResources.KIND_VECTOR_L_VELOCITY) }        //ライン方向流速
        //                                  ,{HySDataKindDefine.VECTOR_W_VELOCITY     , new HySObjectKind(Properties.HyssopImplResources.KIND_VECTOR_W_VELOCITY) }        //横方向流速
        //                                  ,{HySDataKindDefine.VECTOR_D_VELOCITY     , new HySObjectKind(Properties.HyssopImplResources.KIND_VECTOR_D_VELOCITY) }        //深さ方向流速
        //                                  ,{HySDataKindDefine.SCALOR_PRESSURE       , new HySObjectKind(Properties.HyssopImplResources.KIND_SCALOR_PRESSURE) }          //圧力
        //                                  ,{HySDataKindDefine.VECTOR_L_PRESSURE     , new HySObjectKind(Properties.HyssopImplResources.KIND_VECTOR_L_PRESSURE) }        //ライン方向圧力
        //                                  ,{HySDataKindDefine.VECTOR_W_PRESSURE     , new HySObjectKind(Properties.HyssopImplResources.KIND_VECTOR_W_PRESSURE) }        //横方向圧力
        //                                  ,{HySDataKindDefine.VECTOR_D_PRESSURE     , new HySObjectKind(Properties.HyssopImplResources.KIND_VECTOR_D_PRESSURE) }        //深さ方向圧力
        //                                  ,{HySDataKindDefine.SCALOR_RAIN_FALL      , new HySObjectKind(Properties.HyssopImplResources.KIND_SCALOR_RAIN_FALL) }         //雨量
        //                                  };
        ///// <summary>GIS関連データ種別キー名リスト</summary>
        //static public readonly HySKind[,] GIS_STOCKDATA_TYPE = { // データ種別,ラベル名称
        //                                   {HySDataKindDefine.GIS_QUANTITY_OF_WATER_FLOW, new HySObjectKind("流量") }
        //                                  ,{HySDataKindDefine.GIS_WATER_LEVEL           , new HySObjectKind("水位") }
        //                                  ,{HySDataKindDefine.GIS_WATER_VOLUME          , new HySObjectKind("水量") }
        //                                  ,{HySDataKindDefine.GIS_SCALOR_VELOCITY       , new HySObjectKind("流速") }
        //                                  ,{HySDataKindDefine.GIS_VECTOR_L_VELOCITY     , new HySObjectKind("ライン方向流速") }
        //                                  ,{HySDataKindDefine.GIS_VECTOR_W_VELOCITY     , new HySObjectKind("横方向流速") }
        //                                  ,{HySDataKindDefine.GIS_VECTOR_D_VELOCITY     , new HySObjectKind("深さ方向流速") }
        //                                  ,{HySDataKindDefine.GIS_SCALOR_PRESSURE       , new HySObjectKind("圧力") }
        //                                  ,{HySDataKindDefine.GIS_VECTOR_L_PRESSURE     , new HySObjectKind("ライン方向圧力") }
        //                                  ,{HySDataKindDefine.GIS_VECTOR_W_PRESSURE     , new HySObjectKind("横方向圧力") }
        //                                  ,{HySDataKindDefine.GIS_VECTOR_D_PRESSURE     , new HySObjectKind("深さ方向圧力") }
        //                                  ,{HySDataKindDefine.GIS_SCALOR_RAIN_FALL      , new HySObjectKind("雨量") }
        //                                  };
        //static public readonly HySKind[,] GIS_STOCKDATA_TYPE = { // データ種別,ラベル名称
        //                                   {HySDataKindDefine.GIS_QUANTITY_OF_WATER_FLOW, new HySObjectKind(Properties.HyssopImplResources.KIND_QUANTITY_OF_WATER_FLOW) }   //流量
        //                                  ,{HySDataKindDefine.GIS_WATER_LEVEL           , new HySObjectKind(Properties.HyssopImplResources.KIND_WATER_LEVEL) }              //水位
        //                                  ,{HySDataKindDefine.GIS_WATER_VOLUME          , new HySObjectKind(Properties.HyssopImplResources.KIND_WATER_VOLUME) }             //水量
        //                                  ,{HySDataKindDefine.GIS_SCALOR_VELOCITY       , new HySObjectKind(Properties.HyssopImplResources.KIND_SCALOR_VELOCITY) }          //流速
        //                                  ,{HySDataKindDefine.GIS_VECTOR_L_VELOCITY     , new HySObjectKind(Properties.HyssopImplResources.KIND_VECTOR_L_VELOCITY) }        //ライン方向流速
        //                                  ,{HySDataKindDefine.GIS_VECTOR_W_VELOCITY     , new HySObjectKind(Properties.HyssopImplResources.KIND_VECTOR_W_VELOCITY) }        //横方向流速
        //                                  ,{HySDataKindDefine.GIS_VECTOR_D_VELOCITY     , new HySObjectKind(Properties.HyssopImplResources.KIND_VECTOR_D_VELOCITY) }        //深さ方向流速
        //                                  ,{HySDataKindDefine.GIS_SCALOR_PRESSURE       , new HySObjectKind(Properties.HyssopImplResources.KIND_SCALOR_PRESSURE) }          //圧力
        //                                  ,{HySDataKindDefine.GIS_VECTOR_L_PRESSURE     , new HySObjectKind(Properties.HyssopImplResources.KIND_VECTOR_L_PRESSURE) }        //ライン方向圧力
        //                                  ,{HySDataKindDefine.GIS_VECTOR_W_PRESSURE     , new HySObjectKind(Properties.HyssopImplResources.KIND_VECTOR_W_PRESSURE) }        //横方向圧力
        //                                  ,{HySDataKindDefine.GIS_VECTOR_D_PRESSURE     , new HySObjectKind(Properties.HyssopImplResources.KIND_VECTOR_D_PRESSURE) }        //深さ方向圧力
        //                                  ,{HySDataKindDefine.GIS_SCALOR_RAIN_FALL      , new HySObjectKind(Properties.HyssopImplResources.KIND_SCALOR_RAIN_FALL) }         //雨量
        //                                  };
        /// <summary>検索種別キー名リスト</summary>
        static public readonly HySKind[,] SEARCHDATA_TYPE = { 
                                           { HySDispDefine.STOCKDATA_KIND_CALC_RESULT_DATA, new HySObjectKind(Properties.HyssopImplResources.STOCKDATA_KIND_CALC_RESULT_DATA) } //演算結果データ
                                          ,{ HySDispDefine.STOCKDATA_KIND_EXTERNAL        , new HySObjectKind(Properties.HyssopImplResources.STOCKDATA_KIND_EXTERNAL)     }     //外部データ
                                                  };
        /// <summary>期間指定キー名リスト</summary>
        static public readonly HySKind[,] PERIODDATA_TYPE = { 
                                           { HySDispDefine.SPECIFICATION_TODAY   , new HySObjectKind(Properties.HyssopImplResources.DATE_TARGET) }  //指定日当日
                                          ,{ HySDispDefine.SPECIFICATION_PERIOD  , new HySObjectKind(Properties.HyssopImplResources.DATE_TERM) }    //指定日期間
                                          ,{ HySDispDefine.SPECIFICATION_DAY_FROM, new HySObjectKind(Properties.HyssopImplResources.DATE_AFTER) }   //指定日以降
                                          ,{ HySDispDefine.SPECIFICATION_DAY_TO  , new HySObjectKind(Properties.HyssopImplResources.DATE_BEFORE) }  //指定日以前
                                                  };
        /// <summary>画面グループキー名リスト</summary>
        static public readonly HySKind[,] PARENTS_SCREEN_NAME = { 
                                           { HySDefine.DISP_FORM_LINE_GRAPH       , new HySObjectKind(Properties.HyssopImplResources.DISP_FORM_LINE_GRAPH) }        //基本画面
                                          ,{ HySDefine.DISP_FORM_HYDRO_HYETO_GRAPH, new HySObjectKind(Properties.HyssopImplResources.DISP_FORM_HYDRO_HYETO_GRAPH) } //ハイドロ／ハイエトグラフ
                                          ,{ HySDefine.DISP_FORM_RIVERBED_SHAPE   , new HySObjectKind(Properties.HyssopImplResources.DISP_FORM_RIVERBED_SHAPE) }    //一次元縦断データ
                                          ,{ HySDefine.DISP_FORM_HQ_GRAPH         , new HySObjectKind(Properties.HyssopImplResources.DISP_FORM_HQ_GRAPH) }          //Ｈ－Ｑ曲線図
                                          ,{ HySDefine.DISP_FORM_EXCEL            , new HySObjectKind(Properties.HyssopImplResources.DISP_FORM_EXCEL) }             //ＥＸＣＥＬ
                                          ,{ HySDefine.DISP_FORM_GIS2D_MESH       , new HySObjectKind(Properties.HyssopImplResources.DISP_FORM_GIS2D_MESH) }        //演算結果表示（メッシュ形式）
                                          ,{ HySDefine.DISP_FORM_SEARCH_CONDITION , new HySObjectKind(Properties.HyssopImplResources.DISP_FORM_SEARCH_CONDITION) }  //検索条件設定
                                          ,{ HySDefine.DISP_FORM_RESULT_SELECTION , new HySObjectKind(Properties.HyssopImplResources.DISP_FORM_RESULT_SELECTION) }  //検索結果選択
                                          ,{ HySDefine.DISP_FORM_GRAPH_CUSTOMIZ   , new HySObjectKind(Properties.HyssopImplResources.DISP_FORM_GRAPH_CUSTOMIZ) }    //グラフカスタマイズ
                                                  };
        /// <summary>画面グループ毎検索対象伝送情報型定義</summary>
        //static public readonly HySKind[,] SEARCH_TRANINFO_TYPE = { 
        //                                   {HySDefine.DISP_FORM_LINE_GRAPH,
        //                                             new HySObjectKind("ポイント時系列情報") , null },
        //                                   {HySDefine.DISP_FORM_HYDRO_HYETO_GRAPH,
        //                                             new HySObjectKind("ポイント時系列情報") , null },
        //                                   {HySDefine.DISP_FORM_RIVERBED_SHAPE,
        //                                             new HySObjectKind("1次元配列時系列情報"), null },
        //                                   {HySDefine.DISP_FORM_HQ_GRAPH,
        //                                             null                                    , null },
        //                                   {HySDefine.DISP_FORM_EXCEL,
        //                                             new HySObjectKind("ポイント時系列情報") , new HySObjectKind("1次元配列時系列情報") },
        //                                   {HySDefine.DISP_FORM_GIS2D_MESH,
        //                                             new HySObjectKind("2次元配列時系列情報"), null }
        //                                         };
        static public readonly HySKind[, ,] SEARCH_TRANINFO_TYPE = { 
                                           {
                                               { HySDefine.DISP_FORM_LINE_GRAPH, new HySObjectKind(Properties.HyssopImplResources.NAME_SINGLE_CELL_SERIAL),
                                                   HySDataKindDefine.D1_CELL_SERIAL, new HySObjectKind("1"),  new HySObjectKind("0"),  new HySObjectKind("0") }
                                              ,{ HySDefine.DISP_FORM_LINE_GRAPH, null, null, null, null, null }
                                              ,{ HySDefine.DISP_FORM_LINE_GRAPH, null, null, null, null, null }
                                              ,{ HySDefine.DISP_FORM_LINE_GRAPH, null, null, null, null, null }
                                              ,{ HySDefine.DISP_FORM_LINE_GRAPH, null, null, null, null, null }
                                           },    // ポイント時系列情報
                                           {
                                               { HySDefine.DISP_FORM_HYDRO_HYETO_GRAPH, new HySObjectKind(Properties.HyssopImplResources.NAME_SINGLE_CELL_SERIAL),
                                                   HySDataKindDefine.D1_CELL_SERIAL, new HySObjectKind("1"),  new HySObjectKind("0"),  new HySObjectKind("0") }
                                              ,{ HySDefine.DISP_FORM_HYDRO_HYETO_GRAPH, new HySObjectKind(Properties.HyssopImplResources.NAME_D1_CELL_SERIAL),
                                                   HySDataKindDefine.D1_CELL_SERIAL, new HySObjectKind("!1"), new HySObjectKind("0"),  new HySObjectKind("0") }
                                              ,{ HySDefine.DISP_FORM_HYDRO_HYETO_GRAPH, null, null, null, null, null }
                                              ,{ HySDefine.DISP_FORM_HYDRO_HYETO_GRAPH, null, null, null, null, null }
                                              ,{ HySDefine.DISP_FORM_HYDRO_HYETO_GRAPH, null, null, null, null, null }
                                           },    // ポイント時系列情報  1次元配列時系列情報
                                           {
                                               { HySDefine.DISP_FORM_RIVERBED_SHAPE, new HySObjectKind(Properties.HyssopImplResources.NAME_D1_CELL_SERIAL),
                                                   HySDataKindDefine.D1_CELL_SERIAL, new HySObjectKind("!1"), new HySObjectKind("0"),  new HySObjectKind("0") }
                                              ,{ HySDefine.DISP_FORM_RIVERBED_SHAPE, null, null, null, null, null }
                                              ,{ HySDefine.DISP_FORM_RIVERBED_SHAPE, null, null, null, null, null }
                                              ,{ HySDefine.DISP_FORM_RIVERBED_SHAPE, null, null, null, null, null }
                                              ,{ HySDefine.DISP_FORM_RIVERBED_SHAPE, null, null, null, null, null }
                                           },    // 1次元配列時系列情報
                                           {
                                               { HySDefine.DISP_FORM_HQ_GRAPH, null, null, null, null, null }
                                              ,{ HySDefine.DISP_FORM_HQ_GRAPH, null, null, null, null, null }
                                              ,{ HySDefine.DISP_FORM_HQ_GRAPH, null, null, null, null, null }
                                              ,{ HySDefine.DISP_FORM_HQ_GRAPH, null, null, null, null, null }
                                              ,{ HySDefine.DISP_FORM_HQ_GRAPH, null, null, null, null, null }
                                           },
                                           {
                                               { HySDefine.DISP_FORM_EXCEL, new HySObjectKind(Properties.HyssopImplResources.NAME_SINGLE_CELL_SERIAL
                                                   + "," + Properties.HyssopImplResources.NAME_D1_CELL_SERIAL),
                                                   HySDataKindDefine.D1_CELL_SERIAL, null,  new HySObjectKind("0"),  new HySObjectKind("0") }
                                              ,{ HySDefine.DISP_FORM_EXCEL, null, null, null, null, null }
                                              ,{ HySDefine.DISP_FORM_EXCEL, null, null, null, null, null }
                                              ,{ HySDefine.DISP_FORM_EXCEL, null, null, null, null, null }
                                              ,{ HySDefine.DISP_FORM_EXCEL, null, null, null, null, null }
                                           },   // ポイント時系列情報  1次元配列時系列情報
                                           {
                                               { HySDefine.DISP_FORM_GIS2D_MESH, new HySObjectKind(Properties.HyssopImplResources.NAME_D2_CELL_SERIAL),
                                                   HySDataKindDefine.D2_GIS_MESH_SERIAL, null,  null,  new HySObjectKind("0") }
                                              ,{ HySDefine.DISP_FORM_GIS2D_MESH, null, null, null, null, null }
                                              ,{ HySDefine.DISP_FORM_GIS2D_MESH, null, null, null, null, null }
                                              ,{ HySDefine.DISP_FORM_GIS2D_MESH, null, null, null, null, null }
                                              ,{ HySDefine.DISP_FORM_GIS2D_MESH, null, null, null, null, null }
                                           }  // 2次元配列時系列情報
                                                                  };
        /// <summary>評価機能最大検索件数</summary>
        static public readonly long SERACH_MAX_NUMBER = 100;

        /// <summary>正判定文字</summary>
        static public readonly string TRUE_TEXT = "true";
        /// <summary>偽判定文字</summary>
        static public readonly string FALSE_TEXT = "false";

        // =====================================
        // end of クラス内 定数定義
        // =====================================
    }
}
