﻿// <summary>ソースコード：インスタンス共有データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.CoreImpl.HSBusiProc
{
    /// <summary><para>class outline:</para>
    /// <para>インスタンス共有データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/10/01][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class HySDispInstanceCommon : HySDataRoot, HySVersionManagement 
    {
        /// <summary>リンクドリスト</summary>
        protected HySDataLinkedList[] m_csLinkdListArray = null;

        /// <summary>ハッシュテーブル</summary>
        protected HySDataHashTable[] m_csHashTableArray = null;

        /// <summary>時刻配列</summary>
        protected HySTime[] m_csTimeArray = null;

        /// <summary>整数配列</summary>
        protected long[] m_lLongArray = null;

        /// <summary>実数配列</summary>
        protected double[] m_dDoubleArray = null;

        /// <summary>文字列配列</summary>
        protected HySString[] m_csStringArray = null;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDispInstanceCommon csInstanceCommon = new HySDispInstanceCommon()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDispInstanceCommon 生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDispInstanceCommon()
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>リンクドリスト配列設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetDataLinkedListArray(csListArray)</para>
        /// </example>
        /// <param name="csListArray">リンクドリスト配列インスタンス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetDataLinkedListArray(HySDataLinkedList[] csListArray)
        {
            m_csLinkdListArray = csListArray;
        }
        /// <summary><para>method outline:</para>
        /// <para>リンクドリスト配列取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDataLinkedList[] csLinkedList = GetDataLinkedListArray()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataLinkedList[] リンクドリスト配列インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDataLinkedList[] GetDataLinkedListArray()
        {
            return m_csLinkdListArray;
        }

        /// <summary><para>method outline:</para>
        /// <para>ハッシュテーブル配列設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetDataHashTableArray(csHListArray)</para>
        /// </example>
        /// <param name="csHListArray">ハッシュテーブル配列インスタンス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetDataHashTableArray(HySDataHashTable[] csHListArray)
        {
            m_csHashTableArray = csHListArray;
        }
        /// <summary><para>method outline:</para>
        /// <para>ハッシュテーブル配列取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDataHashTable[] csHashTable = GetDataHashTable()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataHashTable[] ハッシュテーブル配列インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDataHashTable[] GetDataHashTableArray()
        {
            return m_csHashTableArray;
        }

        /// <summary><para>method outline:</para>
        /// <para>時刻配列設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetTimeArray(csTimeList)</para>
        /// </example>
        /// <param name="csTimeList">時刻配列インスタンス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetTimeArray(HySTime[] csTimeList)
        {
            long lCnt = csTimeList.GetLength(0);
            if (lCnt > 0)
            {  // データ転送が必要な場合
                m_csTimeArray = new HySTime[(int)lCnt];
                for (int iLp = 0; iLp < (int)lCnt; iLp++)
                {
                    m_csTimeArray[iLp] = csTimeList[iLp];
                }
            }
            else
            {  // データ転送が不要な場合
                m_csTimeArray = null;
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>時刻配列取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySTime[] csTimeList = GetTimeArray()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySTime[] 時刻配列インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySTime[] GetTimeArray()
        {
            return m_csTimeArray;
        }

        /// <summary><para>method outline:</para>
        /// <para>整数配列設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetLongArray(lList)</para>
        /// </example>
        /// <param name="lList">整数配列インスタンス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetLongArray(long[] lList)
        {
            long lCnt = lList.GetLength(0);
            if (lCnt > 0)
            {  // データ転送が必要な場合
                m_lLongArray = new long[(int)lCnt];
                for (int iLp = 0; iLp < (int)lCnt; iLp++)
                {
                    m_lLongArray[iLp] = lList[iLp];
                }
            }
            else
            {  // データ転送が不要な場合
                m_lLongArray = null;
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>整数配列取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long[] lList = GetLongArray()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long[] 整数配列インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long[] GetLongArray()
        {
            return m_lLongArray;
        }

        /// <summary><para>method outline:</para>
        /// <para>実数配列設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetDoubleArray(dList)</para>
        /// </example>
        /// <param name="dList">実数配列インスタンス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetDoubleArray(double[] dList)
        {
            long lCnt = dList.GetLength(0);
            if (lCnt > 0)
            {  // データ転送が必要な場合
                m_dDoubleArray = new double[(int)lCnt];
                for (int iLp = 0; iLp < (int)lCnt; iLp++)
                {
                    m_dDoubleArray[iLp] = dList[iLp];
                }
            }
            else
            {  // データ転送が不要な場合
                m_dDoubleArray = null;
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>実数配列取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>double[] dList = GetDoubleArray()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>double[] 実数配列インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual double[] GetDoubleArray()
        {
            return m_dDoubleArray;
        }

        /// <summary><para>method outline:</para>
        /// <para>字列配列設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetStringArray(csList)</para>
        /// </example>
        /// <param name="csList">文字列配列インスタンス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetStringArray(HySString[] csList)
        {
            long lCnt = csList.GetLength(0);
            if (lCnt > 0)
            {  // データ転送が必要な場合
                m_csStringArray = new HySString[(int)lCnt];
                for (int iLp = 0; iLp < (int)lCnt; iLp++)
                {
                    m_csStringArray[iLp] = csList[iLp];
                }
            }
            else
            {  // データ転送が不要な場合
                m_csStringArray = null;
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>文字列配列取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySString[] csList = GetStringArray()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString[] 文字列配列インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySString[] GetStringArray()
        {
            return m_csStringArray;
        }

        
        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                if (GetDecodedVersion() == null)
                {
                    // 旧バージョンからの移行処理を入れる
                }
                else
                {
                    //旧バージョンから順にバージョンを上げて行く
                    switch (GetDecodedVersion())
                    {
                        case "1.00":
                            {
                                // 旧バージョンからの移行処理を入れる
                                break;
                            }
                        //case "2.00": << 以後バージョンアップに伴って処理追加
                        //{
                        //    break;
                        //}
                    }
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
