﻿// <summary>ソースコード：データ検索要求クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYSSOP.CoreImpl.HSLibraryMng;

namespace CommonMP.HYSSOP.CoreImpl.HSBusiProc
{
    /// <summary><para>class outline:</para>
    /// <para>データ検索要求データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class HySDispSearchRequest : HySDataRoot, HySVersionManagement 
    {
        /// <summary>リトライカウンタ</summary>
        protected long m_lRetryCount = 0;

        /// <summary>検索条件</summary>
        protected HySString m_csQueryCondition = null;

        /// <summary>要求元識別子</summary>
        protected HySID m_csID = null;

        /// <summary>サブイベント番号（検索種別）</summary>
        protected long m_lSubEventNo = 0;

        /// <summary>第２付属識別子（データ種別）</summary>
        protected HySID m_csDataID = null;

        /// <summary>送信先シミュレーション種別識別子</summary>
        protected HySKind m_csToSimKind = null;

        /// <summary>データ検索条件エントリクラス</summary>
        protected HySQueryCtlData m_csQueryCtlData = null;

        /// <summary>データＩＤリスト</summary>
        protected HySDataLinkedList m_csDataIDList = null;

        /// <summary>部分更新リスト</summary>
        protected HySDBPartialUpdateSpec m_csUpdateSpec = null;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>使用禁止</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDispSearchRequest 生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected HySDispSearchRequest()
        {
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDispSearchRequest csDispSerchrequest = new HySDispSearchRequest(csID)</para>
        /// </example>
        /// <param name="csID">要求元識別子</param>
        /// <returns>HySDispSearchRequest 生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDispSearchRequest(HySID csID)
        {
            m_csID = csID.Clone();
            m_csQueryCtlData = new HySQueryCtlData();
            m_csQueryCondition = new HySString("");

            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDispSearchRequest csDispSerchrequest = new HySDispSearchRequest(csID,csQueryCondition)</para>
        /// </example>
        /// <param name="csID">要求元識別子</param>
        /// <param name="csQueryCondition">検索条件</param>
        /// <returns>HySDispSearchRequest 生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDispSearchRequest(HySID csID, HySString csQueryCondition)
        {
            m_csID = csID.Clone();
            m_csQueryCtlData = new HySQueryCtlData();
            m_csQueryCondition = csQueryCondition.Clone();

            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>要求元識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySID csID = GetcsID()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySID 要求元識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySID GetcsID()
        {
            return m_csID;
        }

        /// <summary><para>method outline:</para>
        /// <para>サブイベント番号（検索種別）設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetSubEventNo(lSubEventNo)</para>
        /// </example>
        /// <param name="lSubEventNo">サブイベント番号（検索種別）</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetSubEventNo(long lSubEventNo)
        {
            m_lSubEventNo = lSubEventNo;
        }
        /// <summary><para>method outline:</para>
        /// <para>サブイベント番号（検索種別）取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lSubEventNo = GetSubEventNo()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long サブイベント番号（検索種別）</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetSubEventNo()
        {
            return m_lSubEventNo;
        }

        /// <summary><para>method outline:</para>
        /// <para>第２付属識別子（データ種別）取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetDataID(csDataID)</para>
        /// </example>
        /// <param name="csDataID">第２付属識別子（データ種別）</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetDataID(HySID csDataID)
        {
            m_csDataID = csDataID.Clone();
        }
        /// <summary><para>method outline:</para>
        /// <para>第２付属識別子（データ種別）取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySID csDataID = GetDataID()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySID 第２付属識別子（データ種別）</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySID GetDataID()
        {
            return m_csDataID;
        }

        /// <summary><para>method outline:</para>
        /// <para>送信先シミュレーション種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetToSimKind(csToSimKind)</para>
        /// </example>
        /// <param name="csToSimKind">送信先シミュレーション種別識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetToSimKind(HySKind csToSimKind)
        {
            m_csToSimKind = csToSimKind;
        }
        /// <summary><para>method outline:</para>
        /// <para>送信先シミュレーション種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySKind csToSimKind = GetToSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySKind 送信先シミュレーション種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySKind GetToSimKind()
        {
            return m_csToSimKind;
        }

        /// <summary><para>method outline:</para>
        /// <para>演算結果データ一覧検索条件エントリクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>CreateCalcResultListQuery(csData)</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CreateCalcResultListQuery()
        {
            int iLp;
            bool bFlag = false;
            bool bInFlg = false;
            HySString csFieldName = null;
            Type csDataType = null;
            HySQueryCompareMode csCompareMode = HySQueryCompareMode.EQUALS;
            object csValueToCompare = null;
            HySTime[] csTime = new HySTime[2];
            DateTime csDTBase;
            TimeSpan csTS;
            string sWk = "";
            string[] sInWk;

            // 初期設定
            m_csQueryCtlData.SetIsMetaDataOnly(true);                  // メタデータのみ取得を設定
            m_csQueryCtlData.SetLimitOfSearchResults((int)HySDispDefine.SERACH_MAX_NUMBER); // 最大検索件数を設定
            m_lSubEventNo = HySLibraryMngDefine.DB_QUERY_DATA_LIST;    // サブイベント番号（検索種別）
            m_csDataID = HySLibraryMngDefine.DB_KIND_CALC_RESULT_DATA; // 第２付属識別子（データ種別） 
            m_csToSimKind = HySDefine.SIMULATOR_KIND;                  // 送信先シミュレーション種別識別子

            // 期間指定有無を判定
            sInWk = m_csQueryCondition.ToString().Split(',');
            for (iLp = 0; iLp < HySDispDefine.PERIODDATA_TYPE.GetLength(0); iLp++)
            {  // データ種別件数分繰り返す
                if (HySDispDefine.PERIODDATA_TYPE[iLp, 0].ToString().Equals(sInWk[3]) == true)
                {  // 期間指定区分が一致した場合
                    csFieldName = HySCalResultDataQueryFieldNames.CALC_EXEC_DATE; // フィールド名設定
                    csDataType = typeof(HySTime);                              // データタイプ設定
                    csCompareMode = HySQueryCompareMode.BETWEEN;               // 範囲（最小～最大）設定
                    switch (iLp)
                    {
                        case 0: // 当日指定
                            csDTBase = DateTime.Parse("1/1/1970 0:0:0");   // 基準時刻
                            sWk = DateTime.Now.ToString("yyyy/MM/dd") + " 0:0:0";
                            csTS = DateTime.Parse(sWk) - csDTBase;
                            csTime[0] = new HySTime((long)csTS.TotalSeconds);
                            sWk = DateTime.Now.ToString("yyyy/MM/dd") + " 23:59:59";
                            csTS = DateTime.Parse(sWk) - csDTBase;
                            csTime[1] = new HySTime((long)csTS.TotalSeconds);
                            csValueToCompare = csTime.Clone(); // データ設定
                            bInFlg = true; // 検索エントリ登録要設定
                            break;
                        case 1: // 指定期間
                            if (sInWk[4].Length > 0 && sInWk[5].Length > 0)
                            {  // 開始と終了が設定されている場合
                                bInFlg = true; // 検索エントリ登録要設定
                                try
                                {
                                    csDTBase = DateTime.Parse("1/1/1970 0:0:0");   // 基準時刻
                                    sWk = DateTime.Parse(sInWk[4]).ToString("yyyy/MM/dd") + " 0:0:0";
                                    csTS = DateTime.Parse(sWk) - csDTBase;
                                    csTime[0] = new HySTime((long)csTS.TotalSeconds);
                                    sWk = DateTime.Parse(sInWk[5]).ToString("yyyy/MM/dd") + " 23:59:59";
                                    csTS = DateTime.Parse(sWk) - csDTBase;
                                    csTime[1] = new HySTime((long)csTS.TotalSeconds);
                                    csValueToCompare = csTime.Clone(); // データ設定
                                }
                                catch
                                {
                                    bInFlg = false;
                                }
                            }
                            break;
                        case 2: // 指定日以降
                            if( sInWk[4].Length > 0)
                            {  // 開始が設定されている場合
                                bInFlg = true; // 検索エントリ登録要設定
                                try
                                {
                                    csDTBase = DateTime.Parse("1/1/1970 0:0:0");   // 基準時刻
                                    sWk = DateTime.Parse(sInWk[4]).ToString("yyyy/MM/dd") + " 0:0:0";
                                    csTS = DateTime.Parse(sWk) - csDTBase;
                                    csTime[0] = new HySTime((long)csTS.TotalSeconds);
                                    sWk = DateTime.Now.ToString("yyyy/MM/dd") + " 23:59:59";
                                    csTS = DateTime.Parse(sWk) - csDTBase;
                                    csTime[1] = new HySTime((long)csTS.TotalSeconds);
                                    csValueToCompare = csTime.Clone(); // データ設定
                                }
                                catch
                                {
                                    bInFlg = false;
                                }
                            }
                            break;
                        case 3: // 指定日以前
                            if (sInWk[5].Length > 0)
                            {  // 終了が設定されている場合
                                bInFlg = true; // 検索エントリ登録要設定
                                try
                                {
                                    csDTBase = DateTime.Parse("1/1/1970 0:0:0");   // 基準時刻
                                    csTS = csDTBase - csDTBase;
                                    csTime[0] = new HySTime((long)csTS.TotalSeconds);
                                    sWk = DateTime.Parse(sInWk[5]).ToString("yyyy/MM/dd") + " 23:59:59";
                                    csTS = DateTime.Parse(sWk) - csDTBase;
                                    csTime[1] = new HySTime((long)csTS.TotalSeconds);
                                    csValueToCompare = csTime.Clone(); // データ設定
                                }
                                catch
                                {
                                    bInFlg = false;
                                }
                            }
                            break;
                        default : // その他
                            break;
                    }
                    if (bInFlg == true)
                    {  // エントリフィールド登録要の場合
                        // データ検索条件エントリクラス生成
                        HySQueryEntryData csQueryEntryData = new HySQueryEntryData();
                        csQueryEntryData.SetFieldName(csFieldName.Clone());   // 検索対象フィールド名設定
                        csQueryEntryData.SetDataType(csDataType);        // フィールドのデータ型設定
                        csQueryEntryData.SetCompareMode(csCompareMode);  // 比較モード列挙体設定
                        csQueryEntryData.SetValueToCompare(csValueToCompare); // 比較対象の値設定
                        m_csQueryCtlData.SetQueryEntryData(csQueryEntryData); // 検索条件エントリを登録
                        bInFlg = false;
                    }
                    break;
                }
            }
            // 日付以外の検索条件編集
            bInFlg = false;
            bFlag = false;
            for (iLp = 0; iLp < sInWk.Length; iLp++)
            {  // 設定項目件数分繰り返す
                switch (iLp)
                {  // 項目で分岐
                    case 0: // 検索種別
                        if (HySDispDefine.STOCKDATA_KIND_CALC_RESULT_DATA.ToString().Equals(sInWk[iLp]) == true)
                        {  // 演算結果データの場合
                            m_lSubEventNo = HySLibraryMngDefine.DB_QUERY_DATA_LIST;    // サブイベント番号（検索種別）
                            m_csDataID = HySLibraryMngDefine.DB_KIND_CALC_RESULT_DATA; // 第２付属識別子（データ種別） 
                            m_csToSimKind = HySDefine.SIMULATOR_KIND;                  // 送信先シミュレーション種別識別子
                            bFlag = true; // 検索条件生成設定
                        }
                        break;
                    case 1: // プロジェクト名称
                        if (bFlag == true)
                        {  // 検索条件生成が有効な場合
                            if (sInWk[iLp].Length > 0)
                            {  // 入力が有る場合
                                csFieldName = HySCalResultDataQueryFieldNames.PROJECT_NAME; // フィールド名設定
                                csDataType = typeof(HySString);               // データタイプ設定
                                csCompareMode = HySQueryCompareMode.EQUALS;   // 一致設定
                                csValueToCompare = new HySString(sInWk[iLp]); // データ設定
                                bInFlg = true; // 検索エントリ登録要設定
                            }
                        }
                        break;
                    case 2: // データ種別
                        if (bFlag == true)
                        {  // 検索条件生成が有効な場合
                            if (sInWk[iLp].Length > 0)
                            {  // 入力が有る場合
                                csFieldName = HySCalResultDataQueryFieldNames.DATA_KIND; // データ種別
                                csDataType = typeof(HySObjectKind);               // データタイプ設定
                                csCompareMode = HySQueryCompareMode.EQUALS;       // 一致設定
                                csValueToCompare = new HySObjectKind(sInWk[iLp]); // データ設定
                                bInFlg = true; // 検索エントリ登録要設定
                            }
                        }
                        break;
                    case 6: // 件名
                        if (bFlag == true)
                        {  // 検索条件生成が有効な場合
                            if (sInWk[iLp].Length > 0)
                            {  // 入力が有る場合
                                csFieldName = HySCalResultDataQueryFieldNames.MODEL_SUBJECT; // フィールド名設定
                                csDataType = typeof(HySString);               // データタイプ設定
                                csCompareMode = HySQueryCompareMode.EQUALS;   // 一致設定
                                csValueToCompare = new HySString(sInWk[iLp]); // データ設定
                                bInFlg = true; // 検索エントリ登録要設定
                            }
                        }
                        break;
                    case 7: // ケース名
                        if (bFlag == true)
                        {  // 検索条件生成が有効な場合
                            if (sInWk[iLp].Length > 0)
                            {  // 入力が有る場合
                                csFieldName = HySCalResultDataQueryFieldNames.MODEL_SITUATION; // フィールド名設定
                                csDataType = typeof(HySString);               // データタイプ設定
                                csCompareMode = HySQueryCompareMode.EQUALS;   // 一致設定
                                csValueToCompare = new HySString(sInWk[iLp]); // データ設定
                                bInFlg = true; // 検索エントリ登録要設定
                            }
                        }
                        break;
                    case 8: // 対象
                        if (bFlag == true)
                        {  // 検索条件生成が有効な場合
                            if (sInWk[iLp].Length > 0)
                            {  // 入力が有る場合
                                csFieldName = HySCalResultDataQueryFieldNames.MODEL_TARGET; // フィールド名設定
                                csDataType = typeof(HySString);               // データタイプ設定
                                csCompareMode = HySQueryCompareMode.EQUALS;   // 一致設定
                                csValueToCompare = new HySString(sInWk[iLp]); // データ設定
                                bInFlg = true; // 検索エントリ登録要設定
                            }
                        }
                        break;
                    case 9: // モデル名
                        if (bFlag == true)
                        {  // 検索条件生成が有効な場合
                            if (sInWk[iLp].Length > 0)
                            {  // 入力が有る場合
                                csFieldName = HySCalResultDataQueryFieldNames.MODEL_CALC_TYPE; // フィールド名設定
                                csDataType = typeof(HySString);               // データタイプ設定
                                csCompareMode = HySQueryCompareMode.EQUALS;   // 一致設定
                                csValueToCompare = new HySString(sInWk[iLp]); // データ設定
                                bInFlg = true; // 検索エントリ登録要設定
                            }
                        }
                        break;
                    case 10: // 種別
                        if (bFlag == true)
                        {  // 検索条件生成が有効な場合
                            if (sInWk[iLp].Length > 0)
                            {  // 入力が有る場合
                                csFieldName = HySCalResultDataQueryFieldNames.MODEL_TYPE; // フィールド名設定
                                csDataType = typeof(HySString);               // データタイプ設定
                                csCompareMode = HySQueryCompareMode.EQUALS;   // 一致設定
                                csValueToCompare = new HySString(sInWk[iLp]); // データ設定
                                bInFlg = true; // 検索エントリ登録要設定
                            }
                        }
                        break;
                    case 11: // 管理者
                        if (bFlag == true)
                        {  // 検索条件生成が有効な場合
                            if (sInWk[iLp].Length > 0)
                            {  // 入力が有る場合
                                csFieldName = HySCalResultDataQueryFieldNames.MANAGER_NAME; // フィールド名設定
                                csDataType = typeof(HySString);               // データタイプ設定
                                csCompareMode = HySQueryCompareMode.EQUALS;   // 一致設定
                                csValueToCompare = new HySString(sInWk[iLp]); // データ設定
                                bInFlg = true; // 検索エントリ登録要設定
                            }
                        }
                        break;
                    case 12: // 要素ＩＤ
                        if (bFlag == true)
                        {  // 検索条件生成が有効な場合
                            if (sInWk[iLp].Length > 0)
                            {  // 入力が有る場合
                                csFieldName = HySCalResultDataQueryFieldNames.ELEMENT_ID; // フィールド名設定
                                csDataType = typeof(HySID);                 // データタイプ設定
                                csCompareMode = HySQueryCompareMode.EQUALS; // 一致設定
                                csValueToCompare = new HySID(sInWk[iLp]);   // データ設定
                                bInFlg = true; // 検索エントリ登録要設定
                            }
                        }
                        break;
                    case 13: // 最大検索数
                        if (bFlag == true)
                        {  // 検索条件生成が有効な場合
                            if (sInWk[iLp].Length > 0)
                            {  // 入力が有る場合
                                m_csQueryCtlData.SetLimitOfSearchResults(int.Parse(sInWk[iLp]));
                            }
                        }
                        break;
                    case 14: // 検索データタイプ
                        if (bFlag == true)
                        {  // 検索条件生成が有効な場合
                            if (sInWk[iLp].Length > 0)
                            {  // 入力が有る場合
                                csFieldName = HySCalResultDataQueryFieldNames.DATA_TYPE; // フィールド名設定
                                csDataType = typeof(HySObjectKind);               // データタイプ設定
                                csCompareMode = HySQueryCompareMode.EQUALS;       // 一致設定
                                csValueToCompare = new HySObjectKind(sInWk[iLp]); // データ設定
                                bInFlg = true; // 検索エントリ登録要設定
                            }
                        }
                        break;
                    case 15: // データ次元１
                        if (bFlag == true)
                        {  // 検索条件生成が有効な場合
                            if (sInWk[iLp].Length > 0)
                            {  // 入力が有る場合
                                string sDim1 = sInWk[iLp];
                                csFieldName = HySCalResultDataQueryFieldNames.DATA_DIM1; // フィールド名設定
                                csDataType = typeof(HySLong); // データタイプ設定
                                if (sDim1.Contains("!") == true)
                                {  // 否定コードが有る場合
                                    csCompareMode = HySQueryCompareMode.NOT; // 否定設定
                                    sDim1 = sDim1.Replace("!", ""); // 否定コードの削除
                                }
                                else
                                {  // 否定コードが無い場合
                                    csCompareMode = HySQueryCompareMode.EQUALS; // 一致設定
                                }
                                csValueToCompare = new HySLong(long.Parse(sDim1)); // データ設定
                                bInFlg = true; // 検索エントリ登録要設定
                            }
                        }
                        break;
                    case 16: // データ次元２
                        if (bFlag == true)
                        {  // 検索条件生成が有効な場合
                            if (sInWk[iLp].Length > 0)
                            {  // 入力が有る場合
                                csFieldName = HySCalResultDataQueryFieldNames.DATA_DIM2; // フィールド名設定
                                csDataType = typeof(HySLong);                     // データタイプ設定
                                csCompareMode = HySQueryCompareMode.EQUALS;       // 一致設定
                                csValueToCompare = new HySLong(long.Parse(sInWk[iLp])); // データ設定
                                bInFlg = true; // 検索エントリ登録要設定
                            }
                        }
                        break;
                    case 17: // データ次元３
                        if (bFlag == true)
                        {  // 検索条件生成が有効な場合
                            if (sInWk[iLp].Length > 0)
                            {  // 入力が有る場合
                                csFieldName = HySCalResultDataQueryFieldNames.DATA_DIM3; // フィールド名設定
                                csDataType = typeof(HySLong);                     // データタイプ設定
                                csCompareMode = HySQueryCompareMode.EQUALS;       // 一致設定
                                csValueToCompare = new HySLong(long.Parse(sInWk[iLp])); // データ設定
                                bInFlg = true; // 検索エントリ登録要設定
                            }
                        }
                        break;
                    default:
                        break;
                }
                if (bFlag == false)
                {  // 検索種別が一致しなかった場合
                    break;
                }
                else
                {  // 検索種別が一致した場合
                    if (bInFlg == true)
                    {  // エントリフィールド登録要の場合
                        // データ検索条件エントリクラス生成
                        HySQueryEntryData csQueryEntryData = new HySQueryEntryData();
                        csQueryEntryData.SetFieldName(csFieldName.Clone());   // 検索対象フィールド名設定
                        csQueryEntryData.SetDataType(csDataType);             // フィールドのデータ型設定
                        csQueryEntryData.SetCompareMode(csCompareMode);       // 比較モード列挙体設定
                        csQueryEntryData.SetValueToCompare(csValueToCompare); // 比較対象の値設定
                        m_csQueryCtlData.SetQueryEntryData(csQueryEntryData); // 検索条件エントリを登録
                        bInFlg = false;
                    }
                }
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>演算結果データ検索条件エントリクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>CreateCalcResultDtaQuery(csDataID)</para>
        /// </example>
        /// <param name="csDataID">検索データＩＤ一覧</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CreateCalcResultDtaQuery(HySDataLinkedList csDataID)
        {
            m_lSubEventNo = HySLibraryMngDefine.DB_QUERY_DATA_LIST_BY_ID; // サブイベント番号（複数データ一括取得）
            m_csDataID = HySLibraryMngDefine.DB_KIND_CALC_RESULT_DATA;    // 第２付属識別子（データ種別） 
            m_csToSimKind = HySDefine.SIMULATOR_KIND;                     // 送信先シミュレーション種別識別子
            m_csDataIDList = csDataID;
        }
        /// <summary><para>method outline:</para>
        /// <para>演算ロット情報一覧検索条件エントリクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>CreateCalcLotInfoListQuery(csQueryEntryData)</para>
        /// </example>
        /// <param name="csQueryEntryData">検索エントリデータ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CreateCalcLotInfoListQuery(HySQueryEntryData csQueryEntryData)
        {
            m_csQueryCtlData.SetIsMetaDataOnly(true);               // メタデータのみ取得を設定
            m_csQueryCtlData.SetQueryEntryData(csQueryEntryData);   // 検索条件エントリを登録
            m_lSubEventNo = HySLibraryMngDefine.DB_QUERY_DATA_LIST; // サブイベント番号（検索種別）
            m_csDataID = HySLibraryMngDefine.DB_KIND_CALC_LOT_INFO; // 第２付属識別子（データ種別） 
            m_csToSimKind = HySDefine.SIMULATOR_KIND;               // 送信先シミュレーション種別識別子
        }
        /// <summary><para>method outline:</para>
        /// <para>演算ロット情報更新条件エントリクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>CreateCalcLotInfoUpdateQuery(csUpdateSpec)</para>
        /// </example>
        /// <param name="csUpdateSpec">検索データＩＤ一覧</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CreateCalcLotInfoUpdateQuery(HySDBPartialUpdateSpec csUpdateSpec)
        {
            m_lSubEventNo = HySLibraryMngDefine.DB_REGISTER_DATA_UPDATE_PARTIAL; // サブイベント番号（部分更新）
            m_csDataID = HySLibraryMngDefine.DB_KIND_CALC_LOT_INFO;       // 第２付属識別子（データ種別） 
            m_csToSimKind = HySDefine.SIMULATOR_KIND;                     // 送信先シミュレーション種別識別子
            m_csUpdateSpec = csUpdateSpec;                                // 部分更新情報
        }

        /// <summary><para>method outline:</para>
        /// <para>データＩＤ検索条件リスト取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDataLinkedList csDataID = GetDtatIDList()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataLinkedList データＩＤ検索条件リスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDataLinkedList GetDtatIDList()
        {
            return m_csDataIDList;
        }

        /// <summary><para>method outline:</para>
        /// <para>部分更新指定リスト取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDBPartialUpdateSpec csUpdateSpec = GetUpdateSpec()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDBPartialUpdateSpec 部分更新情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDBPartialUpdateSpec GetUpdateSpec()
        {
            return m_csUpdateSpec;
        }

        /// <summary><para>method outline:</para>
        /// <para>検索エントリ登録</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetQueryEntryData(csQueryEntryData)</para>
        /// </example>
        /// <param name="csQueryEntryData">データ検索条件エントリクラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetQueryEntryData(HySQueryEntryData csQueryEntryData)
        {
            m_csQueryCtlData.SetQueryEntryData(csQueryEntryData); // 検索条件エントリを登録
        }

        /// <summary><para>method outline:</para>
        /// <para>データ検索条件クラス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySQueryCtlData csQueryCtlData = GetQueryCtlData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySQueryCtlData データ検索条件クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySQueryCtlData GetQueryCtlData()
        {
            return m_csQueryCtlData;
        }

        /// <summary><para>method outline:</para>
        /// <para>リトライ回数更新</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = UpRetryCount()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>bool リトライ可否(=true:可、=false:否)</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool UpRetryCount()
        {
            if ((m_lRetryCount + 1) >= 2)
            {  // リトライオーバの場合
                m_lRetryCount = 2;
                return false;
            }
            else
            {  // リトライ可の場合
                m_lRetryCount++; // リトライカウンタ更新
                return true;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>検索条件取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySString csQueryCondition = GetQueryCondition()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString 検索条件</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySString GetQueryCondition()
        {
            return m_csQueryCondition.Clone();
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                if (GetDecodedVersion() == null)
                {
                    // 旧バージョンからの移行処理を入れる
                }
                else
                {
                    //旧バージョンから順にバージョンを上げて行く
                    switch (GetDecodedVersion())
                    {
                        case "1.00":
                            {
                                // 旧バージョンからの移行処理を入れる
                                break;
                            }
                        //case "2.00": << 以後バージョンアップに伴って処理追加
                        //{
                        //    break;
                        //}
                    }
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
