﻿using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.CoreImpl.HSBusiProc
{
    /// <summary><para>class outline:</para>
    /// <para>評価グラフ表示用定義情報クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/12/01][新規作成]</para>
    /// </remarks>
    public class HySEvGrphDefine
    {
        // ===========================
        // 種別識別子関係
        // ===========================
        /// <summary>業務種別識別子：システム内でユニークな値としてください</summary>
        static public readonly HySKind HYSDOTNETLINEGRAPH_BUSINESS_KIND = new HySObjectKind("CommonEvaluationBusiProcedure");//("HsAddin.McGraphViewBusiProc");
        /// <summary>画面ファクトリーID：システム内でユニークな値としてください</summary>
        static public readonly HySIdentifier HYSDOTNETLINEGRAPH_FACTORY_ID_SCREEN = new HySID("HySEvViewScreenFactory");//("HsAddin.McGraphView.Factory.Screen");
        /// <summary>ビューア内処理ファクトリー：システム内でユニークな値としてください</summary>
        static public readonly HySIdentifier HYSDOTNETLINEGRAPH_FACTORY_ID_VIEWRJOB = new HySID("HySEvViewViewerJobFactory");//("HsAddin.McGraphView.Factory.ViewerJob");


        // ===========================
        // 画面識別子関係
        // ===========================
        /// <summary>プロジェクト管理画面：本業務内でユニークな値としてください</summary>
        static public readonly HySKind HYSDOTNETLINEGRAPH_SCREEN = new HySObjectKind("HySDotNetLineGraphScreen");
        // ToDo 画面のIDを追加（画面数分）


        // ===========================
        // メニューコールバック番号定義関係
        // ===========================
        /// <summary>何らかの処理：本業務内でユニークな値としてください</summary>
        static public readonly long HYSDOTNETLINEGRAPH_DO_SOMETHING = 1;
        /// <summary>サンプル画面表示開始：本業務内でユニークな値としてください</summary>
        static public readonly long HYSDOTNETLINEGRAPH_DISP_SCREEN = 60306;//[2010.12.07]変更10→60306
        // ToDo メニューからのコールバック番号を追加定義（メニュー数分）

        // Ver1.2 追加 >>>
        // ===========================
        // サブイベント番号定義関係
        // ===========================
        /// <summary>画面設定保存指示</summary>
        static public readonly long CMND_DISPINFO_SAVE = -999430;
        /// <summary>画面設定復元指示</summary>
        static public readonly long CMND_DISPINFO_RESTORE = -999431;
        // Ver1.2 追加 <<<

        /*
        // ===========================
        // グラフ設定
        // ===========================
        /// <summary>欠損値</summary>
        static public readonly float g_InvalidValue = -9999;
        /// <summary>欠損値2</summary>
        static public readonly float g_InvalidValue2 = -9998;  //[2010.06.01]
        /// <summary>右軸（棒）最大値</summary>
        public float g_Rainfall_MaxY = g_InvalidValue;
        /// <summary>右軸（棒）最小値</summary>
        public float g_Rainfall_MinY = g_InvalidValue;

        /// <summary>左軸最大値</summary>
        public float g_WaterLevel_MaxY = g_InvalidValue;
        /// <summary>左軸最小値</summary>
        public float g_WaterLevel_MinY = g_InvalidValue;

        /// <summary>右軸（折）最大値</summary>
        public float g_FlowMeter_MaxY = g_InvalidValue;
        /// <summary>右軸（折）最小値</summary>
        public float g_FlowMeter_MinY = g_InvalidValue;

        /// <summary>線</summary>
        static public Boolean g_IsLine = true;
        /// <summary>ポイント</summary>
        static public  Boolean g_IsPoint = true;
        /// <summary>状態の保存</summary>
        public bool g_bAutoStatus = true;
        /// <summary>Y軸範囲設定</summary>
        public bool g_bAutoBounds = true;
        /// <summary>左軸ラベル</summary>
        public string g_sLeftLabel = "左軸";
        /// <summary>右軸ラベル</summary>
        public string g_sRightlabel = "右軸";
        */
    }
}
