﻿// <summary>ソースコード：システム共通業務処理クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSBusiProc;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.CoreImpl.HSBusiProc
{
    internal class HySSysBusiProcedure  : HySBusiProcedure
    {
        /// <summary>シミュレーター種別識別子</summary>
        protected HySKind m_csSimKindID = HySDefine.COMMON_SYS_BUSIPROCEDURE;
        /// <summary>業務管理制御クラス</summary>
        protected HySControllerRoot m_csController = null;
        /// <summary>業務動作中フラグ</summary>
        protected bool m_bWorkFlg = false;

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> 使用禁止</para>
        /// </example>
        /// <param name=""></param>
        /// <returns>HySSysBusiProcedure 生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private HySSysBusiProcedure()
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySBusiProcedure cdBusiProc = new HySSysBusiProcedure(csController)</para>
        /// </example>
        /// <param name="csController">業務管理制御クラス</param>
        /// <returns>HySSysBusiProcedure 生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySSysBusiProcedure(HySControllerRoot csController)
        {
            m_csController = csController;
        }

        // === シミュレーター種別識別子 ===
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetSimKind(HySKind csSimKindID)
        {
            // Do Nothing
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySKind シミュレーター種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySKind GetSimKind()
        {
            return m_csSimKindID;
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = HySBusiProcedure.EqualSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>Boolean true:同じ、false:異なる</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Boolean EqualSimKind(HySKind csSimKindID)
        {
            return m_csSimKindID.Equals(csSimKindID);
        }

        // === 各種設定 ===
        /// <summary><para>method outline:</para>
        /// <para>制御クラスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySSysUnit.SetController( csCtl ) </para>
        /// </example>
        /// <param name="csCtl">制御クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetController(HySControllerRoot csCtl)
        {
            m_csController = csCtl;
        }

        // === 初期化／終了 ===
        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>Boolean 常にtrue</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Boolean Initialize()
        {
            m_bWorkFlg = true;
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>Boolean 常にtrue</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Boolean Terminate()
        {
            m_bWorkFlg = false;
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>システム終了準備完了判別</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = ExitOK( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>Boolean true:システムExit準備OK　、false:システムExit準備NG</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Boolean ExitOK()
        {
            if (m_bWorkFlg == true)
            { return false; }
            else
            { return true; }
        }

        // === 動作 ===
        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>Boolean true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Boolean EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = true;

            long lEventNo = ((HySEventObject)csEvent).GetEventNo();
            long lSubEventNo = ((HySEventObject)csEvent).GetSubEventNo();

            if (lEventNo == HySEventObject.CMND_SHUTDOWN_SYSTEM)
            {
                csEvent.SetTo(HySSysEvent.OBJID_SYSCONTROLLER); // 宛先をシステム制御に変更
                bRtn = this.PutEvent(csEvent);
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを送る</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySSysUnit.PutEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <returns>Boolean true:正常, false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>自分からイベントを送信する時に使用する</para>
        /// </remarks>
        public Boolean PutEvent(HySSysEvent csEvent)
        {
            return m_csController.PutEvent(csEvent);
        }
        /// <summary><para>method outline:</para>
        /// <para>ファクトリー管理クラスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetFactoryMng( csFactoryMng ) </para>
        /// </example>
        /// <param name="csFactoryMng">ファクトリー管理クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetFactoryMng(HySFactoryMng csFactoryMng)
        {
            // Do Nothing
        }
        //
    }
}
