﻿// <summary>ソースコード：定義データ処理クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Xml;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSController;

namespace CommonMP.HYSSOP.CoreImpl.HSController.DIContainer
{
    /// <summary><para>class outline:</para>
    /// <para>定義データ処理クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class HySConfigDataHandler
    {
        /// <summary> XMLタグ　kind </summary>
        static public readonly string xml_KIND = "kind";
        /// <summary> XMLタグ　package </summary>
        static public readonly string xml_PACKAGE = "package";
        /// <summary> XMLタグ　class </summary>
        static public readonly string xml_CLASS = "class";
        /// <summary> XMLタグ　dll </summary>
        static public readonly string xml_DLL = "dll";

        /// <summary> 定義データ</summary>
        private HySConfigData m_csConfigData;

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySConfigDataHandler csHandler = new HySConfigDataHandler(csConfigData)</para>
        /// </example>
        /// <param name="csConfigData">定義データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySConfigDataHandler(HySConfigData csConfigData)
        {
            m_csConfigData = csConfigData;
        }

        /// <summary><para>method outline:</para>
        /// <para>読み込み情報解析</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Parser(csXmlReader)</para>
        /// </example>
        /// <param name="csXmlReader">読込み情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void Parser(HySXmlReader csXmlReader)
        {
            HySXmlNode csRootNode;
            HySXmlNodeList csNodeList;
            HySXmlNode csNode;
            long lNodeListCount;
            long lLoop;
            csRootNode = csXmlReader.GetRootNode();
            csNodeList = csRootNode.GetChildNodeList();
            lNodeListCount = csNodeList.GetCount();
            for (lLoop = 0; lLoop < lNodeListCount; lLoop++)
            {
                csNode = csNodeList.GetNode(lLoop);
                if (csNode.GetXmlNode().NodeType != XmlNodeType.Comment)
                {
                    HySAttributesImpl csAttributes = new HySAttributesImpl();
                    // kind属性
                    csAttributes.AddAttribute(xml_KIND, csNode.GetAttribute(xml_KIND));
                    // package属性
                    csAttributes.AddAttribute(xml_PACKAGE, csNode.GetAttribute(xml_PACKAGE));
                    // dll属性
                    csAttributes.AddAttribute(xml_DLL, csNode.GetAttribute(xml_DLL));
                    // class属性
                    csAttributes.AddAttribute(xml_CLASS, csNode.GetAttribute(xml_CLASS));
                    // 属性情報追加
                    AddConfigData(csAttributes);
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>定義データ編集</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>AddConfigData(csAttributes)</para>
        /// </example>
        /// <param name="csAttributes">定義データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void AddConfigData(HySAttributesImpl csAttributes)
        {
            String csKey;
            String csKind;
            String csPackage;
            String csClassName;
            String csDllName;

            csKind = csAttributes["kind"];
            csClassName = csAttributes["class"];
            csDllName = csAttributes["dll"];
            csPackage = csAttributes["package"];
            // キーをパッケージ＋クラス名称＋ＤＬＬ名称とする。
            csKey = csPackage + "_" + csClassName + "_" + csDllName;

            if ((csClassName != null) &&
                (csDllName != null) &&
                (csPackage != null))
            {
                m_csConfigData.AddConfigData(csKey, csKind, csPackage, csClassName, csDllName);
            }

        }
    }
}
