﻿// <summary>ソースコード：定義データ管理クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Reflection;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSController;

namespace CommonMP.HYSSOP.CoreImpl.HSController.DIContainer
{
    /// <summary><para>class outline:</para>
    /// <para>定義データ管理クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class HySConfigDataManager
    {
        /// <summary>定義データ</summary>
        private HySConfigData m_csConfigData;

        /// <summary>定義データ読込み処理 </summary>
        private HySConfigDataReader m_csDataReader;

        /// <summary>定義データ作成処理</summary>
        private HySConfigDataMaker m_csDataMaker;

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySConfigDataManager csManager = new HySConfigDataManager(csReader,csMaker)</para>
        /// </example>
        /// <param name="csReader">定義データ読込み処理</param>
        /// <param name="csMaker">定義データ作成処理</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySConfigDataManager(HySConfigDataReader csReader, HySConfigDataMaker csMaker)
        {
            m_csDataReader = csReader;
            m_csDataMaker = csMaker;
        }

        /// <summary><para>method outline:</para>
        /// <para>定義データ読込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySConfigDataManager.ConfigDataLoad( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>定義データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void ConfigDataLoad()
        {
            m_csConfigData = m_csDataReader.ConfigDataLoad();
        }

        /// <summary><para>method outline:</para>
        /// <para>全ファクトリクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>CreateFactoryClassAll( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>定義データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void CreateFactoryClassAll()
        {
            m_csDataMaker.MakeFactoryClass(m_csConfigData);
        }

        /// <summary><para>method outline:</para>
        /// <para>クラス生成可否チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Boolean bRtn = CanCreateClass( csCreateClass,csFactoryClass )</para>
        /// </example>
        /// <param name="csCreateClass">生成クラス</param>
        /// <param name="csFactoryClass">ファクトリクラス</param>
        /// <returns>true : 可、false : 不可</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Boolean CanCreateClass(HySString csCreateClass, HySString csFactoryClass)
        {
            Boolean bRtn = false;
            Assembly csAssembly = null;
            Module csModule = null;
            Type csType = null;
            String csKey;
            String csDllName;
            String csPackageName;
            String csClassName;

            csKey = csFactoryClass.ToString();
            csDllName = m_csConfigData.GetFactoryDll(csKey);
            csPackageName = m_csConfigData.GetFactoryPackage(csKey);
            csClassName = csCreateClass.ToString();
            if (File.Exists(csDllName))
            {
                csAssembly = Assembly.LoadFrom(@csDllName);
                csModule = csAssembly.GetModule(csDllName);
                csType = csModule.GetType(csPackageName + "." + csClassName);
                if (csType != null)
                {
                    bRtn = true;
                }
            }
            return bRtn;
        }
    }
}
