﻿// <summary>ソースコード：定義データ読込み管理ファクトリ</summary>
// <author>CommonMP</author>

using System;
using System.IO;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;

namespace CommonMP.HYSSOP.CoreImpl.HSController.DIContainer
{
    /// <summary><para>class outline:</para>
    /// <para>定義データ読込み管理ファクトリ</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class HySConfigDataReaderFactory
    {
        /// <summary>ファイルタイプ：ｃｓｖ</summary>
        private static HySString FILETYPE_CSV = new HySString("csv");

        /// <summary>ファイルタイプ：ｘｍｌ</summary>
        private static HySString FILETYPE_XML = new HySString("xml");

        /// <summary>ファイルパス</summary>
        private static HySString DATA_PATH = new HySString("\\conf\\");

        /// <summary><para>method outline:</para>
        /// <para>定義データリーダ処理生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySConfigDataReader csReader = CreateInstanse( csFileName )</para>
        /// </example>
        /// <param name="csFileName">定義データファイル名称</param>
        /// <returns>定義データリーダ処理</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static HySConfigDataReader CreateInstanse(HySString csFileName)
        {
            HySString csDataPath = null;

            HySString csFileType = null;
            csDataPath = HySEnvInf.GetHomeDirectory() + DATA_PATH;

            // diconファイル種別
            csFileType = HySEnvInf.GetEnvInf(new HySString("DICON_FILETYPE"));

            if (FILETYPE_XML.Equal(csFileType) == true)
            {
                // ファイルタイプがＸＭＬの場合
                return (HySConfigDataReader)new HySXmlFileConfigDataReader(csDataPath, csFileName);
            }
            else if (FILETYPE_CSV.Equal(csFileType) == true)
            {
                // ファイルタイプがＣＳＶの場合
                return (HySConfigDataReader)new HySCsvFileConfigDataReader(csDataPath, csFileName);
            }
            else
            {
                throw new NotSupportedException(
                    "未知の形式です" + csFileType);
            }
        }
    }
}
