﻿// <summary>ソースコード：ＣＳＶファイル情報読込み</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.IO;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSController;

namespace CommonMP.HYSSOP.CoreImpl.HSController.DIContainer
{
    /// <summary><para>class outline:</para>
    /// <para>ＣＳＶファイル情報読込み</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class HySCsvFileConfigDataReader : HySConfigDataReader
    {
        /// <summary>ファイル名称</summary>
        private String m_csFileName;

        /// <summary>ファイルパス</summary>
        private String m_csDataPath;

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySCsvFileConfigDataReader csReader = new HySCsvFileConfigDataReader(csDataPath,csFileName)</para>
        /// </example>
        /// <param name="csDataPath">ファイルパス</param>
        /// <param name="csFileName">ファイル名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySCsvFileConfigDataReader(HySString csDataPath, HySString csFileName)
        {
            m_csDataPath = csDataPath.ToString();
            m_csFileName = csFileName.ToString();
        }

        /// <summary><para>method outline:</para>
        /// <para>定義データ読込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySConfigData csData = ConfigDataLoad( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>定義データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySConfigData ConfigDataLoad()
        {
            // データパス、ファイル名称は環境定義管理クラスより

            HySConfigData csResult = new HySConfigData();
            StreamReader csReader = null;
            try
            {
                csReader = new StreamReader(m_csDataPath + m_csFileName, Encoding.GetEncoding("Shift_JIS"));
                String csLine;
                while (HasValue(csLine = csReader.ReadLine()))
                {
                    ReadFromList(csResult,csLine);
                }
            }
            catch (FileNotFoundException Exp)
            {
                //Console.WriteLine(Exp.ToString());
                HySLog.LogOut(HySLog.TRIAL_RUN, m_csFileName + "==>" + Exp.ToString());
            }
            catch (IOException Exp)
            {
                //Console.WriteLine(Exp.ToString());
                HySLog.LogOut(HySLog.TRIAL_RUN, m_csFileName + "==>" + Exp.ToString());
            }
            finally
            {
                if (csReader != null)
                    csReader.Close();
            }
            return csResult;
        }

        /// <summary><para>method outline:</para>
        /// <para>読み込み情報編集</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ReadFromList( csConfigData,csLineList )</para>
        /// </example>
        /// <param name="csConfigData">定義データ</param>
        /// <param name="csLineList">読み込み情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ReadFromList(HySConfigData csConfigData, String csLineList)
        {
            String[] csSplitData;
            csSplitData = csLineList.Split(',');
            long lCount = 0;
            String csKey = null;
            String csKind = null;
            String csPackage = null;
            String csClassName = null;
            String csDllName = null;
            if (csLineList[0] != '#')
            {
                foreach (String csStr in csSplitData)
                {
                    switch (lCount)
                    {
                        case 0:
                            csKind = csStr;
                            break;
                        case 1:
                            csPackage = csStr;
                            break;
                        case 2:
                            csClassName = csStr;
                            csKey = csStr;
                            break;
                        case 3:
                            csDllName = csStr;
                            break;
                        default:
                            break;
                    }
                    lCount++;
                }
                // キーをパッケージ＋クラス名称＋ＤＬＬ名称とする。
                csKey = csPackage + "_" + csClassName + "_" + csDllName;
                csConfigData.AddConfigData(csKey, csKind, csPackage, csClassName, csDllName);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>データ有無判定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Boolean bRtn = HasValue( csConfigData,csLineList )</para>
        /// </example>
        /// <param name="csStr">文字列</param>
        /// <returns>true  : 有り、false : 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private Boolean HasValue(String csStr)
        {
            return (csStr != null) && (csStr.Length > 0);
        }
    }
}
