﻿// <summary>ソースコード：ＤＩコンテナ基底クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;

namespace CommonMP.HYSSOP.CoreImpl.HSController.DIContainer
{
    /// <summary><para>class outline:</para>
    /// <para>ＤＩコンテナ基底クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    abstract public class HySDIContainerImpl : HySDIContainer
    {
        /// <summary><para>method outline:</para>
        /// <para>定義データ管理クラス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySConfigDataManager csManager = HySDIContainerImpl.GetConfigDataManager(csFactoryMng)</para>
        /// </example>
        /// <param name="csFactoryMng">ファクトリ管理クラス</param>
        /// <returns>定義データ管理クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        abstract public HySConfigDataManager GetConfigDataManager(HySFactoryManager csFactoryMng);
    }
}
