﻿// <summary>ソースコード：ＨＹＳＳＯＰ ＤＩコンテナクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;

namespace CommonMP.HYSSOP.CoreImpl.HSController.DIContainer
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＳＳＯＰ ＤＩコンテナクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class HySSystemDIContainer : HySDIContainerImpl
    {
        /// <summary>定義データファイル名称</summary>
        HySString m_csFileName;
        
        //// <summary>定義データファイル定義名称</summary>
        //HySString m_csDiconFileDefName;

        /// <summary><para>method outline:</para>
        /// <para>定義データ管理クラス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySConfigDataManager csManager = GetConfigDataManager(csFactoryMng)</para>
        /// </example>
        /// <param name="csFactoryMng">ファクトリ管理クラス</param>
        /// <returns>定義データ管理クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySConfigDataManager GetConfigDataManager(HySFactoryManager csFactoryMng)
        {
            // 環境ファイルより取得
            m_csFileName = HySEnvInf.GetEnvInf(new HySString("HYSSYSTEMDICON"));
            //m_csFileName = HySEnvInf.GetEnvInf(m_csDiconFileDefName);

            HySConfigDataReader csDataReader = HySConfigDataReaderFactory.CreateInstanse(m_csFileName);

            HySConfigDataMaker csDataMaker = new HySConfigDataMaker(csFactoryMng);

            HySConfigDataManager csManager = new HySConfigDataManager(csDataReader, csDataMaker);

            return csManager;
        }
        /*
        /// <summary><para>method outline:</para>
        /// <para>定義データ管理クラス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetDiconFileDefName(csName)</para>
        /// </example>
        /// <param name="csName">定義データファイル定義名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetDiconFileDefName(HySString csName)
        {
            m_csDiconFileDefName = csName;
        }
        */
    }
}
