﻿// <summary>ソースコード：ＸＭＬファイル情報読込み</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Xml;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSController;

namespace CommonMP.HYSSOP.CoreImpl.HSController.DIContainer
{
    /// <summary><para>class outline:</para>
    /// <para>ＸＭＬファイル情報読込み</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class HySXmlFileConfigDataReader : HySConfigDataReader
    {
        /// <summary>ＤＩコンテナ定義ファイル名称</summary>
        private String m_csFileName;

        /// <summary>ファイルパス</summary>
        private String m_csDataPath;

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySXmlFileConfigDataReader csReader = new HySXmlFileConfigDataReader(csDataPath,csFileName)</para>
        /// </example>
        /// <param name="csDataPath">ファイルパス</param>
        /// <param name="csFileName">ファイル名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySXmlFileConfigDataReader(HySString csDataPath, HySString csFileName)
        {
            m_csDataPath = csDataPath.ToString();
            m_csFileName = csFileName.ToString();
        }

        /// <summary><para>method outline:</para>
        /// <para>定義データ読込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySConfigData csData = ConfigDataLoad( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>定義データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySConfigData ConfigDataLoad()
        {
            HySXmlReader csXmlReader = null;
            HySConfigData csResult = null;
            HySString csFullPath = new HySString(m_csDataPath) + new HySString(m_csFileName);
            HySConfigDataHandler csHandler = null;
            HySFile csFile = new HySFile(csFullPath);
            if (csFile.Exist() == true)
            {
                // 定義データの読み込み＆解析
                csXmlReader = new HySXmlReader(csFullPath);
                csResult = new HySConfigData();
                csHandler = new HySConfigDataHandler(csResult);
                csHandler.Parser(csXmlReader);
            }
            return csResult;
        }
    }
}
