﻿// <summary>ソースコード：属性情報クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSController;

namespace CommonMP.HYSSOP.CoreImpl.HSController.DIContainer
{
    /// <summary><para>class outline:</para>
    /// <para>属性情報クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class HySAttributesImpl : HySRoot
    {
        /// <summary>属性データ</summary>
        private readonly Hashtable m_csValues = new Hashtable();

        /// <summary>属性データキー</summary>
        private readonly IList m_csQNames = new ArrayList();

        /// <summary><para>method outline:</para>
        /// <para>属性情報追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>AddAttribute(csQName,csValue)</para>
        /// </example>
        /// <param name="csQName">属性データキー</param>
        /// <param name="csValue">属性データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void AddAttribute(string csQName, string csValue)
        {
            m_csQNames.Add(csQName);
            m_csValues[csQName] = csValue;
        }

        /// <summary><para>method outline:</para>
        /// <para>キー指定属性データ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>String csKind = HySAttributesImpl[ csQName ]</para>
        /// </example>
        /// <param name="csQName">属性データキー</param>
        /// <returns>属性データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string this[string csQName]
        {
            get
            {
                return (string)m_csValues[csQName];
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>キー位置指定属性データ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>String csKind = HySAttributesImpl[ lIndex ]</para>
        /// </example>
        /// <param name="lIndex">キー位置</param>
        /// <returns>属性データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string this[long lIndex]
        {
            get
            {
                return (string)m_csValues[(String)m_csQNames[(int)lIndex]];
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>属性データ数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lNum = Count( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>属性データ数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long Count
        {
            get
            {
                return m_csQNames.Count;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>キー位置指定属性データキー取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>String csKind = GetQName[ lIndex ]</para>
        /// </example>
        /// <param name="lIndex">キー位置</param>
        /// <returns>属性データキー</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetQName(long lIndex)
        {
            return (string)m_csQNames[(int)lIndex];
        }
    }
}
