﻿// <summary>ファクトリ管理クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.CoreImpl.HSController
{
    /// <summary><para>class outline:</para>
    /// <para>ファクトリ管理クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class HySFactoryManager : HySFactoryMng
    {
        /// <summary>ファクトリクラスリスト</summary>
        protected List<HySFactory> m_csFactoryList = new List<HySFactory>();

        /// <summary>スクリーンファクトリ集合体</summary>
        protected HySScreenFactorySet m_csScreenFactorySet = new HySScreenFactorySet();

        //// <summary>スクリーンファクトリ集合体</summary> <= HYMCO 側の概念を意識してはならない
        //protected HySFactorySet m_csPropertyScreenFactorySet = null;

        /// <summary>画面フォームファクトリ集合体</summary>
        protected HySViewFormFactorySet m_csViewFormFactorySet = new HySViewFormFactorySet();

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySFactoryManager csManager = new HySFactoryManager()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySFactoryManager()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>ファクトリ数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lFactoryNum =.GetFactoryNum( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ファクトリ数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetFactoryNum()
        {
            return (long)m_csFactoryList.Count;          
        }

        /// <summary><para>method outline:</para>
        /// <para>ファクトリクラス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySFactory csFactory =.GetFactory( lOrderNo ) </para>
        /// </example>
        /// <param name="lOrderNo">位置（０相対）</param>
        /// <returns>ファクトリクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySFactory GetFactory(long lOrderNo)
        {
            return m_csFactoryList[(int)lOrderNo];
        }
        /// <summary><para>method outline:</para>
        /// <para>キー指定ファクトリクラス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySFactory csFactory = HySFactoryManager.GetFactory(csKey)</para>
        /// </example>
        /// <param name="csKey">データ識別子</param>
        /// <returns>ファクトリクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySFactory GetFactory(HySIdentifier csKey)
        {
            HySFactory csResult = null;
            HySFactory csWorkFct;
            int iFctNo = m_csFactoryList.Count;
            for (int iLp = 0; iLp < iFctNo; iLp++)
            {
                csWorkFct = m_csFactoryList[iLp];
                if( csWorkFct != null )
                {
                    if( csWorkFct.EqualFactory(csKey) == true )
                    {
                        csResult = csWorkFct;
                        break;
                    }
                }
            }
            return csResult;
        }

        /// <summary><para>method outline:</para>
        /// <para>ファクトリクラス追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>AddFactory(csFactory)</para>
        /// </example>
        /// <param name="csFactory">ファクトリクラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void AddFactory(HySFactory csFactory)
        {
            m_csFactoryList.Add(csFactory);
        }

        /// <summary><para>method outline:</para>
        /// <para>スクリーンファクトリクラス追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>AddScreenFactory(csScreenFctry)</para>
        /// </example>
        /// <param name="csScreenFctry">スクリーンファクトリクラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void AddScreenFactory(HySScreenFactory csScreenFctry)
        {
            m_csScreenFactorySet.AddFactory(csScreenFctry);
        }

        /// <summary><para>method outline:</para>
        /// <para>スクリーンファクトリ集合体取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySScreenFactorySet csScrnSet = GetScreenFactorySet( ) </para>
        /// </example>
        /// <param name=""></param>
        /// <returns>スクリーンファクトリ集合体</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySScreenFactorySet GetScreenFactorySet()
        {   return m_csScreenFactorySet;   }

        /*
        /// <summary><para>method outline:</para>
        /// <para>プロパティスクリーンファクトリ集合体設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetPropertyScreenFactorySet(csScrnSet)</para>
        /// </example>
        /// <param name="csScrnSet">プロパティスクリーンファクトリ集合体</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetPropertyScreenFactorySet(HySFactorySet csScrnSet)
        {
            m_csPropertyScreenFactorySet = csScrnSet;
        }
        */

        /*
        /// <summary><para>method outline:</para>
        /// <para>プロパティスクリーンファクトリ集合体取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySScreenFactorySet csScrnSet = GetPropertyScreenFactorySet( ) </para>
        /// </example>
        /// <param name=""></param>
        /// <returns>スクリーンファクトリ集合体</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySFactorySet GetPropertyScreenFactorySet()
        { return (HySFactorySet)m_csPropertyScreenFactorySet; }
        */


        /// <summary><para>method outline:</para>
        /// <para>表示業務画面ファクトリ集合体取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDispFormFactorySet csScrnSet = GetDispFormFactorySet( ) </para>
        /// </example>
        /// <param name=""></param>
        /// <returns>HySDispFormFactorySet 表示業務画面ファクトリ集合体</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySViewFormFactorySet GetViewFormFactorySet()
        { return m_csViewFormFactorySet; }


        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ShutDown( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void ShutDown()
        {
            HySFactory csWorkFct;
            int iFctNo = m_csFactoryList.Count;
            for (int iLp = 0; iLp < iFctNo; iLp++)
            {
                csWorkFct = m_csFactoryList[iLp];
                if (csWorkFct != null)
                {
                    csWorkFct.Term();
                }
            }
            m_csScreenFactorySet.Term();
        }
    }
}
