﻿// <summary>ファクトリクラス集合体</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMP.HYSSOP.CoreImpl.HSController
{
    /// <summary><para>class outline:</para>
    /// <para>ファクトリクラス集合体</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public abstract class HySFactorySet : HySFactory
    {
        /// <summary>識別子</summary>
        protected HySID m_csDataID=null;

        /// <summary>ファクトリクラスリスト</summary>
        protected LinkedList<HySFactory> m_csFactoryList = new LinkedList<HySFactory>();
        /// <summary>ファクトリ管理クラス</summary>
        protected HySFactoryManager m_csFactoryMng = null;

        /// <summary><para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Init(csFactoryMng) </para>
        /// </example>
        /// <param name="csFactoryMng">ファクトリ管理</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void Init(HySFactoryMng csFactoryMng)
        {
            m_csFactoryMng = (HySFactoryManager)csFactoryMng;
        }
        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Term() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void Term()
        {
            HySFactory csFactory = null;


            LinkedListNode<HySFactory> csFactoryNode = m_csFactoryList.First;
            for (long lLoop = 0; lLoop < m_csFactoryList.Count; lLoop++)
            {
                csFactory = csFactoryNode.Value;
                csFactory.Term();
                csFactoryNode = csFactoryNode.Next;
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetFactoryID( csID ) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetFactoryID(HySIdentifier csID)
        {
            m_csDataID = (HySID)csID;
        }
        /// <summary><para>method outline:</para>
        /// <para>識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySIdentifier csID = GetFactoryID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySIdentifier GetFactoryID()
        {
            return (HySIdentifier)m_csDataID;
        }
        /// <summary><para>method outline:</para>
        /// <para>識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EqualFactory( csID ) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <returns>true  : ＝、false : ≠</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean EqualFactory(HySIdentifier csID)
        {
            return m_csDataID.Equals(csID);
        }

        /// <summary><para>method outline:</para>
        /// <para>スクリーンファクトリクラス追加</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> AddMcFactory( csFactory ) </para>
        /// </example>
        /// <param name="csFactory">データ識別子</param>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void AddFactory(HySFactory csFactory)
        {
            m_csFactoryList.AddLast(csFactory);
        }
        /// <summary><para>method outline:</para>
        /// <para>ファクトリクラス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySFactory csFactory = GetFactory( csFactoryID ) </para>
        /// </example>
        /// <param name="csFactoryID">データ識別子</param>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySFactory GetFactory(HySIdentifier csFactoryID)
        {
            HySFactory csFactory = null;
            HySFactory csResult = null;

            LinkedListNode<HySFactory> csFactoryNode = m_csFactoryList.First;
            for (long lLoop = 0; lLoop < m_csFactoryList.Count; lLoop++)
            {
                csFactory = csFactoryNode.Value;
                if (csFactory.EqualFactory(csFactoryID))
                {
                    csResult = csFactory;
                    break;
                }
                csFactoryNode = csFactoryNode.Next;
            }
            return csResult;
        }

        /// <summary><para>method outline:</para>
        /// <para>ファクトリクラス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySFactory csFactory = GetFactory( lOderNum ) </para>
        /// </example>
        /// <param name="lOderNum">リスト上の指定位置</param>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySFactory GetFactory(long lOderNum)
        {
            HySFactory csResult = null;
            if (lOderNum <= m_csFactoryList.Count)
            {
                LinkedListNode<HySFactory> csFactoryNode = m_csFactoryList.First;
                for (long lLoop = 0; lLoop <= lOderNum; lLoop++)
                {
                    csResult = csFactoryNode.Value;
                    csFactoryNode = csFactoryNode.Next;
                }
            }
            return csResult;
        }
        /// <summary><para>method outline:</para>
        /// <para>内部のファクトリクラス数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lNum = GetFactoryNum( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetFactoryNum()
        { return m_csFactoryList.Count; }
    }
}
