﻿// <summary>スクリーンファクトリクラス集合体</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMP.HYSSOP.CoreImpl.HSController
{
    /// <summary><para>class outline:</para>
    /// <para>スクリーンファクトリクラス集合体</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class HySScreenFactorySet : HySFactorySet ,  HySScreenFactory
    {
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>なし</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetSimKind(HySKind csSimKindID)
        {
            // Do Nothing
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>シミュレーター種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySKind GetSimKind()
        {
            return HySDefine.COMMON_SCREEN_SET;
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = McFigureUnity.EqualSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>true  : 同じ、false : 異なる</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean EqualSimKind(HySKind csSimKindID)
        {
            return HySDefine.COMMON_SCREEN_SET.Equals(csSimKindID);
        }

        /// <summary><para>method outline:</para>
        /// <para>スクリーンクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySScreen csScreen = CreateScreen( csSimulatorKind,csID,csScreenKind ) </para>
        /// </example>
        /// <param name="csSimulatorKind">シミュレーター種別識別子</param>
        /// <param name="csID">識別子</param>
        /// <param name="csScreenKind">画面種別</param>
        /// <returns>スクリーンクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySScreen CreateScreen(HySKind csSimulatorKind, HySIdentifier csID, HySKind csScreenKind)
        {
            HySScreen csRtnScreen = null;
            HySScreenFactory csScreenFactory = null;

            LinkedListNode<HySFactory> csFactoryNode = m_csFactoryList.First;
            for (long lLoop = 0; lLoop < m_csFactoryList.Count; lLoop++)
            {
                csScreenFactory = csFactoryNode.Value as HySScreenFactory;
                if (csScreenFactory != null)
                {
                    if (csScreenFactory.EqualSimKind(csSimulatorKind) == true)
                    {   // シミュレーション種別が一緒ならば
                        csRtnScreen = csScreenFactory.CreateScreen(csSimulatorKind, csID, csScreenKind);
                        if (csRtnScreen != null)
                        {
                            csRtnScreen.SetSimKind(csSimulatorKind);    // シミュレーション種別識別子設定
                            csRtnScreen.SetID(csID);           // データ識別子設定
                            csRtnScreen.SetScreenKind(csScreenKind); // スクリーン種別識別子設定
                            break;
                        }
                    }
                }
                csFactoryNode = csFactoryNode.Next;
            }
            return csRtnScreen;
        }

        
    }
}
