﻿// <summary>画面ファクトリクラス集合体</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;


namespace CommonMP.HYSSOP.CoreImpl.HSController
{
    /// <summary><para>class outline:</para>
    /// <para>画面ファクトリクラス集合体</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// </remarks>
    public class HySViewFormFactorySet : HySFactorySet, HySViewFormFactory
    {
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>なし</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetSimKind(HySKind csSimKindID)
        {
            // Do Nothing
        }
        /// <summary><para>method outline:</para>
        /// <para>業務種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>業務種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySKind GetSimKind()
        {
            return HySDefine.COMMON_VIEWRFORM_SET;
        }

        /// <summary><para>method outline:</para>
        /// <para>業務種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EqualSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">業務種別識別子</param>
        /// <returns>true  : 同じ、false : 異なる</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean EqualSimKind(HySKind csSimKindID)
        {
            return HySDefine.COMMON_VIEWRFORM_SET.Equals(csSimKindID);
        }

        /// <summary><para>method outline:</para>
        /// <para>画面フォームクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySViewForm csViewFrom = CreateViewForm( csSimulatorKind,csID,csFormKind ) </para>
        /// </example>
        /// <param name="csSimKind">シミュレーター種別識別子</param>
        /// <param name="csID">識別子</param>
        /// <param name="csFormKind">画面種別</param>
        /// <returns>HySViewForm 画面フォームクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySViewForm CreateViewForm(HySKind csSimKind, HySIdentifier csID, HySKind csFormKind)
        {
            HySViewForm csRtnForm = null;
            HySViewFormFactory csFormFactory = null;

            LinkedListNode<HySFactory> csFactoryNode = m_csFactoryList.First;
            for (long lLoop = 0; lLoop < m_csFactoryList.Count; lLoop++)
            {
                csFormFactory = csFactoryNode.Value as HySViewFormFactory;
                if (csFormFactory != null)
                {
                    if (csFormFactory.EqualSimKind(csSimKind) == true)
                    {   // シミュレーション種別が一緒ならば
                        csRtnForm = csFormFactory.CreateViewForm(csSimKind, csID, csFormKind);
                        if (csRtnForm != null)
                        {
                            break;
                        }
                    }
                    csRtnForm = csFormFactory.CreateViewForm(csSimKind, csID, csFormKind);
                    if (csRtnForm != null)
                    {
                        break;
                    }
                }
                csFactoryNode = csFactoryNode.Next;
            }
            return csRtnForm;
        }
    }
}