﻿// <summary>ソースコード：業務処理制御クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSBusiProc;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSBusiProc;


namespace CommonMP.HYSSOP.CoreImpl.HSController
{
    /// <summary><para>class outline:</para>
    /// <para>業務処理制御クラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class HySBusiController : HySControllerRoot
    {
        /// <summary>イベント管理</summary>
        protected HySEventManager m_csEventMng=null;
        /// <summary>ファクトリ管理</summary>
        protected HySFactoryMng m_csFactoryManager=null;

        /// <summary>業務管理用ハッシュテーブル</summary>
        protected Hashtable     m_csBusiProcTbl= new Hashtable();

        /// <summary>搭載業務数</summary>
        protected long      m_lBusiProcNum = 0;

        /// <summary>業務識別キー管理リスト</summary>
        protected IList m_csBusiProcKeyList = new ArrayList();
        
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySBusiController csController = new HySBusiController( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySBusiController()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetFactoryManager( ) </para>
        /// </example>
        /// <param name="csFactoryManager">ファクトリ管理クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetFactoryManager(HySFactoryMng csFactoryManager)
        {
            m_csFactoryManager = csFactoryManager;
        }

        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : 正常、false : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean Initialize()
        {
            // 最初にシステムを制御する　共通業務を入れておく
            this.SetSysUnit( (HySSysUnit) new HySSysBusiProcedure(this) );

            HySBusiProcFactory csFactory = null;
            HySBusiProcedure csBusiProc = null;
            // 複数の　業務生成ファクトリに対してそれぞれ業務を作成させる
            long lFctNo = m_csFactoryManager.GetFactoryNum();
            for (long lLp = 0; lLp < lFctNo; lLp++)
            {
                csFactory = m_csFactoryManager.GetFactory(lLp) as HySBusiProcFactory;
                if (csFactory != null)
                {
                    csBusiProc = csFactory.CreateBusiProcedure();
                    csBusiProc.SetSimKind(csFactory.GetSimKind());
                    csBusiProc.SetController(this);
                    csBusiProc.SetFactoryMng(m_csFactoryManager);
                    this.SetSysUnit((HySSysUnit)csBusiProc );
                }
            }
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>業務取得処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> LoadBusiProcedure( csPrc ) </para>
        /// </example>
        /// <param name="csPrc">業務クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void LoadBusiProcedure(HySBusiProcedure csPrc)
        {
            csPrc.SetController(this);
            HySKind csSimKind = csPrc.GetSimKind();
            HySString csPrcKey = (HySString)csSimKind.GetString();
            m_csBusiProcTbl[csPrcKey.ToString()] = csPrc;
            m_lBusiProcNum += 1;
            m_csBusiProcKeyList.Add(csPrcKey);
        }

        /// <summary><para>method outline:</para>
        /// <para>立ち上がり処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = WakeUp( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : 正常、false : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean WakeUp()
        { 
            bool bRtn = false;
            for (long lLp = 1; lLp <= m_lBusiProcNum; lLp++)
            {
                HySString csPrcKey = (HySString)m_csBusiProcKeyList[(int)(lLp - 1)];
                HySBusiProcedure csBusiProc = m_csBusiProcTbl[csPrcKey.ToString()] as HySBusiProcedure;
                if (csBusiProc != null)
                {
                    bRtn = csBusiProc.Initialize();
                    if (bRtn != true)
                    {
                        break;
                    }
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = ShutDown( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : 正常、false : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean ShutDown()
        {
            bool bRtn = true;
            for (long lLp = 1; lLp <= m_lBusiProcNum; lLp++)
            {
                HySString csPrcKey = (HySString)m_csBusiProcKeyList[(int)(m_lBusiProcNum - lLp)];
                HySBusiProcedure csBusiProc = (HySBusiProcedure)m_csBusiProcTbl[csPrcKey.ToString()];
                if (csBusiProc != null)
                {
                    csBusiProc.Terminate();
                }
            }
            return bRtn;
        }
        
        /// <summary><para>method outline:</para>
        /// <para>システム構成要素を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSysUnit( csUnit ) </para>
        /// </example>
        /// <param name="csUnit">システム構成要素</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetSysUnit(HySSysUnit csUnit)
        {
            this.LoadBusiProcedure( (HySBusiProcedure)csUnit );
        }

        /// <summary><para>method outline:</para>
        /// <para>イベント管理クラスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSysEventManager( csEventMng ) </para>
        /// </example>
        /// <param name="csEventMng">イベント管理クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetEventManager(HySEventMngRoot csEventMng)
        {
            m_csEventMng = (HySEventManager)csEventMng;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベントをシステム構成要素にポストする</para>
        /// </remarks>
        public virtual Boolean EventCallback(HySSysEvent csEvent)
        {
            bool bRtn = false;
            // 業務は複数あるため、どの業務なのかを判断する必要がある。
            HySKind csSimKind = ((HySEventObject)csEvent).GetToSimKind();
            if (csSimKind != null)
            {
                // 業務指定ありの為、該当業務のみにイベントを投げる。
                HySString csPrcKey = (HySString)csSimKind.GetString();
                HySBusiProcedure csBusiProc = (HySBusiProcedure)m_csBusiProcTbl[csPrcKey.ToString()];
                if (csBusiProc != null)
                {
                    bRtn = csBusiProc.EventCallback(csEvent);
                }
                else
                {
                   // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(HySLog.TRIAL_RUN,"HySBusiController::EventCallback",
                        Properties.HysMsgResources.STATEMENT_NO_BUSI_PROC + "["+csPrcKey.ToString()+"]");
                   // HySLog.LogOut(HySLog.TRIAL_RUN, "HySBusiController::EventCallback", " NoBusiProc[" + csPrcKey.ToString() + "])");
                }
            }
            else
            {   
                // 種別識別子が設定されていない場合は全ての業務にイベントを投げる。
                for (long lLp = 1; lLp <= m_lBusiProcNum; lLp++)
                {
                    HySString csPrcKey = (HySString)m_csBusiProcKeyList[(int)(m_lBusiProcNum - lLp)];
                    HySBusiProcedure csBusiProc = (HySBusiProcedure)m_csBusiProcTbl[csPrcKey.ToString()];
                    if (csBusiProc != null)
                    {
                        bRtn = csBusiProc.EventCallback(csEvent);
                        //if (bRtn != true)
                        //{
                        //    break;
                        //}
                    }
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントをイベント管理クラスにポストする</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = PutEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>送信元識別子を自分で付与する</para>
        /// </remarks>
        public virtual bool PutEvent(HySSysEvent csEvent)
        {
            csEvent.SetFrom(HySSysEvent.OBJID_BUSIPROCEDURE);
            return m_csEventMng.PutEvent(csEvent);
        }

        /// <summary><para>method outline:</para>
        /// <para>システム終了準備完了判別</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = ExitOK( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : システムExit準備OK　、false : システムExit準備NG</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean ExitOK()
        {
            Boolean bRtn = true;
            Boolean bLocalRtn = false;
            for (long lLp = 1; lLp <= m_lBusiProcNum; lLp++)
            {
                HySString csPrcKey = (HySString)m_csBusiProcKeyList[(int)(lLp - 1)];
                HySBusiProcedure csBusiProc = (HySBusiProcedure)m_csBusiProcTbl[csPrcKey.ToString()];
                if (csBusiProc != null)
                {
                    bLocalRtn = csBusiProc.ExitOK();
                    if (bLocalRtn != true)
                    {
                        bRtn = false;
                        break;
                    }
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>宛先識別番号を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lAdressIDNo = AdressIDNo() </para>
        /// </example>
        /// <returns>宛先識別番号:(HySSysEvent.OBJID_GISCONTROLLER)</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long AdressIDNo()
        {
            return HySSysEvent.OBJID_BUSIPROCEDURE;
        }   
    }
}
