﻿// <summary>ソースコード：システム内イベント制御クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSGIS;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.CoreImpl.HSController
{
    /// <summary><para>class outline:</para>
    /// <para>システム内イベント制御クラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class HySGISController : HySControllerRoot
    {
        /// <summary>イベント管理</summary>
        protected HySEventManager  m_csEventMng;
        /// <summary>ファクトリ管理</summary>
        protected HySFactoryMng m_csFactoryManager;

        /// <summary>ＧＩＳエンジン</summary>
        protected HySGISEngine m_csGISEngine = null;

        /*
        /// <summary>ＧＩＳエンジン管理用ハッシュテーブル</summary>
        protected Hashtable m_csGISEngineTbl = new Hashtable();  // <--- GISエンジンが複数存在することがあるか？　複数存在するならば必要

        /// <summary>搭載ＧＩＳエンジン数</summary>
        protected long m_lGISEngineNum = 0;

        /// <summary>ＧＩＳエンジン識別キー管理リスト</summary>
        protected IList m_csGISEngineKeyList = new ArrayList();
        */

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGISController csController =  new HySGISController( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGISController()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>システム構成要素を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSysUnit( csUnit ) </para>
        /// </example>
        /// <param name="csUnit">システム構成要素</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetSysUnit(HySSysUnit csUnit)
        {
            m_csGISEngine = (HySGISEngine)csUnit;
            m_csGISEngine.SetController(this);
        }
        /*
        /// <summary><para>method outline:</para>
        /// <para>ＧＩＳエンジン取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySControllerRoot.LoadGISEngine(csPrc) </para>
        /// </example>
        /// <param name="csPrc">ＧＩＳエンジン</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void LoadGISEngine(HySGISEngine csPrc)
        {
            csPrc.SetController(this);

            //HySIdentifier csGISID = csPrc.GetID();

            HySKind csGISKind = csPrc.GetGISKind();
            HySString csPrcKey = (HySString)csGISKind.ToString();
            //HySString csPrcKey = (HySString)csGISID.ToString();
            m_csGISEngineTbl[csPrcKey] = csPrc;
            m_lGISEngineNum += 1;
            m_csGISEngineKeyList.Add(csPrcKey);
        }
        */
        /// <summary><para>method outline:</para>
        /// <para>イベント管理クラスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSysEventManager( csEventMng ) </para>
        /// </example>
        /// <param name="csEventMng">イベント管理クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetEventManager(HySEventMngRoot csEventMng)
        {
            m_csEventMng = (HySEventManager)csEventMng;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベントをシステム構成要素にポストする</para>
        /// </remarks>
        public Boolean EventCallback(HySSysEvent csEvent)
        {
            return m_csGISEngine.EventCallback(csEvent);
            /*
            Boolean bRtn = false;
            // ＧＩＳエンジンは複数ありえるため、どのＧＩＳエンジンなのかを判断する必要がある。
            HySKind csGISKind = ((HySEventObject)csEvent).GetSimKind();
            if (csGISKind != null)
            //HySIdentifier csGISID = ((HySEventObject)csEvent).GetSuppID();
            //if (csGISID != null)
            {
                HySString csPrcKey = (HySString)csGISKind.ToString();
                HySGISEngine csGISEngine = (HySGISEngine)m_csGISEngineTbl[csPrcKey];
                if (csGISEngine != null)
                {
                    bRtn = csGISEngine.EventCallback(csEvent);
                }
                else
                {
                    //HySLog.LogOut(HySLog.ONLINE,"HySBusiController::EventCallback(NoBusiProc["+"prcKey"+"])");
                }
            }
            return bRtn;
            */
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントをイベント管理クラスにポストする</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = PutEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>送信元識別子を自分で付与する</para>
        /// </remarks>
        public Boolean PutEvent(HySSysEvent csEvent)
        {
            csEvent.SetFrom(HySSysEvent.OBJID_GISCONTROLLER);
            return m_csEventMng.PutEvent(csEvent);
        }

        /// <summary><para>method outline:</para>
        /// <para>ファクトリ管理設定処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetFactoryManager( ) </para>
        /// </example>
        /// <param name="csFactoryManager">ファクトリ管理クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetFactoryManager(HySFactoryMng csFactoryManager)
        {
            m_csFactoryManager = csFactoryManager;
        }

        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : 正常、false : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Boolean Initialize()
        {
            HySGISFactory csFactory = null;
            HySGISEngine csGISEng = null;
            // 複数の　生成ファクトリに対してそれぞれライブラリ管理を作成させる
            long lFctNo = m_csFactoryManager.GetFactoryNum();
            for (long lLp = 0; lLp < lFctNo; lLp++)
            {
                csFactory = m_csFactoryManager.GetFactory(lLp) as HySGISFactory;
                if (csFactory != null)
                {
                    csGISEng = csFactory.CreateGIS();
                    csGISEng.SetController(this);
                    this.SetSysUnit((HySSysUnit)csGISEng);
                    break; // GIS が複数の場合には、　break を取る
                }
            }
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>立ち上がり処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = WakeUp( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : 正常、false : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Boolean WakeUp()
        {
            Boolean bRtn = false;
            if(m_csGISEngine != null)
            {
                bRtn = m_csGISEngine.Initialize();
            }
            return bRtn;
            /*  将来ＧＩＳエンジンを複数積んだときに使用
            Boolean bRtn = false;
            for (long lLp = 1; lLp <= m_lGISEngineNum; lLp++)
            {
                HySString csPrcKey = (HySString)m_csGISEngineKeyList[(int)(lLp - 1)];
                HySGISEngine csGISEngine = (HySGISEngine)m_csGISEngineTbl[csPrcKey];
                if (csGISEngine != null)
                {
                    bRtn = csGISEngine.Initialize();
                    if (bRtn != true)
                    {
                        break;
                    }
                }
            }
            return bRtn;
            */
        }

        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = ShutDown( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : 正常、false : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Boolean ShutDown()
        {
            Boolean bRtn = true;
            if (m_csGISEngine != null)
            {
                bRtn =  m_csGISEngine.Terminate();
            }
            return bRtn;
            /*  将来ＧＩＳエンジンを複数積んだときに使用
             Boolean bRtn = true;
             for (long lLp = 1; lLp <= m_lGISEngineNum; lLp++)
             {
                 HySString csPrcKey = (HySString)m_csGISEngineKeyList[(int)(lLp - 1)];
                 HySGISEngine GISEngine = (HySGISEngine)m_csGISEngineTbl[csPrcKey];
                 if (GISEngine != null)
                 {
                     bRtn = GISEngine.Terminate();
                     if (bRtn != true)
                     {
                         break;
                     }
                 }
             }
             return bRtn;
             */
        }
        /// <summary><para>method outline:</para>
        /// <para>システム終了準備完了判別</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySControllerRoot.ExitOK( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : システムExit準備OK　、false : システムExit準備NG</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Boolean ExitOK()
        {
            Boolean bRtn = true;
            if (m_csGISEngine != null)
            {
                bRtn = m_csGISEngine.ExitOK();
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>宛先識別番号を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lAdressIDNo = AdressIDNo() </para>
        /// </example>
        /// <returns>宛先識別番号:(HySSysEvent.OBJID_GISCONTROLLER)</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long AdressIDNo()
        {
            return HySSysEvent.OBJID_GISCONTROLLER;
        }
    }
}
