﻿// <summary>ソースコード：ライブラリ管理制御クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSLibraryMng;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.CoreImpl.HSController
{
    /// <summary><para>class outline:</para>
    /// <para>ライブラリ管理制御クラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class HySLibraryController : HySControllerRoot
    {
        ///// <summary>ライブラリ管理</summary>
        //HySLibraryMng m_csLibMng = null;

        /// <summary>イベント管理</summary>
        protected HySEventManager m_csEventMng = null;

        /// <summary>ファクトリ管理クラス</summary>
        protected HySFactoryMng m_csFactoryManager = null;

        /// <summary>ライブラリ管理用ハッシュテーブル</summary>
        protected Hashtable m_csLibraryMngTbl = new Hashtable();

        /// <summary>搭載ライブラリ管理数</summary>
        protected long m_lLibraryMngNum = 0;

        /// <summary>ライブラリ管理識別キー管理リスト</summary>
        protected IList m_csLibraryMngKeyList = new ArrayList();

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySLibraryController = new HySLibraryController( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySLibraryController()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>ファクトリ管理クラスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetFactoryManager( csFactoryManager ) </para>
        /// </example>
        /// <param name="csFactoryManager">ファクトリ管理クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetFactoryManager(HySFactoryMng csFactoryManager)
        {
            m_csFactoryManager = csFactoryManager;
        }

        /// <summary><para>method outline:</para>
        /// <para>システム構成要素を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSysUnit( csUnit ) </para>
        /// </example>
        /// <param name="csUnit">システム構成要素</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetSysUnit(HySSysUnit csUnit)
        {
            this.LoadLibraryManager((HySLibraryMng)csUnit);
        }

        /// <summary><para>method outline:</para>
        /// <para>イベント管理クラスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSysEventManager( csEventMng ) </para>
        /// </example>
        /// <param name="csEventMng">イベント管理クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetEventManager(HySEventMngRoot csEventMng)
        {
            m_csEventMng = (HySEventManager)csEventMng;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベントをシステム構成要素にポストする</para>
        /// </remarks>
        public virtual Boolean EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = false;
            // ライブラリ管理は複数ありえるため、どのライブラリ管理なのかを判断する必要がある。
            HySKind csSimKind = ((HySEventObject)csEvent).GetToSimKind();
            if (csSimKind != null)
            {
                HySString csPrcKey = (HySString)csSimKind.GetString();
                HySLibraryMng csLibraryMng = (HySLibraryMng)m_csLibraryMngTbl[csPrcKey.ToString()];
                if (csLibraryMng != null)
                {
                    bRtn = csLibraryMng.EventCallback(csEvent);
                }
                else
                {
                    //HySLog.LogOut(HySLog.ONLINE,"HySBusiController::EventCallback(NoBusiProc["+"prcKey"+"])");
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントをイベント管理クラスにポストする</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = PutEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>送信元識別子を自分で付与する</para>
        /// </remarks>
        public virtual Boolean PutEvent(HySSysEvent csEvent)
        {
            csEvent.SetFrom(HySSysEvent.OBJID_LIBMANAGER);
            return m_csEventMng.PutEvent(csEvent);
        }


        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : 正常、false : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean Initialize()
        {
            HySLibraryMngFactory csFactory = null;
            HySLibraryMng csLibMng = null;
            // 複数の　生成ファクトリに対してそれぞれライブラリ管理を作成させる
            long lFctNo = m_csFactoryManager.GetFactoryNum();
            for (long lLp = 0; lLp < lFctNo; lLp++)
            {
                csFactory = m_csFactoryManager.GetFactory(lLp) as HySLibraryMngFactory;
                if (csFactory != null)
                {
                    csLibMng = csFactory.CreateLibraryManager();
                    csLibMng.SetController(this);
                    this.SetSysUnit((HySSysUnit)csLibMng);
                    csLibMng.SetFactoryManager(m_csFactoryManager);
                }
            }
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>ライブラリ管理取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> LoadLibraryManager(csPrc) </para>
        /// </example>
        /// <param name="csPrc">ライブラリ管理</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void LoadLibraryManager(HySLibraryMng csPrc)
        {
            csPrc.SetController(this);
            HySKind csSimKind = csPrc.GetSimKind();
            HySString csPrcKey = (HySString)csSimKind.GetString();
            m_csLibraryMngTbl[csPrcKey.ToString()] = csPrc;
            m_lLibraryMngNum += 1;
            m_csLibraryMngKeyList.Add(csPrcKey);
        }

        /// <summary><para>method outline:</para>
        /// <para>立ち上がり処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = WakeUp( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : 正常、false : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean WakeUp()
        {
            Boolean bRtn = false;
            for (long lLp = 1; lLp <= m_lLibraryMngNum; lLp++)
            {
                HySString csPrcKey = (HySString)m_csLibraryMngKeyList[(int)(lLp - 1)];
                HySLibraryMng csLibraryMng = (HySLibraryMng)m_csLibraryMngTbl[csPrcKey.ToString()];
                if (csLibraryMng != null)
                {
                    bRtn = csLibraryMng.Initialize();
                    if (bRtn != true)
                    {
                        break;
                    }
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = ShutDown( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : 正常、false : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean ShutDown()
        {
            Boolean bRtn = true;
            for (long lLp = 1; lLp <= m_lLibraryMngNum; lLp++)
            {
                HySString csPrcKey = (HySString)m_csLibraryMngKeyList[(int)(lLp - 1)];
                HySLibraryMng csLibraryMng = (HySLibraryMng)m_csLibraryMngTbl[csPrcKey.ToString()];
                if (csLibraryMng != null)
                {
                    csLibraryMng.Terminate();
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>システム終了準備完了判別</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = ExitOK( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : システムExit準備OK　、false : システムExit準備NG</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean ExitOK()
        {
            Boolean bRtn = true;
            Boolean bLocalRtn = false;
            for (long lLp = 1; lLp <= m_lLibraryMngNum; lLp++)
            {
                HySString csPrcKey = (HySString)m_csLibraryMngKeyList[(int)(lLp - 1)];
                HySLibraryMng csLibraryMng = (HySLibraryMng)m_csLibraryMngTbl[csPrcKey.ToString()];
                if (csLibraryMng != null)
                {
                    bLocalRtn = csLibraryMng.ExitOK();
                    if (bRtn != true)
                    {
                        bRtn = false;
                        break;
                    }
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>宛先識別番号を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lAdressIDNo = AdressIDNo() </para>
        /// </example>
        /// <returns>宛先識別番号</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long AdressIDNo()
        { 
            return HySSysEvent.OBJID_LIBMANAGER;
        }

    }
}
