﻿// <summary>ソースコード：ビューア制御クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSController.DIContainer;

namespace CommonMP.HYSSOP.CoreImpl.HSController
{
    /// <summary><para>class outline:</para>
    /// <para>ビューア制御クラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class HySViewerController : HySControllerRoot
    {

        /// <summary>メインビューア</summary>
        protected HySViewer m_csMainViewer=null;

        /// <summary>イベント管理</summary>
        protected HySEventManager m_csEventMng = null;

        /// <summary>ファクトリ管理</summary>
        protected HySFactoryMng m_csFactoryMng = null;

        /// <summary>画面イベントキュー（待ちなし）
        /// 外部から　EventCallBack() は　色々なスレッドから呼ばれる
        /// 従って、画面のスレッドに乗り換える必要がある Queueu からの取り出しは、定期的なタイマーで行う　
        /// </summary>
        protected HySTryQueue m_csEventMainViewer = new HySTryQueue(1024);

        /// <summary>定義データ管理</summary>
        protected HySConfigDataManager m_csConfigDataMng = null;

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySViewerController csController = new HySViewerController( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySViewerController()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : 正常、false : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean Initialize()
        {
            HySViewerFactory csViewerFactory = null;
            HySViewer csViewer = null;

            // 複数の　生成ファクトリに対してそれぞれライブラリ管理を作成させる
            long lFctNo = m_csFactoryMng.GetFactoryNum();
            for (long lLp = 0; lLp < lFctNo; lLp++)
            {
                csViewerFactory = m_csFactoryMng.GetFactory(lLp) as HySViewerFactory;
                if (csViewerFactory != null)
                {
                    csViewer = csViewerFactory.CreateViewer(HySDefine.COMPONENT_ID_BUSIPROCEDURE);
                    csViewer.SetController(this);
                    csViewer.SetFactoryManager(m_csFactoryMng);
                    this.SetSysUnit(csViewer);
                    break; // Viewer は一つであるから　break する
                }
            }
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>立ち上がり処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = WakeUp( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : 正常、false : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean WakeUp()
        {
            //ViewJobを作成し、ビューア内に設定する
            HySViewerJobFactory csViewrJobFactory = null;
            HySViewerJob csViewrJob = null;
            long lFctNo = m_csFactoryMng.GetFactoryNum();
            for (long lLp = 0; lLp < lFctNo; lLp++)
            {
                csViewrJobFactory = m_csFactoryMng.GetFactory(lLp) as HySViewerJobFactory;
                // ビューア内部処理ファクトリ取得
                if (csViewrJobFactory != null)
                {
                    csViewrJob = csViewrJobFactory.CreateViewerJob(HySDefine.COMPONENT_ID_VIEWRJOB);// ビューア内部処理生成

                    csViewrJob.SetViewer(m_csMainViewer);   // 各種設定

                    m_csMainViewer.AddViewerJob(csViewrJob);    // ビューアに積む
                }
            }

            m_csMainViewer.Initialize();

            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>ファクトリ管理設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetFactoryMng( csFactoryMng ) </para>
        /// </example>
        /// <param name="csFactoryMng">ファクトリ管理</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetFactoryMng(HySFactoryMng csFactoryMng)
        {
            m_csFactoryMng = csFactoryMng;
        }

        /// <summary><para>method outline:</para>
        /// <para>定義データ管理を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetConfigDataMng( csConfigDataMng ) </para>
        /// </example>
        /// <param name="csConfigDataMng">定義データ管理</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetConfigDataMng(HySConfigDataManager csConfigDataMng)
        {
            m_csConfigDataMng = csConfigDataMng;
        }

        /// <summary><para>method outline:</para>
        /// <para>システム構成要素を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSysUnit( csUnit ) </para>
        /// </example>
        /// <param name="csUnit">システム構成要素</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetSysUnit(HySSysUnit csUnit)
        {
            m_csMainViewer = (HySViewer)csUnit;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベント管理クラスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSysEventManager( csEventMng ) </para>
        /// </example>
        /// <param name="csEventMng">イベント管理クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetEventManager(HySEventMngRoot csEventMng)
        {
            m_csEventMng = (HySEventManager)csEventMng;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 画面は一般的にマルチスレッドセーフではないので、
        /// 一旦Queueuへイベントを投げる（待ち無しQueueu)
        /// 此処で受け取ったQueueuは、画面のタイマーにより
        /// TryWatchEvent() 内で取り出されて、画面のスレッド上で
        /// 画面の EventCallback() をコールする
        /// </para>
        /// </remarks>
        public virtual Boolean EventCallback(HySSysEvent csEvent)
        {
            return m_csEventMainViewer.TryPushObject(csEvent);
        }
        /// <summary><para>method outline:</para>
        /// <para>画面へのイベント見張り（ウエイトしない）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> TryWatchEvent( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 画面側のタイマーからコールされて、
        /// 他の処理部から画面へのイベントを取り出し、
        /// 画面の　EventCallback() を呼ぶ</para>
        /// </remarks>
        public virtual void TryWatchEvent()
        {
            try
            {
                HySEventObject csEvent = (HySEventObject)m_csEventMainViewer.TryPullObject();
                if (csEvent != null)
                {
                    m_csMainViewer.EventCallback(csEvent);
                }
            }
            catch (Exception ex)
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "HySViewerController", "TryWatchEvent" , Properties.HysMsgResources.STATEMENT_CATCH_EXCEPTION + ex.Message);
               // HySLog.LogOut(HySLog.ONLINE, "HySViewerController", "TryWatchEvent", "Catch Exception Event: " + ex.Message);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントをイベント管理クラスにポストする</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = PutEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>送信元識別子を自分で付与する</para>
        /// </remarks>
        public virtual Boolean PutEvent(HySSysEvent csEvent)
        {
            csEvent.SetFrom(HySSysEvent.OBJID_VIEWER);
            return m_csEventMng.PutEvent(csEvent);
        }

        /// <summary><para>method outline:</para>
        /// <para>宛先識別番号を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lAdressIDNo = AdressIDNo() </para>
        /// </example>
        /// <returns>宛先識別番号:(HySSysEvent.OBJID_VIEWER)</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long AdressIDNo()
        {
            return HySSysEvent.OBJID_VIEWER;
        }

        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = ShutDown( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : 正常、false : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean ShutDown()
        {
            Boolean bRtn = true;
            m_csMainViewer.Terminate();
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>システム終了準備完了判別</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = ExitOK( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : システムExit準備OK　、false : システムExit準備NG</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean ExitOK()
        {
            return m_csMainViewer.ExitOK();
        }

        /// <summary><para>method outline:</para>
        /// <para>起動処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Run( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void Run()
        {
            m_csMainViewer.Run();
        }

        /// <summary><para>method outline:</para>
        /// <para>プロセス終了</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Exit( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void Exit()
        {
            m_csMainViewer.Exit();
        }

    }
}
