﻿using System;
using System.Collections.Generic;
using System.Text;
using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMP.HYSSOP.CoreImpl.HSDBA.FileBase
{
    /// <summary><para>class outline:</para>
    /// <para>演算結果データのメタデータキー定義クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/06/22][新規作成]</para>
    /// </remarks>
    public static class HySCalResultMetaKeyDefines
    {
        /// <summary>
        /// 演算結果ID
        /// </summary>
        public static readonly HySString CALC_RESULT_ID = new HySString("__CALC_RESULT_ID__");

        /// <summary>
        /// 要素名称
        /// </summary>
        public static readonly HySString ELEMENT_NAME = HySCalResultDataQueryFieldNames.ELEMENT_NAME;

        /// <summary>
        /// 要素ID
        /// </summary>
        public static readonly HySString ELEMENT_ID = HySCalResultDataQueryFieldNames.ELEMENT_ID;

        /// <summary>
        /// 演算結果連番
        /// </summary>
        public static readonly HySString CALC_RESULT_SEQNO = HySCalResultDataQueryFieldNames.CALC_RESULT_SEQNO;

        /// <summary>
        /// プロジェクト名（プロジェクト情報より）
        /// </summary>
        public static readonly HySString PROJECT_NAME = HySCalResultDataQueryFieldNames.PROJECT_NAME;

        /// <summary>
        /// 管理者名（プロジェクト情報より）
        /// </summary>
        public static readonly HySString MANAGER_NAME = HySCalResultDataQueryFieldNames.MANAGER_NAME;

        /// <summary>
        /// 種別（プロジェクト情報より）
        /// </summary>
        public static readonly HySString MODEL_TYPE = HySCalResultDataQueryFieldNames.MODEL_TYPE;

        /// <summary>
        /// 対象（プロジェクト情報より）
        /// </summary>
        public static readonly HySString MODEL_TARGET = HySCalResultDataQueryFieldNames.MODEL_TARGET;

        /// <summary>
        /// モデル（プロジェクト情報より）
        /// </summary>
        public static readonly HySString MODEL_CALC_TYPE = HySCalResultDataQueryFieldNames.MODEL_CALC_TYPE;

        /// <summary>
        /// 件名（プロジェクト情報より）
        /// </summary>
        public static readonly HySString MODEL_SUBJECT = HySCalResultDataQueryFieldNames.MODEL_SUBJECT;

        /// <summary>
        /// ケース名（プロジェクト情報より）
        /// </summary>
        public static readonly HySString MODEL_SITUATION = HySCalResultDataQueryFieldNames.MODEL_SITUATION;

        /// <summary>
        /// 演算実行日時（演算ロット情報より）
        /// </summary>
        public static readonly HySString CALC_EXEC_DATE = HySCalLotInfoQueryFieldNames.CALC_EXEC_DATE;

        /// <summary>
        /// データ型
        /// </summary>
        public static readonly HySString DATA_TYPE = HySCalResultDataQueryFieldNames.DATA_TYPE;

        /// <summary>
        /// データ次元1
        /// </summary>
        public static readonly HySString DATA_DIM1 = HySCalResultDataQueryFieldNames.DATA_DIM1;

        /// <summary>
        /// データ次元2
        /// </summary>
        public static readonly HySString DATA_DIM2 = HySCalResultDataQueryFieldNames.DATA_DIM2;

        /// <summary>
        /// データ次元3
        /// </summary>
        public static readonly HySString DATA_DIM3 = HySCalResultDataQueryFieldNames.DATA_DIM3;


    }
}
