﻿// <summary>ソースコード：>共通DBA基底クラス</summary>
// <author>CommonMP</author>

using System;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMP.HYSSOP.CoreImpl.HSDBA
{
    /// <summary><para>class outline:</para>
    /// <para>共通DBA基底クラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>データベースアクセスの基本操作を定義する。</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/06/18][新規作成]</para>
    /// </remarks>
    public abstract class HySCommonDBA: HySRoot
    {
        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySCommonDBA csDBA = new HySCommonDBA()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySCommonDBA  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected HySCommonDBA()
        {
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>1件新規登録</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = RegisterNew( csStockData )</para>
        /// </example>
        /// <param name="csStockData">登録対象のデータ</param>
        /// <returns>true:成功、false:失敗(データベースは更新されていない)</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract Boolean RegisterNew(HySStockData csStockData);
        /// <summary>
        /// <para>method outline:</para>
        /// <para>複数件新規登録</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = RegisterNew( csStockDataList ) </para>
        /// </example>
        /// <param name="csStockDataList">登録対象のデータリスト</param>
        /// <returns>true:成功、false:失敗(データベースは更新されていない)</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract Boolean RegisterNew(HySStockDataList csStockDataList);
        /// <summary>
        /// <para>method outline:</para>
        /// <para>登録済みデータの更新</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = Update( csStockData ) </para>
        /// </example>
        /// <param name="csStockData">更新対象のデータ</param>
        /// <returns>true:成功、false:失敗(データベースは更新されていない)</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract Boolean Update(HySStockData csStockData);
        /// <summary>
        /// <para>method outline:</para>
        /// <para>1件削除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = Delete( csID ) </para>
        /// </example>
        /// <param name="csID">削除対象データのID</param>
        /// <returns>true:成功、false:失敗(データベースは更新されていない)</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract Boolean Delete(HySIdentifier csID);
        /// <summary>
        /// <para>method outline:</para>
        /// <para>複数件一括削除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = Delete( csIDs ) </para>
        /// </example>
        /// <param name="csIDs">削除対象データのID配列</param>
        /// <returns>true:成功、false:失敗(データベースは更新されていない)</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract Boolean Delete(HySIdentifier[] csIDs);
        /// <summary>
        /// <para>method outline:</para>
        /// <para>複数件一括削除(検索条件指定)</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = Delete( csQueryCtrlData ) </para>
        /// </example>
        /// <param name="csQueryCtrlData">削除対象データの検索条件</param>
        /// <returns>true:成功、false:失敗(データベースは更新されていない)</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract Boolean Delete(HySQueryCtlData csQueryCtrlData);
        /// <summary>
        /// <para>method outline:</para>
        /// <para>データ1件取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = GetData( csID, csStockData ) </para>
        /// </example>
        /// <param name="csID">取得対象データのID</param>
        /// <param name="csStockData">取得したデータオブジェクト</param>
        /// <returns>true:成功、false:失敗(指定IDのデータは存在しない、その他エラー)</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract Boolean GetData(HySIdentifier csID, out HySStockData csStockData);
        /// <summary>
        /// <para>method outline:</para>
        /// <para>データ複数件取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = GetDataList( csIDs, csStockDataList ) </para>
        /// </example>
        /// <param name="csIDs">取得対象データのID配列</param>
        /// <param name="csStockDataList">取得したデータオブジェクトのリスト</param>
        /// <returns>true:成功、false:失敗(指定ID配列のデータの1つ以上が存在しない、その他エラー)</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract Boolean GetDataList(HySIdentifier[] csIDs, out HySStockDataList csStockDataList);
        /// <summary>
        /// <para>method outline:</para>
        /// <para>一覧検索</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = SearchList( csQueryCtlData, csStockDataList ) </para>
        /// </example>
        /// <param name="csQueryCtlData">取得対象データの検索条件</param>
        /// <param name="csStockDataList">取得したデータオブジェクトのリスト</param>
        /// <returns>true:成功(0件を含む)、false:失敗(検索条件指定誤り、その他エラー)</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract Boolean SearchList(HySQueryCtlData csQueryCtlData, out HySStockDataList csStockDataList);

        /// <summary>
        /// <para>method outline:</para>
        /// <para>部分更新</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = UpdatePartial( csQueryCtlData, csModifyData ) </para>
        /// </example>
        /// <param name="csQueryCtlData">更新対象データの検索条件</param>
        /// <param name="csModifyData">更新データ。更新対象フィールド名は検索条件フィールド名と同じ。</param>
        /// <returns>true:成功、false:失敗(データベースは更新されていない)</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean UpdatePartial(HySQueryCtlData csQueryCtlData, HySDataHashTable csModifyData)
        {
            HySDBALog.WriteOnline("HySCommonDBA", "UpdatePartial", "method not supported");
            return false;
        }
    }
}
