﻿// <summary>ソースコード：>共通DBA基底クラス</summary>
// <author>CommonMP</author>

using System;
using System.Text;
using System.Collections.Generic;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.Interface.HSData;

namespace CommonMP.HYSSOP.CoreImpl.HSDBA
{
    /// <summary><para>class outline:</para>
    /// <para>共通DBAログ出力クラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>データベースアクセスクラスが使用する共通ログ出力処理</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/07/14][新規作成]</para>
    /// </remarks>
    public static class HySDBALog
    {
        /// <summary>
        /// ログ出力(オンライン)
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDBALog.WriteOnline(csClass, csMethod, csMessage, csLabelValuePairs); </para>
        /// </example>
        /// <param name="csClass">クラス名</param>
        /// <param name="csMethod">メソッド名</param>
        /// <param name="csMessage">メッセージ</param>
        /// <param name="csLabelValuePairs">名前・値ペアの配列(省略可能)</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static void WriteOnline(string csClass, string csMethod, string csMessage, params object[] csLabelValuePairs)
        {
            Write(HySLog.ONLINE, csClass, csMethod, csMessage, csLabelValuePairs);
        }

        /// <summary>
        /// ログ出力(デバッグ)
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDBALog.WriteDebug(csClass, csMethod, csMessage, csLabelValuePairs); </para>
        /// </example>
        /// <param name="csClass">クラス名</param>
        /// <param name="csMethod">メソッド名</param>
        /// <param name="csMessage">メッセージ</param>
        /// <param name="csLabelValuePairs">名前・値ペアの配列(省略可能)</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static void WriteDebug(string csClass, string csMethod, string csMessage, params object[] csLabelValuePairs)
        {
            Write(HySLog.DEBUG, csClass, csMethod, csMessage, csLabelValuePairs);
        }

        /// <summary>
        /// ログ出力(デバッグ)
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDBALog.Write(lLevel, csClass, csMethod, csMessage, csLabelValuePairs); </para>
        /// </example>
        /// <param name="lLevel">ログレベル</param>
        /// <param name="csClass">クラス名</param>
        /// <param name="csMethod">メソッド名</param>
        /// <param name="csMessage">メッセージ</param>
        /// <param name="csLabelValuePairs">名前・値ペアの配列(省略可能)</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static void Write(long lLevel, string csClass, string csMethod, string csMessage, object[] csLabelValuePairs)
        {
            List<string> pList = new List<string>();
            bool b = false;
            string n = null;
            string v = null;
            foreach (object o in csLabelValuePairs)
            {
                if (!b)
                {
                    if (o is string)
                    {
                        n = (string)o;
                    }
                    else
                    {
                        n = o.ToString();
                    }
                }
                else
                {
                    v = ObjectToString(o);
                    pList.Add(string.Format("{0}={1}", n, v));
                    n = null;
                    v = null;
                }
                b = (!b);
            }
            if (n != null)
            {
                pList.Add(string.Format("{0}=??", n));
            }
            string sParams = string.Empty;
            if (pList.Count > 0)
            {
                sParams = string.Format(" {{{0}}}", string.Join(", ", pList.ToArray()));
            }
            string logclass = string.Format("{0}.{1}", csClass, csMethod);
            string logmsg = string.Format("{0}{1}", csMessage, sParams);
            HySLog.LogOut(lLevel, logclass, logmsg);
        }

        private static string ObjectToString(object o)
        {
            if (o is HySString)
            {
                return ((HySString)o).ToString();
            }
            else if (o is HySTime)
            {
                try
                {
                    return HySCalendar.GetString((HySTime)o, HySCalendar.FORMAT.lSW_YEAR).ToString();
                }
                catch
                {
                    return ((HySTime)o).GetTime().ToString() + "(GetString failed)";
                }
            }
            else if (o is HySIdentifier)
            {
                return ((HySIdentifier)o).ToString();
            }
            else if (o is HySObjectKind)
            {
                return ((HySObjectKind)o).ToString();
            }
            else if (o is HySLong)
            {
                return ((HySLong)o).m_lValue.ToString();
            }
            else if (o != null)
            {
                return o.ToString();
            }
            else
            {
                return "<null>";
            }
        }
    }
}
