﻿// <summary>ソースコード：表示業務処理基底クラス</summary>
// <author>CommonMP</author>

using System;
using System.Threading;
using System.Collections.Generic;
using System.Text;
using System.IO;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSDBAProc;
using CommonMP.HYSSOP.Interface.HSBusiProc;

using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.CoreImpl.HSDBAProc
{
    /// <summary><para>class outline:</para>
    /// <para>一般業務の基底クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.2.0][2011/10/01][新規作成]</para>
    /// </remarks>
    public class HySDBAProcedureBase : HySDBAProcedure
    {
        ///// <summary>ログ出力用　クラス名称</summary>
        //private static readonly string CLASS_NAME = "HySDBAProcedureBase";
        /// <summary>シミュレータ識別子</summary>
        protected HySKind m_csSimKindID;
        /// <summary>ＤＢアクセススレッド制御</summary>
        protected HySDBAThreadCtl m_csDBAThreadCtl = null;
        /// <summary>業務制御クラス</summary>
        protected HySBusiProcedure m_csBusiProc = null;
        /// <summary>定期河川縦横断データ管理システム　アダプタ</summary>
        protected HySAdaptorIF m_csAdaptor = null;


        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDBAProcedureBase csDBAProc = new HySDBAProcedureBase( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDBAProcedureBase 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDBAProcedureBase()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetSimKind(HySKind csSimKindID)
        {
            m_csSimKindID = csSimKindID;
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>シミュレーター種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySKind GetSimKind()
        {
            return m_csSimKindID;
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bVar = EqualSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>
        /// true  : 同じ
        /// false : 異なる
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean EqualSimKind(HySKind csSimKindID)
        {
            return m_csSimKindID.Equals(csSimKindID);
        }

        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean Initialize()
        {
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean Terminate()
        {
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        virtual public Boolean EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = false;
            HySEventObject csEventObj = csEvent as HySEventObject;
            if (csEventObj != null)
            {
                HySKind csSimKind = csEventObj.GetToSimKind();
                long lFromObjNo = csEvent.From();
                long lEventNo = csEventObj.GetEventNo();
                long lSubEventNo = csEventObj.GetSubEventNo();
                HySID csID = csEventObj.GetSuppID();
                HySDataRoot csMainData = csEventObj.GetData();
                HySDataRoot csSuppData = csEventObj.GetSubData();
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>ＤＢアクセススレッド制御クラス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDBAThreadCtl( csThrdCtl ) </para>
        /// </example>
        /// <param name="csThrdCtl">演算スレッド制御クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetDBAThreadCtl(HySDBAThreadCtl csThrdCtl)
        {
            m_csDBAThreadCtl = csThrdCtl;
        }


        ///// <summary><para>method outline:</para>
        ///// <para>イベントを受け取った時に動作するメソッド</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para> bool bRtn = EventReceived(
        /////        long lFromObjNo,
        /////        long lEventNo,
        /////        long lSubEventNo,
        /////        HySID csID,
        /////        HySDataRoot csMainData,
        /////        HySDataRoot csSuppData
        /////                                 );
        ///// </para>
        ///// </example>
        ///// <param name="lFromObjNo">
        ///// イベントの送り元番号
        ///// HySSysEvent.OBJID_VIEWER 等が設定されている
        ///// </param>
        ///// <param name="lEventNo">
        ///// 送られたイベント番号
        ///// HySEventObject.CMND_START_SIMULATION 等が設定されている
        ///// </param>
        ///// <param name="lSubEventNo">
        ///// 送られたイベントの補足番号
        ///// ユーザー側で定義できる
        ///// </param>
        ///// <param name="csID">
        ///// 送られたイベントID
        ///// ユーザー側で定義できる　null の事も有り得る
        ///// </param>
        ///// <param name="csMainData">
        ///// 送られたイベント付属データ
        ///// ユーザー側で定義できる　null の事も有り得る
        ///// </param>
        ///// <param name="csSuppData">
        ///// 送られたイベント付属データ（補足）
        ///// ユーザー側で定義できる　null の事も有り得る
        ///// </param>
        ///// <returns>true:=正常, false:=異常</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>各実装クラスは受け取ったイベント毎に処理を行う</para>
        ///// </remarks>
        //abstract protected Boolean EventReceived
        //    (
        //        long lFromObjNo,
        //        long lEventNo,
        //        long lSubEventNo,
        //        HySID csID,
        //        HySDataRoot csMainData,
        //        HySDataRoot csSuppData
        //    );

        ///// <summary><para>method outline:</para>
        ///// <para>イベントを送るメソッド</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para> bool bRtn = SendEvent(
        /////        long lToObjNo,
        /////        long lEventNo,
        /////        long lSubEventNo,
        /////        HySID csID,
        /////        HySDataRoot csMainData,
        /////        HySDataRoot csSuppData
        /////                                 );
        ///// </para>
        ///// </example>
        ///// <param name="lToObjNo">
        ///// イベントの送り先番号
        ///// HySSysEvent.OBJID_VIEWER 等を設定する
        ///// </param>
        ///// <param name="lEventNo">
        ///// 送るイベント番号
        ///// HySEventObject.CMND_START_SIMULATION 等を設定する
        ///// </param>
        ///// <param name="lSubEventNo">
        ///// イベントの補足番号
        ///// ユーザー側で定義できる
        ///// </param>
        ///// <param name="csID">
        ///// イベントID
        ///// ユーザー側で定義できる　null の事も有り得る
        ///// </param>
        ///// <param name="csMainData">
        ///// イベント付属データ
        ///// ユーザー側で定義できる　null の事も有り得る
        ///// </param>
        ///// <param name="csSuppData">
        ///// イベント付属データ（補足）
        ///// ユーザー側で定義できる　null の事も有り得る
        ///// </param>
        ///// <returns>true:=正常, false:=異常</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>各実装クラスは受け取ったイベント毎に処理を行う</para>
        ///// </remarks>
        //virtual protected Boolean SendEvent
        //    (
        //        long lToObjNo,
        //        long lEventNo,
        //        long lSubEventNo,
        //        HySID csID,
        //        HySDataRoot csMainData,
        //        HySDataRoot csSuppData
        //    )
        //{
        //    HySEventObject csEventObj = new HySEventObject(lToObjNo, lEventNo, lSubEventNo);
        //    csEventObj.SetSuppID(csID);
        //    csEventObj.SetData(csMainData);
        //    csEventObj.SetSubData(csSuppData);

        //    return this.PutEvent(csEventObj);
        //}

        /// <summary><para>method outline:</para>
        /// <para>イベントを送る</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = PutEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>自分からイベントを送信する時に使用する</para>
        /// </remarks>
        virtual public Boolean PutEvent(HySSysEvent csEvent)
        {
            Boolean bRtn = false;
            csEvent.SetFrom(HySSysEvent.OBJID_BUSIPROCEDURE);
            ((HySEventObject)csEvent).SetFromSimKind(this.GetSimKind());
            ((HySEventObject)csEvent).SetToSimKind(this.GetSimKind());
            bRtn = ((HySDBAThreadControllerBase)m_csDBAThreadCtl).PutEvent(csEvent);
            if (!bRtn)
            {
                HySLog.LogOut(HySLog.ONLINE, "GflwBusiProcedure.PutEvent", "イベント送信失敗");
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>アダプタ作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> RsdServiceAccessAdaptor csAdaptor = CreateAdaptor() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>RsdServiceAccessAdaptor 定期河川縦横断データ管理システムアダプタクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>定期河川縦横断データ管理システムからデータ取得を行うためのアダプタを作成する</para>
        /// </remarks>
        virtual protected HySAdaptorIF CreateAdaptor()
        {
            HySWebProxy csProxy = null;

            // プロキシ情報の取得
            HySNetworkConfigManager csNetWorkConfig = new HySNetworkConfigManager();
            if (csNetWorkConfig.Initialize())
            {
                csProxy = csNetWorkConfig.GetProxy();
            }

            HySWebAccess csAccess = new HySWebAccess( );

            HySServiceAccessAdaptorBase csAdaptor = new HySServiceAccessAdaptorBase(csAccess);
            csAdaptor.SetDBAProcedure(this);

            return csAdaptor;
        }
    }
}
