// <summary>ソースコード：CSVファイル取り扱い用共通データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>１次元ＣＳＶデータ列</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/12/01][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class HySCSVFileDim1Data : HySDataRoot, HySVersionManagement
    {
        /// <summary>データ配列１</summary>
        protected long m_lDim1 = 0;

        /// <summary>データリスト</summary>
        protected HySDataLinkedList m_csDataList = new HySDataLinkedList();

        /// <summary>データのラベル </summary>
        protected HySString[] m_csLabel = null;
              
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCSVFileDim1Data csDt= new HySCSVFileDim1Data() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> HySCSVFileDim1Data 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySCSVFileDim1Data()
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>１次元ＣＳＶ形式ファイルを読み込む</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = ReadCSVFile(csFile) </para>
        /// </example>
        /// <param name="csFile">入力ファイル</param>
        /// <returns>long  >0:=正常(読み込んだレコード数), -1:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>EXCELで作成したデータ等使用する場合に必要</para>
        /// </remarks>
        public virtual long ReadCSVFile(HySFile csFile)
        {
            long lRtn = -1;
            m_csDataList.Clear();

            HySString sOut = new HySString();
            string[] sInWk;
            // 表の種別の読み込み
            if (csFile.ReadText(ref sOut) > 0)
            {   // データ有り
                try
                {
                    // ','区切りで展開する
                    sInWk = sOut.ToString().Split(',');
                    if (sInWk[0].Equals(this.GetClassName().ToString()) == false && sInWk[0].Equals("HySCSVFileData") == false)//[2010.12.16]HySCSVFileData型も読めるように追記
                    { return lRtn; }
                }
                catch
                {
                    lRtn = -1;
                }
            }
            // 時系列判断
            if (csFile.ReadText(ref sOut) > 0)
            {   // データ有り
                try
                {
                    // ','区切りで展開する
                    sInWk = sOut.ToString().Split(',');
                    if (TIME_SERIAL.Equals(sInWk[1]) == true)
                    {   // 時系列
                    }
                }
                catch
                {
                    return lRtn;
                }
            }
             
            // 表題読み込み(配列数決定)
            if (csFile.ReadText(ref sOut) > 0)
            {   // データ有り
                try
                {
                    // ','区切りで展開する
                    sInWk = sOut.ToString().Split(',');
                    m_lDim1 = sInWk.LongLength-1;
                    if (m_lDim1 < 1)
                    {
                        return lRtn;
                    }
                }
                catch
                {
                    return lRtn;
                }
            }


            // データ読み込み開始
            CSVDim1Recorde csRecord = null;
            long lclRtn = 0;
            lRtn = 0;
            for (; ; )
            {
                csRecord = new CSVDim1Recorde(m_lDim1);
                lclRtn= csRecord.ReadCSVFile(csFile);
                if (lclRtn > 0)
                {
                    m_csDataList.AddLast(csRecord);
                    lRtn += 1;
                }
                else if( lclRtn < 0 )
                {
                    lRtn = -1;
                    break;
                }
                else if (lclRtn == 0)
                {
                    break;
                }
            }
            return lRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>ＣＳＶ形式ファイルのヘッダー情報を読み込む</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = HeadInfRead(csFile) </para>
        /// </example>
        /// <param name="csFile">入力ファイル</param>
        /// <returns>long  >0:=正常, -1:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>EXCELで作成したデータ等使用する場合に必要</para>
        /// </remarks>
        public virtual long HeadInfRead(HySFile csFile)
        {
            long lRtn = -1;
            HySString sOut = new HySString();
            string[] sInWk;
            // 表の種別の読み込み
            if (csFile.ReadText(ref sOut) > 0)
            {   // データ有り
                try
                {
                    // ','区切りで展開する
                    sInWk = sOut.ToString().Split(',');
                    if (sInWk[0].Equals(this.GetClassName().ToString()) == false && sInWk[0].Equals("HySCSVFileData") == false)//[2010.12.16]HySCSVFileData型も読めるように追記
                    { return lRtn; }
                }
                catch
                {
                    lRtn = -1;
                }
            }
            // 時系列判断
            if (csFile.ReadText(ref sOut) > 0)
            {   // データ有り
                try
                {
                    // ','区切りで展開する
                    sInWk = sOut.ToString().Split(',');
                    if (TIME_SERIAL.Equals(sInWk[1]) == true)
                    {   // 時系列
                    }
                }
                catch
                {
                    return lRtn;
                }
            }
            // 表題読み込み(配列数決定)
            if (csFile.ReadText(ref sOut) > 0)
            {   // データ有り
                try
                {
                    // ','区切りで展開する
                    sInWk = sOut.ToString().Split(',');
                    m_lDim1 = sInWk.LongLength - 1;
                    if (m_lDim1 < 1)
                    {
                        return lRtn;
                    }
                    else
                    {
                        m_csLabel = new HySString[m_lDim1];
                        for (long lLp = 0; lLp < m_lDim1; lLp++)
                        {
                            m_csLabel[lLp] = new HySString(sInWk[lLp + 1]);
                        }
                    }
                }
                catch
                {
                    return lRtn;
                }
            }

            return 0;
        }

        /// <summary><para>method outline:</para>
        /// <para>クラス名を返す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csClassName = GetClassName() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString  クラス名</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySString[] GetDataLabelName()
        {
            return m_csLabel;
        }

        /// <summary><para>method outline:</para>
        /// <para>１レコード配列取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetDimention(lDim1) </para>
        /// </example>
        /// <param name="lDim1">１レコードの行数</param>
        /// <returns> 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void GetDimention(ref long lDim1)
        {
            lDim1 = m_lDim1;
        }
        /// <summary><para>method outline:</para>
        /// <para>データの時系列リスト取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataLinkedList csDtList = GetDataList() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> HySDataLinkedList データの時系列リスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDataLinkedList GetDataList()
        { return m_csDataList; }

        /// <summary><para>method outline:</para>
        /// <para>クラス名を返す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csClassName = GetClassName() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString  クラス名</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected virtual HySString GetClassName()
        {
            return new HySString("HySCSVFileDim1Data");
        }

        /// <summary><para>method outline:</para>
        /// <para>１レコード配列設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDimention(lDim1) </para>
        /// </example>
        /// <param name="lDim1">１レコードの行数</param>
        /// <returns> 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetDimention(long lDim1)
        {
            m_lDim1 = lDim1;
            m_csLabel = new HySString[m_lDim1];
            for (long lLp = 0; lLp < m_lDim1; lLp++)
            {
                m_csLabel[lLp] = new HySString("Data" + lLp.ToString());
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>ＣＳＶ形式ファイルのヘッダー情報を書き出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HeadInfWrite(csFile) </para>
        /// </example>
        /// <param name="csFile">出力ファイル</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>ファイルは書き出しモードでオープン済みであること</para>
        /// </remarks>
        public virtual void HeadInfWrite(HySFile csFile)
        {
            csFile.WriteText("HySCSVFileData,Ver1.0");  // ヘッダー
//          csFile.WriteText("データ区分, 時系列");  // ヘッダー

            // ver1.6 出力ファイル標準フォーマットの英語化
            csFile.WriteText("DataType, TimeSeries");  // ヘッダー

            String sWString = "Time";
            for (int iLp = 0; iLp < m_lDim1; iLp++)
            {
                sWString += ", " + m_csLabel[iLp].ToString();
            }
            csFile.WriteText(sWString);
        }
        
        /* 将来用
        public virtual long WriteCSVFile(HySFile csFile);
        public virtual void SetDataLabelName(HySString[] csLabelName);
        public virtual void AddData(CSVDim1Recorde)
        */

        /// <summary> 時系列判断文字列 </summary>
        public readonly string TIME_SERIAL = "TimeSeries";

        /// <summary><para>class outline:</para>
        /// <para>２次元ＣＳＶ１レコード分のデータ</para>
        /// </summary>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        /// <remarks><para>history:</para>
        /// <para>[CommonMP][ver 1.0.0][2009/12/01][新規作成]</para>
        /// </remarks>
        [Serializable]
        public class CSVDim1Recorde : HySDataRoot, HySVersionManagement
        {
            /// <summary>レコードの時刻</summary>
            protected HySTime m_csTime = null;
            /// <summary> 行データ（列数分の配列） </summary>
            protected double[] m_dData = null;

            /// <summary><para>method outline:</para>
            /// <para>デフォルトコンストラクタ</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> 使用禁止 </para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns> CSVDim1Recorde 生成されたクラスのインスタンス</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>使用禁止</para>
            /// </remarks>
            protected CSVDim1Recorde()
            { 
                //バージョン情報設定
                SetNowVersion();
            }
            /// <summary><para>method outline:</para>
            /// <para>コンストラクタ</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> CSVDim1Recorde csDt= new CSVDim1Recorde(lDim1) </para>
            /// </example>
            /// <param name="lDim1">１レコードの行数</param>
            /// <returns> CSVDim1Recorde 生成されたクラスのインスタンス</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public CSVDim1Recorde(long lDim1)
            {
                //バージョン情報設定
                SetNowVersion();
                m_dData = new double[lDim1];

            }
            /// <summary><para>method outline:</para>
            /// <para>１行分のデータ読み込み</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> double[] csDt= ReadCSVFile() </para>
            /// </example>
            /// <param name="csFile">CSVファイル</param>
            /// <returns> long =1:データ有り、 =0:データ無し、=-1:異常</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public virtual long ReadCSVFile(HySFile csFile)
            {
                long lRtn = 0;
                HySString sOut = new HySString();
                string[] sInWk;
                if (csFile.ReadText(ref sOut) > 0)
                {   // データ有り
                    lRtn = 1;
                    try
                    {
                        // ','区切りで展開する
                        sInWk = sOut.ToString().Split(',');
                        m_csTime = HySCalendar.CreateTime(sInWk[0]);
                        if (m_csTime == null) { lRtn = -1; return lRtn; }
                        for (int lP = 0; lP < m_dData.Length; lP++)
                        {
                            if (lP + 1 < sInWk.Length)
                            {
                                m_dData[lP] = double.Parse(sInWk[lP + 1]);
                            }
                            else
                            {
                                m_dData[lP] = 0.0;
                            }
                        }
                    }
                    catch
                    {
                        lRtn = -1;
                    }
                }
                return lRtn;
            }
            /// <summary><para>method outline:</para>
            /// <para>レコードの時刻取得</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> HySTime csTm= GetTime() </para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns> HySTime レコードの時刻</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public virtual HySTime GetTime()
            { return m_csTime; }
            /// <summary><para>method outline:</para>
            /// <para>１レコード分のデータ取得</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> CSVRowData[] csDt= GetData() </para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns> CSVRowData[] １レコード分のデータ</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public virtual double[] GetData()
            { return m_dData; }

            // ================================================
            //   バージョンアップ時の下位互換性を保つ為の処理
            // ================================================
            /// <summary>保存バージョン情報</summary>
            private string m_sDecodedVersion;
            /// <summary><para>method outline:</para>
            /// <para>バージョン情報取得</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> string sDecodedVersion = GetDecodedVersion()</para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>string 保存バージョン情報</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>メンバー変数に設定されているバージョン情報を返す</para>
            /// </remarks>
            public string GetDecodedVersion()
            {
                return m_sDecodedVersion;
            }
            /// <summary><para>method outline:</para>
            /// <para>バージョン情報取得</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> string sVersion = GetNowVersion()</para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>string 現在のバージョン情報</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public string GetNowVersion()
            {
                return "1.00";
            }
            /// <summary><para>method outline:</para>
            /// <para>バージョン情報設定</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> SetNowVersion()</para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>無し</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>現在のバージョン情報をメンバー変数に設定する</para>
            /// </remarks>
            public void SetNowVersion()
            {
                m_sDecodedVersion = GetNowVersion();
            }
             /// <summary><para>method outline:</para>
            /// <para>復元後の整合性確保処理</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> PostDeserialize( ) </para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>無し</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
            /// バージョンによって変数等追加がない場合には、実装の必要がない
            /// </para>
            /// </remarks>
            public virtual void PostDeserialize()
            {
                if (GetDecodedVersion() != GetNowVersion())
                {
                    if (GetDecodedVersion() == null)
                    {
                        //旧バージョンからの移行処理を入れる
                    }
                    else
                    {
                        //旧バージョンから順にバージョンを上げて行く
                        switch (GetDecodedVersion())
                        {
                            case "1.00":
                                break;
                        }                       
                    }
                    SetNowVersion();
                }
            } 
            /// <summary><para>method outline:</para>
            /// <para>逆シリアル化時追加処理</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
            /// </example>
            /// <param name="csObj">ダミー</param>
            /// <returns>無し</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>予約処理</para>
            /// </remarks>
            void IDeserializationCallback.OnDeserialization(Object csObj)
            {
                PostDeserialize();
            }

        }
 
 
        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
    //
}
