// <summary>ソースコード：CSVファイル取り扱い用共通データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>３次元ＣＳＶデータ列</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/02/09][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class HySCSVFileDim3Data : HySDataRoot, HySVersionManagement
    {
        /// <summary>データ配列１</summary>
        protected long m_lDim1 = 0;
        /// <summary>データ配列２</summary>
        protected long m_lDim2 = 0;
        /// <summary>データ配列３</summary>
        protected long m_lDim3 = 0;


        /// <summary>データリスト</summary>
        protected HySDataLinkedList m_csDataList = new HySDataLinkedList();

              
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCSVFileDim3Data csDt= new HySCSVFileDim3Data() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> HySCSVFileDim3Data 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySCSVFileDim3Data()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>３次元ＣＳＶ形式ファイルを読み込む</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = ReadCSVFile(csFile) </para>
        /// </example>
        /// <param name="csFile">入力ファイル</param>
        /// <returns>long  >0:=正常(読み込んだレコード数), -1:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>EXCELで作成したデータ等使用する場合に必要</para>
        /// </remarks>
        public virtual long ReadCSVFile(HySFile csFile)
        {
            long lRtn = -1;
            m_csDataList.Clear();

            HySString sOut = new HySString();
            string[] sInWk;
            // 表の種別の読み込み
            if (csFile.ReadText(ref sOut) > 0)
            {   // データ有り
                try
                {
                    // ','区切りで展開する
                    sInWk = sOut.ToString().Split(',');
                    if (sInWk[0].Equals(this.GetClassName().ToString()) == false)
                    { return lRtn; }
                }
                catch
                {
                    lRtn = -1;
                }
            }
            // 時系列判断
            if (csFile.ReadText(ref sOut) > 0)
            {   // データ有り
                try
                {
                    // ','区切りで展開する
                    sInWk = sOut.ToString().Split(',');
                    if (TIME_SERIAL.Equals(sInWk[1]) == true)
                    {   // 時系列
                    }
                }
                catch
                {
                    return lRtn;
                }
            }
            // 配列数読み込み
            if (csFile.ReadText(ref sOut) > 0)
            {   // データ有り
                try
                {
                    // ','区切りで展開する
                    sInWk = sOut.ToString().Split(',');
                    m_lDim1 = Convert.ToInt32(sInWk[1]);
                    m_lDim2 = Convert.ToInt32(sInWk[3]);
                    m_lDim3 = Convert.ToInt32(sInWk[5]);
                }
                catch
                {
                    return lRtn;
                }
            }
            // 表題読み込み
            if (csFile.ReadText(ref sOut) > 0)
            {   // データ有り
            }
            // データ読み込み開始
            CSVDim3Recorde csRecord = null;
            long lclRtn = 0;
            lRtn = 0;
            for (; ; )
            {
                csRecord = new CSVDim3Recorde(m_lDim1, m_lDim2, m_lDim3);
                lclRtn= csRecord.ReadCSVFile(csFile);
                if (lclRtn > 0)
                {
                    m_csDataList.AddLast(csRecord);
                    lRtn += 1;
                }
                else if( lclRtn < 0 )
                {
                    lRtn = -1;
                    break;
                }
                else if (lclRtn == 0)
                {
                    break;
                }
            }
            return lRtn;
        }
               
        /// <summary><para>method outline:</para>
        /// <para>ＣＳＶ形式ファイルのヘッダー情報を読み込む</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = HeadInfRead(csFile) </para>
        /// </example>
        /// <param name="csFile">入力ファイル</param>
        /// <returns>long  >0:=正常, -1:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>EXCELで作成したデータ等使用する場合に必要</para>
        /// </remarks>
        public virtual long HeadInfRead(HySFile csFile)
        {
            long lRtn = -1;

            HySString sOut = new HySString();
            string[] sInWk;
            // 表の種別の読み込み
            if (csFile.ReadText(ref sOut) > 0)
            {   // データ有り
                try
                {
                    // ','区切りで展開する
                    sInWk = sOut.ToString().Split(',');
                    if (sInWk[0].Equals(this.GetClassName().ToString()) == false)
                    { return lRtn; }
                }
                catch
                {
                    lRtn = -1;
                }
            }
            // 時系列判断
            if (csFile.ReadText(ref sOut) > 0)
            {   // データ有り
                try
                {
                    // ','区切りで展開する
                    sInWk = sOut.ToString().Split(',');
                    if (TIME_SERIAL.Equals(sInWk[1]) == true)
                    {   // 時系列
                    }
                }
                catch
                {
                    return lRtn;
                }
            }
            // 配列数読み込み
            if (csFile.ReadText(ref sOut) > 0)
            {   // データ有り
                try
                {
                    // ','区切りで展開する
                    sInWk = sOut.ToString().Split(',');
                    m_lDim1 = Convert.ToInt32(sInWk[1]);
                    m_lDim2 = Convert.ToInt32(sInWk[3]);
                    m_lDim3 = Convert.ToInt32(sInWk[5]);
                }
                catch
                {
                    return lRtn;
                }
            }
            // 表題読み込み
            if (csFile.ReadText(ref sOut) > 0)
            {   // データ有り
            }
 
            return 0;
        }
        /// <summary><para>method outline:</para>
        /// <para>１レコード配列取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetDimention(lDim1,lDim2,lDim3) </para>
        /// </example>
        /// <param name="lDim1">１レコードの行数</param>
        /// <param name="lDim2">１レコードの列数</param>
        /// <param name="lDim3">１レコードの高さ数</param>
        /// <returns> 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void GetDimention(ref long lDim1, ref long lDim2, ref long lDim3)
        {
            lDim1 = m_lDim1;
            lDim2 = m_lDim2;
            lDim3 = m_lDim3;
        }
        /// <summary><para>method outline:</para>
        /// <para>データの時系列リスト取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataLinkedList csDtList = GetDataList() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> HySDataLinkedList データの時系列リスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDataLinkedList GetDataList()
        { return m_csDataList; }

        /// <summary><para>method outline:</para>
        /// <para>クラス名を返す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csClassName = GetClassName() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString  クラス名</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected virtual HySString GetClassName()
        {
            return new HySString("HySCSVFileDim3Data");
        }

        /* 将来用
        /// <summary><para>method outline:</para>
        /// <para>１レコード配列設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDimention(lDim1,lDim2) </para>
        /// </example>
        /// <param name="lDim1">１レコードの行数</param>
        /// <param name="lDim2">１レコードの列数</param>
        /// <param name="lDim3">１レコードの高さ数</param>
        /// <returns> 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetDimention(long lDim1, long lDim2, long lDim3)
        {
            m_lDim1 = lDim1;
            m_lDim2 = lDim2;
            m_lDim3 = lDim3;
        }
        /// <summary><para>method outline:</para>
        /// <para>ＣＳＶ形式ファイルのヘッダー情報を書き出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HeadInfWrite(csFile) </para>
        /// </example>
        /// <param name="csFile">出力ファイル</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>ファイルは書き出しモードでオープン済みであること</para>
        /// </remarks>
        public virtual void HeadInfWrite(HySFile csFile)
        {
            // ３次元時系列データならば
            csFile.WriteText("HySCSVFileDim3Data,Ver1.0");  // ヘッダー
            csFile.WriteText("データ区分, 時系列");  // ヘッダー

            csFile.WriteText("配列数," + m_lDim1.ToString()
                                            + ",×," + m_lDim2.ToString()
                                            + ",×," + m_lDim3.ToString());  // ヘッダー
            csFile.WriteText("Time, Data");  // ヘッダー
        }

        public virtual long WriteCSVFile(HySFile csFile);
        public virtual void AddData(CSVDim3Recorde)
        */

        /// <summary> 時系列判断文字列 </summary>
        public readonly string TIME_SERIAL = "TimeSeries";

        /// <summary><para>class outline:</para>
        /// <para>３次元ＣＳＶ１レコード分のデータ</para>
        /// </summary>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        /// <remarks><para>history:</para>
        /// <para>[CommonMP][ver 1.0.0][2010/02/09][新規作成]</para>
        /// </remarks>
        [Serializable]
        public class CSVDim3Recorde : HySDataRoot
        {
            /// <summary>レコードの時刻</summary>
            protected HySTime m_csTime = null;
            /// <summary> 行データ（列数分の配列） </summary>
            protected CSVDim2Recorde[] m_dDim2RowData = null;

            /// <summary><para>method outline:</para>
            /// <para>デフォルトコンストラクタ</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> 使用禁止 </para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns> CSVDim3Recorde 生成されたクラスのインスタンス</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>使用禁止</para>
            /// </remarks>
            protected CSVDim3Recorde()
            { }
            /// <summary><para>method outline:</para>
            /// <para>コンストラクタ</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> CSVDim3Recorde csDt= new CSVDim3Recorde(lDim1,lDim2,lDim3) </para>
            /// </example>
            /// <param name="lDim1">１レコードの行数</param>
            /// <param name="lDim2">１レコードの列数</param>
            /// <param name="lDim3">１レコードのセル数</param>
            /// <returns> CSVDim3Recorde 生成されたクラスのインスタンス</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public CSVDim3Recorde(long lDim1, long lDim2, long lDim3)
            {
                m_dDim2RowData = new CSVDim2Recorde[lDim3];
                for (long lP = 0; lP < lDim3; lP++)
                {

                    m_dDim2RowData[lP] = new CSVDim2Recorde(lDim1,lDim2);
                }
            }
            /// <summary><para>method outline:</para>
            /// <para>１レコード分のデータ読み込み</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> double[] csDt= ReadCSVFile() </para>
            /// </example>
            /// <param name="csFile">CSVファイル</param>
            /// <returns> long =1:データ有り、 =0:データ無し、=-1:異常</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public virtual long ReadCSVFile(HySFile csFile)
            {
                long lRtn = 0;
                long lclRtn = 0;
                HySString sOut = new HySString();
                string[] sInWk;

                if (csFile.ReadText(ref sOut) > 0)
                {   // データ有り
                    lRtn = 1;
                    try
                    {
                        // ','区切りで展開する
                        sInWk = sOut.ToString().Split(',');
                        m_csTime = HySCalendar.CreateTime(sInWk[0]);
                        if (m_csTime == null) { lRtn = -1; return lRtn; }
                        for (int lP = 0; lP < m_dDim2RowData.Length; lP++)
                        {
                            lclRtn = m_dDim2RowData[lP].ReadCSVFile(csFile);
                            if (lclRtn < 1)
                            {
                                lRtn = lclRtn;
                                break;
                            }
                        }
                    }
                    catch
                    {
                        lRtn = -1;
                    }
                }
                return lRtn;
            }
            /// <summary><para>method outline:</para>
            /// <para>レコードの時刻取得</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> HySTime csTm= GetTime() </para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns> HySTime レコードの時刻</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public virtual HySTime GetTime()
            { return m_csTime; }
            /// <summary><para>method outline:</para>
            /// <para>１レコード分のデータ取得</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> CSVRowData[] csDt= GetData() </para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns> CSVRowData[] １レコード分のデータ</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public virtual CSVDim2Recorde[] GetData()
            { return m_dDim2RowData; }


        /// <summary><para>class outline:</para>
        /// <para>２次元ＣＳＶ１レコード分のデータ</para>
        /// </summary>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        /// <remarks><para>history:</para>
        /// <para>[CommonMP][ver 1.0.0][2009/12/01][新規作成]</para>
        /// </remarks>
            [Serializable]
            public class CSVDim2Recorde : HySDataRoot
            {
                ///// <summary>レコードの時刻</summary>
                //protected HySTime m_csTime = null;

                /// <summary> 行データ（列数分の配列） </summary>
                protected CSVRowData[] m_dRowData = null;

                /// <summary><para>method outline:</para>
                /// <para>デフォルトコンストラクタ</para>
                /// </summary>
                /// <example><para>usage:</para>
                /// <para> 使用禁止 </para>
                /// </example>
                /// <param name="">無し</param>
                /// <returns> CSVDim2Recorde 生成されたクラスのインスタンス</returns>
                /// <exception cref="">無し</exception>
                /// <remarks><para>remarks:</para>
                /// <para>使用禁止</para>
                /// </remarks>
                protected CSVDim2Recorde()
                { }
                /// <summary><para>method outline:</para>
                /// <para>コンストラクタ</para>
                /// </summary>
                /// <example><para>usage:</para>
                /// <para> CSVDim2Recorde csDt= new CSVDim2Recorde(lDim1,lDim2) </para>
                /// </example>
                /// <param name="lDim1">１レコードの行数</param>
                /// <param name="lDim2">１レコードの列数</param>
                /// <returns> CSVDim2Recorde 生成されたクラスのインスタンス</returns>
                /// <exception cref="">無し</exception>
                /// <remarks><para>remarks:</para>
                /// <para>無し</para>
                /// </remarks>
                public CSVDim2Recorde(long lDim1, long lDim2)
                {
                    m_dRowData = new CSVRowData[lDim2];
                    for (long lP = 0; lP < lDim2; lP++)
                    {
                        m_dRowData[lP] = new CSVRowData(lDim1);
                    }
                }
                /// <summary><para>method outline:</para>
                /// <para>１レコード分のデータ読み込み</para>
                /// </summary>
                /// <example><para>usage:</para>
                /// <para> double[] csDt= ReadCSVFile() </para>
                /// </example>
                /// <param name="csFile">CSVファイル</param>
                /// <returns> long =1:データ有り、 =0:データ無し、=-1:異常</returns>
                /// <exception cref="">無し</exception>
                /// <remarks><para>remarks:</para>
                /// <para>無し</para>
                /// </remarks>
                public virtual long ReadCSVFile(HySFile csFile)
                {
                    long lRtn = 1;
                    long lclRtn = 0;

                    try
                    {
                        for (int lP = 0; lP < m_dRowData.Length; lP++)
                        {
                            lclRtn = m_dRowData[lP].ReadCSVFile(csFile);
                            if (lclRtn < 1)
                            {
                                lRtn = lclRtn;
                                break;
                            }
                        }
                    }
                    catch
                    {
                        lRtn = -1;
                    }
                    return lRtn;
                }

                /// <summary><para>method outline:</para>
                /// <para>１レコード分のデータ取得</para>
                /// </summary>
                /// <example><para>usage:</para>
                /// <para> CSVRowData[] csDt= GetData() </para>
                /// </example>
                /// <param name="">無し</param>
                /// <returns> CSVRowData[] １レコード分のデータ</returns>
                /// <exception cref="">無し</exception>
                /// <remarks><para>remarks:</para>
                /// <para>無し</para>
                /// </remarks>
                public virtual CSVRowData[] GetData()
                { return m_dRowData; }

                /// <summary><para>class outline:</para>
                /// <para>２次元ＣＳＶ１行分のデータ</para>
                /// </summary>
                /// <remarks><para>remarks:</para>
                /// <para>無し</para>
                /// </remarks>
                /// <remarks><para>history:</para>
                /// <para>[CommonMP][ver 1.0.0][2009/12/01][新規作成]</para>
                /// </remarks>
                [Serializable]
                public class CSVRowData : HySDataRoot
                {
                    /// <summary>１行分のデータ</summary>
                    protected double[] m_dData = null;

                    /// <summary><para>method outline:</para>
                    /// <para>デフォルトコンストラクタ</para>
                    /// </summary>
                    /// <example><para>usage:</para>
                    /// <para> 使用禁止 </para>
                    /// </example>
                    /// <param name="">無し</param>
                    /// <returns> CSVRowData 生成されたクラスのインスタンス</returns>
                    /// <exception cref="">無し</exception>
                    /// <remarks><para>remarks:</para>
                    /// <para>使用禁止</para>
                    /// </remarks>
                    protected CSVRowData()
                    { }
                    /// <summary><para>method outline:</para>
                    /// <para>コンストラクタ</para>
                    /// </summary>
                    /// <example><para>usage:</para>
                    /// <para> CSVRowData csDt= new CSVRowData(lDim) </para>
                    /// </example>
                    /// <param name="lDim">１行分のデータ数</param>
                    /// <returns> CSVRowData 生成されたクラスのインスタンス</returns>
                    /// <exception cref="">無し</exception>
                    /// <remarks><para>remarks:</para>
                    /// <para>無し</para>
                    /// </remarks>
                    public CSVRowData(long lDim)
                    {
                        m_dData = new double[lDim];
                    }
                    /// <summary><para>method outline:</para>
                    /// <para>１行分のデータ読み込み</para>
                    /// </summary>
                    /// <example><para>usage:</para>
                    /// <para> double[] csDt= ReadCSVFile() </para>
                    /// </example>
                    /// <param name="csFile">CSVファイル</param>
                    /// <returns> long =1:データ有り、 =0:データ無し、=-1:異常</returns>
                    /// <exception cref="">無し</exception>
                    /// <remarks><para>remarks:</para>
                    /// <para>無し</para>
                    /// </remarks>
                    public virtual long ReadCSVFile(HySFile csFile)
                    {
                        long lRtn = 0;
                        HySString sOut = new HySString();
                        string[] sInWk;
                        if (csFile.ReadText(ref sOut) > 0)
                        {   // データ有り
                            lRtn = 1;
                            try
                            {
                                // ','区切りで展開する
                                sInWk = sOut.ToString().Split(',');
                                for (int lP = 0; lP < m_dData.Length; lP++)
                                {
                                    //if (lP + 1 < sInWk.Length)    //mod 20100316
                                    if (lP + 2 < sInWk.Length)
                                    {
                                        //m_dData[lP] = double.Parse(sInWk[lP + 1]);    //mod 20100316
                                        m_dData[lP] = double.Parse(sInWk[lP + 2]);
                                    }
                                    else
                                    {
                                        m_dData[lP] = 0.0;
                                    }
                                }
                            }
                            catch
                            {
                                lRtn = -1;
                            }
                        }
                        return lRtn;
                    }
                    /// <summary><para>method outline:</para>
                    /// <para>１行分のデータ取得</para>
                    /// </summary>
                    /// <example><para>usage:</para>
                    /// <para> double[] csDt= GetData() </para>
                    /// </example>
                    /// <param name="">無し</param>
                    /// <returns> double[] １行分のデータ</returns>
                    /// <exception cref="">無し</exception>
                    /// <remarks><para>remarks:</para>
                    /// <para>無し</para>
                    /// </remarks>
                    public virtual double[] GetData()
                    { return m_dData; }
                }

            }
            //
        }
        //
 
        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public virtual string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public virtual void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
    }
    //
}
