﻿// <summary>ソースコード：河道縦断面グラフデータクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;


namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>表示データ列</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// </remarks>
    [Serializable]
    public abstract class HySGraphDataPair : HySDataRoot, HySVersionManagement
    {
        /// <summary>ベースデータリスト </summary>
        protected HySLinkedListDouble m_csBaseList = new HySLinkedListDouble();
        /// <summary>データリスト </summary>
        protected HySLinkedListDouble m_csDataList = new HySLinkedListDouble();

        /// <summary>ベースデータ配列（ワーク用） </summary>
        protected double[] m_dBaseDim = null;
        /// <summary>データ配列（ワーク用） </summary>
        protected double[] m_dDataDim = null;

               
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGraphDataPair csDt= new HySGraphDataPair() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> HySGraphDataPair 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGraphDataPair()
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>データ対設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AddData(dBaseDt,dDt) </para>
        /// </example>
        /// <param name="dBaseDt">ベース側データ</param>
        /// <param name="dDt">データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void AddData(double dBaseDt, double dDt)
        {
            m_csBaseList.AddLast(dBaseDt);
            m_csDataList.AddLast(dDt);
        }

        /// <summary><para>method outline:</para>
        /// <para>データ数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lNum = GetDataNum( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long データ数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetDataNum()
        {
            return m_csDataList.GetCount();
        }
        /// <summary><para>method outline:</para>
        /// <para>ベース側データ配列取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> double[] dData = GetBaseDim( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>double[] ベース側データ配列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>参照のみ</para>
        /// </remarks>
        public virtual double[] GetBaseDim()
        {
            long lDtNum = m_csBaseList.GetCount();
            m_dBaseDim = new double[lDtNum];
            m_csBaseList.SetCursorFirst(); // カーソルを先頭に設定
            for (long lP = 0; lP < lDtNum; lP++)
            {  // データ件数分繰り返す
                m_dBaseDim[(int)lP] = m_csBaseList.GetCursorData(); // データ取得
                m_csBaseList.MoveCursorNext(); // 次へ
            }
            return m_dBaseDim;
        }
        /// <summary><para>method outline:</para>
        /// <para>データ配列取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> double[] dData = GetDataDim( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>double[] データ配列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>参照のみ</para>
        /// </remarks>
        public virtual double[] GetDataDim()
        {
            long lDtNum = m_csDataList.GetCount();
            m_dDataDim = new double[lDtNum];
            m_csDataList.SetCursorFirst();
            for (long lP = 0; lP < lDtNum; lP++)
            {  // データ件数分繰り返す
                m_dDataDim[(int)lP] = m_csDataList.GetCursorData(); // データ取得
                m_csDataList.MoveCursorNext(); // 次へ
            }
            return m_dDataDim;
        }
        /// <summary><para>method outline:</para>
        /// <para>データ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetData( lOrderNo, ref dBaseDt, ref dDt) </para>
        /// </example>
        /// <param name="lOrderNo">データ並び位置</param>
        /// <param name="dBaseDt">ベース側</param>
        /// <param name="dDt">データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void GetData(long lOrderNo, ref double dBaseDt, ref double dDt)
        {
            long lP;
            long lDtNum;
           
            // 初期化
            lDtNum = m_csBaseList.GetCount();
            if (lOrderNo <= 0 || lDtNum < lOrderNo)
            {  // データ並び位置が範囲外の場合
                dDt = -1.0E32;
            }
            else
            {  // データ並び位置が範囲内の場合
                m_csBaseList.SetCursorFirst();
                for (lP = 0; lP < lOrderNo; lP++)
                {  // データ件数分繰り返す
                    dBaseDt = m_csBaseList.GetCursorData(); // データ取得
                    m_csBaseList.MoveCursorNext(); // 次へ
                }
                lDtNum = m_csDataList.GetCount();
                m_csDataList.SetCursorFirst();
                for (lP = 0; lP < lOrderNo; lP++)
                {  // データ件数分繰り返す
                    dDt = m_csDataList.GetCursorData(); // データ取得
                    m_csDataList.MoveCursorNext(); // 次へ
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>データのクリア</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ClearData( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void ClearData()
        {
            m_csBaseList.Clear();
            m_csDataList.Clear();
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public  string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public  string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public  void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public  virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                if (GetDecodedVersion() == null)
                {
                    // 旧バージョンからの移行処理を入れる
                }
                else
                {
                    //旧バージョンから順にバージョンを上げて行く
                    switch (GetDecodedVersion())
                    {
                        case "1.00":
                            {
                                // 旧バージョンからの移行処理を入れる
                                break;
                            }
                        //case "2.00": << 以後バージョンアップに伴って処理追加
                        //{
                        //    break;
                        //}
                    }                    
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }

    }
}
