﻿// <summary>ソースコード：ＨＱ　グラフデータクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;


namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＱ　グラフデータ</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class HySGraphHQ : HySGraphDataPair, HySVersionManagement
    {
        /// <summary>地点識別子 </summary>
        protected HySID m_csGeoPosID;
        /// <summary>地点位置 </summary>
        protected HySGeoPoint m_csPosition;
        /// <summary>地点名 </summary>
        protected HySString m_csPositionName;
        /// <summary>河口からの距離 </summary>
        protected double m_csAltitudeKilo = 0.0;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> 使用禁止 </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> HySGraphHQ 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        protected HySGraphHQ()
        {
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGraphHQ csData = new HySGraphHQ(csGePosID); </para>
        /// </example>
        /// <param name="csGePosID">地点識別子</param>
        /// <returns> HySGraphHQ 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGraphHQ(HySID csGePosID)
        {
            m_csGeoPosID = (HySID)csGePosID;
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>地点識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csIdentifier = GetGeoPosID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySID 地点識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySID GetGeoPosID()
        {
            return m_csGeoPosID;
        }

        /// <summary><para>method outline:</para>
        /// <para>地点位置設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetPosition( csPosition ) </para>
        /// </example>
        /// <param name="csPosition">地点位置座標</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetPosition(HySGeoPoint csPosition)
        {
            m_csPosition = csPosition;
        }
        /// <summary><para>method outline:</para>
        /// <para>地点位置取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGeoPoint csPosition = GetPosition( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySGeoPoint 地点位置</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGeoPoint GetPosition()
        {
            return m_csPosition;
        }

        /// <summary><para>method outline:</para>
        /// <para>地点名称設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetPositionName( csPositionName ) </para>
        /// </example>
        /// <param name="csPositionName">地点名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetPositionName(HySString csPositionName)
        {
            m_csPositionName = csPositionName.Clone();
        }
        /// <summary><para>method outline:</para>
        /// <para>地点名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csPositionName = GetPositionName( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString 地点名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetPositionName()
        {
            return m_csPositionName;
        }

        /// <summary><para>method outline:</para>
        /// <para>河口からの距離設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetAltitudeKilo( csAltitudeKilo ) </para>
        /// </example>
        /// <param name="csAltitudeKilo">河口からの距離</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetAltitudeKilo(double csAltitudeKilo)
        {
            m_csAltitudeKilo = csAltitudeKilo;
        }
        /// <summary><para>method outline:</para>
        /// <para>河口からの距離取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> double csAltitudeKilo = GetcsAltitudeKilo( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>double 河口からの距離</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public double GetcsAltitudeKilo()
        {
            return m_csAltitudeKilo;
        }

        /// <summary><para>method outline:</para>
        /// <para>流量・水位データ追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>AddHQData( dQ , dH ) </para>
        /// </example>
        /// <param name="dQ">流量</param>
        /// <param name="dH">水位</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void AddHQData(double dQ, double dH)
        {
            base.AddData(dQ, dH);
        }
        /// <summary><para>method outline:</para>
        /// <para>流量・水位データ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetHQData( lOrderNo, ref dQ, ref dH ) </para>
        /// </example>
        /// <param name="lOrderNo">データ並び位置</param>
        /// <param name="dQ">流量</param>
        /// <param name="dH">水位</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void GetHQData(long lOrderNo, ref double dQ, ref double dH)
        {
            base.GetData(lOrderNo, ref dQ, ref dH);
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {
            base.PostDeserialize();

            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /*
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
        */
    }
}
