﻿// <summary>ソースコード：河道縦断面グラフデータクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;


namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>河道データ列</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class HySGraphLineLaneKilo : HySGraphDataPair, HySTimeRecordIF, HySVersionManagement
    {
        /*
        /// <summary>河口からの距離 </summary>
        protected HySLinkedListDouble m_csBaseList = new HySLinkedListDouble();
        /// <summary>データリスト </summary>
        protected HySLinkedListDouble m_csDataList = new HySLinkedListDouble();
        */

        /// <summary>保持データ種別</summary>
        public HySObjectKind m_csDataKind = null;

        /*
        /// <summary>河口からの距離データ配列（ワーク用） </summary>
        protected double[] m_dBaseDim = null;
        /// <summary>データ配列（ワーク用） </summary>
        protected double[] m_dDataDim = null;
        */

        //============　時刻情報　================
        /// <summary>時刻</summary>
        protected HySTime m_csTime = HySTime.DEFAULT_TIME.Clone();

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> 使用禁止 </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> HySGraphLineLaneKilo 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        protected HySGraphLineLaneKilo()
        {
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGraphLineLaneKilo csData = new HySGraphLineLaneKilo(csDataKind); </para>
        /// </example>
        /// <param name="csDataKind">データの種別</param>
        /// <returns> HySGraphLineLaneKilo 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGraphLineLaneKilo(HySObjectKind csDataKind)
        {
            m_csDataKind = csDataKind.Clone();
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>データの種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySObjectKind csDtMeaning = GetDataMeaning() </para>
        /// </example>
        /// <param name="">無し</param> 
        /// <returns>HySObjectKind データの意味</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySObjectKind GetDataMeaning()
        {
            return m_csDataKind;
        }


        /// <summary><para>method outline:</para>
        /// <para>データ対設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AddKiloHyData(dKilo,dDt) </para>
        /// </example>
        /// <param name="dKilo">河口からの距離</param>
        /// <param name="dDt">データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void AddKiloHyData(double dKilo, double dDt)
        {
            base.AddData(dKilo, dDt);
        }
        /// <summary><para>method outline:</para>
        /// <para>データ対設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AddData(dDt) </para>
        /// </example>
        /// <param name="dDt">データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void AddData(double dDt)
        {
            m_csDataList.AddLast(dDt);
        }
        
        /*
        /// <summary><para>method outline:</para>
        /// <para>データ数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetDataNum( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>データ数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetDataNum()
        {
            return m_csDataList.GetCount();
        }
        */
        /// <summary><para>method outline:</para>
        /// <para>河口からの距離データ配列取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> double[] dData = GetKiloDataDim( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>double[] 河口からの距離データ配列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>参照のみ</para>
        /// </remarks>
        public virtual double[] GetKiloDataDim()
        {
            return base.GetBaseDim();
        }
        /*
        /// <summary><para>method outline:</para>
        /// <para>データ配列取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetDataDim( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>double[] データ配列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>参照のみ</para>
        /// </remarks>
        public virtual double[] GetDataDim()
        {
            long lDtNum = m_csDataList.GetCount();
            m_dDataDim = new double[lDtNum];
            // m_dDataDim に　m_csDataListの中身を入れていく
            return m_dDataDim;
        }
        /// <summary><para>method outline:</para>
        /// <para>データ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetData( ref dKilo, ref dDt) </para>
        /// </example>
        /// <param name="lOrderNo">データ並び位置</param>
        /// <param name="dKilo">河口からの距離</param>
        /// <param name="dDt">データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void GetData(long lOrderNo, ref double dKilo, ref double dDt)
        {

        }
        */
        /// <summary><para>method outline:</para>
        /// <para>データ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetData( lOrderNo, ref dDt) </para>
        /// </example>
        /// <param name="lOrderNo">データ並び位置</param>
        /// <param name="dDt">データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void GetData(long lOrderNo,ref double dDt)
        {
            long lDtNum = m_csDataList.GetCount();
            if (lOrderNo <= 0 || lDtNum < lOrderNo)
            {  // データ並び位置が範囲外の場合
                dDt = -1.0E32; 
            }
            else
            {  // データ並び位置が範囲内の場合
                m_csDataList.SetCursorFirst();
                for (long lP = 0; lP < lOrderNo; lP++)
                {  // データ件数分繰り返す
                    dDt = m_csDataList.GetCursorData(); // データ取得
                    m_csDataList.MoveCursorNext(); // 次へ
                }
            }
        }

        /*
        /// <summary><para>method outline:</para>
        /// <para>データのクリア</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ClearData( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void ClearData()
        {

        }
        */

        /// <summary><para>method outline:</para>
        /// <para>時刻設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetTime(csTime) </para>
        /// </example>
        /// <param name="csTime">時刻</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetTime(HySTime csTime)
        {
            m_csTime.SetTime(csTime);
        }
        /// <summary><para>method outline:</para>
        /// <para>時刻取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTime csTime = GetTime() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySTime 時刻</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySTime GetLastTime()
        {
            return m_csTime;
        }

        /// <summary><para>method outline:</para>
        /// <para>日付時刻比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = EqualTime(csTime) </para>
        /// </example>
        /// <param name="csTime">比較用日付管理クラスオブジェクト(HySTime)</param>
        /// <returns>bool  =HySTime の現在時刻が 引数：Date と同じ場合は true、そうでない場合は false
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool EqualTime(HySTime csTime)
        {
            bool bRtn = false;
            if (m_csTime != null)
            {
                bRtn = m_csTime.Equals(csTime);
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>指定時刻よりも後か</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = After(csTime) </para>
        /// </example>
        /// <param name="csTime">
        /// 比較用日付管理クラスオブジェクト(HySTime)
        /// </param>
        /// <returns>bool  =HySTime の現在時刻が 引数：Date の時刻よりあとの場合は true、そうでない場合は false </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool After(HySTime csTime)
        {
            bool bRtn = false;
            if (m_csTime != null)
            {
                bRtn = m_csTime.After(csTime);
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>指定時刻よりも前か</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = Before(csTime) </para>
        /// </example>
        /// <param name="csTime">比較用日付管理クラスオブジェクト(HySTime)</param>
        /// <returns>
        /// bool　判定結果
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>bool  =HySTime の現在時刻が 引数：Date の時刻より前の場合は true、そうでない場合は false</para>
        /// </remarks>
        public virtual bool Before(HySTime csTime)
        {
            bool bRtn = false;
            if (m_csTime != null)
            {
                bRtn = m_csTime.Before(csTime);
            }
            return bRtn;
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {
            base.PostDeserialize();

            if (GetDecodedVersion() != GetNowVersion())
            {
                if (GetDecodedVersion() == null)
                {
                    // 旧バージョンからの移行処理を入れる
                }
                else
                {
                    //旧バージョンから順にバージョンを上げて行く
                    switch (GetDecodedVersion())
                    {
                        case "1.00":
                            {
                                // 旧バージョンからの移行処理を入れる
                                break;
                            }
                        //case "2.00": << 以後バージョンアップに伴って処理追加
                        //{
                        //    break;
                        //}
                    }                    
                }
                SetNowVersion();
            }
        }
        /*
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
        */
    }
}
