﻿// <summary>ソースコード：ＨＱ　グラフデータクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;


namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＱ　グラフデータ</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>ＨＱグラフデータ（HySGraphHQをハッシュテーブル管理したもの）</para>
    /// <para>Remarks</para>
    /// <para>無し</para>
    /// </remarks>
    [Serializable]
    public class HySHQData : HySDataRoot, HySVersionManagement
    {
        /// <summary>データ管理テーブル(HySGraphHQ)が管理される</summary>
        protected HySDataHashTable m_csDataTable = null;

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySHQData csData = new HySHQData(); </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> HySHQData 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySHQData()
        {
            m_csDataTable = new HySDataHashTable(); // ハッシュテーブル生成
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>ＨＱグラフ作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGraphHQ csGraph = CreateHQGraph(csPosID) </para>
        /// </example>
        /// <param name="csPosID">地点識別子（＝グラフを識別する識別子）</param>
        /// <returns>HySGraphHQ 生成されたＨＱグラフ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySGraphHQ CreateHQGraph(HySID csPosID)
        {
            HySGraphHQ csGraphHQ = new HySGraphHQ(csPosID);
            HySString csKeyID = (HySString)csPosID.GetString();
            m_csDataTable.AddObject(csKeyID, csGraphHQ);
            return csGraphHQ;
        }
        /// <summary><para>method outline:</para>
        /// <para>データのクリア</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> RemoveHQGraph(csPosID) </para>
        /// </example>
        /// <param name="csPosID">地点識別子（＝グラフを識別する識別子）</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void RemoveHQGraph(HySID csPosID)
        {
            HySString csKeyID = (HySString)csPosID.GetString();
            m_csDataTable.DeleteData(csKeyID);
        }
        /// <summary><para>method outline:</para>
        /// <para>ＨＱグラフ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGraphHQ csGraph = GetHQGraph(csPosID) </para>
        /// </example>
        /// <param name="csPosID">地点識別子（＝グラフを識別する識別子）</param>
        /// <returns>HySGraphHQ ＨＱグラフ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySGraphHQ GetHQGraph(HySID csPosID)
        {
            HySString csKeyID = (HySString)csPosID.GetString();
            return (HySGraphHQ)m_csDataTable.GetObject(csKeyID);
        }
        /// <summary><para>method outline:</para>
        /// <para>ＨＱグラフ数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lGrphNum = GetHQGraphNum( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long ＨＱグラフ数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetHQGraphNum()
        {
            HySDataLinkedList csList = m_csDataTable.GetKeyList(); // キーリスト一覧取得
            long lPosNum = csList.GetCount(); // 一覧表件数取得
            csList = null;
            return lPosNum;
        }
        /// <summary><para>method outline:</para>
        /// <para>ＨＱグラフ識別子配列取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID[] csGraphIDList = GetHQGraphIDList( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySID[] 地点識別子（＝グラフを識別する識別子）</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySID[] GetHQGraphIDList()
        {
            HySID[] csID = null;

            HySDataLinkedList csList = m_csDataTable.GetKeyList(); // キーリスト一覧取得
            long lPosNum = csList.GetCount(); // 一覧表件数取得
            if (lPosNum > 0)
            {  // 登録データがある場合
                csID = new HySID[lPosNum];
                for (int iLp = 0; iLp < lPosNum; iLp++)
                {  // 登録データ件数分繰り返す
                    HySString csPosID = csList.GetData((long)iLp) as HySString;
                    if (csPosID is HySString)
                    {  // データが有る場合
                        csID[iLp] = new HySID(new HySString(csPosID.ToString())); // 時系列グラフＩＤ設定
                    }
                }
                csList = null;
            }
            return csID;
        }


        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                if (GetDecodedVersion() == null)
                {
                    // 旧バージョンからの移行処理を入れる
                }
                else
                {
                    //旧バージョンから順にバージョンを上げて行く
                    switch (GetDecodedVersion())
                    {
                        case "1.00":
                            {
                                // 旧バージョンからの移行処理を入れる
                                break;
                            }
                        //case "2.00": << 以後バージョンアップに伴って処理追加
                        //{
                        //    break;
                        //}
                    }                    
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
