﻿// <summary>ソースコード：ハイドロ／ハイエト／水位　グラフデータクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;


namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>ハイドロ／ハイエト／水位関係　グラフデータ</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>時系列グラフデータ（HySGraphLineTimeSeries）をハッシュテーブル管理したもの</para>
    /// <para>Remarks</para>
    /// <para>無し</para>
    /// </remarks>
    [Serializable]
    public class HySHydroHyetoData : HySDataRoot, HySVersionManagement
    {
        /// <summary>地点識別子 </summary>
        protected HySID m_csGeoPosID = null;
        /// <summary>地点位置 </summary>
        protected HySGeoPoint m_csPosition = null;

        /// <summary>データ管理テーブル(HySGraphLineTimeSeries)が管理される</summary>
        protected HySDataHashTable m_csDataTable = null;
        
        /*
        /// <summary>ハイエト時刻リスト </summary>
        protected HySLinkedListTime m_csHyetoTimeList = new HySLinkedListTime();
        /// <summary>ハイエトデータリスト </summary>
        protected HySLinkedListDouble m_csHyetoDataList = new HySLinkedListDouble();

        /// <summary>ハイドロ時刻リスト </summary>
        protected HySLinkedListTime m_csHydroTimeList = new HySLinkedListTime();
        /// <summary>ハイドロデータリスト </summary>
        protected HySLinkedListDouble m_csHydroDataList = new HySLinkedListDouble();

        /// <summary>水位時刻リスト </summary>
        protected HySLinkedListTime m_csWaterLevelTimeList = new HySLinkedListTime();
        /// <summary>水位データリスト </summary>
        protected HySLinkedListDouble m_csWaterLevelDataList = new HySLinkedListDouble();

        /// <summary><para>method outline:</para>
        /// <para>データ追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AddData(csTime,  dHyetoDt,  dHydroDt,  dWaterLevel) </para>
        /// </example>
        /// <param name="csTime">時刻</param>
        /// <param name="dHyetoDt">降雨量(mm/h)</param>
        /// <param name="dHydroDt">流量(m3/s)</param>
        /// <param name="dWaterLevel">水位(m)</param>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>３変数が同時に設定できる場合に使用する</para>
        /// </remarks>
        public virtual void AddData(HySTime csTime, double dHyetoDt, double dHydroDt, double dWaterLevel)
        {
            this.AddHyetoData(csTime, dHyetoDt);
            this.AddHydroData(csTime, dHydroDt);
            this.AddWaterLevelData(csTime, dWaterLevel);
        }
        */

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySHydroHyetoData csData = new HySHydroHyetoData(); </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> HySHydroHyetoData 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySHydroHyetoData()
        {
            m_csDataTable = new HySDataHashTable(); // ハッシュテーブル生成
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>地点識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetGeoPosID( csID ) </para>
        /// </example>
        /// <param name="csID">地点識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetGeoPosID(HySID csID)
        {
            m_csGeoPosID = (HySID)csID;
        }
        /// <summary><para>method outline:</para>
        /// <para>地点識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csIdentifier = GetGeoPosID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySID 地点識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySID GetGeoPosID()
        {
            return m_csGeoPosID;
        }

        /// <summary><para>method outline:</para>
        /// <para>地点位置設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetPosition( csPosition ) </para>
        /// </example>
        /// <param name="csPosition">地点位置座標</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetPosition(HySGeoPoint csPosition)
        {
            m_csPosition = csPosition;
        }
        /// <summary><para>method outline:</para>
        /// <para>地点位置取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGeoPoint csPosition = GetPosition( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySGeoPoint 地点位置</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySGeoPoint GetPosition()
        {
            return m_csPosition;
        }

        /// <summary><para>method outline:</para>
        /// <para>時系列グラフ作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataRoot csGraph = CreateTimeSeriesGraph(csGraphID,csDataKind) </para>
        /// </example>
        /// <param name="csGraphID">グラフを識別する識別子</param>
        /// <param name="csDataKind">データ種別</param>
        /// <returns>HySDataRoot 生成された時系列グラフ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDataRoot CreateTimeSeriesGraph(HySID csGraphID, HySObjectKind csDataKind)
        {
            // 時系列グラフデータクラス生成
            HySDataRoot csGraphLineTimeSeries = new HySGraphLineTimeSeries(csDataKind);
            // データ管理テーブルに登録
            HySString csKeyID = new HySString(csGraphID.GetString().ToString());
            m_csDataTable.AddObject(csKeyID, csGraphLineTimeSeries);
            // 生成された時系列グラフインスタンスを返す
            return csGraphLineTimeSeries;
        }
        /// <summary><para>method outline:</para>
        /// <para>データのクリア</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> RemoveGraph(csGraphID) </para>
        /// </example>
        /// <param name="csGraphID">グラフを識別する識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void RemoveGraph(HySID csGraphID)
        {
            HySString csKeyID = new HySString(csGraphID.GetString().ToString());
            m_csDataTable.DeleteData(csKeyID);
        }
        /// <summary><para>method outline:</para>
        /// <para>時系列グラフ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataRoot csGraph = GetTimeSeriesGraph(csGraphID) </para>
        /// </example>
        /// <param name="csGraphID">グラフを識別する識別子</param>
        /// <returns>HySDataRoot 時系列グラフ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDataRoot GetTimeSeriesGraph(HySID csGraphID)
        {
            HySString csKeyID = new HySString(csGraphID.GetString().ToString());
            return m_csDataTable.GetObject(csKeyID);
        }
        /// <summary><para>method outline:</para>
        /// <para>時系列グラフ数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lGrphNum = GetTimeSeriesGraphNum( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long 時系列グラフ数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetTimeSeriesGraphNum()
        {
            HySDataLinkedList csList = m_csDataTable.GetKeyList(); // キーリスト一覧取得
            long lGraphNum = csList.GetCount(); // 一覧表件数取得
            csList = null;
            return lGraphNum;
        }
        /// <summary><para>method outline:</para>
        /// <para>時系列グラフ識別子配列取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID[] csGraphIDList = GetTimeSeriesGraphIDList( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySID[] 時系列グラフＩＤ配列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySID[] GetTimeSeriesGraphIDList()
        {
            HySID[] csID = null;

            HySDataLinkedList csList = m_csDataTable.GetKeyList(); // キーリスト一覧取得
            long lGraphNum = csList.GetCount(); // 一覧表件数取得
            if (lGraphNum > 0)
            {  // 登録データがある場合
                csID = new HySID[lGraphNum];
                for (int iLp = 0; iLp < lGraphNum; iLp++)
                {  // 登録データ件数分繰り返す
                    HySString csGraphID = csList.GetData((long)iLp) as HySString;
                    if (csGraphID is HySString)
                    {  // データが有る場合
                        csID[iLp] = new HySID(new HySString(csGraphID.ToString())); // 時系列グラフＩＤ設定
                    }
                }
                csList = null;
            }
            return csID;
        }

        /* 河道リスト用のハイドロ／ハイエト／水位関連データを別に作るのかを確認してから対応する（その場合略称を替える？）↓
        /// <summary><para>method outline:</para>
        /// <para>時系列グラフ作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGraphLineLaneKilo csGraph = CreateTimeSeriesGraph(csGraphID,csDataKind) </para>
        /// </example>
        /// <param name="csGraphID">グラフを識別する識別子</param>
        /// <param name="csDataKind">データ種別</param>
        /// <returns>生成された時系列グラフ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySGraphLineLaneKilo CreateTimeSeriesGraph(HySID csGraphID, HySObjectKind csDataKind)
        {
            return null;
        }
        /// <summary><para>method outline:</para>
        /// <para>データのクリア</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> RemoveGraph(csGraphID) </para>
        /// </example>
        /// <param name="csGraphID">グラフを識別する識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void RemoveGraph(HySID csGraphID)
        {
            // 
        }
        /// <summary><para>method outline:</para>
        /// <para>時系列グラフ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGraphLineLaneKilo csGraph = GetTimeSeriesGraph(csGraphID) </para>
        /// </example>
        /// <param name="csGraphID">グラフを識別する識別子</param>
        /// <returns>時系列グラフ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySGraphLineLaneKilo GetTimeSeriesGraph(HySID csGraphID)
        {
            return null;
        }
        /// <summary><para>method outline:</para>
        /// <para>時系列グラフ数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lGrphNum = GetTimeSeriesGraphNum( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>時系列グラフ数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetTimeSeriesGraphNum()
        {
            HySDataLinkedList csList = m_csDataTable.GetKeyList(); // キーリスト一覧取得
            long lGraphNum = csList.GetCount(); // 一覧表件数取得
            csList = null;
            return lGraphNum;
        }
        /// <summary><para>method outline:</para>
        /// <para>時系列グラフ識別子配列取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID[] csGraphIDList = GetTimeSeriesGraphIDList( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySID[] 時系列グラフＩＤ配列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySID[] GetTimeSeriesGraphIDList()
        {
            return null;
        }
        */


        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public  string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public  string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public  void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
