﻿// <summary>ソースコード：セルデータ配列 基底抽象化クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using System.Runtime.Serialization;

namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>セルデータ配列 基底抽象化クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>空間上に　セルデータ配列情報を保持できる（但し直交座標）</para>
    /// </remarks>
    [Serializable]
    public abstract class HySCellArray : HySTimeRecordIF, HySVersionManagement
    {
        //============　データ分割数　================
        /// <summary>第１分割数</summary>
        protected long m_lDim1 = 1;
        /// <summary>第２分割数</summary>
        protected long m_lDim2 = 1;
        /// <summary>第３分割数</summary>
        protected long m_lDim3 = 1;

        /// <summary> セル内のデータの意味を示す </summary>
        protected HySDataCharacteristicInCell m_csCellDataKind = null;

        //============　時刻情報　================
        /// <summary>時刻</summary>
        protected HySTime m_csTime = HySTime.DEFAULT_TIME.Clone();

        /// <summary>セル識別子管理情報(時系列情報の場合には、使用しない) </summary>
        protected HySCellIDManageData m_csCellIDMngData=null;

        


        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellArray csData = new HySCellArray( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySCellArray 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected HySCellArray()
        {
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellArray csGeoMesh = new HySCellArray(lCellDim1, lCellDim2, lCellDim3, lDataDimInCell) </para>
        /// </example>
        /// <param name="lCellDim1">第１メッシュ分割数</param>
        /// <param name="lCellDim2">第２メッシュ分割数</param>
        /// <param name="lCellDim3">第３メッシュ分割数</param>
        /// <param name="lDataDimInCell">１セル内のデータ数</param>
        /// <returns> HySCellArray 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para> 抽象化クラスであるため、派生側で　:base( lCellDim1, lCellDim2, lCellDim3,lDataDimInCell) として使用する </para>
        /// </remarks>
        public HySCellArray(long lCellDim1, long lCellDim2, long lCellDim3, long lDataDimInCell)
        {
            /*
            m_lDim1 = lCellDim1;
            m_lDim2 = lCellDim2;
            m_lDim3 = lCellDim3;
            if (lDataDimInCell > 0)
            {
                m_csCellDataKind = new HySDataCharacteristicInCell(lDataDimInCell);
            }
            */
            this.Init(lCellDim1, lCellDim2, lCellDim3, lDataDimInCell,true);
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellArray csGeoMesh = new HySCellArray(lCellDim1, lCellDim2, lCellDim3, lDataDimInCell, bSW) </para>
        /// </example>
        /// <param name="lCellDim1">第１メッシュ分割数</param>
        /// <param name="lCellDim2">第２メッシュ分割数</param>
        /// <param name="lCellDim3">第３メッシュ分割数</param>
        /// <param name="lDataDimInCell">１セル内のデータ数</param>
        /// <param name="bSW">内部セル変数設定フラグ</param>
        /// <returns> HySCellArray 生成されたクラスのインスタンス：常にfalse</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para> 抽象化クラスであるため、派生側で　:base( lCellDim1, lCellDim2, lCellDim3,lDataDimInCell) として使用する </para>
        /// </remarks>
        internal HySCellArray(long lCellDim1, long lCellDim2, long lCellDim3, long lDataDimInCell, bool bSW)
        {
            this.Init(lCellDim1, lCellDim2, lCellDim3, lDataDimInCell, false);
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Init(lCellDim1, lCellDim2, lCellDim3, lDataDimInCell) </para>
        /// </example>
        /// <param name="lCellDim1">第１メッシュ分割数</param>
        /// <param name="lCellDim2">第２メッシュ分割数</param>
        /// <param name="lCellDim3">第３メッシュ分割数</param>
        /// <param name="lDataDimInCell">１セル内のデータ数</param>
         /// <param name="bSW">内部セル変数設定フラグ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>コンストラクターから呼ばれる</para>
        /// </remarks>
        protected virtual void Init(long lCellDim1, long lCellDim2, long lCellDim3, long lDataDimInCell,bool bSW)
        {
            m_lDim1 = lCellDim1;
            m_lDim2 = lCellDim2;
            m_lDim3 = lCellDim3;
            if (bSW == true)
            {
                if (lDataDimInCell > 0)
                {
                    m_csCellDataKind = new HySDataCharacteristicInCell(lDataDimInCell);
                }
            }
            else
            {
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>コピーコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellArray csData = new HySCellArray(csOrgData); </para>
        /// </example>
        /// <param name="csOrgData">コピー元データ</param>
        /// <returns> HySCellArray 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySCellArray(HySCellArray csOrgData)
        {
            this.CopyData(csOrgData);
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>第１メッシュ分割数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lDim = GetDimension1() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long 第１メッシュ分割数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetDimension1()
        {
            return m_lDim1;
        }
        /// <summary><para>method outline:</para>
        /// <para>第２メッシュ分割数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lDim = GetDimension2() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long 第２メッシュ分割数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetDimension2()
        {
            return m_lDim2;
        }
        /// <summary><para>method outline:</para>
        /// <para>第３メッシュ分割数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lDim = GetDimension3() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long 第３メッシュ分割数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetDimension3()
        {
            return m_lDim3;
        }

        /// <summary><para>method outline:</para>
        /// <para>セル内データ配列数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lDim = GetDataDimentionInCell() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long セル内データ配列数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetDataDimentionInCell()
        {
            if (m_csCellDataKind != null)
            {
                return m_csCellDataKind.m_lDim;
            }
            else
            {
                return 0;
            }
        }
        

        /// <summary><para>method outline:</para>
        /// <para>セル内データ種別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCellDataCharacteristic(csCellChara) </para>
        /// </example>
        /// <param name="csCellChara">１セル内の各データの種別</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetCellDataCharacteristic(HySDataCharacteristicInCell csCellChara)
        {
            m_csCellDataKind = csCellChara;
        }

        /// <summary><para>method outline:</para>
        /// <para>セル内データ種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDataCharacteristicInCell csKind = GetCellDataCharacteristic();</para>
        /// <para>csKind.SetDataKind( lItemNo,  csLabel,  csDataKind,  csUnit) 等の処理</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataCharacteristicInCell セル内データ種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDataCharacteristicInCell GetCellDataCharacteristic()
        { return m_csCellDataKind; }


        /// <summary><para>method outline:</para>
        /// <para>セル内データ種別変数をNULLクリアする</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NullClearCellDataKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>システム側で使用。一般ユーザーは使用禁止</para>
        /// </remarks>
        public virtual void NullClearCellDataKind()
        { 
            m_csCellDataKind = null;
        }

        /// <summary><para>method outline:</para>
        /// <para>時刻設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetTime(csTime) </para>
        /// </example>
        /// <param name="csTime">時刻</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetTime(HySTime csTime)
        {
            if (csTime != null)
            {
                m_csTime.SetTime(csTime);
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>時刻取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTime csTime = GetLastTime() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySTime 時刻</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySTime GetLastTime()
        {
            return m_csTime;
        }

        /// <summary><para>method outline:</para>
        /// <para>日付時刻比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = EqualTime(csTime) </para>
        /// </example>
        /// <param name="csTime">比較用日付管理クラスオブジェクト(HySTime)</param>
        /// <returns>
        /// bool　判定結果
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>bool  =HySTime の現在時刻が 引数：Date と同じ場合は true、そうでない場合は false</para>
        /// </remarks>
        public virtual bool EqualTime(HySTime csTime)
        {
            bool bRtn = false;
            if (m_csTime != null)
            {
                bRtn = m_csTime.Equals(csTime);
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>指定時刻よりも後か</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = After(csTime) </para>
        /// </example>
        /// <param name="csTime">比較用日付管理クラスオブジェクト(HySTime)</param>
        /// <returns>
        /// bool　判定結果
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>bool  =HySTime の現在時刻が 引数：Date の時刻よりあとの場合は true、そうでない場合は false</para>
        /// </remarks>
        public virtual bool After(HySTime csTime)
        {
            bool bRtn = false;
            if (m_csTime != null)
            {
                bRtn = m_csTime.After(csTime);
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>指定時刻よりも前か</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = Before(csTime) </para>
        /// </example>
        /// <param name="csTime">比較用日付管理クラスオブジェクト(HySTime)</param>
        /// <returns>
        /// bool　判定結果
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>bool  =HySTime の現在時刻が 引数：Date の時刻より前の場合は true、そうでない場合は false</para>
        /// </remarks>
        public virtual bool Before(HySTime csTime)
        {
            bool bRtn = false;
            if (m_csTime != null)
            {
                bRtn = m_csTime.Before(csTime);
            }
            return bRtn;
        }

        /*
        /// <summary><para>method outline:</para>
        /// <para>系列データの種別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDataMeaning(lDimItemNo, csMeaningKind) </para>
        /// </example>
        /// <param name="lDimItemNo">配列の順番（０相対）</param> 
        /// <param name="csMeaning">データの意味</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetDataMeaning(long lDimItemNo, HySObjectKind csMeaning)
        {
            if (lDimItemNo >= 0 && lDimItemNo < m_csCellDataKind.m_lDim)
            {
                m_csCellDataKind.m_csDataKind[lDimItemNo] = csMeaning.Clone();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>系列データの種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySObjectKind csDtMeaning = GetDataMeaning(lDimItemNo) </para>
        /// </example>
        /// <param name="lDimItemNo">配列の順番（０相対）</param> 
        /// <returns>HySObjectKind データの意味</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySObjectKind GetDataMeaning(long lDimItemNo)
        {
            HySObjectKind csRtn = null;
            if (lDimItemNo >= 0 && lDimItemNo < m_csCellDataKind.m_lDim)
            {
                csRtn = m_csCellDataKind.m_csDataKind[lDimItemNo];
            }

            return csRtn;
        }
        */

        /// <summary><para>method outline:</para>
        /// <para>セル識別管理データ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCellIDMngData(csCellIDMngData) </para>
        /// </example>
        /// <param name="csCellIDMngData">セル識別管理データ</param> 
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetCellIDMngData(HySCellIDManageData csCellIDMngData)
        {
            m_csCellIDMngData = csCellIDMngData;
        }
        /// <summary><para>method outline:</para>
        /// <para>セル識別管理データ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellIDManageData csCellIDMngDt = GetCellIDMngData( ) </para>
        /// </example>
        /// <param name=""></param> 
        /// <returns>HySCellIDManageData セル識別管理データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySCellIDManageData GetCellIDMngData()
        {
            return m_csCellIDMngData;
        }

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられたデータを自分にコピーする</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CopyData(csOrgData) </para>
        /// </example>
        /// <param name="csOrgData">コピー元情報</param>
        /// <returns> 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CopyData(HySCellArray csOrgData)
        {
            // 共通情報のコピー
            CopyCommonInfo(csOrgData);
            if (csOrgData.m_csCellDataKind != null)
            {
                m_csCellDataKind = csOrgData.m_csCellDataKind.Clone();
            }
            
        }

        /// <summary><para>method outline:</para>
        /// <para>共通情報をコピーする</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CopyInfo(csOrgData) </para>
        /// </example>
        /// <param name="csOrgData">コピー元情報</param>
        /// <returns> 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected virtual void CopyCommonInfo(HySCellArray csOrgData)
        {
            m_lDim1 = csOrgData.m_lDim1;
            m_lDim2 = csOrgData.m_lDim2;
            m_lDim3 = csOrgData.m_lDim3;

            if (csOrgData.m_csCellIDMngData != null)
            {
                m_csCellIDMngData = new HySCellIDManageData();
                m_csCellIDMngData.CopyData(csOrgData.m_csCellIDMngData);
            }

            m_csTime.SetTime(csOrgData.m_csTime);
        }

        /// <summary><para>method outline:</para>
        /// <para>個別セル取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellData csCell = GetCell(lIdx1) </para>
        /// </example>
        /// <param name="lIdx1">第１配列のセル位置</param>
        /// <returns> HySCellData セル　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract HySCellData GetCell(long lIdx1);
        /// <summary><para>method outline:</para>
        /// <para>個別セル取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellData csCell = GetCell(lIdx1,lIdx2) </para>
        /// </example>
        /// <param name="lIdx1">第１配列のセル位置</param>
        /// <param name="lIdx2">第２配列のセル位置</param>
        /// <returns> HySCellData セル　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract HySCellData GetCell(long lIdx1, long lIdx2);
        /// <summary><para>method outline:</para>
        /// <para>個別セル取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellData csCell = GetCell(lIdx1,lIdx2,lIdx3) </para>
        /// </example>
        /// <param name="lIdx1">第１配列のセル位置</param>
        /// <param name="lIdx2">第２配列のセル位置</param>
        /// <param name="lIdx3">第３配列のセル位置</param>
        /// <returns> HySCellData セル　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract HySCellData GetCell(long lIdx1, long lIdx2, long lIdx3);

        /// <summary><para>method outline:</para>
        /// <para>単独データセル配列生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellArray csCellArray = CreateSingleDataCellArray(lDataIndex) </para>
        /// </example>
        /// <param name="lDataIndex">セル内データIndex(0相対)</param>
        /// <returns> HySCellArray 単独データセル配列　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>指定されたインデックスのセル内部データのみを持つセル配列データを生成する</para>
        /// </remarks>
        public abstract HySCellArray CreateSingleDataCellArray(long lDataIndex);

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
        /// <summary>
        /// S.H.　内部データクリア
        /// </summary>
        virtual  public void ClearData()
        {
        }
    }
}
