﻿// <summary>ソースコード：１セル内データ（１次元配列）</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;


namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>１セル内データ（１次元配列）</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>本クラスの派生クラスは全て[Serializable]であること</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class HySCellData : HySDataRoot, HySVersionManagement
    {
        /// <summary>配列数</summary>
        public long m_lDim = 1;
        /// <summary>保持データ</summary>
        public double[] m_dData = null;
       
        /// <summary><para>method outline:</para>
        /// <para>デストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>無し</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メモリーリーク防止の為　内部変数は必ず null にセットする</para>
        /// </remarks>
        ~HySCellData()
        {
            //long NDt = m_dData.Length;
            //for (long lLp = 0; lLp < NDt; lLp++)
            //{
            //    m_dData[lLp] = null;
            //}
            m_dData = null;
            m_sDecodedVersion = null;
        }

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> 使用禁止 </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> HySCellData 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        protected HySCellData()
        {
            //バージョン情報設定
            SetNowVersion();
        }



        public HySCellData(long lDim) 
        {
            m_lDim = lDim;
            m_dData = new double[m_lDim];
            for(int i=0;i< m_lDim;i++)
            {
                m_dData[i] = 0.0;
            }
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary>
        /// S.H.　内部データクリア
        /// </summary>
        public void ClearData()
        {
            for (int i = 0; i < m_lDim; i++)
            {
                m_dData[i] = 0.0;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellData csData = Clone( ); </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> HySCellData 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySCellData Clone()
        {
            HySCellData csRtn = new HySCellData(m_lDim);
            for (long lLp = 0; lLp < m_lDim; lLp++)
            {
                csRtn.m_dData[lLp] = m_dData[lLp];
            }
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>セル情報をXMLへ書き出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySXmlNode csXmlNode = XmlOUT(csXmlWriter) </para>
        /// </example>
        /// <param name="csXmlWriter">XML書き出しクラス</param>
        /// <returns>HySXmlNode  XMLノードクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySXmlNode XmlOUT(ref HySXmlWriter csXmlWriter)
        {
            HySXmlNode csRtn = HySXmlNode.CreateElement(HySDefine.xml_CELL_DATA, csXmlWriter);

            HySXmlNode csLclNode;
            for (int iLp = 0; iLp < m_lDim; iLp++)
            {
                csLclNode = HySXmlNode.CreateElement(HySDefine.xml_INDEX, csXmlWriter);

                csLclNode.SetAttribute(HySDefine.xml_INDEX_NO, iLp.ToString());
                csLclNode.SetAttribute(HySDefine.xml_INDEX_VALUE, m_dData[iLp].ToString());

                csRtn.AppendChild(csLclNode);   // AppendChildは最後に行う
            }
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>XMLからセル情報を読み出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = XmlIN(csPrptyXml) </para>
        /// </example>
        /// <param name="csPrptyXml">入力XML</param>
        /// <returns>bool  =true:正常、=false:型式不適等</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>HySDefine.xml_CELL_DATAタグの選択は外部で行っておく</para>
        /// </remarks>
        public virtual bool XmlIN(HySXmlNode csPrptyXml)
        {
            if (csPrptyXml == null)
            { return false; }

            m_dData = null;

            HySXmlNode csXml = null;
            HySXmlNodeList csXmlVariableList = csPrptyXml.GetChildNodeListByTagName(HySDefine.xml_INDEX);
            long lValCnt = csXmlVariableList.GetCount();

            m_lDim = lValCnt;
            m_dData = new double[m_lDim];

            string sOrderAttr; long lOrder = 0;
            string sValueAttr; double dVal = 0;

            for (long lLoop = 0; lLoop < m_lDim; lLoop++)
            {
                csXml = csXmlVariableList.GetNode(lLoop);
                // 順序
                sOrderAttr = csXml.GetAttribute(HySDefine.xml_INDEX_NO);
                lOrder = Convert.ToInt32(sOrderAttr);
                // 値
                sValueAttr = csXml.GetAttribute(HySDefine.xml_INDEX_VALUE);
                dVal = Convert.ToDouble(sValueAttr);

                m_dData[lOrder] = dVal;
            }
            return true;
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
