﻿// <summary>ソースコード：セル配列データ（１次元配列）</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
//using CommonMP.HYSSOP.CoreImpl.HSData.CommonData;

namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>セル配列データ（１次元配列）</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>本クラスの派生クラスは全て[Serializable]であること</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class HySD1CellArrayData : HySCellArray
    {     
        //============　保持データ　================
        /// <summary>保持データ </summary>
        protected HySCellData[] m_csCellArray = null;
        /// <summary>セル内情報配列数</summary>
        protected long m_lDataDimInCell = 1;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> 使用禁止 </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> HySD1CellArrayData 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        private HySD1CellArrayData()
        {
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySD1CellArrayData csData = new HySD1CellArrayData(lCellDim, lDataDimInCell); </para>
        /// </example>
        /// <param name="lCellDim">セル配列数</param>
        /// <param name="lDataDimInCell">セル内データ配列数</param>
        /// <returns> HySD1CellArrayData 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySD1CellArrayData(long lCellDim, long lDataDimInCell)
            : base(lCellDim, 0, 0, lDataDimInCell)
        {
            /*
            m_lDataDimInCell = lDataDimInCell;
            m_csCellArray = new HySCellData[lCellDim];
            for (long lLp = 0; lLp < lCellDim; lLp++)
            {
                m_csCellArray[lLp] = new HySCellData(lDataDimInCell);
            }
            */
            this.Init(lCellDim, lDataDimInCell, true);
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>コピーコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySD1CellArrayData csData = new HySD1CellArrayData(csOrgData); </para>
        /// </example>
        /// <param name="csOrgData">コピー元データ</param>
        /// <returns> HySD1CellArrayData 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySD1CellArrayData(HySD1CellArrayData csOrgData)
            : base(csOrgData)
        {
            CopyData(csOrgData);
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>内部処理用コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySD1CellArrayData csData = new HySD1CellArrayData(lCellDim1, lDataDimInCell, false); </para>
        /// </example>
        /// <param name="lCellDim1">セル配列数</param>
        /// <param name="lDataDimInCell">セル内データ配列数</param>
        /// <param name="bSW">常にfalse</param>
        /// <returns> HySD1CellArrayData 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>内部処理用：
        ///   時系列情報として情報を設定するとき　各レコード間に共通な情報を
        /// 　内部に冗長な情報として持たないように、共通情報の生成を止めて生成する
        /// </para>
        /// </remarks>
        internal HySD1CellArrayData(long lCellDim1, long lDataDimInCell, bool bSW)
            : base(lCellDim1, 0, 0, 0,bSW)
        {
            /*
            m_lDataDimInCell = lDataDimInCell;
            m_csCellArray = new HySCellData[lCellDim1];
            for (long lLp = 0; lLp < lCellDim1; lLp++)
            {
                m_csCellArray[lLp] = new HySCellData(lDataDimInCell);
            }
            */
            this.Init(lCellDim1, lDataDimInCell, bSW);
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Init(lCellDim1, lDataDimInCell, bSW) </para>
        /// </example>
        /// <param name="lCellDim1">第１メッシュ分割数</param>
        /// <param name="lDataDimInCell">１セル内のデータ数</param>
        /// <param name="bSW">内部セル変数設定フラグ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>コンストラクターから呼ばれる</para>
        /// </remarks>
        protected virtual void Init(long lCellDim1, long lDataDimInCell, bool bSW)
        {
            base.Init(lCellDim1, 0, 0, lDataDimInCell, bSW);
            
            m_lDataDimInCell = lDataDimInCell;
            m_csCellArray = new HySCellData[lCellDim1];
            for (long lLp = 0; lLp < lCellDim1; lLp++)
            {
                m_csCellArray[lLp] = new HySCellData(lDataDimInCell);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>配列インスタンス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellData[] csData = GetCellData() </para>
        /// <para> y = csData[j].m_dData[n]; (取得) </para>
        /// <para> csData[i].m_dData[n] = x; (代入) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySCellData[] １次元配列インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>配列のインデックスは０相対</para>
        /// </remarks>
        public HySCellData[] GetCellData()
        {
            return m_csCellArray;
        }
        /// <summary><para>method outline:</para>
        /// <para>指定インスタンス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellData csData = GetCellData(1) </para>
        /// <para> y = csData.m_dData[n]; (取得) </para>
        /// <para> csData.m_dData[n] = x; (代入) </para>
        /// </example>
        /// <param name="lItm0">配列位置</param>
        /// <returns>HySCellData セルインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>配列のインデックスは０相対</para>
        /// </remarks>
        public HySCellData GetCellData(long lItm0)
        {
            if (lItm0 < 0 || lItm0 >= m_lDim1)
            {
                return null;
            }
            else
            {
                return m_csCellArray[lItm0];
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>配列インスタンス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCellData(csArry) </para>
        /// </example>
        /// <param name="csArry">セル型クラス１次元配列インスタンス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>システム内で使用する為、一般ユーザーは使用禁止</para>
        /// </remarks>
        public  void SetCellData(HySCellData[] csArry)
        {
            m_csCellArray = csArry;
        }

        /// <summary><para>method outline:</para>
        /// <para>セル内データ配列数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lDim = GetDataDimentionInCell() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long セル内データ配列数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override long GetDataDimentionInCell()
        {
            return m_lDataDimInCell;
        }

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられたデータを自分にコピーする</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CopyData(csOrgData) </para>
        /// </example>
        /// <param name="csOrgData">コピー元情報</param>
        /// <returns> 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void CopyData(HySCellArray csOrgData)
        {
            HySD1CellArrayData csD1CellArray = csOrgData as HySD1CellArrayData;
            if (csD1CellArray == null)
            {
                return;
            }

            base.CopyData((HySCellArray)csD1CellArray);
            m_lDataDimInCell = csD1CellArray.m_lDataDimInCell;
            m_csCellArray = new HySCellData[m_lDim1];
            if (csD1CellArray.m_csCellArray != null)
            {
                for (long lLp = 0; lLp < m_lDim1; lLp++)
                {
                    m_csCellArray[lLp] = csD1CellArray.m_csCellArray[lLp].Clone();
                }
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>個別セル取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellData csCell = GetCell(lIdx1) </para>
        /// </example>
        /// <param name="lIdx1">第１配列のセル位置</param>
        /// <returns> HySCellData セル　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySCellData GetCell(long lIdx1)
        { return m_csCellArray[lIdx1]; }
        /// <summary><para>method outline:</para>
        /// <para>個別セル取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellData csCell = GetCell(lIdx1,lIdx2) </para>
        /// </example>
        /// <param name="lIdx1">第１配列のセル位置</param>
        /// <param name="lIdx2">第２配列のセル位置</param>
        /// <returns> HySCellData セル　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySCellData GetCell(long lIdx1, long lIdx2)
        { return null; }
        /// <summary><para>method outline:</para>
        /// <para>個別セル取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellData csCell = GetCell(lIdx1,lIdx2,lIdx3) </para>
        /// </example>
        /// <param name="lIdx1">第１配列のセル位置</param>
        /// <param name="lIdx2">第２配列のセル位置</param>
        /// <param name="lIdx3">第３配列のセル位置</param>
        /// <returns> HySCellData セル　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySCellData GetCell(long lIdx1, long lIdx2, long lIdx3)
        { return null; }

        /// <summary><para>method outline:</para>
        /// <para>単独データセル配列生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellArray csCellArray = CreateSingleDataCellArray(lDataIndex) </para>
        /// </example>
        /// <param name="lDataIndex">セル内データIndex(0相対)</param>
        /// <returns> HySCellArray 単独データセル配列　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>指定されたインデックスのセル内部データのみを持つセル配列データを生成する</para>
        /// </remarks>
        public override HySCellArray CreateSingleDataCellArray(long lDataIndex)
        {
            HySD1CellArrayData csRtnData = null;

            // Indexが正しい場合のみ生成
            if ( (lDataIndex >= 0) && (lDataIndex < m_lDataDimInCell) )
            {
                csRtnData = new HySD1CellArrayData(m_lDim1, 1);
                // 共通情報の設定
                csRtnData.CopyCommonInfo(this);

                // 指定されたIndexのデータのみを持つセル配列を生成
                if (this.m_csCellDataKind != null)
                {
                    csRtnData.m_csCellDataKind = this.m_csCellDataKind.CreateSingleDataCharacteristic(lDataIndex);
                }
                for (long lLp = 0; lLp < m_lDim1; lLp++)
                {
                    csRtnData.m_csCellArray[lLp].m_dData[0] = this.m_csCellArray[lLp].m_dData[lDataIndex];
                }
            }

            return csRtnData;
        }


        /// <summary>
        /// S.H.　内部データクリア
        /// </summary>
        public override void ClearData()
        {
            for (long lLp = 0; lLp < m_lDim1; lLp++)
            {
                m_csCellArray[lLp].ClearData();
            }
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {
            base.PostDeserialize();

            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
    }
}
