﻿// <summary>ソースコード：セル　時系列 データクラス<</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;

namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>セルデータ配列 基底抽象化クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>セルデータ配列情報を時系列にて管理するクラスの基底</para>
    /// </remarks>
    [Serializable]
    public abstract class HySTimeSeriesCellArray : HySTimeSeriesBase //, HySVersionManagement
    {
        /// <summary> セル内のデータの意味を示す </summary>
        protected HySDataCharacteristicInCell m_csCellDataKind = null;
        /// <summary>セル識別子管理情報 </summary>
        protected HySCellIDManageData m_csCellIDMngData = new HySCellIDManageData();


        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTimeSeriesCellArray CellArray = new HySTimeSeriesCellArray() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> HySTimeSeriesCellArray 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        public HySTimeSeriesCellArray()
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>セル内データ配列数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lDim = GetDataDimentionInCell() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long セル内データ配列数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetDataDimentionInCell()
        {
            return m_csCellDataKind.m_lDim;
        }
        /// <summary><para>method outline:</para>
        /// <para>セル内データ種別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCellDataCharacteristic(csCellChara) </para>
        /// </example>
        /// <param name="csCellChara">１セル内の各データの種別</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetCellDataCharacteristic(HySDataCharacteristicInCell csCellChara)
        { 
            m_csCellDataKind = csCellChara; 
        }

        /// <summary><para>method outline:</para>
        /// <para>セル内データ種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataCharacteristicInCell csKind = GetCellDataCharacteristic();</para>
        /// <para> csKind.SetDataKind( lItemNo,  csLabel,  csDataKind,  csUnit) 等の処理</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataCharacteristicInCell セル内データ種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDataCharacteristicInCell GetCellDataCharacteristic()
        { 
            return m_csCellDataKind; 
        }

        /// <summary><para>method outline:</para>
        /// <para>セル識別管理データ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCellIDMngData(csCellIDMngData) </para>
        /// </example>
        /// <param name="csCellIDMngData">セル識別管理データ</param> 
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCellIDMngData(HySCellIDManageData csCellIDMngData)
        {
            m_csCellIDMngData = csCellIDMngData;
        }

        /// <summary><para>method outline:</para>
        /// <para>セル識別管理データ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellIDManageData csCellIDMngDt = GetCellIDMngData( ) </para>
        /// </example>
        /// <param name="">無し</param> 
        /// <returns>HySCellIDManageData セル識別管理データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySCellIDManageData GetCellIDMngData()
        {
            return m_csCellIDMngData;
        }

        /// <summary><para>method outline:</para>
        /// <para>共通情報をコピーする</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CopyCommonInfo(csOrgData) </para>
        /// </example>
        /// <param name="csOrgData">コピー元情報</param>
        /// <returns> 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>引数で受け取ったデータからレコード情報以外の共通情報をコピーする</para>
        /// </remarks>
        protected virtual void CopyCommonInfo(HySTimeSeriesCellArray csOrgData)
        {
            m_lMaxDataNum = csOrgData.m_lMaxDataNum;
            m_csCellDataKind = csOrgData.m_csCellDataKind.Clone();
            m_csCellIDMngData.CopyData(csOrgData.m_csCellIDMngData);
        }

        /// <summary><para>method outline:</para>
        /// <para>単独データ時系列セル配列生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTimeSeriesCellArray csTSCellArray = CreateSingleDataCellArray(lDataIndex) </para>
        /// </example>
        /// <param name="lDataIndex">セル内データIndex(0相対)</param> 
        /// <returns>HySTimeSeriesCellArray 単独データ時系列セル配列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>指定されたインデックスのセル内部データのみを持つ時系列セル配列データを生成する</para>
        /// </remarks>
        public HySTimeSeriesCellArray CreateSingleDataCellArray(long lDataIndex)
        {
            HySTimeSeriesCellArray csRtnData = null;

            // Indexが正しい場合のみ生成
            if ((lDataIndex >= 0) && (lDataIndex < m_csCellDataKind.m_lDim))
            {
                // 自身の共通情報所持インスタンス生成
                csRtnData = CreateInstance();
                csRtnData.CopyCommonInfo(this);

                // セルデータ種別情報設定
                if (m_csCellIDMngData != null)
                {
                    csRtnData.m_csCellDataKind = m_csCellDataKind.CreateSingleDataCharacteristic(lDataIndex);
                }

                // 時系列情報設定
                long lDataNum = GetCount();
                SetCursorFirst();
                // 元のレコードを単独データにして設定する
                for (long lLp = 0; lLp < lDataNum; lLp++)
                {
                    HySCellArray csRecordData = GetCursorData() as HySCellArray;
                    csRtnData.AddData(csRecordData.CreateSingleDataCellArray(lDataIndex));
                    MoveCursorNext();
                }
            }

            return csRtnData;
        }

        /// <summary><para>method outline:</para>
        /// <para>インスタンス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTimeSeriesCellArray csTSCellArray = CreateInstance() </para>
        /// </example>
        /// <param name="">無し</param> 
        /// <returns>HySTimeSeriesCellArray 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>自分自身の同一の型のインスタンスを生成する</para>
        /// </remarks>
        protected abstract HySTimeSeriesCellArray CreateInstance();

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {
            base.PostDeserialize();

            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
    }
}
