﻿// <summary>ソースコード：３次元セル　時系列 データクラス<</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>３次元セル時系列 データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>地理空間上に　３次元メッシュ状の情報を保持できる（但し直交座標）</para>
    /// <para>Remarks</para>
    /// <para>無し</para>
    /// </remarks>
    [Serializable]
    public class HySTimeSeriesD3CellArrayData : HySTimeSeriesCellArray //, HySVersionManagement
    {
        //============　データ分割数　================
        /// <summary>第１分割数</summary>
        protected long m_lDim1 = 1;
        /// <summary>第２分割数</summary>
        protected long m_lDim2 = 1;
        /// <summary>第３分割数</summary>
        protected long m_lDim3 = 1;


        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> 使用禁止 </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> HySTimeSeriesD3CellArrayData 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        private HySTimeSeriesD3CellArrayData()
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTimeSeriesD3CellArrayData csData = new HySTimeSeriesD3CellArrayData(lCellDim1, lCellDim2, lCellDim3, lDataDimInCell); </para>
        /// </example>
        /// <param name="lCellDim1">第１セル配列数</param>
        /// <param name="lCellDim2">第２セル配列数</param>
        /// <param name="lCellDim3">第３セル配列数</param>
        /// <param name="lDataDimInCell">セル内データ配列数</param>
        /// <returns> HySTimeSeriesD3CellArrayData 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySTimeSeriesD3CellArrayData(long lCellDim1, long lCellDim2, long lCellDim3, long lDataDimInCell)
        {
            m_lDim1 = lCellDim1;
            m_lDim2 = lCellDim2;
            m_lDim3 = lCellDim3;
            m_csCellDataKind = new HySDataCharacteristicInCell(lDataDimInCell);
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTimeSeriesD3CellArrayData csData = new HySTimeSeriesD3CellArrayData(csOrgData); </para>
        /// </example>
        /// <param name="csOrgData">コピー元情報</param>
        /// <returns> HySTimeSeriesD3CellArrayData 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySTimeSeriesD3CellArrayData(HySTimeSeriesD3CellArrayData csOrgData)
        {
            CopyData(csOrgData);
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTimeSeriesD3CellArrayData csData = new HySTimeSeriesD3CellArrayData(csCellArray); </para>
        /// </example>
        /// <param name="csCellArray">3次元セル配列データ</param>
        /// <returns> HySTimeSeriesD3CellArrayData 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySTimeSeriesD3CellArrayData(HySD3CellArrayData csCellArray)
        {
            m_lDim1 = csCellArray.GetDimension1();
            m_lDim2 = csCellArray.GetDimension2();
            m_lDim3 = csCellArray.GetDimension3();
            m_csCellDataKind = csCellArray.GetCellDataCharacteristic().Clone();
            m_csCellIDMngData = new HySCellIDManageData();
            m_csCellIDMngData.CopyData(csCellArray.GetCellIDMngData());
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>第１メッシュ分割数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lDim = GetDimension1() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long 第１メッシュ分割数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetDimension1()
        {
            return m_lDim1;
        }
        /// <summary><para>method outline:</para>
        /// <para>第２メッシュ分割数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lDim = GetDimension2() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long 第２メッシュ分割数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetDimension2()
        {
            return m_lDim2;
        }
        /// <summary><para>method outline:</para>
        /// <para>第３メッシュ分割数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lDim = GetDimension3() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long 第３メッシュ分割数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetDimension3()
        {
            return m_lDim3;
        }

        /// <summary><para>method outline:</para>
        /// <para>新しいレコードを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTimeRecordIF csNewRecord = CreateNewRecord( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySTimeRecordIF 新レコード</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>時系列として保持すべき情報を新規に生成する</para>
        /// </remarks>
        public override HySTimeRecordIF CreateNewRecord()
        {
            return new HySD3CellArrayData(m_lDim1, m_lDim2, m_lDim3, m_csCellDataKind.m_lDim, false);
        }     
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられたデータを自分にコピーする</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CopyData(csOrgTimeSeriesData) </para>
        /// </example>
        /// <param name="csOrgTimeSeriesData">コピー元情報</param>
        /// <returns> 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void CopyData(HySTimeSeriesBase csOrgTimeSeriesData)
        {   
            HySTimeSeriesD3CellArrayData csOrgData = csOrgTimeSeriesData as HySTimeSeriesD3CellArrayData;
            HySD3CellArrayData csRecordData = null;
            if (csOrgData != null)
            {
                // 共通情報のコピー
                CopyCommonInfo(csOrgData);

                // 時系列情報のコピー
                m_csLastTime = csOrgData.m_csLastTime.Clone();
                this.m_csDataList.Clear();

                long lDataNum = csOrgData.GetCount();
                csOrgData.SetCursorFirst();
                for (long lLp = 0; lLp < lDataNum; lLp++)
                {
                    csRecordData = csOrgData.GetCursorData() as HySD3CellArrayData;
                    this.AddData(new HySD3CellArrayData(csRecordData));
                    csOrgData.MoveCursorNext();
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>共通情報をコピーする</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CopyCommonInfo(csOrgData) </para>
        /// </example>
        /// <param name="csOrgData">コピー元情報</param>
        /// <returns> 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>引数で受け取ったデータからレコード情報以外の共通情報をコピーする</para>
        /// </remarks>
        protected override void CopyCommonInfo(HySTimeSeriesCellArray csOrgData)
        {
            base.CopyCommonInfo(csOrgData);

            HySTimeSeriesD3CellArrayData csOrgD3Data = csOrgData as HySTimeSeriesD3CellArrayData;
            m_lDim1 = csOrgD3Data.m_lDim1;
            m_lDim2 = csOrgD3Data.m_lDim2;
            m_lDim3 = csOrgD3Data.m_lDim3;
        }

        /// <summary><para>method outline:</para>
        /// <para>系列データの種別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDataMeaning(lDimItemNo, csMeaning) </para>
        /// </example>
        /// <param name="lDimItemNo">配列の順番（０相対）</param> 
        /// <param name="csMeaning">データの意味</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetDataMeaning(long lDimItemNo, HySObjectKind csMeaning)
        {
            if (lDimItemNo >= 0 && lDimItemNo < m_csCellDataKind.m_lDim)
            {
                m_csCellDataKind.m_csDataKind[lDimItemNo] = csMeaning.Clone();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>系列データの種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySObjectKind csDtMeaning = GetDataMeaning(lDimItemNo) </para>
        /// </example>
        /// <param name="lDimItemNo">配列の順番（０相対）</param> 
        /// <returns>HySObjectKind データの意味</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySObjectKind GetDataMeaning(long lDimItemNo)
        {
            HySObjectKind csRtn = null;
            if (lDimItemNo >= 0 && lDimItemNo < m_csCellDataKind.m_lDim)
            {
                csRtn = m_csCellDataKind.m_csDataKind[lDimItemNo];
            }

            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>インスタンス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTimeSeriesCellArray csTSCellArray = CreateInstance() </para>
        /// </example>
        /// <param name="">無し</param> 
        /// <returns>HySTimeSeriesCellArray 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>自分自身の同一の型のインスタンスを生成する</para>
        /// </remarks>
        protected override HySTimeSeriesCellArray CreateInstance()
        {
            // 自身と同じ形のインスタンスを生成する
            return new HySTimeSeriesD3CellArrayData(m_lDim1, m_lDim2, m_lDim3, m_csCellDataKind.m_lDim);  
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {
            base.PostDeserialize();

            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
    }
}
