﻿// <summary>ソースコード：>ＨＹＳＳＯＰハッシュテーブルクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>ハッシュテーブルクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class HySDataHashTable : HySDataRoot, HySVersionManagement
    {
        /// <summary>テーブル</summary>
        protected Hashtable m_csHashTbl;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataHashTable csDataHashTable = new HySDataHashTable() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataHashTable  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDataHashTable()
        {
            //バージョン情報設定
            SetNowVersion();
            m_csHashTbl = new Hashtable();
        }

        /// <summary><para>method outline:</para>
        /// <para>デストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>無し</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メモリーリーク防止の為　内部変数は必ず null にセットする</para>
        /// </remarks>
        ~HySDataHashTable()
        {
            try
            {
                this.ClearAllObject();
                //if (m_csHashTbl != null)
                //{
                //    m_csHashTbl.Clear();
                //}
                m_csHashTbl = null;
                m_sDecodedVersion = null;
            }
            catch
            {
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>ハッシュテーブルにデータを追加する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AddObject(csKeyID, csData) </para>
        /// </example>
        /// <param name="csKeyID">キー</param>
        /// <param name="csData">データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void AddObject(HySString csKeyID, HySDataRoot csData)
        {
            m_csHashTbl[csKeyID.ToString()] = csData;      // キーがすでに存在する場合: 対応する値の置き換え
        }
        public virtual void AddObject(HySID csKeyID, HySDataRoot csData)
        {
            m_csHashTbl[csKeyID.ToString()] = csData;      // キーがすでに存在する場合: 対応する値の置き換え
        }
        /// <summary><para>method outline:</para>
        /// <para>ハッシュテーブルのデータを入れ替える</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetObject(csKeyID, csData) </para>
        /// </example>
        /// <param name="csKeyID">キー</param>
        /// <param name="csData">データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetObject(HySString csKeyID, HySDataRoot csData)
        {
            m_csHashTbl[csKeyID.ToString()] = csData;      // キーがすでに存在する場合: 対応する値の置き換え
        }
        public virtual void SetObject(HySID csKeyID, HySDataRoot csData)
        {
            m_csHashTbl[csKeyID.ToString()] = csData;      // キーがすでに存在する場合: 対応する値の置き換え
        }
        /// <summary><para>method outline:</para>
        /// <para>ハッシュテーブルからデータを取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataRoot csData = GetObject(csKeyID) </para>
        /// </example>
        /// <param name="csKeyID">キー</param>
        /// <returns>HySDataRoot　データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDataRoot GetObject(HySString csKeyID)
        {
            return (HySDataRoot)m_csHashTbl[csKeyID.ToString()];
        }
        public virtual HySDataRoot GetObject(HySID csKeyID)
        {
            return (HySDataRoot)m_csHashTbl[csKeyID.ToString()];
        }

        /// <summary><para>method outline:</para>
        /// <para>ハッシュテーブルからキーに対応するデータを削除する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> DeleteData(csKeyID) </para>
        /// </example>
        /// <param name="csKeyID">キー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void DeleteData(HySString csKeyID)
        {
            m_csHashTbl.Remove(csKeyID.ToString());
        }

        /// <summary><para>method outline:</para>
        /// <para>ハッシュテーブルが保持しているデータを全て削除する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ClearAllObject() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void ClearAllObject()
        {
            if (m_csHashTbl != null)
            {
                m_csHashTbl.Clear();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>キー指定データ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataRoot csData = csDataHashTable[csKeyID] </para>
        /// </example>
        /// <param name="csKeyID">キー</param>
        /// <returns>HySDataRoot　値</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDataRoot this[HySString csKeyID]
        {
            get
            {
                return (HySDataRoot)m_csHashTbl[csKeyID.ToString()];
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>ハッシュテーブルから全ハッシュキーを取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataLinkedList csKeyList = GetKeyList() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataLinkedList　全ハッシュキーリスト情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>件数が無い時はNULLが返る</para>
        /// </remarks>
        public virtual HySDataLinkedList GetKeyList()
        {
            HySDataLinkedList csKeyList = new HySDataLinkedList();
            foreach (string csName in m_csHashTbl.Keys)
            {  // ハッシュテーブル件数繰り返す
                csKeyList.AddLast(new HySString(csName));
            }
            if (csKeyList.GetCount() <= 0)
            {  // キー情報が無い場合
                csKeyList = null;
                return null;
            }
            else
            {
                return csKeyList;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>ハッシュテーブルから全データを取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataLinkedList csKeyList = GetKeyList() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataLinkedList　全データリスト情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>件数が無い時はNULLが返る</para>
        /// </remarks>
        public virtual HySDataLinkedList GetDataList()
        {
            HySDataLinkedList csKeyList = this.GetKeyList();
            if (csKeyList == null)
            {
                return null;
            }

            HySDataLinkedList csDataList = new HySDataLinkedList();
            HySString csKy;
            HySDataRoot  csDt;
            long lNum = csKeyList.GetCount();
            csKeyList.SetCursorFirst();
            for (long lLp = 0; lLp < lNum; lLp++)
            {
                csKy = csKeyList.GetCursorData() as HySString;
                csDt = m_csHashTbl[csKy.ToString()] as HySDataRoot;
                if (csDt != null)
                {
                    csDataList.AddLast(csDt);
                }
                csKeyList.MoveCursorNext();
            }
            return csDataList;
        }

        /// <summary><para>method outline:</para>
        /// <para>ハッシュテーブル内のペア情報数を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lNum = GetCount() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long　ハッシュテーブル内のペア情報数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para></para>
        /// </remarks>
        public virtual long GetCount()
        {
            return m_csHashTbl.Count;
        }

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Copy(csOrgObj) </para>
        /// </example>
        /// <param name="csOrgObj">コピー元情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void Copy(HySDataHashTable csOrgObj)
        {
            this.ClearAllObject();

            HySDataLinkedList csKeyList = csOrgObj.GetKeyList();
            if (csKeyList != null)
            {
                HySString csKy;
                HySDataRoot csDt;
                long lNum = csKeyList.GetCount();
                csKeyList.SetCursorFirst();
                for (long lLp = 0; lLp < lNum; lLp++)
                {
                    csKy = csKeyList.GetCursorData() as HySString;
                    csDt = csOrgObj.m_csHashTbl[csKy.ToString()] as HySDataRoot;
                    if (csDt != null)
                    {
                        this.AddObject(csKy, csDt);
                    }

                    csKeyList.MoveCursorNext();
                }
           }
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                if (GetDecodedVersion() == null)
                {
                    //旧バージョンからの移行処理を入れる
                }
                else
                {
                    //旧バージョンから順にバージョンを上げて行く
                    switch (GetDecodedVersion())
                    {
                        case "1.00":
                            break;
                    }                    
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }

        //
    }
}
