﻿// <summary>ソースコード：>ＨＹＳＳＯＰイベントクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;

namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>イベントクラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>
    /// [CommonMP][ver 1.0.0][2008/10/01][新規作成]
    /// [CommonMP][ver 1.2.0][2011/10/01][イベント追加]</para>
    /// </remarks>
    [Serializable]
    public class HySEventObject : HySSysEvent, HySVersionManagement
    {

        /// <summary>イベント識別番号</summary>
        protected long m_lEventNo = HySEventObject.DEFAULT_SYSTEM;
        /// <summary>送信先シミュレーション種別識別子</summary>
        protected HySObjectKind m_csToSimKind = null;
        /// <summary>送信元シミュレーション種別識別子</summary>
        protected HySObjectKind m_csFromSimKind = null;
        /// <summary>付属イベント番号(任意設定)</summary>
        protected long m_lSubEventNo = 0;
        /// <summary>付属データ</summary>
        protected HySDataRoot m_csData = null;
        /// <summary>第２付属データ</summary>
        protected HySDataRoot m_csSubData = null;
        /// <summary>付属識別子</summary>
        protected HySID m_csSuppID = null;
        /// <summary>応答情報識別子</summary>
        protected HySID m_csResponseInfoID= null;

        
        /// <summary><para>method outline:</para>
        /// <para>デストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>無し</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メモリーリーク防止の為　内部変数は必ず null にセットする</para>
        /// </remarks>
        ~HySEventObject()
        {
            m_csToSimKind = null;
            m_csFromSimKind = null;
            m_csData = null;
            m_csSubData = null;
            m_csSuppID = null;
            m_csResponseInfoID = null;
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySEventObject csEventObject = new  HySEventObject(lTo, lEventNo)</para>
        /// </example>
        /// <param name="lTo">イベント送り先</param>
        /// <param name="lEventNo">イベント番号</param>
        /// <returns>HySEventObject  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySEventObject(long lTo, long lEventNo)
            : base(lTo)
        {
            m_lEventNo = lEventNo;
            m_csData = null;
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySEventObject csEventObject = new  HySEventObject(lTo, lEventNo, csData)</para>
        /// </example>
        /// <param name="lTo">イベント送り先</param>
        /// <param name="lEventNo">イベント番号</param>
        /// <param name="csData">付加データ</param>
        /// <returns>HySEventObject  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySEventObject(long lTo, long lEventNo, HySDataRoot csData)
            : base(lTo)
        {
            m_lEventNo = lEventNo;  // イベント識別番号
            m_csData = csData;      // データ
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySEventObject csEventObject = new  HySEventObject(lTo, lEventNo, lSubNo)</para>
        /// </example>
        /// <param name="lTo">イベント送り先</param>
        /// <param name="lEventNo">イベント番号</param>
        /// <param name="lSubNo">サブイベント番号</param>
        /// <returns>HySEventObject  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySEventObject(long lTo, long lEventNo, long lSubNo)
            : base(lTo)
        {
            m_lEventNo = lEventNo;
            m_lSubEventNo = lSubNo;
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySEventObject csEventObject = new  HySEventObject(lTo, lEventNo, csSuppID)</para>
        /// </example>
        /// <param name="lTo">イベント送り先</param>
        /// <param name="lEventNo">イベント番号</param>
        /// <param name="csSuppID">補助識別子</param>
        /// <returns>HySEventObject  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySEventObject(long lTo, long lEventNo, HySID csSuppID)
            : base(lTo)
        {
            m_lEventNo = lEventNo;
            m_csSuppID = csSuppID;
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>イベント番号設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetEventNo(lEventNo)</para>
        /// </example>
        /// <param name="lEventNo">イベント番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetEventNo(long lEventNo)
        {
            m_lEventNo = lEventNo;
        }

        /// <summary><para>method outline:</para>
        /// <para>ベント番号取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lEventNo = GetEventNo()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>lEventNo　イベント番号</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetEventNo()
        {
            return m_lEventNo;
        }

        /// <summary><para>method outline:</para>
        /// <para>送り先シミュレーター種別識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetToSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetToSimKind(HySKind csSimKindID)
        {
            m_csToSimKind = (HySObjectKind)csSimKindID;
            if (m_csFromSimKind == null)
            {  // 送り元シミュレーター種別識別子が未設定の場合
                m_csFromSimKind = (HySObjectKind)csSimKindID;
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>送り先シミュレーター種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csSimKind = GetToSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySKind　シミュレーター種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySKind GetToSimKind()
        {
            return m_csToSimKind;
        }

        /// <summary><para>method outline:</para>
        /// <para>送り元シミュレーター種別識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetFromSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetFromSimKind(HySKind csSimKindID)
        {
            m_csFromSimKind = (HySObjectKind)csSimKindID;
        }
        /// <summary><para>method outline:</para>
        /// <para>送り元シミュレーター種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csSimKind = GetFromSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySKind　シミュレーター種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySKind GetFromSimKind()
        {
            return m_csFromSimKind;
        }

        /// <summary><para>method outline:</para>
        /// <para>付加データ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetData(csData)</para>
        /// </example>
        /// <param name="csData">付加データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetData(HySDataRoot csData)
        {
            m_csData = csData;
        }
        /// <summary><para>method outline:</para>
        /// <para>付加データ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataRoot csData = GetData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataRoot　付加データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDataRoot GetData()
        {
            return m_csData;
        }

        /// <summary><para>method outline:</para>
        /// <para>第２付加データ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSubData(csSubData) </para>
        /// </example>
        /// <param name="csSubData">第２付加データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetSubData(HySDataRoot csSubData)
        {
            m_csSubData = csSubData;
        }
        /// <summary><para>method outline:</para>
        /// <para>第２付加データ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataRoot csSubData = GetSubData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataRoot  第２付加データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDataRoot GetSubData()
        {
            return m_csSubData;
        }


        /// <summary><para>method outline:</para>
        /// <para>サブイベント番号設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSubEventNo(lSubNo) </para>
        /// </example>
        /// <param name="lSubNo">サブイベント番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetSubEventNo(long lSubNo)
        {
            m_lSubEventNo = lSubNo;
        }
        /// <summary><para>method outline:</para>
        /// <para>サブイベント番号取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lSubEventNo = GetSubEventNo() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long  サブイベント番号</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetSubEventNo()
        {
            return m_lSubEventNo;
        }

        /// <summary><para>method outline:</para>
        /// <para>補助識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSuppID(csSuppID)</para>
        /// </example>
        /// <param name="csSuppID">補助識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetSuppID(HySID csSuppID)
        {
            m_csSuppID = csSuppID;
        }
        /// <summary><para>method outline:</para>
        /// <para>補助識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csSuppID =  GetSuppID() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySID  補助識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySID GetSuppID()
        {
            return m_csSuppID;
        }

        /// <summary><para>method outline:</para>
        /// <para>応答情報識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetResponseInfo(csResponseInfoID)</para>
        /// </example>
        /// <param name="csResponseInfoID">応答情報識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetResponseInfo(HySID csResponseInfoID)
        {
            m_csResponseInfoID = csResponseInfoID;
        }
        /// <summary><para>method outline:</para>
        /// <para>応答情報識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csResponseInfoID = GetResponseInfo()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySID　応答情報識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySID GetResponseInfo()
        {
            return m_csResponseInfoID;
        }

        /// <summary><para>method outline:</para>
        /// <para>応答イベント生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySEventObject csResponseEvent = CreateResponceEvent(lEventNo)</para>
        /// </example>
        /// <param name="lEventNo">イベント番号</param>
        /// <returns>HySEventObject　イベントオブジェクト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// ・指定されたメインイベント番号を持つ
        /// ・自身の送り元シミュレーターを送り先シミュレーターに設定
        /// ・自身の同一の応答情報識別子
        /// 以下のようなイベントオブジェクトを生成する
        /// </para>
        /// </remarks>
        public HySEventObject CreateResponceEvent(long lEventNo)
        {
            HySEventObject csResponseEvent = new HySEventObject(From(), lEventNo);
            csResponseEvent.SetToSimKind(GetFromSimKind());
            csResponseEvent.SetResponseInfo(GetResponseInfo());

            return csResponseEvent;
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {
            base.PostDeserialize();

            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /*
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
        */


        // =====================================
        // start of クラス内 定数定義
        // =====================================

        // <System Command Event>
        /// <summary>デフォルト状態</summary>
        static public readonly long DEFAULT_SYSTEM = -1;
        /// <summary>シャットダウン指示</summary>
        static public readonly long CMND_SHUTDOWN_SYSTEM = -2;
        /// <summary>プロセスExit指示</summary>
        static public readonly long CMND_EXIT_SYSTEM = -3;

        // <Simulation Command Event>
        /// <summary>シミュレーション関連一般指示(通常は使用しない)</summary>
        static public readonly long CMND_SIMULATION_COMMON = -999990;
        /// <summary>シミュレーション関連一般正常報告(通常は使用しない)</summary>
        static public readonly long NOTICE_SIMULATION_OK = -999791;
        /// <summary>シミュレーション関連一般異常報告(通常は使用しない)</summary>
        static public readonly long NOTICE_SIMULATION_NG = -999792;
        //// <summary>シミュレーション準備指示</summary>
        //static public readonly long CMND_PREPARE_SIMULATION = -999901;
        /// <summary>シミュレーション初期化指示</summary>
        static public readonly long CMND_INITIALIZE_SIMULATION = -999902;
        /// <summary>シミュレーション開始指示</summary>
        static public readonly long CMND_START_SIMULATION = -999903;
        /// <summary>シミュレーション中断指示</summary>
        static public readonly long CMND_PAUSE_SIMULATION = -999904;
        /// <summary>シミュレーション再開指示</summary>
        static public readonly long CMND_RESTART_SIMULATION = -999905;
        /// <summary>シミュレーション強制終了指示</summary>
        static public readonly long CMND_STOP_SIMULATION = -999906;
        /// <summary>シミュレーション計算進捗状況報告指示</summary>
        static public readonly long CMND_REPORT_SIMU_PROGRESS = -99907;
        /// <summary>シミュレーション入力情報取り込み指示(入力情報が更新された場合等)</summary>
        static public readonly long CMND_RENEW_INPUTDATA = -999908;
        /// <summary>シミュレーション内のモデル構築開始指示</summary>
        static public readonly long CMND_MODEL_CONSTRUCTION = -999909;
        /// <summary>シミュレータ新規生成指示</summary>
        static public readonly long CMND_NEW_SIMULATOR_CREATE = -999910;
        /// <summary>シミュレーション計算スケジュール関連指示イベント（m_lSubEventNoを使用する） </summary>
        static public readonly long CMND_SIMU_SCHEDULE_EVENT = -999911;
        /// <summary>シミュレータ復元指示</summary>
        static public readonly long CMND_SIMULATOR_RESTORE = -999912;
        /// <summary>シミュレータ保存指示</summary>
        static public readonly long CMND_SIMULATOR_SAVE = -999913;
        /// <summary>シミュレータ破棄指示</summary>
        static public readonly long CMND_SIMULATOR_DELETE = -999914;

        // <Simulation Notice Event>
        /// <summary>シミュレーション初期化完了報告</summary>
        static public readonly long NOTICE_INITIALIZE_SIMULATION = -999702;
        /// <summary>シミュレーション初期化失敗報告</summary>
        static public readonly long NOTICE_CANNOT_INITIALIZE_SIMULATION = -999701;
        /// <summary>シミュレーション計算開始報告</summary>
        static public readonly long NOTICE_START_SIMULATION = -999703;
        /// <summary>シミュレーション計算開始ＮＧ報告</summary>
        static public readonly long NOTICE_CANNOT_START_SIMULATION = -999705;
        /// <summary>シミュレーション計算中断報告</summary>
        static public readonly long NOTICE_PAUSE_SIMULATION = -999704;
        ///// <summary>シミュレーション再開報告</summary>
        //static public readonly long NOTICE_RESTART_SIMULATION = -999705; // <-- NOTICE_START_SIMULATION で共通化
        /// <summary>シミュレーション計算強制終了指示応答</summary>
        static public readonly long NOTICE_STOP_SIMULATION = -999706;
        /// <summary>シミュレーション計算完了報告</summary>
        static public readonly long NOTICE_COMPLETE_SIMULATION = -999707;
        /// <summary>シミュレーション計算異常終了報告</summary>
        static public readonly long NOTICE_SIMULATION_ABEND = -999775;
        /// <summary>シミュレーション計算進捗状況報告</summary>
        static public readonly long NOTICE_REPORT_SIMU_PROGRESS = -99717;
        /// <summary>シミュレーション中間結果変更報告</summary>
        static public readonly long NOTICE_RENEW_SIMULATION = -999708;
        /// <summary>シミュレーションモデル作成終了報告（正常）</summary>
        static public readonly long NOTICE_OK_MODEL_CONSTRUCTION = -999738;
        /// <summary>シミュレーションモデル作成終了報告（異常）</summary>
        static public readonly long NOTICE_NG_MODEL_CONSTRUCTION = -999739;
        /// <summary>シミュレータ生成完了報告</summary>
        static public readonly long NOTICE_SIMULATOR_CREATE_SUCCESS = -999922;
        /// <summary>シミュレータ生成失敗報告</summary>
        static public readonly long NOTICE_SIMULATOR_CREATE_FAIL = -999923;
        /// <summary>シミュレーション計算スケジュール関連通知イベント（m_lSubEventNoを使用する） </summary>
        static public readonly long NOTICE_SIMU_SCHEDULE_EVENT = -999911;
        /// <summary>シミュレータ復元完了報告</summary>
        static public readonly long NOTICE_END_SIMULATOR_RESTORE = -999712;
        /// <summary>シミュレータ保存完了報告</summary>
        static public readonly long NOTICE_END_SIMULATOR_SAVE = -999713;
        /// <summary>シミュレータ破棄完了報告</summary>
        static public readonly long NOTICE_END_SIMULATOR_DELETE = -999714;
        /// <summary>シミュレータ復元異常報告</summary>
        static public readonly long NOTICE_END_SIMULATOR_RESTORE_NG = -999812;
        /// <summary>シミュレータ保存異常報告</summary>
        static public readonly long NOTICE_END_SIMULATOR_SAVE_NG = -999813;


        // <DB Command/Notice Event>
        /// <summary>DB関連一般指示(通常は使用しない)</summary>
        static public readonly long CMND_DB_COMMON = -999500;
        /// <summary>DB登録検索指示</summary>
        static public readonly long CMND_DB_QUERY = -999501;
        /// <summary>DB関連検索結果</summary>
        static public readonly long NOTICE_DB_QUERY = -999502;
        /// <summary>DB登録指示</summary>
        static public readonly long CMND_DB_REGISTER = -999503;
        //// <summary>DB更新指示</summary>
        //CMND_DB_UPDATE未使用となったためコメント）
        //static public readonly long CMND_DB_UPDATE = -999504;
        /// <summary>DB登録削除</summary>
        static public readonly long CMND_DB_DELETE = -999505;
        /// <summary>DB関連一般報告(処理正常報告)</summary>
        static public readonly long NOTICE_DB_OK = -999506;
        /// <summary>DB関連一般報告(処理異常報告)</summary>
        static public readonly long NOTICE_DB_NG = -999507;

// Ver1.1 追加 >>>
        // <Project Command/Notice Event>
        /// <summary>プロジェクト保存指示</summary>
        static public readonly long CMND_PROJECT_SAVE = -999511;
        /// <summary>プロジェクト保存指示</summary>
        static public readonly long CMND_PROJECT_SAVE_ACT = -999512;
// Ver1.1 追加 <<<

        // <Display Command/Notice Event>
        /// <summary>画面関連一般指示</summary>
        static public readonly long CMND_DISPLY_COMMON = -999400;
        /// <summary>画面関連一般指示</summary>
        static public readonly long CMND_BROADCAST_SCREEN = -999401;
        /// <summary>画面表示指示</summary>
        static public readonly long CMND_DISP_SCREEN = -999402;
        /// <summary>画面表示指示</summary>
        static public readonly long CMND_RENEW_SCREEN = -999413;
        /// <summary>画面消去指示</summary>
        static public readonly long CMND_CLOSE_SCREEN = -999420;

        /// <summary>画面関連一般報告(正常報告)</summary>
        static public readonly long NOTICE_DISPLY_OK = -999498;
        /// <summary>画面関連一般報告(異常報告)</summary>
        static public readonly long NOTICE_DISPLY_NG = -999499;

        /// <summary>画面関連メッセージ表示指示</summary>
        static public readonly long CMND_DISPLY_MESSAGE = -999404;

        // <GIS Command/Notice Event>
        /// <summary>GIS関連一般指示</summary>
        static public readonly long CMND_GIS_COMMON = -999300;
        /// <summary>GIS関連一般報告(正常報告)</summary>
        static public readonly long NOTICE_GIS_OK = -999398;
        /// <summary>GIS関連一般報告(異常報告)</summary>
        static public readonly long NOTICE_GIS_NG = -999399;

        // <業務 Command/Notice Event>
        /// <summary>業務関連メイン画面起動完了報告</summary>
        static public readonly long NOTICE_MAINVIWER_RUN_COMPLETE = -999201;

        /// <summary>業務関連一般指示</summary>
        static public readonly long CMND_BUSIPROC_COMMON = -999202;
        /// <summary>業務関連一般報告(正常報告)</summary>
        static public readonly long NOTICE_BUSIPROC_OK = -999203;
        /// <summary>業務関連一般報告(異常報告)</summary>
        static public readonly long NOTICE_BUSIPROC_NG = -999204;

        // <汎用イベント>
        /// <summary>任意イベント</summary>
        static public readonly long ARBITRARY_EVENT = 0;

// Ver1.2 追加 >>>
        // 外部DB接続処理のバックグラウンド操作化
        // <External DB Command/Notice Event>
        /// <summary>外部データベースツール起動報告</summary>
        static public readonly long NOTICE_EXTDBTOOL_RSD_RUN_COMPLETE = -999101;
        /// <summary>外部データベースツール終了報告</summary>
        static public readonly long NOTICE_EXTDBTOOL_RSD_EXIT_COMPLETE = -999102;
        /// <summary>外部データベースツール起動報告</summary>
        static public readonly long NOTICE_EXTDBTOOL_RW_RUN_COMPLETE = -999103;
        /// <summary>外部データベースツール終了報告</summary>
        static public readonly long NOTICE_EXTDBTOOL_RW_EXIT_COMPLETE = -999104;
        /// <summary>外部データベースツールスレッド終了指示</summary>
        static public readonly long CMND_EXTDBTOOL_RSD_STOP = -999105;
        /// <summary>外部データベースツールスレッド終了指示</summary>
        static public readonly long CMND_EXTDBTOOL_RW_STOP = -999106;
        # region 再検討の為コメント化
        // <LibraryDeleteStart Notice Event>
        ///// <summary>ライブラリ削除開始報告</summary>
        //static public readonly long NOTICE_LIBDEL_START = -999107;
        # endregion
        // Ver1.2 追加 <<<
        // =====================================
        // end of クラス内 定数定義
        // =====================================
    }
}
