﻿// <summary>ソースコード：>ＨＹＳＳＯＰデータ識別子クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>データ識別子クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class HySID : HySIdentifier, HySVersionManagement
    {
        /// <summary>種別</summary>
        protected String m_csKind;
        /// <summary>パッケージ名／ライブラリ名</summary>
        protected String m_csGroupName;
        /// <summary>ユニーク名</summary>
        protected String m_csUniqueKey;

        /// <summary><para>method outline:</para>
        /// <para>デストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>無し</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メモリーリーク防止の為　内部変数は必ず null にセットする</para>
        /// </remarks>
        ~HySID()
        {
            m_csKind = null;
            m_csGroupName = null;
            m_csUniqueKey = null;
            m_sDecodedVersion = null;
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csID = new HySID(csKind, csGroup, csUniqueKey) </para>
        /// </example>
        /// <param name="csKind">種別</param>
        /// <param name="csGroup">パッケージ名／ライブラリ名</param>
        /// <param name="csUniqueKey">ユニーク名</param>
        /// <returns>HySID  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para> システム用（一般モデル開発者は使用しないこと）
        /// 内部では３つのデータは全て一つに纏めて管理される。従って下記の現象に注意
        ///  HySID("a","b","c") 、HySID("abc","","")、HySID("","abc","")、HySID("","","abc") 等はすべて同じと見なされる 
        ///  本コンストラクタの使用を奨励しない
        /// </para>
        /// </remarks>
        [Obsolete("ﾌﾟﾛﾄﾀｲﾌﾟ版互換用：使用を奨励しない")]
        public HySID(HySString csKind, HySString csGroup, HySString csUniqueKey)
        {
            m_csKind = csKind.ToString();
            m_csGroupName = csGroup.ToString();
            m_csUniqueKey = csUniqueKey.ToString();
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csID = new HySID(csKind, csGroup, csUniqueKey) </para>
        /// </example>
        /// <param name="csKind">種別</param>
        /// <param name="csGroup">パッケージ名／ライブラリ名</param>
        /// <param name="csUniqueKey">ユニーク名</param>
        /// <returns>HySID  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para> システム用（一般モデル開発者は使用しないこと）
        /// 内部では３つのデータは全て一つに纏めて管理される。従って下記の現象に注意
        ///  HySID("a","b","c") 、HySID("abc","","")、HySID("","abc","")、HySID("","","abc") 等はすべて同じと見なされる
        ///  本コンストラクタの使用を奨励しない
        /// </para>
        /// </remarks>
        [Obsolete("ﾌﾟﾛﾄﾀｲﾌﾟ版互換用：使用を奨励しない")]
        public HySID(String csKind, String csGroup, String csUniqueKey)
        {
            m_csKind = csKind;
            m_csGroupName = csGroup;
            m_csUniqueKey = csUniqueKey;
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csID = new HySID(csUniqueKey) </para>
        /// </example>
        /// <param name="csUniqueKey">ユニーク名</param>
        /// <returns>HySID  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySID(HySString csUniqueKey)
        {
            m_csKind = "";
            m_csGroupName = "";
            m_csUniqueKey = csUniqueKey.ToString();
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csID = new HySID(csUniqueKey) </para>
        /// </example>
        /// <param name="csUniqueKey">ユニーク名</param>
        /// <returns>HySID  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySID(String csUniqueKey)
        {
            m_csKind = "";
            m_csGroupName = "";
            m_csUniqueKey = csUniqueKey;
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>自分と同じクラスのインスタンスを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csID = Clone() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySID  生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySID Clone()
        {
            //HySID csRtn = new HySID(this.m_csKind, this.m_csGroupName, this.m_csUniqueKey);
            HySID csRtn = new HySID(this.m_csUniqueKey);
            csRtn.m_csKind = this.m_csKind;
            csRtn.m_csGroupName = this.m_csGroupName;
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bWork = Equals(csIdentifier) </para>
        /// </example>
        /// <param name="csIdentifier">データ識別子 </param>
        /// <returns>Boolean　true:=一致, false:=不一致</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean Equals(HySIdentifier csIdentifier)
        {
            Boolean bRtn = false;
            HySID csID = csIdentifier as HySID;
            if ((object)csID == null)
            {
                return bRtn;
            }
            if ((m_csKind + m_csGroupName + m_csUniqueKey).Equals(csID.m_csKind + csID.m_csGroupName + csID.m_csUniqueKey) == true)
            {
                bRtn = true;
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bWork = Equals(csObj) </para>
        /// </example>
        /// <param name="csObj">データ識別子 </param>
        /// <returns>Boolean　true:=一致, false:=不一致</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean Equals(object csObj)
        {
            HySID csID = csObj as HySID;
            if ((object)csID == null)
            {
                return false;
            }

            return Equals(csID);
        }

        /// <summary><para>method outline:</para>
        /// <para>演算子のオーバーロード（==）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRt = (csObj1 == csObj2) </para>
        /// </example>
        /// <param name="csObj1">比較する種別識別子</param>
        /// <param name="csObj2">比較する種別識別子</param>
        /// <returns>Boolean　true:=一致, false:=不一致</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>Equalsに比べて、処理速度は遅くなる</para>
        /// </remarks>
        public static bool operator ==(HySID csObj1, HySID csObj2)
        {
            Boolean bRtn = false;
            if ((object)csObj1 != null)
            {
                bRtn = csObj1.Equals(csObj2);
            }
            else
            {
                if ((object)csObj2 == null)
                {
                    bRtn =  true;
                }
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>演算子のオーバーロード（!=）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRt = (csObj1 != csObj2) </para>
        /// </example>
        /// <param name="csObj1">比較する種別識別子</param>
        /// <param name="csObj2">比較する種別識別子</param>
        /// <returns>Boolean　true:=一致, false:=不一致</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>Equalsに比べて、処理速度は遅くなる</para>
        /// </remarks>
        public static bool operator !=(HySID csObj1, HySID csObj2)
        {
            Boolean bRtn = false;
            if ((object)csObj1 != null)
            {
                bRtn = !(csObj1.Equals(csObj2));
            }
            else
            {
                if ((object)csObj2 != null)
                {
                    bRtn = true;
                }
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>演算子のオーバーロード（+）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID Rtn = csObj1 + csObj2 </para>
        /// </example>
        /// <param name="csObj1">識別子</param>
        /// <param name="csObj2">＋する識別子</param>
        /// <returns>HySID　+ した値</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para> 処理速度は遅くなる</para>
        /// </remarks>
        public static HySID operator +(HySID csObj1, HySID csObj2)
        {
            return new HySID( csObj1.ToString() + csObj2.ToString());
        }

        /// <summary><para>method outline:</para>
        /// <para>全体識別子の文字列変換</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySStringRoot csStringRoot = GetString() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySStringRoot  識別子の文字列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySStringRoot GetString()
        {
            String csStrWk = m_csKind + m_csGroupName + m_csUniqueKey;
            return new HySString(csStrWk);
        }        
        /*
        /// <summary><para>method outline:</para>
        /// <para>全体識別子の文字列変換</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySStringRoot csStringRoot = GetString() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySStringRoot  識別子の文字列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new HySString GetString()
        {
            String csStrWk = m_csKind + m_csGroupName + m_csUniqueKey;
            return new HySString(csStrWk);
        }
        */
        /// <summary><para>method outline:</para>
        /// <para>全体識別子の文字列変換</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> String csString = ToString() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>String  識別子の文字列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override String ToString()
        {
            String csStrWk = m_csKind + m_csGroupName + m_csUniqueKey;
            return csStrWk;
        }
        
        /// <summary><para>method outline:</para>
        /// <para>ユニークキー部の文字列変換</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> String csStr = GetUniqueKeyString() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>String  ユニーク名</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        [Obsolete("ﾌﾟﾛﾄﾀｲﾌﾟ版互換用：使用禁止")]
        public String GetUniqueKeyString()
        { return m_csKind+m_csGroupName+m_csUniqueKey; }
        /// <summary><para>method outline:</para>
        /// <para>ユニークキー部の文字列変換</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csString = ToUniqueKeyString() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString  ユニーク名</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        [Obsolete("ﾌﾟﾛﾄﾀｲﾌﾟ版互換用：使用禁止")]
        public HySString ToUniqueKeyString()
        { return new HySString(m_csKind + m_csGroupName + m_csUniqueKey); }
        
        /// <summary><para>method outline:</para>
        /// <para>ハッシュ コード生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> int iCode = GetHashCode() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>int  ハッシュコード</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override int GetHashCode()
        {
            return (m_csKind + m_csGroupName + m_csUniqueKey).GetHashCode();
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
