﻿// <summary>ソースコード：>ＨＹＳＳＯＰdoube　変数専用　リンクリストクラス</summary>
// <author>CommonMP</author>

using System;
using System.Threading;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>doube 変数専用　リンクリストクラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>Remarks:</para>
    /// <para>C# LinkedList(double) クラスのラッパーの役割を果たす</para>
    /// </remarks>
    [Serializable]
    public class HySLinkedListDouble : HySDataRoot, HySVersionManagement //IDeserializationCallback
    {
        /// <summary>double情報リスト</summary>
        LinkedList<double> m_csDataList = null;

        /// <summary>現在作業中ノード</summary>
        [NonSerialized]
        LinkedListNode<double> m_csCurrentNode = null;

        /// <summary>処理中ミューテックス</summary>
        [NonSerialized]
        private HySMutex m_csBusy = null;

                /// <summary><para>method outline:</para>
        /// <para>デストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>無し</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メモリーリーク防止の為　内部変数は必ず null にセットする</para>
        /// </remarks>
        ~HySLinkedListDouble()
        {
            try
            {
                if (m_csDataList != null)
                {
                    m_csDataList.Clear();
                }
                m_csCurrentNode = null;
                m_csDataList = null;
                m_csBusy = null;
                m_sDecodedVersion = null;
            }
            catch
            {
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySLinkedListDouble csLinkedList = new HySLinkedListDouble() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySLinkedListDouble  生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySLinkedListDouble()
        {
            m_csBusy = new HySMutex();
            m_csDataList = new LinkedList<double>();
            m_csCurrentNode = null;
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>データ数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lCount = GetCount() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long  データ数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetCount()
        {
            return (long)m_csDataList.Count;
        }

        /// <summary><para>method outline:</para>
        /// <para>データの追加(リストの最初に追加される)</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lCount = AddFirst(dData) </para>
        /// </example>
        /// <param name="dData">追加するデータ</param>
        /// <returns>long  データの数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long AddFirst(double dData)
        {
            m_csDataList.AddFirst(dData);
            m_csCurrentNode = m_csDataList.First;
            return m_csDataList.Count;
        }
        /// <summary><para>method outline:</para>
        /// <para>データの追加(リストの最後に追加される)</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lCount = AddLast(dData) </para>
        /// </example>
        /// <param name="dData">追加するデータ</param>
        /// <returns>long  データの数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long AddLast(double dData)
        {
            m_csDataList.AddLast(dData);
            m_csCurrentNode = m_csDataList.Last;
            return m_csDataList.Count;
        }

        /// <summary><para>method outline:</para>
        /// <para>最初のデータを取り外す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lCount = RemoveFirstData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long  データの数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long RemoveFirstData()
        {
            m_csDataList.RemoveFirst();
            m_csCurrentNode = m_csDataList.First;
            return m_csDataList.Count;
        }
        /// <summary><para>method outline:</para>
        /// <para>最後のデータを取り外す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lCount = RemoveLastData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long  データの数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long RemoveLastData()
        {
            if (m_csDataList.Count > 0)
            {
                m_csDataList.RemoveLast();
                m_csCurrentNode = m_csDataList.First;
            }
            else
            {
                m_csCurrentNode = null;
            }
            return m_csDataList.Count;
        }
        /// <summary><para>method outline:</para>
        /// <para>指定位置のデータを取り外す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lCount = RemoveData(lOrderNo) </para>
        /// </example>
        /// <param name="lOrderNo">リスト上の位置（０相対）</param>
        /// <returns>long  データの数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long RemoveData(long lOrderNo)
        {
            m_csCurrentNode = m_csDataList.First;
            for (int iLp = 0; iLp < lOrderNo; iLp++)
            {
                m_csCurrentNode = m_csCurrentNode.Next;
            }
            m_csDataList.Remove(m_csCurrentNode);
            m_csCurrentNode = m_csDataList.First;
            return m_csDataList.Count;
        }

        /// <summary><para>method outline:</para>
        /// <para>カーソル位置を最初に持ってくる</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCursorFirst() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCursorFirst()
        {
            m_csCurrentNode = m_csDataList.First;
        }
        /// <summary><para>method outline:</para>
        /// <para>カーソル位置を最後に持ってくる</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCursorLast() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCursorLast()
        {
            m_csCurrentNode = m_csDataList.Last;
        }
        /// <summary><para>method outline:</para>
        /// <para>カーソル位置を次の位置に持ってくる</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> MoveCursorNext() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void MoveCursorNext()
        {
            if (m_csCurrentNode != null)
            {
                if (m_csCurrentNode.Next != null)
                {
                    m_csCurrentNode = m_csCurrentNode.Next;
                }
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>カーソル位置を一つ前に戻す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> MoveCursorPrev() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void MoveCursorPrev()
        {
            if (m_csCurrentNode != null)
            {
                if (m_csCurrentNode.Previous != null)
                {
                    m_csCurrentNode = m_csCurrentNode.Previous;
                }
            }

        }
        /// <summary><para>method outline:</para>
        /// <para>カーソル位置のデータを取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> double dRtn = GetCursorData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>
        /// double  データ値
        /// カーソル位置不定の場合には　-1.0E32 が返る
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public double GetCursorData()
        {
            double dRtn = -1.0E32;
            if (m_csCurrentNode != null)
            {
                dRtn = m_csCurrentNode.Value;
            }
            return dRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>指定位置のデータを取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> double dDt = GetData(lOrderNo) </para>
        /// </example>
        /// <param name="lOrderNo">指定位置</param>
        /// <returns>
        /// double  データ値
        /// カーソル位置不定の場合には　-1.0E32 が返る
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>速度を重視する場合には、GetCursorData() を用いる</para>
        /// </remarks>
        public double GetData(long lOrderNo)
        {
            double dRtn = -1.0E32;
            m_csCurrentNode = m_csDataList.First;
            for (int iLp = 0; iLp < lOrderNo; iLp++)
            {
                m_csCurrentNode = m_csCurrentNode.Next;
            }
            if (m_csCurrentNode != null)
            {
                dRtn = m_csCurrentNode.Value;
            }
            return dRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>先頭データ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> double dDt = GetFirstData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>
        /// double  データ値
        /// リスト上にデータ無しならば　-1.0E32 が返る</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>先頭から指定数後のデータを取得する</para>
        /// </remarks>
        public double GetFirstData()
        {
            double dRtn = -1.0E32;
            if (m_csDataList.First != null)
            {
                dRtn = m_csDataList.First.Value;
            }
            return dRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>最終データ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> double dDt = GetLastData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>
        /// doubleデータ
        /// リスト上にデータ無しならば　-1.0E32 が返る</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>先頭から指定数後のデータを取得する</para>
        /// </remarks>
        public double GetLastData()
        {
            double dRtn = -1.0E32;
            if (m_csDataList.Last != null)
            {
                dRtn = m_csDataList.Last.Value;
            }
            return dRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>全データ取り外し</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clear() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void Clear()
        {
            m_csDataList.Clear();
            m_csCurrentNode = null;
        }

        /// <summary><para>method outline:</para>
        /// <para>リンクトリストをロックする</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Lock() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>カーソル位置を他の処理から変更されたくない場合等に用いる（デッドロックに気を付けること）</para>
        /// </remarks>
        public void Lock()
        {
            m_csBusy.Wait();
        }
        /// <summary><para>method outline:</para>
        /// <para>リンクトリストをロック解除する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Unlock() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>カーソル位置を他の処理から変更されたくない場合等に用いる（デッドロックに気を付けること）</para>
        /// </remarks>
        public void Unlock()
        {
            m_csBusy.Release();
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            m_csBusy = new HySMutex(); // <-- 重要
            m_csCurrentNode = null; // <-- 重要

            if (GetDecodedVersion() != GetNowVersion())
            {
                if (GetDecodedVersion() == null)
                {
                    // 旧バージョンからの移行処理を入れる
                }
                else
                {
                    //旧バージョンから順にバージョンを上げて行く
                    switch (GetDecodedVersion())
                    {
                        case "1.00":
                            {
                                // 旧バージョンからの移行処理を入れる
                                break;
                            }
                        //case "2.00": << 以後バージョンアップに伴って処理追加
                        //{
                        //    break;
                        //}
                    }                    
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
