﻿// <summary>ソースコード：>ＨＹＳＳＯＰHySTime 変数専用　リンクリストクラス</summary>
// <author>CommonMP</author>

using System;
using System.Threading;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;

using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>HySTime 変数専用　リンクリストクラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>Remarks:</para>
    /// <para>C# LinkedList(HySTime) クラスのラッパーの役割を果たす</para>
    /// </remarks>
    [Serializable]
    public class HySLinkedListTime : HySDataRoot, HySVersionManagement //IDeserializationCallback
    {
        /// <summary>double情報リスト</summary>
        LinkedList<HySTime> m_csTimeList = null;

        /// <summary>現在作業中ノード</summary>
        [NonSerialized]
        LinkedListNode<HySTime> m_csCurrentNode = null;

        /// <summary>処理中ミューテックス</summary>
        [NonSerialized]
        private HySMutex m_csBusy = null;

        /// <summary><para>method outline:</para>
        /// <para>デストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>無し</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メモリーリーク防止の為　内部変数は必ず null にセットする</para>
        /// </remarks>
        ~HySLinkedListTime()
        {
            try
            {
                if (m_csTimeList != null)
                {
                    m_csTimeList.Clear();
                }
                m_csCurrentNode = null;
                m_csTimeList = null;
                m_csBusy = null;
                m_sDecodedVersion = null;
            }
            catch
            {
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySLinkedListTime csLinkedListTime = new HySLinkedListTime() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySLinkedListTime  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySLinkedListTime()
        {
            m_csBusy = new HySMutex();
            m_csTimeList = new LinkedList<HySTime>();
            m_csCurrentNode = null;
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>データ数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lCount = GetCount() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long  データ数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetCount()
        {
            return (long)m_csTimeList.Count;
        }

        /// <summary><para>method outline:</para>
        /// <para>データの追加(リストの最初に追加される)</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lCount = AddFirst(csTime) </para>
        /// </example>
        /// <param name="csTime">追加する時間データ</param>
        /// <returns>long  データの数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long AddFirst(HySTime csTime)
        {
            m_csTimeList.AddFirst(csTime);
            m_csCurrentNode = m_csTimeList.First;
            return m_csTimeList.Count;
        }
        /// <summary><para>method outline:</para>
        /// <para>データの追加(リストの最後に追加される)</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lCount = AddLast(csTime) </para>
        /// </example>
        /// <param name="csTime">追加する時間データ</param>
        /// <returns>long  データの数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long AddLast(HySTime csTime)
        {
            m_csTimeList.AddLast(csTime);
            m_csCurrentNode = m_csTimeList.Last;
            return m_csTimeList.Count;
        }

        /// <summary><para>method outline:</para>
        /// <para>最初のデータを取り外す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTime csTime = RemoveFirstData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySTime  取り外したデータ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySTime RemoveFirstData()
        {
            HySTime csRtn = null;
            m_csCurrentNode = m_csTimeList.First;
            if (m_csCurrentNode != null)
            {
                csRtn = m_csCurrentNode.Value;
            }
            m_csTimeList.RemoveFirst();
            m_csCurrentNode = m_csTimeList.First;
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>最後のデータを取り外す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTime csTime = RemoveLastData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySTime  取り外したデータ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySTime RemoveLastData()
        {
            HySTime csRtn = null;
            m_csCurrentNode = m_csTimeList.Last;
            if (m_csCurrentNode != null)
            {
                csRtn = m_csCurrentNode.Value;
            }
            if (m_csTimeList.Count > 0)
            {
                m_csTimeList.RemoveLast();
                m_csCurrentNode = m_csTimeList.First;
            }
            else
            {
                m_csCurrentNode = null;
            }
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>指定位置のデータを取り外す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTime csTime = RemoveData(lOrderNo) </para>
        /// </example>
        /// <param name="lOrderNo">リスト上の位置（０相対）</param>
        /// <returns>HySTime  取り外したデータ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySTime RemoveData(long lOrderNo)
        {
            HySTime csRtn = null;
            m_csCurrentNode = m_csTimeList.First;
            for (int iLp = 0; iLp < lOrderNo; iLp++)
            {
                m_csCurrentNode = m_csCurrentNode.Next;
            }
            if (m_csCurrentNode != null)
            {
                m_csTimeList.Remove(m_csCurrentNode);
                csRtn = m_csCurrentNode.Value;
               
            }
            m_csCurrentNode = m_csTimeList.First;
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>カーソル位置を最初に持ってくる</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCursorFirst() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCursorFirst()
        {
            m_csCurrentNode = m_csTimeList.First;
        }
        /// <summary><para>method outline:</para>
        /// <para>カーソル位置を最後に持ってくる</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCursorLast() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCursorLast()
        {
            m_csCurrentNode = m_csTimeList.Last;
        }
        /// <summary><para>method outline:</para>
        /// <para>カーソル位置を次の位置に持ってくる</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> MoveCursorNext() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void MoveCursorNext()
        {
            if (m_csCurrentNode != null)
            {
                if (m_csCurrentNode.Next != null)
                {
                    m_csCurrentNode = m_csCurrentNode.Next;
                }
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>カーソル位置を一つ前に戻す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> MoveCursorPrev() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void MoveCursorPrev()
        {
            if (m_csCurrentNode != null)
            {
                if (m_csCurrentNode.Previous != null)
                {
                    m_csCurrentNode = m_csCurrentNode.Previous;
                }
            }

        }
        /// <summary><para>method outline:</para>
        /// <para>カーソル位置の時間を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTime csTime = GetCursorData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>
        /// HySTime  時間
        /// カーソル位置不定の場合には　null が返る
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySTime GetCursorData()
        {
            HySTime csRtn = null;
            if (m_csCurrentNode != null)
            {
                csRtn = m_csCurrentNode.Value;
            }
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>指定位置の時間を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTime csTime = GetDatat(lOrderNo) </para>
        /// </example>
        /// <param name="lOrderNo">指定位置</param>
        /// <returns>
        /// HySTime  時間
        /// カーソル位置不定の場合には　null が返る
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>速度を重視する場合には、GetCursorData() を用いる</para>
        /// </remarks>
        public HySTime GetDatat(long lOrderNo)
        {
            HySTime csRtn = null;
            m_csCurrentNode = m_csTimeList.First;
            for (int iLp = 0; iLp < lOrderNo; iLp++)
            {
                m_csCurrentNode = m_csCurrentNode.Next;
            }
            if (m_csCurrentNode != null)
            {
                csRtn = m_csCurrentNode.Value;
            }
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>先頭時間の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTime csTime = GetFirstData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>
        /// HySTime  時間
        /// リスト上にデータ無しならば　null が返る</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>先頭から指定数後のデータを取得する</para>
        /// </remarks>
        public HySTime GetFirstData()
        {
            HySTime csRtn = null;
            if (m_csTimeList.First != null)
            {
                csRtn = m_csTimeList.First.Value;
            }
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>最終時間の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTime csTime = GetLastData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>
        /// HySTime  時間
        /// リスト上にデータ無しならば　null が返る</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>先頭から指定数後のデータを取得する</para>
        /// </remarks>
        public HySTime GetLastData()
        {
            HySTime csRtn = null;
            if (m_csTimeList.Last != null)
            {
                csRtn = m_csTimeList.Last.Value;
            }
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>全データ取り外し</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clear() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void Clear()
        {
            m_csTimeList.Clear();
            m_csCurrentNode = null;
        }

        /// <summary><para>method outline:</para>
        /// <para>リンクトリストをロックする</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Lock() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>カーソル位置を他の処理から変更されたくない場合等に用いる（デッドロックに気を付けること）</para>
        /// </remarks>
        public void Lock()
        {
            m_csBusy.Wait();
        }
        /// <summary><para>method outline:</para>
        /// <para>リンクトリストをロック解除する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Unlock() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>カーソル位置を他の処理から変更されたくない場合等に用いる（デッドロックに気を付けること）</para>
        /// </remarks>
        public void Unlock()
        {
            m_csBusy.Release();
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            m_csBusy = new HySMutex();  // <-- 重要
            m_csCurrentNode = null;  // <-- 重要

            if (GetDecodedVersion() != GetNowVersion())
            {
                if (GetDecodedVersion() == null)
                {
                    // 旧バージョンからの移行処理を入れる
                }
                else
                {
                    //旧バージョンから順にバージョンを上げて行く
                    switch (GetDecodedVersion())
                    {
                        case "1.00":
                            {
                                // 旧バージョンからの移行処理を入れる
                                break;
                            }
                        //case "2.00": << 以後バージョンアップに伴って処理追加
                        //{
                        //    break;
                        //}
                    }                    
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
