﻿// <summary>ソースコード：>ＨＹＳＳＯＰ種別識別子クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>種別識別子データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class HySObjectKind : HySKind, HySVersionManagement
    {
        /// <summary>データ種別キーデータ</summary>
        protected String m_csKindKey;

                   
        /// <summary><para>method outline:</para>
        /// <para>デストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>無し</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メモリーリーク防止の為　内部変数は必ず null にセットする</para>
        /// </remarks>
        ~HySObjectKind()
        {
            m_csKindKey=null;
            m_sDecodedVersion = null;
        }
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySObjectKind csObjectKind = new HySObjectKind() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySObjectKind  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySObjectKind()
        {
            m_csKindKey = "";
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySObjectKind csObjectKind = new HySObjectKind(csKindKey) </para>
        /// </example>
        /// <param name="csKindKey">種別データキー</param>
        /// <returns>HySObjectKind  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySObjectKind(HySStringRoot csKindKey)
        {
            if (csKindKey != null)
            {
                m_csKindKey = csKindKey.ToString();
            }
            else
            {
                m_csKindKey = "";
            }
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySObjectKind csObjectKind = new HySObjectKind(sKindKey) </para>
        /// </example>
        /// <param name="sKindKey">種別データキー</param>
        /// <returns>HySObjectKind  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySObjectKind(string sKindKey)
        {
            m_csKindKey = sKindKey;
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>自分と同じクラスのインスタンスを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySObjectKind csObjectKind = Clone() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySObjectKind　 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySObjectKind Clone()
        {
            HySObjectKind csRtn = new HySObjectKind(this.m_csKindKey);
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bWork = Equal(csKind) </para>
        /// </example>
        /// <param name="csKind">比較する種別識別子</param>
        /// <returns>Boolean　true:=一致, false:=不一致</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean Equals(HySKind csKind)
        {
            HySObjectKind csObjKind = csKind as HySObjectKind;
            if ((object)csObjKind == null)
            {
                return false;
            }
            return m_csKindKey.Equals(csObjKind.m_csKindKey);
        }
        /// <summary><para>method outline:</para>
        /// <para>識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bWork = Equals(csObj) </para>
        /// </example>
        /// <param name="csObj">比較する種別識別子</param>
        /// <returns>Boolean　true:=一致, false:=不一致</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean Equals(object csObj)
        {
            HySObjectKind csObjKind = csObj as HySObjectKind;
            if ((object)csObjKind == null)
            {
                return false;
            }
            return Equals(csObjKind);
        }
        /// <summary><para>method outline:</para>
        /// <para>演算子のオーバーロード（==）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRt = (csObj1 == csObj2) </para>
        /// </example>
        /// <param name="csObj1">比較する種別識別子</param>
        /// <param name="csObj2">比較する種別識別子</param>
        /// <returns>bool　true:=一致, false:=不一致</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static bool operator ==(HySObjectKind csObj1, HySObjectKind csObj2)
        {
            bool bRtn = false;
            if ((object)csObj1 != null)
            {
                bRtn = csObj1.Equals(csObj2);
            }
            else
            {
                if ((object)csObj2 == null)
                {
                    bRtn = true;
                }
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>演算子のオーバーロード（!=）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRt = (csObj1 != csObj2) </para>
        /// </example>
        /// <param name="csObj1">比較する種別識別子</param>
        /// <param name="csObj2">比較する種別識別子</param>
        /// <returns>bool　true:=不一致, false:=一致</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static bool operator !=(HySObjectKind csObj1, HySObjectKind csObj2)
        {
            bool bRtn = false;
            if ((object)csObj1 != null)
            {
                bRtn = !(csObj1.Equals(csObj2));
            }
            else
            {
                if ((object)csObj2 != null)
                {
                    bRtn = true;
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>識別子の文字列変換</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csString = GetString() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString  文字列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySStringRoot GetString()
        {
            return new HySString(m_csKindKey);
        }
        /// <summary><para>method outline:</para>
        /// <para>識別子の文字列変換</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> String csString = ToString() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>String  文字列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override String ToString()
        {
            return m_csKindKey;
        }

        /// <summary><para>method outline:</para>
        /// <para>ハッシュ コード生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> int iCode = GetHashCode() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>int  ハッシュコード</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override int GetHashCode()
        {
            return m_csKindKey.GetHashCode();
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
