﻿// <summary>ソースコード：>ＨＹＳＳＯＰライブラリ管理制御クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>データコンテナ</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class HySSimulationDataContainer : HySSimulationContainer, HySVersionManagement
    {
        /// <summary>シミュレーター種別識別子</summary>
        protected HySObjectKind m_csKindID = null;
        /// <summary>データ識別子</summary>
        protected HySIdentifier m_csDataID = null;

        /// <summary>データ管理テーブル</summary>
        protected HySDataHashTable m_csDataTable = null;

        /// <summary>シミュレーション計算時刻</summary>
        protected HySDate m_csGoalTime = HySCalendar.CreateNowTime()+ new HySTime(24,0,0);
        /// <summary>シミュレーション初期時刻</summary>
        protected HySDate m_csStartTime = HySCalendar.CreateNowTime();
        /// <summary>シミュレーション目標時刻</summary>
        protected HySDate m_csSimuTime = HySCalendar.CreateNowTime();
        /// <summary>シミュレーション刻み時間</summary>
        protected HySDate m_csDltTime = new HySTime(1,0,0);

         
        /// <summary><para>method outline:</para>
        /// <para>デストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>無し</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メモリーリーク防止の為　内部変数は必ず null にセットする</para>
        /// </remarks>
        ~HySSimulationDataContainer()
        {
            try
            {
                if (m_csDataTable != null)
                {
                    m_csDataTable.ClearAllObject();
                }
                m_csDataTable = null;
                m_csKindID = null;
                m_csDataID = null;
                m_csGoalTime = null;
                m_csStartTime = null;
                m_csSimuTime = null;
                m_csDltTime = null;
                m_sDecodedVersion = null;
            }
            catch
            {
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySSimulationDataContainer csDataContainer = new HySSimulationDataContainer()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySSimulationDataContainer  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected HySSimulationDataContainer()
        {
            this.Init();
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySSimulationDataContainer csDataContainer = new HySSimulationDataContainer(csSimulatorKind, csKey)</para>
        /// </example>
        /// <param name="csSimulatorKind">シミュレーター種別識別子</param>
        /// <param name="csKey">データ識別子</param>
        /// <returns>HySSimulationDataContainer  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySSimulationDataContainer(HySKind csSimulatorKind, HySIdentifier csKey)
        {
            this.Init();
            this.SetSimKind(csSimulatorKind);
            this.SetID(csKey);
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Init() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected void Init()
        {
            m_csDataTable = new HySDataHashTable();
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSimKind(csSimKindID) </para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetSimKind(HySKind csSimKindID)
        {
            m_csKindID = (HySObjectKind)csSimKindID;
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetSimKind() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySKind  シミュレーター種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySKind GetSimKind()
        {
            return m_csKindID;
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bWork = EqualSimKind(csSimKindID) </para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>bool　true:=一致, false:=不一致</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool EqualSimKind(HySKind csSimKindID)
        {
            return m_csKindID.Equals(csSimKindID);
        }
        /// <summary><para>method outline:</para>
        /// <para>識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetID(csID) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetID(HySIdentifier csID)
        {
            m_csDataID = csID;
        }
        /// <summary><para>method outline:</para>
        /// <para>識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySIdentifier csID = GetID() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySIdentifier  識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySIdentifier GetID()
        {
            return m_csDataID;
        }
        /// <summary><para>method outline:</para>
        /// <para>識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Equal(csID) </para>
        /// </example>
        /// <param name="csID">比較する種別識別子</param>
        /// <returns>Boolean　true:=一致, false:=不一致</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean Equal(HySIdentifier csID)
        {
            return m_csDataID.Equals(csID);
        }

        /// <summary><para>method outline:</para>
        /// <para>ＩＯ出力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = IOOut(csIO) </para>
        /// </example>
        /// <param name="csIO">ＩＯ</param>
        /// <returns>long　0:=正常, ＜0:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override long IOOut(HySIOStream csIO)
        {
            long lRtn = 0;
            return lRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>ＩＯ入力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = IOIn(csIO) </para>
        /// </example>
        /// <param name="csIO">ＩＯ</param>
        /// <returns>long　0:=正常, ＜0:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override long IOIn(HySIOStream csIO)
        {
            long lRtn = 0;
            return lRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>データ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetData(csKey, csDt) </para>
        /// </example>
        /// <param name="cskey">キー</param>
        /// <param name="csDt">データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetData(HySStringRoot cskey, HySDataRoot csDt)
        {
            m_csDataTable.AddObject((HySString)cskey, csDt);
        }
        /// <summary><para>method outline:</para>
        /// <para>データ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HysDataRoot csDataRoot = GetData(csKey) </para>
        /// </example>
        /// <param name="csKey">キー</param>
        /// <returns>HySDataRoot  データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySDataRoot GetData(HySStringRoot csKey)
        {
            return m_csDataTable.GetObject((HySString)csKey);
        }
        /// <summary><para>method outline:</para>
        /// <para>データ削除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> DeleteData(csKey) </para>
        /// </example>
        /// <param name="csKey">キー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void DeleteData(HySStringRoot csKey)
        {
            m_csDataTable.DeleteData((HySString)csKey);
        }

        // ＝＝　シミュレーション時間関係管理　＝＝

        /// <summary><para>method outline:</para>
        /// <para>シミュレーション計算初期時刻設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetStartTime(csTime) </para>
        /// </example>
        /// <param name="csTime">時刻</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetStartTime(HySDate csTime)
        {
            if (m_csStartTime != null)
            {
                ((HySTime)m_csStartTime).SetTime((HySTime)csTime);
            }
            else
            {
                m_csStartTime = csTime;
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーション計算初期時刻取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDate csStartTime = GetStartTime() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDate  時刻</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySDate GetStartTime()
        {
            return m_csStartTime;
        }
        /// <summary><para>method outline:</para>
        /// <para>目標時間設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetGoalTime(csTime)</para>
        /// </example>
        /// <param name="csTime">時刻</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetGoalTime(HySDate csTime)
        {
            if (m_csGoalTime != null)
            {
                ((HySTime)m_csGoalTime).SetTime((HySTime)csTime);
            }
            else
            {
                m_csGoalTime = csTime;
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>目標時間取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDate csGoalTime = GetGoalTime() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDate  時刻</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySDate GetGoalTime()
        {
            return m_csGoalTime;
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーション計算時刻設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSimuTIme(csTime) </para>
        /// </example>
        /// <param name="csTime">時刻</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetSimuTime(HySDate csTime)
        {
            if (m_csSimuTime != null)
            {
                ((HySTime)m_csSimuTime).SetTime((HySTime)csTime);
            }
            else
            {
                m_csSimuTime = csTime;
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーション計算時刻取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDate csSimuTime = GetSimuTime() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDate  時刻</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySDate GetSimuTime()
        {
            return m_csSimuTime;
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーション計算刻み時間設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDeltaTime(csDltTm) </para>
        /// </example>
        /// <param name="csDltTm">刻み時間</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetDeltaTime(HySDate csDltTm)
        {
            if (m_csDltTime != null)
            {
                ((HySTime)m_csDltTime).SetTime((HySTime)csDltTm);
            }
            else
            {
                m_csDltTime = csDltTm;
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーション計算刻み時間取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDate csDeltaTime = GetDeltaTime() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDate  刻み時間</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySDate GetDeltaTime()
        {
            return m_csDltTime;
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーション目標時刻到達</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = IsTimeUp() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>Boolean  true:=到達, false:=未到達</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シミュレーション時刻が目標時刻と同じまたは過ぎたならば true を返す</para>
        /// </remarks>
        public override Boolean IsTimeUp()
        {
            Boolean bRtn = false;
            if ((bRtn = m_csSimuTime.Equals(m_csGoalTime)) == false)
            {
                bRtn = m_csSimuTime.After(m_csGoalTime);
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>インスタンス複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySSimulationDataContainer csDataContainer = DuplicateData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySSimulationDataContainer  データコンテナ複製インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>複製に失敗した場合はnullが返却される</para>
        /// </remarks>
        public virtual HySSimulationDataContainer DuplicateData()
        {
            // 自分自身の複製インスタンスを返す。
            HySSimulationDataContainer csDuplicateData = null;

            csDuplicateData = (HySSimulationDataContainer)HySDataDuplicate.DupliCateData(this);

            return csDuplicateData;
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {
            base.PostDeserialize();

            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /*
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
        */
    }
}
