﻿// <summary>ソースコード：>ＨＹＳＳＯＰシミュレーションスケジュールデータクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary>
    /// シミュレーションスケジュールデータクラス
    /// 処理内容、メソッドはすべてダミー
    /// </summary>
    [Serializable]
    public class HySSimulationScheduleData : HySDataRoot, HySVersionManagement
    {
        /// <summary>スケジュール名称</summary>
        protected HySString m_csSimSchName;
        /// <summary>スケジュール識別子</summary>
        protected HySID m_csID;
        /// <summary>ロック中フラグ</summary>
        protected bool m_bLockFlg;
        /// <summary>演算スケジュール単位リスト</summary>
        HySDataLinkedList m_csSimlatorUnitList;

        
        /// <summary><para>method outline:</para>
        /// <para>デストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>無し</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メモリーリーク防止の為　内部変数は必ず null にセットする</para>
        /// </remarks>
        ~HySSimulationScheduleData()
        {
            try
            {
                m_sDecodedVersion = null;
                m_bLockFlg = false;
                if (m_csSimlatorUnitList != null)
                {
                    m_csSimlatorUnitList.Clear();
                }
                m_csSimlatorUnitList = null;
                m_csSimSchName = null;
                m_csID = null;
            }
            catch
            {
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySSimulationScheduleData csSimulationScheduleData = new HySSimulationScheduleData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySSimulationScheduleData  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySSimulationScheduleData()
        {
            m_csSimlatorUnitList = new HySDataLinkedList();
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>演算スケジュール構成要素名称設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSimSchName(csSimuName) </para>
        /// </example>
        /// <param name="csSimuName">名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetSimSchName(HySString csSimuName)
        {
            m_csSimSchName = csSimuName;
        }

        /// <summary><para>method outline:</para>
        /// <para>登録中の演算スケジュール単位の数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lNum = GetUnitNum() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long  演算スケジュール単位の数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetUnitNum()
        {
            return m_csSimlatorUnitList.GetCount();
        }
        /// <summary><para>method outline:</para>
        /// <para>演算スケジュール単位クリア</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ClearUnit() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void ClearUnit()
        {
            m_csSimlatorUnitList.Clear();
        }
        /// <summary><para>method outline:</para>
        /// <para>スケジュール単位追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AddUnit(csUnitDt) </para>
        /// </example>
        /// <param name="csUnitDt">スケジュール単位</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void AddUnit(HySSimulationScheduleUnitData csUnitDt)
        {
            m_csSimlatorUnitList.AddLast(csUnitDt);
        }
        /// <summary><para>method outline:</para>
        /// <para>スケジュール単位取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySSimulationScheduleUnitData csSimulationScheduleUnitData = GetUnit(lIndex) </para>
        /// </example>
        /// <param name="lIndex">位置</param>
        /// <returns>HySSimulationScheduleUnitData  スケジュール単位</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySSimulationScheduleUnitData GetUnit(long lIndex)
        {
            return (HySSimulationScheduleUnitData)m_csSimlatorUnitList.GetData(lIndex);
        }

        /// <summary><para>method outline:</para>
        /// <para>識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetID(csID) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetID(HySIdentifier csID)
        {
            m_csID = (HySID)csID;
        }
        /// <summary><para>method outline:</para>
        /// <para>識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySIdentifier csID = GetID() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySIdentifier  識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySIdentifier GetID()
        {
            return m_csID;
        }
        /// <summary><para>method outline:</para>
        /// <para>識別子による同一比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bWork = Equal(csID) </para>
        /// </example>
        /// <param name="csID">比較する種別識別子</param>
        /// <returns>bool　true:=一致, false:=不一致</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool Equal(HySIdentifier csID)
        {
            return m_csID.Equals(csID);
        }

        /// <summary><para>method outline:</para>
        /// <para>データ変更ロック中フラグの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetLockFlg(bFlg) </para>
        /// </example>
        /// <param name="bFlg">=true:ロック中、=false:ロック解除</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>ロック解除待ち等は行わない。単に目印をつけるのみ</para>
        /// </remarks>
        public void SetLockFlg(bool bFlg)
        { m_bLockFlg = bFlg; }
        /// <summary><para>method outline:</para>
        /// <para>データ変更ロック中フラグの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bFlg = GetLockFlg() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>bool　true:=ロック中, false:=ロック解除中</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>ロック解除待ち等は行わない。単に目印をつけるのみ</para>
        /// </remarks>
        public bool GetLockFlg()
        { return m_bLockFlg; }


        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
